/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ScrollBarUI;

public class JScrollBar
extends JComponent
implements Adjustable,
Accessible {
    private static final long serialVersionUID = -8195169869225066566L;
    public static final String BLOCK_INCREMENT_CHANGED_PROPERTY = "blockIncrement";
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String ORIENTATION_CHANGED_PROPERTY = "orientation";
    public static final String UNIT_INCREMENT_CHANGED_PROPERTY = "unitIncrement";
    protected int blockIncrement;
    protected BoundedRangeModel model;
    protected int orientation;
    protected int unitIncrement;
    private transient ChangeListener changeListener;
    private transient ChangeEvent changeEvent;

    private /* synthetic */ void finit$() {
        this.blockIncrement = 10;
        this.orientation = 1;
        this.unitIncrement = 1;
    }

    public JScrollBar() {
        this(1, 0, 10, 0, 100);
    }

    public JScrollBar(int orientation) {
        this(orientation, 0, 10, 0, 100);
    }

    public JScrollBar(int orientation, int value, int extent, int min, int max) {
        this.finit$();
        this.model = new DefaultBoundedRangeModel(value, extent, min, max);
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException(orientation + " is not a legal orientation");
        }
        this.orientation = orientation;
        this.changeListener = this.createChangeListener();
        this.model.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public void setUI(ScrollBarUI ui) {
        super.setUI(ui);
    }

    public ScrollBarUI getUI() {
        return (ScrollBarUI)this.ui;
    }

    public void updateUI() {
        this.setUI((ScrollBarUI)UIManager.getUI(this));
        this.invalidate();
        this.repaint();
    }

    public String getUIClassID() {
        return "ScrollBarUI";
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("orientation must be one of HORIZONTAL or VERTICAL");
        }
        if (orientation != this.orientation) {
            int oldOrientation = this.orientation;
            this.orientation = orientation;
            this.firePropertyChange(ORIENTATION_CHANGED_PROPERTY, oldOrientation, this.orientation);
        }
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel newModel) {
        if (this.model != newModel) {
            BoundedRangeModel oldModel = this.model;
            this.model = newModel;
            oldModel.removeChangeListener(this.changeListener);
            this.model.addChangeListener(this.changeListener);
            this.firePropertyChange(MODEL_CHANGED_PROPERTY, oldModel, this.model);
        }
    }

    public int getUnitIncrement(int direction) {
        return direction * this.unitIncrement;
    }

    public void setUnitIncrement(int unitIncrement) {
        if (unitIncrement != this.unitIncrement) {
            int oldInc = this.unitIncrement;
            this.unitIncrement = unitIncrement;
            this.firePropertyChange(UNIT_INCREMENT_CHANGED_PROPERTY, oldInc, this.unitIncrement);
        }
    }

    public int getBlockIncrement(int direction) {
        return direction * this.blockIncrement;
    }

    public void setBlockIncrement(int blockIncrement) {
        if (blockIncrement != this.blockIncrement) {
            int oldInc = this.blockIncrement;
            this.blockIncrement = blockIncrement;
            this.firePropertyChange(BLOCK_INCREMENT_CHANGED_PROPERTY, oldInc, this.blockIncrement);
        }
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public int getValue() {
        return this.model.getValue();
    }

    public void setValue(int value) {
        if (this.isEnabled() && value != this.getValue()) {
            this.model.setValue(value);
            this.fireAdjustmentValueChanged(601, 5, value);
        }
    }

    public int getVisibleAmount() {
        return this.model.getExtent();
    }

    public void setVisibleAmount(int extent) {
        if (extent != this.getVisibleAmount()) {
            this.model.setExtent(extent);
            this.fireAdjustmentValueChanged(601, 5, extent);
        }
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int minimum) {
        if (minimum != this.getMinimum()) {
            this.model.setMinimum(minimum);
            this.fireAdjustmentValueChanged(601, 5, minimum);
        }
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int maximum) {
        if (maximum != this.getMaximum()) {
            this.model.setMaximum(maximum);
            this.fireAdjustmentValueChanged(601, 5, maximum);
        }
    }

    public boolean getValueIsAdjusting() {
        return this.model.getValueIsAdjusting();
    }

    public void setValueIsAdjusting(boolean b) {
        this.model.setValueIsAdjusting(b);
    }

    public void setValue(int newValue, int newExtent, int newMin, int newMax) {
        if (!this.isEnabled()) {
            newValue = this.model.getValue();
        }
        if (newValue != this.getValue() || newExtent != this.getVisibleAmount() || newMin != this.getMinimum() || newMax != this.getMaximum()) {
            this.model.setRangeProperties(newValue, newExtent, newMin, newMax, this.model.getValueIsAdjusting());
            this.fireAdjustmentValueChanged(601, 5, newValue);
        }
    }

    private ChangeListener createChangeListener() {
        return new ChangeListener(this){
            private /* synthetic */ JScrollBar this$0;
            {
                this.this$0 = this$0;
            }

            public void stateChanged(ChangeEvent e) {
                this.this$0.fireStateChanged();
            }
        };
    }

    private void fireStateChanged() {
        Object[] changeListeners = this.listenerList.getListenerList();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = changeListeners.length - 2; i >= 0; i -= 2) {
            if (changeListeners[i] != JScrollBar.class$("javax.swing.event.ChangeListener")) continue;
            ((ChangeListener)changeListeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(JScrollBar.class$("javax.swing.event.ChangeListener"), listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(JScrollBar.class$("javax.swing.event.ChangeListener"), listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(JScrollBar.class$("javax.swing.event.ChangeListener"));
    }

    public void addAdjustmentListener(AdjustmentListener listener) {
        this.listenerList.add(JScrollBar.class$("java.awt.event.AdjustmentListener"), listener);
    }

    public void removeAdjustmentListener(AdjustmentListener listener) {
        this.listenerList.remove(JScrollBar.class$("java.awt.event.AdjustmentListener"), listener);
    }

    public AdjustmentListener[] getAdjustmentListeners() {
        return (AdjustmentListener[])this.listenerList.getListeners(JScrollBar.class$("java.awt.event.AdjustmentListener"));
    }

    protected void fireAdjustmentValueChanged(int id, int type, int value) {
        Object[] adjustmentListeners = this.listenerList.getListenerList();
        AdjustmentEvent adjustmentEvent = new AdjustmentEvent(this, 601, 5, value);
        for (int i = adjustmentListeners.length - 2; i >= 0; i -= 2) {
            if (adjustmentListeners[i] != JScrollBar.class$("java.awt.event.AdjustmentListener")) continue;
            ((AdjustmentListener)adjustmentListeners[i + 1]).adjustmentValueChanged(adjustmentEvent);
        }
    }

    public Dimension getMinimumSize() {
        return this.ui.getMinimumSize(this);
    }

    public Dimension getMaximumSize() {
        return this.ui.getMaximumSize(this);
    }

    public void setEnabled(boolean x) {
        super.setEnabled(x);
    }

    protected String paramString() {
        return "JScrollBar";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJScrollBar(this);
        }
        return this.accessibleContext;
    }

    protected class AccessibleJScrollBar
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private /* synthetic */ JScrollBar this$0;
        private static final long serialVersionUID = -7758162392045586663L;

        protected AccessibleJScrollBar(JScrollBar this$0) {
            this.this$0 = this$0;
            super(this$0);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return null;
        }

        public AccessibleValue getAccessibleValue() {
            return null;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number value0) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }
    }
}

