/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.ScrollPaneConstants;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;

public class JScrollPane
extends JComponent
implements Accessible,
ScrollPaneConstants {
    private static final long serialVersionUID = 5203525440012340014L;
    protected JViewport columnHeader;
    protected JViewport rowHeader;
    protected Component lowerLeft;
    protected Component lowerRight;
    protected Component upperLeft;
    protected Component upperRight;
    protected JScrollBar horizontalScrollBar;
    protected int horizontalScrollBarPolicy;
    protected JScrollBar verticalScrollBar;
    protected int verticalScrollBarPolicy;
    protected JViewport viewport;
    Border viewportBorder;
    boolean wheelScrollingEnabled;
    ChangeListener scrollListener = this.createScrollListener();
    public static final String COLUMN_HEADER_CHANGED_PROPERTY = "columnHeader";
    public static final String COMPONENT_ORIENTATION_CHANGED_PROPERTY = "componentOrientation";
    public static final String HORIZONTAL_SCROLLBAR_CHANGED_PROPERTY = "horizontalScrollBar";
    public static final String HORIZONTAL_SCROLLBAR_POLICY_CHANGED_PROPERTY = "horizontalScrollBarPolicy";
    public static final String LAYOUT_CHANGED_PROPERTY = "layout";
    public static final String ROW_HEADER_CHANGED_PROPERTY = "rowHeader";
    public static final String VERTICAL_SCROLLBAR_CHANGED_PROPERTY = "verticalScrollBar";
    public static final String VERTICAL_SCROLLBAR_POLICY_CHANGED_PROPERTY = "verticalScrollBarPolicy";
    public static final String VIEWPORT_CHANGED_PROPERTY = "viewport";
    public static final String VIEWPORT_BORDER_CHANGED_PROPERTY = "viewportBorder";
    public static final String WHEEL_SCROLLING_ENABLED_CHANGED_PROPERTY = "wheelScrollingEnabled";

    public JViewport getColumnHeader() {
        return this.columnHeader;
    }

    public Component getCorner(String key) {
        if (this.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
            if (key == "LOWER_LEADING_CORNER") {
                key = "LOWER_LEFT_CORNER";
            } else if (key == "LOWER_TRAILING_CORNER") {
                key = "LOWER_RIGHT_CORNER";
            } else if (key == "UPPER_LEADING_CORNER") {
                key = "UPPER_LEFT_CORNER";
            } else if (key == "UPPER_TRAILING_CORNER") {
                key = "UPPER_RIGHT_CORNER";
            }
        } else if (this.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            if (key == "LOWER_LEADING_CORNER") {
                key = "LOWER_RIGHT_CORNER";
            } else if (key == "LOWER_TRAILING_CORNER") {
                key = "LOWER_LEFT_CORNER";
            } else if (key == "UPPER_LEADING_CORNER") {
                key = "UPPER_RIGHT_CORNER";
            } else if (key == "UPPER_TRAILING_CORNER") {
                key = "UPPER_LEFT_CORNER";
            }
        }
        if (key == "LOWER_RIGHT_CORNER") {
            return this.lowerRight;
        }
        if (key == "UPPER_RIGHT_CORNER") {
            return this.upperRight;
        }
        if (key == "LOWER_LEFT_CORNER") {
            return this.lowerLeft;
        }
        if (key == "UPPER_LEFT_CORNER") {
            return this.upperLeft;
        }
        return null;
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.horizontalScrollBar;
    }

    public int getHorizontalScrollBarPolicy() {
        return this.horizontalScrollBarPolicy;
    }

    public JViewport getRowHeader() {
        return this.rowHeader;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.verticalScrollBar;
    }

    public int getVerticalScrollBarPolicy() {
        return this.verticalScrollBarPolicy;
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public Border getViewportBorder() {
        return this.viewportBorder;
    }

    public Rectangle getViewportBorderBounds() {
        if (this.viewportBorder == null) {
            if (this.getViewport() == null) {
                return new Rectangle(0, 0, 0, 0);
            }
            return this.getViewport().getBounds();
        }
        Insets i = this.viewportBorder.getBorderInsets(this.getViewport());
        if (this.getViewport() == null) {
            return new Rectangle(0, 0, i.left + i.right, i.top + i.bottom);
        }
        Rectangle b = this.getViewport().getBounds();
        return new Rectangle(b.x - i.left, b.y - i.top, b.width + i.left + i.right, b.height + i.top + i.bottom);
    }

    public boolean isWheelScrollingEnabled() {
        return this.wheelScrollingEnabled;
    }

    private void sync() {
        LayoutManager m = super.getLayout();
        if (m != null && m instanceof ScrollPaneLayout) {
            ScrollPaneLayout sl = (ScrollPaneLayout)m;
            sl.syncWithScrollPane(this);
        }
    }

    private void removeNonNull(Component c) {
        if (c != null) {
            this.remove(c);
        }
    }

    private void addNonNull(Component c) {
        if (c != null) {
            this.add(c);
        }
    }

    public void setComponentOrientation(ComponentOrientation co) {
        ComponentOrientation old = super.getComponentOrientation();
        super.setComponentOrientation(co);
        this.firePropertyChange(COMPONENT_ORIENTATION_CHANGED_PROPERTY, old, co);
        this.sync();
    }

    public void setColumnHeader(JViewport h) {
        JViewport old = this.columnHeader;
        this.removeNonNull(old);
        this.columnHeader = h;
        this.addNonNull(h);
        this.firePropertyChange(COLUMN_HEADER_CHANGED_PROPERTY, old, h);
        this.sync();
    }

    public void setColumnHeaderView(Component c) {
        if (this.columnHeader == null) {
            this.setColumnHeader(this.createViewport());
        }
        this.columnHeader.setView(c);
        this.sync();
    }

    public void setCorner(String key, Component c) {
        if (this.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
            if (key == "LOWER_LEADING_CORNER") {
                key = "LOWER_LEFT_CORNER";
            } else if (key == "LOWER_TRAILING_CORNER") {
                key = "LOWER_RIGHT_CORNER";
            } else if (key == "UPPER_LEADING_CORNER") {
                key = "UPPER_LEFT_CORNER";
            } else if (key == "UPPER_TRAILING_CORNER") {
                key = "UPPER_RIGHT_CORNER";
            }
        } else if (this.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            if (key == "LOWER_LEADING_CORNER") {
                key = "LOWER_RIGHT_CORNER";
            } else if (key == "LOWER_TRAILING_CORNER") {
                key = "LOWER_LEFT_CORNER";
            } else if (key == "UPPER_LEADING_CORNER") {
                key = "UPPER_RIGHT_CORNER";
            } else if (key == "UPPER_TRAILING_CORNER") {
                key = "UPPER_LEFT_CORNER";
            }
        }
        if (key == "LOWER_RIGHT_CORNER") {
            this.removeNonNull(this.lowerRight);
            this.lowerRight = c;
            this.addNonNull(c);
        } else if (key == "UPPER_RIGHT_CORNER") {
            this.removeNonNull(this.upperRight);
            this.upperRight = c;
            this.addNonNull(c);
        } else if (key == "LOWER_LEFT_CORNER") {
            this.removeNonNull(this.lowerLeft);
            this.lowerLeft = c;
            this.addNonNull(c);
        } else if (key == "UPPER_LEFT_CORNER") {
            this.removeNonNull(this.upperLeft);
            this.upperLeft = c;
            this.addNonNull(c);
        } else {
            throw new IllegalArgumentException("unknown corner " + key);
        }
        this.sync();
    }

    public void setHorizontalScrollBar(JScrollBar h) {
        BoundedRangeModel model;
        JScrollBar old = this.horizontalScrollBar;
        this.removeNonNull(old);
        this.horizontalScrollBar = h;
        this.addNonNull(h);
        this.firePropertyChange(HORIZONTAL_SCROLLBAR_CHANGED_PROPERTY, old, h);
        this.sync();
        if (old != null && (model = old.getModel()) != null) {
            model.removeChangeListener(this.scrollListener);
        }
        if (h != null && (model = h.getModel()) != null) {
            model.addChangeListener(this.scrollListener);
        }
    }

    public void setHorizontalScrollBarPolicy(int h) {
        if (h != 30 && h != 31 && h != 32) {
            throw new IllegalArgumentException("unknown horizontal scrollbar policy");
        }
        int old = this.horizontalScrollBarPolicy;
        this.horizontalScrollBarPolicy = h;
        this.firePropertyChange(HORIZONTAL_SCROLLBAR_POLICY_CHANGED_PROPERTY, old, h);
        this.sync();
    }

    public void setLayout(LayoutManager l) {
        LayoutManager old = super.getLayout();
        ScrollPaneLayout tmp = (ScrollPaneLayout)l;
        super.setLayout(l);
        tmp.syncWithScrollPane(this);
        this.firePropertyChange(LAYOUT_CHANGED_PROPERTY, old, l);
        this.sync();
    }

    public void setRowHeader(JViewport v) {
        JViewport old = this.rowHeader;
        this.removeNonNull(old);
        this.rowHeader = v;
        this.addNonNull(v);
        this.firePropertyChange(ROW_HEADER_CHANGED_PROPERTY, old, v);
        this.sync();
    }

    public void setRowHeaderView(Component c) {
        if (this.rowHeader == null) {
            this.setRowHeader(this.createViewport());
        }
        this.rowHeader.setView(c);
        this.sync();
    }

    public void setVerticalScrollBar(JScrollBar v) {
        BoundedRangeModel model;
        JScrollBar old = this.verticalScrollBar;
        this.removeNonNull(old);
        this.verticalScrollBar = v;
        this.addNonNull(v);
        this.firePropertyChange(VERTICAL_SCROLLBAR_CHANGED_PROPERTY, old, v);
        this.sync();
        if (old != null && (model = old.getModel()) != null) {
            model.removeChangeListener(this.scrollListener);
        }
        if (v != null && (model = v.getModel()) != null) {
            model.addChangeListener(this.scrollListener);
        }
    }

    public void setVerticalScrollBarPolicy(int v) {
        if (v != 20 && v != 21 && v != 22) {
            throw new IllegalArgumentException("unknown vertical scrollbar policy");
        }
        int old = this.verticalScrollBarPolicy;
        this.verticalScrollBarPolicy = v;
        this.firePropertyChange(VERTICAL_SCROLLBAR_POLICY_CHANGED_PROPERTY, old, v);
        this.sync();
    }

    public void setWheelScrollingEnabled(boolean b) {
        boolean old = this.wheelScrollingEnabled;
        this.wheelScrollingEnabled = b;
        this.firePropertyChange(WHEEL_SCROLLING_ENABLED_CHANGED_PROPERTY, old, b);
        this.sync();
    }

    public void setViewport(JViewport v) {
        JViewport old = this.viewport;
        this.removeNonNull(old);
        if (old != null) {
            old.removeChangeListener(this.scrollListener);
        }
        this.viewport = v;
        if (v != null) {
            v.addChangeListener(this.scrollListener);
        }
        this.addNonNull(v);
        this.revalidate();
        this.repaint();
        this.firePropertyChange(VIEWPORT_CHANGED_PROPERTY, old, v);
        this.sync();
    }

    public void setViewportBorder(Border b) {
        Border old = this.viewportBorder;
        this.viewportBorder = b;
        this.firePropertyChange(VIEWPORT_BORDER_CHANGED_PROPERTY, old, b);
        this.sync();
    }

    public void setViewportView(Component view) {
        if (this.getViewport() == null) {
            this.setViewport(this.createViewport());
        }
        if (view != null) {
            this.getViewport().setView(view);
        }
        this.sync();
    }

    public boolean isValidateRoot() {
        return true;
    }

    ChangeListener createScrollListener() {
        return new ChangeListener(this){
            private /* synthetic */ JScrollPane this$0;
            {
                this.this$0 = this$0;
            }

            public void stateChanged(ChangeEvent event) {
                JScrollBar vsb = this.this$0.getVerticalScrollBar();
                JScrollBar hsb = this.this$0.getHorizontalScrollBar();
                JViewport vp = this.this$0.getViewport();
                if (vp != null && event.getSource() == vp) {
                    Rectangle vr = vp.getViewRect();
                    Dimension vs = vp.getViewSize();
                    if (vsb != null && (vsb.getMinimum() != 0 || vsb.getMaximum() != vs.height || vsb.getValue() != vr.y || vsb.getVisibleAmount() != vr.height)) {
                        vsb.setValue(vr.y, vr.height, 0, vs.height);
                    }
                    if (hsb != null && (hsb.getMinimum() != 0 || hsb.getMaximum() != vs.width || hsb.getValue() != vr.width || hsb.getVisibleAmount() != vr.height)) {
                        hsb.setValue(vr.x, vr.width, 0, vs.width);
                    }
                } else {
                    int xpos = 0;
                    int ypos = 0;
                    if (vsb != null) {
                        ypos = vsb.getValue();
                    }
                    if (hsb != null) {
                        xpos = hsb.getValue();
                    }
                    Point pt = new Point(xpos, ypos);
                    if (vp != null && vp.getViewPosition() != pt) {
                        vp.setViewPosition(pt);
                    }
                    pt.x = 0;
                    if (this.this$0.rowHeader != null && this.this$0.rowHeader.getViewPosition() != pt) {
                        this.this$0.rowHeader.setViewPosition(pt);
                    }
                    pt.x = xpos;
                    pt.y = 0;
                    if (this.this$0.columnHeader != null && this.this$0.columnHeader.getViewPosition() != pt) {
                        this.this$0.columnHeader.setViewPosition(pt);
                    }
                }
            }
        };
    }

    public JScrollPane() {
        this(null);
    }

    public JScrollPane(Component view) {
        this(view, 20, 30);
    }

    public JScrollPane(int vsbPolicy, int hsbPolicy) {
        this(null, vsbPolicy, hsbPolicy);
    }

    public JScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        this.setVerticalScrollBarPolicy(vsbPolicy);
        this.setVerticalScrollBar(this.createVerticalScrollBar());
        this.setHorizontalScrollBarPolicy(hsbPolicy);
        this.setHorizontalScrollBar(this.createHorizontalScrollBar());
        this.setViewportView(view);
        this.setLayout(new ScrollPaneLayout());
        this.setOpaque(false);
        this.updateUI();
    }

    public JScrollBar createHorizontalScrollBar() {
        return new ScrollBar(this, 0);
    }

    public JScrollBar createVerticalScrollBar() {
        return new ScrollBar(this, 1);
    }

    public JViewport createViewport() {
        return new JViewport();
    }

    public String getUIClassID() {
        return "ScrollPaneUI";
    }

    public void updateUI() {
        ScrollPaneUI b = (ScrollPaneUI)UIManager.getUI(this);
        this.setUI(b);
    }

    class ScrollBar
    extends JScrollBar
    implements UIResource {
        private /* synthetic */ JScrollPane this$0;

        public ScrollBar(JScrollPane this$0, int orientation) {
            this.this$0 = this$0;
            super(orientation);
        }

        public int getBlockIncrement(int direction) {
            Component view = this.this$0.getViewport().getView();
            if (view == null || !(view instanceof Scrollable)) {
                return super.getBlockIncrement(direction);
            }
            Scrollable s = (Scrollable)((Object)view);
            return s.getScrollableBlockIncrement(this.this$0.getViewport().getViewRect(), this.getOrientation(), direction);
        }

        public int getUnitIncrement(int direction) {
            Component view = this.this$0.getViewport().getView();
            if (view == null || !(view instanceof Scrollable)) {
                return super.getUnitIncrement(direction);
            }
            Scrollable s = (Scrollable)((Object)view);
            return s.getScrollableUnitIncrement(this.this$0.getViewport().getViewRect(), this.getOrientation(), direction);
        }
    }
}

