/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Dimension;
import java.awt.MenuContainer;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;

public class JSlider
extends JComponent
implements SwingConstants,
Accessible,
ImageObserver,
MenuContainer,
Serializable {
    static final long serialVersionUID = -1441275936141218479L;
    public static final String INVERTED_CHANGED_PROPERTY = "inverted";
    public static final String LABEL_TABLE_CHANGED_PROPERTY = "labelTable";
    public static final String MAJOR_TICK_SPACING_CHANGED_PROPERTY = "majorTickSpacing";
    public static final String MINOR_TICK_SPACING_CHANGED_PROPERTY = "minorTickSpacing";
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String ORIENTATION_CHANGED_PROPERTY = "orientation";
    public static final String PAINT_LABELS_CHANGED_PROPERTY = "paintLabels";
    public static final String PAINT_TICKS_CHANGED_PROPERTY = "paintTicks";
    private transient boolean paintTicks;
    private transient boolean paintTrack;
    private transient boolean paintLabels;
    private transient Dictionary labelTable;
    protected BoundedRangeModel sliderModel;
    protected int majorTickSpacing;
    protected int minorTickSpacing;
    protected boolean snapToTicks;
    protected int orientation;
    private transient boolean isInverted;
    protected ChangeListener changeListener;
    protected transient ChangeEvent changeEvent;

    private /* synthetic */ void finit$() {
        this.paintTicks = false;
        this.paintTrack = true;
        this.paintLabels = false;
        this.snapToTicks = true;
        this.orientation = 0;
    }

    public JSlider() {
        this(0, 0, 100, 50);
    }

    public JSlider(int orientation) {
        this(orientation, 0, 100, 50);
    }

    public JSlider(int minimum, int maximum) {
        this(0, minimum, maximum, (maximum + minimum) / 2);
    }

    public JSlider(int minimum, int maximum, int value) {
        this(0, minimum, maximum, value);
    }

    public JSlider(int orientation, int minimum, int maximum, int value) {
        this.finit$();
        this.sliderModel = new DefaultBoundedRangeModel(value, 0, minimum, maximum);
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException(orientation + " is not a legal orientation");
        }
        this.orientation = orientation;
        this.changeListener = this.createChangeListener();
        this.sliderModel.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public JSlider(BoundedRangeModel model) {
        this.finit$();
        this.sliderModel = model == null ? new DefaultBoundedRangeModel(50, 0, 0, 100) : model;
        this.changeListener = this.createChangeListener();
        this.sliderModel.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public int getValue() {
        return this.sliderModel.getValue();
    }

    public void setValue(int value) {
        this.sliderModel.setValue(value);
    }

    public SliderUI getUI() {
        return (SliderUI)this.ui;
    }

    public void setUI(SliderUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((SliderUI)UIManager.getUI(this));
        this.invalidate();
        this.repaint();
    }

    public String getUIClassID() {
        return "SliderUI";
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(this){
            private /* synthetic */ JSlider this$0;
            {
                this.this$0 = this$0;
            }

            public void stateChanged(ChangeEvent ce) {
                this.this$0.fireStateChanged();
            }
        };
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(JSlider.class$("javax.swing.event.ChangeListener"), listener);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(JSlider.class$("javax.swing.event.ChangeListener"), listener);
    }

    protected void fireStateChanged() {
        Object[] changeListeners = this.listenerList.getListenerList();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = changeListeners.length - 2; i >= 0; i -= 2) {
            if (changeListeners[i] != JSlider.class$("javax.swing.event.ChangeListener")) continue;
            ((ChangeListener)changeListeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(JSlider.class$("javax.swing.event.ChangeListener"));
    }

    public BoundedRangeModel getModel() {
        return this.sliderModel;
    }

    public void setModel(BoundedRangeModel model) {
        if (model != this.sliderModel) {
            BoundedRangeModel oldModel = this.sliderModel;
            this.sliderModel = model;
            oldModel.removeChangeListener(this.changeListener);
            this.sliderModel.addChangeListener(this.changeListener);
            this.firePropertyChange(MODEL_CHANGED_PROPERTY, oldModel, this.sliderModel);
        }
    }

    public int getMinimum() {
        return this.sliderModel.getMinimum();
    }

    public void setMinimum(int minimum) {
        this.sliderModel.setMinimum(minimum);
    }

    public int getMaximum() {
        return this.sliderModel.getMaximum();
    }

    public void setMaximum(int maximum) {
        this.sliderModel.setMaximum(maximum);
    }

    public boolean getValueIsAdjusting() {
        return this.sliderModel.getValueIsAdjusting();
    }

    public void setValueIsAdjusting(boolean adjusting) {
        this.sliderModel.setValueIsAdjusting(adjusting);
    }

    public int getExtent() {
        return this.sliderModel.getExtent();
    }

    public void setExtent(int extent) {
        this.sliderModel.setExtent(extent);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
        }
        if (orientation != this.orientation) {
            int oldOrientation = this.orientation;
            this.orientation = orientation;
            this.firePropertyChange(ORIENTATION_CHANGED_PROPERTY, oldOrientation, this.orientation);
        }
    }

    public Dictionary getLabelTable() {
        return this.labelTable;
    }

    public void setLabelTable(Dictionary table) {
        if (table != this.labelTable) {
            Dictionary oldTable = this.labelTable;
            this.labelTable = table;
            this.firePropertyChange(LABEL_TABLE_CHANGED_PROPERTY, oldTable, this.labelTable);
        }
    }

    protected void updateLabelUIs() {
        if (this.labelTable == null) {
            return;
        }
        Enumeration list = this.labelTable.elements();
        while (list.hasMoreElements()) {
            JLabel label = (JLabel)list.nextElement();
            label.updateUI();
        }
    }

    public Hashtable createStandardLabels(int increment) {
        return this.createStandardLabels(increment, this.sliderModel.getMinimum());
    }

    public Hashtable createStandardLabels(int increment, int start) {
        Hashtable table = new Hashtable();
        int max = this.sliderModel.getMaximum();
        for (int i = start; i <= max; i += increment) {
            JLabel label = new JLabel(String.valueOf(i));
            label.setVerticalAlignment(0);
            label.setHorizontalAlignment(0);
            Dimension dim = label.getPreferredSize();
            label.setBounds(label.getX(), label.getY(), (int)dim.getWidth(), (int)dim.getHeight());
            table.put(new Integer(i), label);
        }
        return table;
    }

    public boolean getInverted() {
        return this.isInverted;
    }

    public void setInverted(boolean inverted) {
        if (this.isInverted != inverted) {
            boolean oldInverted = this.isInverted;
            this.isInverted = inverted;
            this.firePropertyChange(INVERTED_CHANGED_PROPERTY, oldInverted, this.isInverted);
        }
    }

    public int getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    public void setMajorTickSpacing(int spacing) {
        if (this.majorTickSpacing != spacing) {
            int oldSpacing = this.majorTickSpacing;
            this.majorTickSpacing = spacing;
            this.firePropertyChange(MAJOR_TICK_SPACING_CHANGED_PROPERTY, oldSpacing, this.majorTickSpacing);
        }
    }

    public int getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    public void setMinorTickSpacing(int spacing) {
        if (this.minorTickSpacing != spacing) {
            int oldSpacing = this.minorTickSpacing;
            this.minorTickSpacing = spacing;
            this.firePropertyChange(MINOR_TICK_SPACING_CHANGED_PROPERTY, oldSpacing, this.minorTickSpacing);
        }
    }

    public boolean getSnapToTicks() {
        return this.snapToTicks;
    }

    public void setSnapToTicks(boolean snap) {
        if (snap != this.snapToTicks) {
            this.snapToTicks = snap;
            this.fireStateChanged();
        }
    }

    public boolean getPaintTicks() {
        return this.paintTicks;
    }

    public void setPaintTicks(boolean paint) {
        if (paint != this.paintTicks) {
            boolean oldPaintTicks = this.paintTicks;
            this.paintTicks = paint;
            this.firePropertyChange(PAINT_TICKS_CHANGED_PROPERTY, oldPaintTicks, this.paintTicks);
        }
    }

    public boolean getPaintTrack() {
        return this.paintTrack;
    }

    public void setPaintTrack(boolean paint) {
        this.paintTrack = paint;
    }

    public boolean getPaintLabels() {
        return this.paintLabels;
    }

    public void setPaintLabels(boolean paint) {
        if (paint != this.paintLabels) {
            boolean oldPaintLabels = this.paintLabels;
            this.paintLabels = paint;
            this.firePropertyChange(PAINT_LABELS_CHANGED_PROPERTY, oldPaintLabels, this.paintLabels);
        }
    }

    protected String paramString() {
        return "JSlider";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSlider(this);
        }
        return this.accessibleContext;
    }

    protected class AccessibleJSlider
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private /* synthetic */ JSlider this$0;
        private static final long serialVersionUID = -6301740148041106789L;

        protected AccessibleJSlider(JSlider this$0) {
            this.this$0 = this$0;
            super(this$0);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return null;
        }

        public AccessibleValue getAccessibleValue() {
            return null;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number value0) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }
    }
}

