/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.SpinnerUI;

public class JSpinner
extends JComponent {
    private SpinnerModel model;
    private JComponent editor;
    private EventListenerList listenerList;
    private ChangeListener listener;

    private /* synthetic */ void finit$() {
        this.listenerList = new EventListenerList();
        this.listener = new ChangeListener(this){
            private /* synthetic */ JSpinner this$0;
            {
                this.this$0 = this$0;
            }

            public void stateChanged(ChangeEvent evt) {
                this.this$0.fireStateChanged();
            }
        };
    }

    public JSpinner() {
        this(new SpinnerNumberModel());
    }

    public JSpinner(SpinnerModel model) {
        this.finit$();
        this.model = model;
        model.addChangeListener(this.listener);
        this.setEditor(this.createEditor(model));
        this.updateUI();
    }

    public void commitEdit() throws ParseException {
        if (this.editor instanceof DefaultEditor) {
            ((DefaultEditor)this.editor).commitEdit();
        }
    }

    public JComponent getEditor() {
        return this.editor;
    }

    public void setEditor(JComponent editor) {
        if (editor == null) {
            throw new IllegalArgumentException("editor may not be null");
        }
        if (this.editor instanceof DefaultEditor) {
            ((DefaultEditor)editor).dismiss(this);
        } else if (this.editor instanceof ChangeListener) {
            this.removeChangeListener((ChangeListener)((Object)this.editor));
        }
        if (editor instanceof ChangeListener) {
            this.addChangeListener((ChangeListener)((Object)editor));
        }
        this.editor = editor;
    }

    public SpinnerModel getModel() {
        return this.model;
    }

    public Object getNextValue() {
        return this.model.getNextValue();
    }

    public Object getPreviousValue() {
        return this.model.getPreviousValue();
    }

    public SpinnerUI getUI() {
        return (SpinnerUI)this.ui;
    }

    public Object getValue() {
        return this.model.getValue();
    }

    public void setValue(Object value) {
        this.model.setValue(value);
    }

    public String getUIClassID() {
        return "SpinnerUI";
    }

    public void updateUI() {
        this.setUI((SpinnerUI)UIManager.getUI(this));
    }

    public void setUI(SpinnerUI ui) {
        super.setUI(ui);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(JSpinner.class$("javax.swing.event.ChangeListener"), listener);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(JSpinner.class$("javax.swing.event.ChangeListener"), listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(JSpinner.class$("javax.swing.event.ChangeListener"));
    }

    protected void fireStateChanged() {
        ChangeEvent evt = new ChangeEvent(this);
        ChangeListener[] listeners = this.getChangeListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].stateChanged(evt);
        }
    }

    protected JComponent createEditor(SpinnerModel model) {
        return new StubEditor(this);
    }

    public static class NumberEditor
    extends DefaultEditor {
        public NumberEditor(JSpinner spinner) {
            super(spinner);
        }

        public DecimalFormat getFormat() {
            return null;
        }
    }

    public static class DefaultEditor
    extends JPanel
    implements ChangeListener,
    PropertyChangeListener,
    LayoutManager {
        public DefaultEditor(JSpinner spinner) {
            spinner.addChangeListener(this);
        }

        public void commitEdit() {
        }

        public void dismiss(JSpinner spinner) {
            spinner.removeChangeListener(this);
        }

        public JFormattedTextField getTextField() {
            return null;
        }

        public void layoutContainer(Container parent) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        public void propertyChange(PropertyChangeEvent evt) {
        }

        public void stateChanged(ChangeEvent evt) {
        }

        public void removeLayoutComponent(Component child) {
        }

        public void addLayoutComponent(String name, Component child) {
        }
    }

    public static class StubEditor
    extends JLabel
    implements ChangeListener {
        private JLabel label;
        private JButton up;
        private JButton down;
        private JSpinner spinner;

        public StubEditor(JSpinner spinner) {
            this.spinner = spinner;
            this.setBorder(new EtchedBorder());
            this.setHorizontalAlignment(11);
            this.stateChanged(null);
        }

        public void stateChanged(ChangeEvent evt) {
            this.setText(String.valueOf(this.spinner.getValue()));
        }
    }
}

