/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.SplitPaneUI;

public class JSplitPane
extends JComponent
implements Accessible {
    private static final long serialVersionUID = -5634142046175988380L;
    public static final String BOTTOM = "bottom";
    public static final String CONTINUOUS_LAYOUT_PROPERTY = "continuousLayout";
    public static final String DIVIDER = "divider";
    public static final String DIVIDER_LOCATION_PROPERTY = "dividerLocation";
    public static final String DIVIDER_SIZE_PROPERTY = "dividerSize";
    public static final int HORIZONTAL_SPLIT = 1;
    public static final String LAST_DIVIDER_LOCATION_PROPERTY = "lastDividerLocation";
    public static final String LEFT = "left";
    public static final String ONE_TOUCH_EXPANDABLE_PROPERTY = "oneTouchExpandable";
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String RESIZE_WEIGHT_PROPERTY = "resizeWeight";
    public static final String RIGHT = "right";
    public static final String TOP = "top";
    public static final int VERTICAL_SPLIT = 0;
    protected boolean continuousLayout;
    protected boolean oneTouchExpandable;
    protected int dividerSize;
    protected int lastDividerLocation;
    protected int orientation;
    protected Component leftComponent;
    protected Component rightComponent;
    private transient double resizeWeight;

    private /* synthetic */ void finit$() {
        this.oneTouchExpandable = false;
        this.dividerSize = 10;
    }

    public JSplitPane(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        this.finit$();
        if (newOrientation != 1 && newOrientation != 0) {
            throw new IllegalArgumentException("orientation is invalid.");
        }
        this.orientation = newOrientation;
        this.continuousLayout = newContinuousLayout;
        this.setLeftComponent(newLeftComponent);
        this.setRightComponent(newRightComponent);
        this.updateUI();
    }

    public JSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        this(newOrientation, false, newLeftComponent, newRightComponent);
    }

    public JSplitPane(int newOrientation, boolean newContinuousLayout) {
        this(newOrientation, newContinuousLayout, null, null);
    }

    public JSplitPane(int newOrientation) {
        this(newOrientation, false, null, null);
    }

    public JSplitPane() {
        this(1, false, null, null);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        boolean left = false;
        boolean right = true;
        int div = 2;
        if (constraints == null) {
            if (this.leftComponent == null) {
                constraints = LEFT;
            } else if (this.rightComponent == null) {
                constraints = RIGHT;
            }
        }
        if (constraints instanceof String) {
            String placement = (String)constraints;
            if (placement.equals(BOTTOM) || placement.equals(RIGHT)) {
                if (this.rightComponent != null) {
                    this.remove(this.rightComponent);
                }
                this.rightComponent = comp;
            } else if (placement.equals(LEFT) || placement.equals(TOP)) {
                if (this.leftComponent != null) {
                    this.remove(this.leftComponent);
                }
                this.leftComponent = comp;
            } else if (placement.equals(DIVIDER)) {
                constraints = null;
            } else {
                throw new IllegalArgumentException("Constraints is not a known identifier.");
            }
            super.addImpl(comp, constraints, index);
        }
        this.invalidate();
        this.layout();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSplitPane(this);
        }
        return this.accessibleContext;
    }

    public Component getBottomComponent() {
        return this.rightComponent;
    }

    public int getDividerLocation() {
        if (this.ui != null) {
            return ((SplitPaneUI)this.ui).getDividerLocation(this);
        }
        return -1;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public int getLastDividerLocation() {
        return this.lastDividerLocation;
    }

    public Component getLeftComponent() {
        return this.leftComponent;
    }

    public int getMaximumDividerLocation() {
        if (this.ui != null) {
            return ((SplitPaneUI)this.ui).getMaximumDividerLocation(this);
        }
        return -1;
    }

    public int getMinimumDividerLocation() {
        if (this.ui != null) {
            return ((SplitPaneUI)this.ui).getMinimumDividerLocation(this);
        }
        return -1;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public double getResizeWeight() {
        return this.resizeWeight;
    }

    public Component getRightComponent() {
        return this.rightComponent;
    }

    public Component getTopComponent() {
        return this.leftComponent;
    }

    public SplitPaneUI getUI() {
        return (SplitPaneUI)this.ui;
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public boolean isOneTouchExpandable() {
        return this.oneTouchExpandable;
    }

    public boolean isValidateRoot() {
        return true;
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.ui != null) {
            ((SplitPaneUI)this.ui).finishedPaintingChildren(this, g);
        }
    }

    protected String paramString() {
        return "JSplitPane";
    }

    public void remove(Component component) {
        if (component == this.leftComponent) {
            this.leftComponent = null;
        } else if (component == this.rightComponent) {
            this.rightComponent = null;
        }
        super.remove(component);
    }

    public void remove(int index) {
        Component component = this.getComponent(index);
        if (component == this.leftComponent) {
            this.leftComponent = null;
        } else if (component == this.rightComponent) {
            this.rightComponent = null;
        }
        super.remove(index);
    }

    public void removeAll() {
        this.leftComponent = null;
        this.rightComponent = null;
        super.removeAll();
    }

    public void resetToPreferredSizes() {
        if (this.ui != null) {
            ((SplitPaneUI)this.ui).resetToPreferredSizes(this);
        }
    }

    public void setBottomComponent(Component comp) {
        if (comp != null) {
            this.add(comp, BOTTOM);
        } else {
            this.add((Component)new JButton("right button"), BOTTOM);
        }
    }

    public void setContinuousLayout(boolean newContinuousLayout) {
        if (newContinuousLayout != this.continuousLayout) {
            boolean oldValue = this.continuousLayout;
            this.continuousLayout = newContinuousLayout;
            this.firePropertyChange(CONTINUOUS_LAYOUT_PROPERTY, oldValue, this.continuousLayout);
        }
    }

    public void setDividerLocation(double proportionalLocation) {
        if (proportionalLocation > 1.0 || proportionalLocation < 0.0) {
            throw new IllegalArgumentException("proportion has to be between 0 and 1.");
        }
        int max = this.orientation == 1 ? this.getWidth() : this.getHeight();
        this.setDividerLocation((int)(proportionalLocation * (double)max));
    }

    public void setDividerLocation(int location) {
        if (this.ui != null && location != this.getDividerLocation()) {
            int oldLocation = this.getDividerLocation();
            ((SplitPaneUI)this.ui).setDividerLocation(this, location);
            this.firePropertyChange(DIVIDER_LOCATION_PROPERTY, oldLocation, location);
        }
    }

    public void setDividerSize(int newSize) {
        if (newSize != this.dividerSize) {
            int oldSize = this.dividerSize;
            this.dividerSize = newSize;
            this.firePropertyChange(DIVIDER_SIZE_PROPERTY, oldSize, this.dividerSize);
        }
    }

    public void setLastDividerLocation(int newLastLocation) {
        if (newLastLocation != this.lastDividerLocation) {
            int oldValue = this.lastDividerLocation;
            this.lastDividerLocation = newLastLocation;
            this.firePropertyChange(LAST_DIVIDER_LOCATION_PROPERTY, oldValue, this.lastDividerLocation);
        }
    }

    public void setLeftComponent(Component comp) {
        if (comp != null) {
            this.add(comp, LEFT);
        } else {
            this.add((Component)new JButton("left button"), LEFT);
        }
    }

    public void setOneTouchExpandable(boolean newValue) {
        if (newValue != this.oneTouchExpandable) {
            boolean oldValue = this.oneTouchExpandable;
            this.oneTouchExpandable = newValue;
            this.firePropertyChange(ONE_TOUCH_EXPANDABLE_PROPERTY, oldValue, this.oneTouchExpandable);
        }
    }

    public void setOrientation(int orientation) {
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException("orientation must be one of VERTICAL_SPLIT, HORIZONTAL_SPLIT");
        }
        if (orientation != this.orientation) {
            int oldOrientation = this.orientation;
            this.orientation = orientation;
            this.firePropertyChange(ORIENTATION_PROPERTY, oldOrientation, this.orientation);
        }
    }

    public void setResizeWeight(double value) {
        this.resizeWeight = value;
    }

    public void setRightComponent(Component comp) {
        if (comp != null) {
            this.add(comp, RIGHT);
        } else {
            this.add((Component)new JButton("right button"), RIGHT);
        }
    }

    public void setTopComponent(Component comp) {
        if (comp != null) {
            this.add(comp, TOP);
        } else {
            this.add((Component)new JButton("left button"), TOP);
        }
    }

    public void setUI(SplitPaneUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((SplitPaneUI)UIManager.getUI(this));
        this.invalidate();
        this.repaint();
    }

    public String getUIClassID() {
        return "SplitPaneUI";
    }

    static {
        BOTTOM = BOTTOM;
        CONTINUOUS_LAYOUT_PROPERTY = CONTINUOUS_LAYOUT_PROPERTY;
        DIVIDER = DIVIDER;
        DIVIDER_LOCATION_PROPERTY = DIVIDER_LOCATION_PROPERTY;
        DIVIDER_SIZE_PROPERTY = DIVIDER_SIZE_PROPERTY;
        LAST_DIVIDER_LOCATION_PROPERTY = LAST_DIVIDER_LOCATION_PROPERTY;
        LEFT = LEFT;
        ONE_TOUCH_EXPANDABLE_PROPERTY = ONE_TOUCH_EXPANDABLE_PROPERTY;
        ORIENTATION_PROPERTY = ORIENTATION_PROPERTY;
        RESIZE_WEIGHT_PROPERTY = RESIZE_WEIGHT_PROPERTY;
        RIGHT = RIGHT;
        TOP = TOP;
    }

    protected class AccessibleJSplitPane
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private /* synthetic */ JSplitPane this$0;
        private static final long serialVersionUID = -1788116871416305366L;

        protected AccessibleJSplitPane(JSplitPane this$0) {
            this.this$0 = this$0;
            super(this$0);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return null;
        }

        public AccessibleValue getAccessibleValue() {
            return null;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number value0) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }
    }
}

