/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.TableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JTable
extends JComponent
implements TableModelListener,
Scrollable,
TableColumnModelListener,
ListSelectionListener,
CellEditorListener,
Accessible {
    private static final long serialVersionUID = 3876025080382781659L;
    public static final int AUTO_RESIZE_OFF = 0;
    public static final int AUTO_RESIZE_NEXT_COLUMN = 1;
    public static final int AUTO_RESIZE_SUBSEQUENT_COLUMNS = 2;
    public static final int AUTO_RESIZE_ALL_COLUMNS = 4;
    public static final int AUTO_RESIZE_LAST_COLUMN = 3;
    protected Hashtable defaultEditorsByColumnClass;
    protected Hashtable defaultRenderersByColumnClass;
    protected int editingColumn;
    protected int editingRow;
    protected boolean autoCreateColumnsFromModel;
    protected int autoResizeMode;
    protected int rowHeight;
    protected int rowMargin;
    protected boolean rowSelectionAllowed;
    protected boolean cellSelectionEnabled;
    protected TableModel dataModel;
    protected TableColumnModel columnModel;
    protected ListSelectionModel selectionModel;
    protected AccessibleContext accessibleContext;
    protected TableCellEditor cellEditor;
    protected boolean dragEnabled;
    protected Color gridColor;
    protected Dimension preferredScrollableViewportSize;
    Color selectionBackground;
    private static final String SELECTION_BACKGROUND_CHANGED_PROPERTY = "selectionBackground";
    Color selectionForeground;
    private static final String SELECTION_FOREGROUND_CHANGED_PROPERTY = "selectionForeground";
    protected boolean showHorizontalLines;
    protected boolean showVerticalLines;
    protected JTableHeader tableHeader;

    public JTable() {
        this(null, null, null);
    }

    public JTable(int numRows, int numColumns) {
        this(new DefaultTableModel(numRows, numColumns));
    }

    public JTable(Object[][] data, Object[] columnNames) {
        this(new DefaultTableModel(data, columnNames));
    }

    public JTable(TableModel dm) {
        this(dm, null, null);
    }

    public JTable(TableModel dm, TableColumnModel cm) {
        this(dm, cm, null);
    }

    public JTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        this.dataModel = dm == null ? this.createDefaultDataModel() : dm;
        this.setSelectionModel(sm == null ? this.createDefaultListSelectionModel() : sm);
        this.columnModel = cm;
        this.autoCreateColumnsFromModel = false;
        if (cm == null) {
            this.autoCreateColumnsFromModel = true;
            this.createColumnsFromModel();
        }
        this.columnModel.addColumnModelListener(this);
        this.defaultRenderersByColumnClass = new Hashtable();
        this.defaultEditorsByColumnClass = new Hashtable();
        this.autoResizeMode = 4;
        this.rowHeight = 16;
        this.rowMargin = 1;
        this.rowSelectionAllowed = true;
        this.cellEditor = null;
        this.dragEnabled = false;
        this.preferredScrollableViewportSize = new Dimension(450, 400);
        this.showHorizontalLines = true;
        this.showVerticalLines = true;
        this.setInterCellSpacing(new Dimension(1, 1));
        this.setTableHeader(new JTableHeader(this.columnModel));
        this.updateUI();
    }

    public JTable(Vector data, Vector columnNames) {
        this(new DefaultTableModel(data, columnNames));
    }

    public static JScrollPane createScrollPaneForTable(JTable table) {
        return new JScrollPane(table);
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    protected TableModel createDefaultDataModel() {
        return new DefaultTableModel();
    }

    protected ListSelectionModel createDefaultListSelectionModel() {
        return new DefaultListSelectionModel();
    }

    private void createColumnsFromModel() {
        if (this.dataModel == null) {
            return;
        }
        TableColumnModel cm = this.createDefaultColumnModel();
        for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
            cm.addColumn(new TableColumn(i));
        }
        this.setColumnModel(cm);
    }

    public void columnAdded(TableColumnModelEvent event) {
        this.revalidate();
        this.repaint();
    }

    public void columnMarginChanged(ChangeEvent event) {
        this.revalidate();
        this.repaint();
    }

    public void columnMoved(TableColumnModelEvent event) {
        this.revalidate();
        this.repaint();
    }

    public void columnRemoved(TableColumnModelEvent event) {
        this.revalidate();
        this.repaint();
    }

    public void columnSelectionChanged(ListSelectionEvent event) {
        this.repaint();
    }

    public void editingCanceled(ChangeEvent event) {
        this.repaint();
    }

    public void editingStopped(ChangeEvent event) {
        this.repaint();
    }

    public void tableChanged(TableModelEvent event) {
        this.repaint();
    }

    public void valueChanged(ListSelectionEvent event) {
        this.repaint();
    }

    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        int height = this.getHeight();
        int width = this.columnModel.getColumn(column).getWidth();
        int x_gap = this.columnModel.getColumnMargin();
        int y_gap = this.rowMargin;
        column = Math.max(0, Math.min(column, this.getColumnCount() - 1));
        row = Math.max(0, Math.min(row, this.getRowCount() - 1));
        int x = 0;
        int y = (height + y_gap) * row;
        for (int i = 0; i < column; ++i) {
            x += this.columnModel.getColumn(i).getWidth();
            x += x_gap;
        }
        if (includeSpacing) {
            return new Rectangle(x, y, width, height);
        }
        return new Rectangle(x, y, width - x_gap, height - y_gap);
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
    }

    public int getSelectedRow() {
        return this.selectionModel.getMinSelectionIndex();
    }

    public ListSelectionModel getSelectionModel() {
        if (!this.rowSelectionAllowed) {
            return null;
        }
        return this.selectionModel;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return visibleRect.height * direction;
        }
        return visibleRect.width * direction;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.autoResizeMode != 0;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return this.rowHeight;
        }
        int sum = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            sum += this.columnModel.getColumn(0).getWidth();
        }
        if (this.getColumnCount() == 0) {
            return 10;
        }
        return sum / this.getColumnCount();
    }

    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor editor = this.columnModel.getColumn(column).getCellEditor();
        if (editor == null) {
            editor = this.getDefaultEditor(this.dataModel.getColumnClass(column));
        }
        return editor;
    }

    public TableCellEditor getDefaultEditor(Class columnClass) {
        if (this.defaultEditorsByColumnClass.containsKey(columnClass)) {
            return (TableCellEditor)this.defaultEditorsByColumnClass.get(columnClass);
        }
        DefaultCellEditor r = new DefaultCellEditor(new JTextField());
        this.defaultEditorsByColumnClass.put(columnClass, r);
        return r;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = this.columnModel.getColumn(column).getCellRenderer();
        if (renderer == null) {
            renderer = this.getDefaultRenderer(this.dataModel.getColumnClass(column));
        }
        return renderer;
    }

    public TableCellRenderer getDefaultRenderer(Class columnClass) {
        if (this.defaultRenderersByColumnClass.containsKey(columnClass)) {
            return (TableCellRenderer)this.defaultRenderersByColumnClass.get(columnClass);
        }
        DefaultTableCellRenderer r = new DefaultTableCellRenderer();
        this.defaultRenderersByColumnClass.put(columnClass, r);
        return r;
    }

    public int convertColumnIndexToModel(int vc) {
        if (vc < 0) {
            return vc;
        }
        if (vc > this.getColumnCount()) {
            return -1;
        }
        return this.columnModel.getColumn(vc).getModelIndex();
    }

    public int convertColumnIndexToView(int mc) {
        if (mc < 0) {
            return mc;
        }
        int ncols = this.getColumnCount();
        for (int vc = 0; vc < ncols; ++vc) {
            if (this.columnModel.getColumn(vc).getModelIndex() != mc) continue;
            return vc;
        }
        return -1;
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        boolean rsa = this.getRowSelectionAllowed();
        boolean csa = this.getColumnSelectionAllowed();
        boolean rs = rsa ? this.getSelectionModel().isSelectedIndex(row) : false;
        boolean cs = csa ? this.columnModel.getSelectionModel().isSelectedIndex(column) : false;
        boolean isSelected = rsa && csa && rs && cs || rsa && !csa && rs || !rsa && csa && cs;
        return renderer.getTableCellRendererComponent(this, this.dataModel.getValueAt(row, this.convertColumnIndexToView(column)), isSelected, false, row, column);
    }

    public boolean getAutoCreateColumnsFromModel() {
        return this.autoCreateColumnsFromModel;
    }

    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getRowMargin() {
        return this.rowMargin;
    }

    public boolean getRowSelectionAllowed() {
        return this.rowSelectionAllowed;
    }

    public boolean getCellSelectionEnabled() {
        return this.getColumnSelectionAllowed() && this.getRowSelectionAllowed();
    }

    public TableModel getModel() {
        return this.dataModel;
    }

    public int getColumnCount() {
        return this.dataModel.getColumnCount();
    }

    public int getRowCount() {
        return this.dataModel.getRowCount();
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public int getSelectedColumn() {
        return this.columnModel.getSelectionModel().getMinSelectionIndex();
    }

    private static int countSelections(ListSelectionModel lsm) {
        int lo = lsm.getMinSelectionIndex();
        int hi = lsm.getMaxSelectionIndex();
        int sum = 0;
        if (lo != -1 && hi != -1) {
            switch (lsm.getSelectionMode()) {
                case 0: {
                    sum = 1;
                    break;
                }
                case 1: {
                    sum = hi - lo;
                    break;
                }
                case 2: {
                    for (int i = lo; i < hi; ++i) {
                        if (!lsm.isSelectedIndex(i)) continue;
                        ++sum;
                    }
                    break;
                }
            }
        }
        return sum;
    }

    private static int[] getSelections(ListSelectionModel lsm) {
        int sz = JTable.countSelections(lsm);
        int[] ret = new int[sz];
        int lo = lsm.getMinSelectionIndex();
        int hi = lsm.getMaxSelectionIndex();
        int j = 0;
        ArrayList ls = new ArrayList();
        if (lo != -1 && hi != -1) {
            switch (lsm.getSelectionMode()) {
                case 0: {
                    ret[0] = lo;
                    break;
                }
                case 1: {
                    int i = lo;
                    while (i < hi) {
                        ret[j++] = i++;
                    }
                    break;
                }
                case 2: {
                    for (int i = lo; i < hi; ++i) {
                        if (!lsm.isSelectedIndex(i)) continue;
                        ret[j++] = i;
                    }
                    break;
                }
            }
        }
        return ret;
    }

    public int getSelectedColumnCount() {
        return JTable.countSelections(this.columnModel.getSelectionModel());
    }

    public int[] getSelectedColumns() {
        return JTable.getSelections(this.columnModel.getSelectionModel());
    }

    public boolean getColumnSelectionAllowed() {
        return this.getColumnModel().getColumnSelectionAllowed();
    }

    public int getSelectedRowCount() {
        return JTable.countSelections(this.selectionModel);
    }

    public int[] getSelectedRows() {
        return JTable.getSelections(this.selectionModel);
    }

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public Dimension getInterCellSpacing() {
        return new Dimension(this.columnModel.getColumnMargin(), this.rowMargin);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredScrollableViewportSize;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public boolean getShowHorizontalLines() {
        return this.showHorizontalLines;
    }

    public boolean getShowVerticalLines() {
        return this.showVerticalLines;
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setAutoCreateColumnsFromModel(boolean a) {
        this.autoCreateColumnsFromModel = a;
    }

    public void setAutoResizeMode(int a) {
        this.autoResizeMode = a;
        this.revalidate();
        this.repaint();
    }

    public void setRowHeight(int r) {
        this.rowHeight = r;
        this.revalidate();
        this.repaint();
    }

    public void setRowMargin(int r) {
        this.rowMargin = r;
        this.revalidate();
        this.repaint();
    }

    public void setRowSelectionAllowed(boolean r) {
        this.rowSelectionAllowed = r;
        this.repaint();
    }

    public void setCellSelectionEnabled(boolean c) {
        this.setColumnSelectionAllowed(c);
        this.setRowSelectionAllowed(c);
        this.cellSelectionEnabled = true;
    }

    public void setModel(TableModel m) {
        if (m == null) {
            throw new IllegalArgumentException();
        }
        TableModel tmp = this.dataModel;
        if (this.autoCreateColumnsFromModel) {
            this.createColumnsFromModel();
        }
        if (tmp != null) {
            tmp.removeTableModelListener(this);
        }
        if (m != null) {
            m.addTableModelListener(this);
        }
        this.dataModel = m;
        this.revalidate();
        this.repaint();
    }

    public void setColumnModel(TableColumnModel c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        TableColumnModel tmp = this.columnModel;
        if (tmp != null) {
            tmp.removeColumnModelListener(this);
        }
        if (c != null) {
            c.addColumnModelListener(this);
        }
        this.columnModel = c;
        if (this.dataModel != null && this.columnModel != null) {
            int ncols = this.getColumnCount();
            for (int i = 0; i < ncols; ++i) {
                this.columnModel.getColumn(i).setHeaderValue(this.dataModel.getColumnName(i));
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void setColumnSelectionAllowed(boolean c) {
        this.getColumnModel().setColumnSelectionAllowed(c);
        this.repaint();
    }

    public void setSelectionModel(ListSelectionModel s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        ListSelectionModel tmp = this.selectionModel;
        if (tmp != null) {
            tmp.removeListSelectionListener(this);
        }
        if (s != null) {
            s.addListSelectionListener(this);
        }
        this.selectionModel = s;
    }

    public void setSelectionMode(int s) {
        this.selectionModel.setSelectionMode(s);
        this.repaint();
    }

    public void setCellEditor(TableCellEditor c) {
        TableCellEditor tmp = this.cellEditor;
        if (tmp != null) {
            tmp.removeCellEditorListener(this);
        }
        if (c != null) {
            c.addCellEditorListener(this);
        }
        this.cellEditor = c;
    }

    public void setDragEnabled(boolean d) {
        this.dragEnabled = d;
    }

    public void setGridColor(Color g) {
        this.gridColor = g;
        this.repaint();
    }

    public void setInterCellSpacing(Dimension i) {
        this.rowMargin = i.height;
        this.columnModel.setColumnMargin(i.width);
        this.repaint();
    }

    public void setPreferredScrollableViewportSize(Dimension p) {
        this.preferredScrollableViewportSize = p;
        this.revalidate();
        this.repaint();
    }

    public void setSelectionBackground(Color s) {
        Color tmp = this.selectionBackground;
        this.selectionBackground = s;
        if (tmp == null && s != null || s == null && tmp != null || tmp != null && s != null && !tmp.equals(s)) {
            this.firePropertyChange(SELECTION_BACKGROUND_CHANGED_PROPERTY, tmp, s);
        }
        this.repaint();
    }

    public void setSelectionForeground(Color s) {
        Color tmp = this.selectionForeground;
        this.selectionForeground = s;
        if (tmp == null && s != null || s == null && tmp != null || tmp != null && s != null && !tmp.equals(s)) {
            this.firePropertyChange(SELECTION_FOREGROUND_CHANGED_PROPERTY, tmp, s);
        }
        this.repaint();
    }

    public void setShowGrid(boolean s) {
        this.setShowVerticalLines(s);
        this.setShowHorizontalLines(s);
    }

    public void setShowHorizontalLines(boolean s) {
        this.showHorizontalLines = s;
        this.repaint();
    }

    public void setShowVerticalLines(boolean s) {
        this.showVerticalLines = s;
        this.repaint();
    }

    public void setTableHeader(JTableHeader t) {
        if (this.tableHeader != null) {
            this.tableHeader.setTable(null);
        }
        this.tableHeader = t;
        if (this.tableHeader != null) {
            this.tableHeader.setTable(this);
        }
        this.revalidate();
        this.repaint();
    }

    protected void configureEnclosingScrollPane() {
        JScrollPane jsp = (JScrollPane)SwingUtilities.getAncestorOfClass(JTable.class$("javax.swing.JScrollPane"), this);
        if (jsp != null && this.tableHeader != null) {
            jsp.setColumnHeaderView(this.tableHeader);
        }
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    protected void unconfigureEnclosingScrollPane() {
        JScrollPane jsp = (JScrollPane)SwingUtilities.getAncestorOfClass(JTable.class$("javax.swing.JScrollPane"), this);
        if (jsp != null) {
            jsp.setColumnHeaderView(null);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    public void removeNotify() {
        super.addNotify();
        this.unconfigureEnclosingScrollPane();
    }

    private void distributeSpill(TableColumn[] cols, int spill) {
        int i;
        int MIN = 0;
        int MAX = 0;
        int PREF = 0;
        int[] min = new int[cols.length];
        int[] max = new int[cols.length];
        int[] pref = new int[cols.length];
        for (i = 0; i < cols.length; ++i) {
            pref[i] = cols[i].getPreferredWidth();
            min[i] = cols[i].getMinWidth();
            max[i] = cols[i].getMaxWidth();
            PREF += pref[i];
            MIN += min[i];
            MAX += max[i];
        }
        for (i = 0; i < cols.length; ++i) {
            int adj = 0;
            adj = spill > 0 ? spill * (pref[i] - min[i]) / (PREF - MIN) : spill * (max[i] - pref[i]) / (MAX - PREF);
            cols[i].setWidth(pref[i] + adj);
        }
    }

    public void doLayout() {
        TableColumn[] cols;
        TableColumn resizingColumn = null;
        int ncols = this.getColumnCount();
        if (ncols < 1) {
            return;
        }
        int[] pref = new int[ncols];
        int prefSum = 0;
        int rCol = -1;
        if (this.tableHeader != null) {
            resizingColumn = this.tableHeader.getResizingColumn();
        }
        for (int i = 0; i < ncols; ++i) {
            int p;
            TableColumn col = this.columnModel.getColumn(i);
            pref[i] = p = col.getWidth();
            prefSum += p;
            if (resizingColumn != col) continue;
            rCol = i;
        }
        int spill = prefSum - this.getWidth();
        if (resizingColumn != null) {
            switch (this.getAutoResizeMode()) {
                case 3: {
                    TableColumn col = this.columnModel.getColumn(ncols - 1);
                    col.setWidth(col.getPreferredWidth() + spill);
                    break;
                }
                case 1: {
                    TableColumn col = this.columnModel.getColumn(ncols - 1);
                    col.setWidth(col.getPreferredWidth() + spill);
                    break;
                }
                case 4: {
                    cols = new TableColumn[ncols];
                    for (int i = 0; i < ncols; ++i) {
                        cols[i] = this.columnModel.getColumn(i);
                    }
                    this.distributeSpill(cols, spill);
                    break;
                }
                case 2: {
                    cols = new TableColumn[ncols];
                    for (int i = rCol; i < ncols; ++i) {
                        cols[i] = this.columnModel.getColumn(i);
                    }
                    this.distributeSpill(cols, spill);
                }
            }
        } else {
            cols = new TableColumn[ncols];
            for (int i = 0; i < ncols; ++i) {
                cols[i] = this.columnModel.getColumn(i);
            }
            this.distributeSpill(cols, spill);
        }
    }

    public void sizeColumnsToFit(boolean lastColumnOnly) {
        this.doLayout();
    }

    public void sizeColumnsToFit(int resizingColumn) {
        this.doLayout();
    }

    public String getUIClassID() {
        return "TableUI";
    }

    public TableUI getUI() {
        return (TableUI)this.ui;
    }

    public void updateUI() {
        this.setUI((TableUI)UIManager.getUI(this));
        this.revalidate();
        this.repaint();
    }
}

