/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.AccessibleStateSet;
import javax.swing.SwingConstants;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class JTextField
extends JTextComponent
implements SwingConstants {
    private static final long serialVersionUID = 353853209832607592L;
    public static final String notifyAction = "notify-field-accept";
    private int columns;
    private int align;

    public JTextField() {
        this(null, null, 0);
    }

    public JTextField(String text) {
        this(null, text, 0);
    }

    public JTextField(int columns) {
        this(null, null, columns);
    }

    public JTextField(String text, int columns) {
        this(null, text, columns);
    }

    public JTextField(Document doc, String text, int columns) {
        if (columns < 0) {
            throw new IllegalArgumentException();
        }
        this.columns = columns;
        this.setDocument(doc == null ? this.createDefaultModel() : doc);
        if (text != null) {
            this.setText(text);
        }
    }

    protected Document createDefaultModel() {
        return new PlainDocument();
    }

    public String getUIClassID() {
        return "TextFieldUI";
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(JTextField.class$("java.awt.event.ActionListener"), listener);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(JTextField.class$("java.awt.event.ActionListener"), listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(JTextField.class$("java.awt.event.ActionListener"));
    }

    protected void fireActionPerformed() {
        ActionEvent event = new ActionEvent(this, 0, notifyAction);
        ActionListener[] listeners = this.getActionListeners();
        for (int index = 0; index < listeners.length; ++index) {
            listeners[index].actionPerformed(event);
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        if (columns < 0) {
            throw new IllegalArgumentException();
        }
        this.columns = columns;
        this.invalidate();
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.align;
    }

    public void setHorizontalAlignment(int newAlign) {
        int oldAlign = this.align;
        this.align = newAlign;
        this.invalidate();
        this.repaint();
        this.firePropertyChange("horizontalAlignment", oldAlign, newAlign);
    }

    public void setFont(Font newFont) {
        super.setFont(newFont);
        this.revalidate();
    }

    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int fontHeight = fm.getMaxAscent() + fm.getMaxDescent();
        int columnWidth = fm.charWidth('m');
        Dimension size = this.columns != 0 ? new Dimension(this.columns * columnWidth + 4, fontHeight + 4) : new Dimension(10, 10);
        return size;
    }

    protected class AccessibleJTextField
    extends JTextComponent.AccessibleJTextComponent {
        private /* synthetic */ JTextField this$0;
        private static final long serialVersionUID = 8255147276740453036L;

        protected AccessibleJTextField(JTextField this$0) {
            this.this$0 = this$0;
            super(this$0);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }
    }
}

