/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class JToggleButton
extends AbstractButton
implements Accessible {
    private static final long serialVersionUID = -3128248873429850443L;

    public JToggleButton() {
        this(null, null);
    }

    public JToggleButton(Action a) {
        this();
        this.setAction(a);
    }

    public JToggleButton(Icon icon) {
        this(null, icon);
    }

    public JToggleButton(Icon icon, boolean selected) {
        this(null, icon, selected);
    }

    public JToggleButton(String text) {
        this(text, null);
    }

    public JToggleButton(String text, boolean selected) {
        this(text, null, selected);
    }

    public JToggleButton(String text, Icon icon) {
        this(text, icon, false);
    }

    public JToggleButton(String text, Icon icon, boolean selected) {
        super(text, icon);
        this.horizontalAlignment = 10;
        this.setModel(new ToggleButtonModel());
        this.model.setSelected(selected);
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    public String getUIClassID() {
        return "ToggleButtonUI";
    }

    protected String paramString() {
        return "JToggleButton";
    }

    public void updateUI() {
        ButtonUI b = (ButtonUI)UIManager.getUI(this);
        this.setUI(b);
    }

    public static class ToggleButtonModel
    extends DefaultButtonModel {
        private static final long serialVersionUID = -1589950750899943974L;

        public void setPressed(boolean b) {
            if (!this.isEnabled()) {
                return;
            }
            super.setPressed(b);
            if (!b && this.isArmed()) {
                this.setSelected(this.isSelected() ^ true);
            }
        }
    }
}

