/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ViewportUI;

public class JViewport
extends JComponent {
    private static final long serialVersionUID = -6925142919680527970L;
    public static final int SIMPLE_SCROLL_MODE = 0;
    public static final int BLIT_SCROLL_MODE = 1;
    public static final int BACKINGSTORE_SCROLL_MODE = 2;
    ChangeEvent changeEvent;
    int scrollMode;
    protected boolean scrollUnderway;
    protected boolean isViewSizeSet;
    Dimension extentSize;
    Dimension viewSize;
    Point lastPaintPosition;

    private /* synthetic */ void finit$() {
        this.changeEvent = new ChangeEvent(this);
    }

    public JViewport() {
        this.finit$();
        this.setOpaque(true);
        this.updateUI();
    }

    public Dimension getExtentSize() {
        if (this.extentSize == null) {
            return this.toViewCoordinates(this.getSize());
        }
        return this.extentSize;
    }

    public Dimension toViewCoordinates(Dimension size) {
        return size;
    }

    public Point toViewCoordinates(Point p) {
        Point pos = this.getViewPosition();
        return new Point(p.x + pos.x, p.y + pos.y);
    }

    public void setExtentSize(Dimension newSize) {
        this.extentSize = newSize;
        this.fireStateChanged();
    }

    public Dimension getViewSize() {
        if (this.isViewSizeSet) {
            return this.viewSize;
        }
        return this.getView().getSize();
    }

    public void setViewSize(Dimension newSize) {
        this.viewSize = newSize;
        Component view = this.getView();
        if (view != null) {
            view.setSize(this.viewSize);
        }
        this.isViewSizeSet = true;
        this.fireStateChanged();
    }

    public Point getViewPosition() {
        Component view = this.getView();
        if (view == null) {
            return new Point(0, 0);
        }
        Point p = view.getLocation();
        p.x = -p.x;
        p.y = -p.y;
        return p;
    }

    public void setViewPosition(Point p) {
        Component view = this.getView();
        if (view != null) {
            Point q = new Point(-p.x, -p.y);
            view.setLocation(q);
            this.fireStateChanged();
        }
    }

    public Rectangle getViewRect() {
        return new Rectangle(this.getViewPosition(), this.getExtentSize());
    }

    public boolean isBackingStoreEnabled() {
        return this.scrollMode == 2;
    }

    public void setBackingStoreEnabled(boolean b) {
        if (b && this.scrollMode != 2) {
            this.scrollMode = 2;
            this.fireStateChanged();
        }
    }

    public void setScrollMode(int mode) {
        this.scrollMode = mode;
        this.fireStateChanged();
    }

    public int getScrollMode() {
        return this.scrollMode;
    }

    public Component getView() {
        if (this.getComponentCount() == 0) {
            return null;
        }
        return this.getComponents()[0];
    }

    public void setView(Component v) {
        while (this.getComponentCount() > 0) {
            this.remove(0);
        }
        if (v != null) {
            this.add(v);
            this.fireStateChanged();
        }
    }

    public void revalidate() {
        this.fireStateChanged();
        super.revalidate();
    }

    public void reshape(int x, int y, int w, int h) {
        boolean changed = x != this.getX() || y != this.getY() || w != this.getWidth() || h != this.getHeight();
        super.reshape(x, y, w, h);
        if (changed) {
            this.fireStateChanged();
        }
    }

    public void addImpl(Component comp, Object constraints, int index) {
        if (this.getComponentCount() > 0) {
            this.remove(this.getComponents()[0]);
        }
        super.addImpl(comp, constraints, index);
    }

    public final Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public final Insets getInsets(Insets insets) {
        if (insets == null) {
            return this.getInsets();
        }
        insets.top = 0;
        insets.bottom = 0;
        insets.left = 0;
        insets.right = 0;
        return insets;
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.getListeners(JViewport.class$("javax.swing.event.ChangeListener"));
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void paint(Graphics g) {
        this.paintComponent(g);
    }

    void fireStateChanged() {
        ChangeListener[] listeners = this.getChangeListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].stateChanged(this.changeEvent);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(JViewport.class$("javax.swing.event.ChangeListener"), listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(JViewport.class$("javax.swing.event.ChangeListener"), listener);
    }

    public String getUIClassID() {
        return "ViewportUI";
    }

    public void updateUI() {
        this.setUI((ViewportUI)UIManager.getUI(this));
    }
}

