/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class MenuSelectionManager {
    protected ChangeEvent changeEvent;
    protected EventListenerList listenerList;
    private static final MenuSelectionManager manager = new MenuSelectionManager();
    private Vector selectedPath;

    private /* synthetic */ void finit$() {
        this.changeEvent = new ChangeEvent(this);
        this.listenerList = new EventListenerList();
        this.selectedPath = new Vector();
    }

    protected void fireStateChanged() {
        ChangeListener[] listeners = this.getChangeListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].stateChanged(this.changeEvent);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(MenuSelectionManager.class$("javax.swing.event.ChangeListener"), listener);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(MenuSelectionManager.class$("javax.swing.event.ChangeListener"), listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(MenuSelectionManager.class$("javax.swing.event.ChangeListener"));
    }

    public void clearSelectedPath() {
        for (int i = this.selectedPath.size() - 1; i >= 0; --i) {
            ((MenuElement)this.selectedPath.get(i)).menuSelectionChanged(false);
        }
        this.selectedPath.clear();
        this.fireStateChanged();
    }

    public Component componentForPoint(Component source, Point sourcePoint) {
        Point sourcePointOnScreen = sourcePoint;
        SwingUtilities.convertPointToScreen(sourcePointOnScreen, source);
        Component resultComp = null;
        for (int i = 0; i < this.selectedPath.size(); ++i) {
            Component comp = (Component)this.selectedPath.get(i);
            Dimension size = comp.getSize();
            Point compPointOnScreen = comp.getLocationOnScreen();
            if (compPointOnScreen.x > sourcePointOnScreen.x || sourcePointOnScreen.x >= compPointOnScreen.x + size.width || compPointOnScreen.y > sourcePointOnScreen.y || sourcePointOnScreen.y >= compPointOnScreen.y + size.height) continue;
            Point p = sourcePointOnScreen;
            SwingUtilities.convertPointFromScreen(p, comp);
            resultComp = SwingUtilities.getDeepestComponentAt(comp, p.x, p.y);
            break;
        }
        return resultComp;
    }

    public static MenuSelectionManager defaultManager() {
        return manager;
    }

    public MenuElement[] getSelectedPath() {
        MenuElement[] path = new MenuElement[this.selectedPath.size()];
        for (int i = 0; i < path.length; ++i) {
            path[i] = (MenuElement)this.selectedPath.get(i);
        }
        return path;
    }

    public boolean isComponentPartOfCurrentMenu(Component c) {
        for (int i = 0; i < this.selectedPath.size(); ++i) {
            MenuElement[] subElements = ((MenuElement)this.selectedPath.get(i)).getSubElements();
            for (int j = 0; j < subElements.length; ++j) {
                if (!subElements[j].getComponent().equals(c)) continue;
                return true;
            }
        }
        return false;
    }

    public void processKeyEvent(KeyEvent e) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void processMouseEvent(MouseEvent event) {
        Component source = (Component)event.getSource();
        Component mouseOverMenuComp = event.getID() == 506 || event.getID() == 502 ? this.componentForPoint(source, event.getPoint()) : source;
        if (mouseOverMenuComp != null && mouseOverMenuComp instanceof MenuElement) {
            MenuElement[] path = this.getPath(mouseOverMenuComp);
            ((MenuElement)((Object)mouseOverMenuComp)).processMouseEvent(event, path, manager);
        }
    }

    public void setSelectedPath(MenuElement[] path) {
        MenuElement oldSelectedItem;
        int i;
        if (path == null) {
            this.clearSelectedPath();
            return;
        }
        int minSize = path.length;
        if (path.length > this.selectedPath.size()) {
            minSize = this.selectedPath.size();
            for (i = this.selectedPath.size(); i < path.length; ++i) {
                this.selectedPath.add(path[i]);
                path[i].menuSelectionChanged(true);
            }
        } else if (path.length < this.selectedPath.size()) {
            for (i = this.selectedPath.size() - 1; i >= path.length; --i) {
                ((MenuElement)this.selectedPath.get(i)).menuSelectionChanged(false);
                this.selectedPath.remove(i);
            }
            minSize = path.length;
        }
        for (i = minSize - 1; i >= 0 && !path[i].equals(oldSelectedItem = (MenuElement)this.selectedPath.get(i)); --i) {
            oldSelectedItem.menuSelectionChanged(false);
            path[i].menuSelectionChanged(true);
            this.selectedPath.setElementAt(path[i], i);
        }
        this.fireStateChanged();
    }

    private MenuElement[] getPath(Component c) {
        ArrayList path = new ArrayList();
        if (c instanceof JMenu) {
            path.add(((JMenu)c).getPopupMenu());
        }
        while (c instanceof MenuElement) {
            path.add(0, (MenuElement)((Object)c));
            if (c instanceof JPopupMenu) {
                c = ((JPopupMenu)c).getInvoker();
                continue;
            }
            c = c.getParent();
        }
        Object[] pathArray = new MenuElement[path.size()];
        path.toArray(pathArray);
        return pathArray;
    }

    public MenuSelectionManager() {
        this.finit$();
    }
}

