/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class RepaintManager {
    Hashtable dirtyComponents = new Hashtable();
    RepaintWorker repaintWorker;
    Vector invalidComponents = new Vector();
    boolean doubleBufferingEnabled = true;
    Image doubleBuffer;
    Dimension doubleBufferMaximumSize;
    private static RepaintManager globalManager;

    public RepaintManager() {
        this.repaintWorker = new RepaintWorker(this);
        this.doubleBufferMaximumSize = new Dimension(2000, 2000);
    }

    public static RepaintManager currentManager(Component component) {
        if (globalManager == null) {
            globalManager = new RepaintManager();
        }
        return globalManager;
    }

    public static RepaintManager currentManager(JComponent component) {
        return RepaintManager.currentManager((Component)component);
    }

    public static void setCurrentManager(RepaintManager manager) {
        globalManager = manager;
    }

    public synchronized void addInvalidComponent(JComponent component) {
        Container ancestor;
        for (ancestor = component.getParent(); !(ancestor == null || ancestor instanceof JComponent && ((JComponent)ancestor).isValidateRoot()); ancestor = ancestor.getParent()) {
        }
        if (ancestor != null && ancestor instanceof JComponent && ((JComponent)ancestor).isValidateRoot()) {
            component = (JComponent)ancestor;
        }
        if (this.invalidComponents.contains(component)) {
            return;
        }
        this.invalidComponents.add(component);
        if (!this.repaintWorker.isLive()) {
            this.repaintWorker.setLive(true);
            SwingUtilities.invokeLater(this.repaintWorker);
        }
    }

    public synchronized void removeInvalidComponent(JComponent component) {
        this.invalidComponents.removeElement(component);
    }

    public synchronized void addDirtyRegion(JComponent component, int x, int y, int w, int h) {
        Rectangle r = new Rectangle(x, y, w, h);
        if (this.dirtyComponents.containsKey(component)) {
            r = r.union((Rectangle)this.dirtyComponents.get(component));
        }
        this.dirtyComponents.put(component, r);
        if (!this.repaintWorker.isLive()) {
            this.repaintWorker.setLive(true);
            SwingUtilities.invokeLater(this.repaintWorker);
        }
    }

    public Rectangle getDirtyRegion(JComponent component) {
        return (Rectangle)this.dirtyComponents.get(component);
    }

    public void markCompletelyDirty(JComponent component) {
        Rectangle r = component.getBounds();
        this.addDirtyRegion(component, r.x, r.y, r.width, r.height);
    }

    public void markCompletelyClean(JComponent component) {
        this.dirtyComponents.remove(component);
    }

    public boolean isCompletelyDirty(JComponent component) {
        Rectangle dirty = (Rectangle)this.dirtyComponents.get(component);
        if (dirty == null) {
            return false;
        }
        Rectangle r = component.getBounds();
        if (r == null) {
            return true;
        }
        return dirty.contains(r);
    }

    public void validateInvalidComponents() {
        Enumeration e = this.invalidComponents.elements();
        while (e.hasMoreElements()) {
            JComponent comp = (JComponent)e.nextElement();
            if (!comp.isVisible() || !comp.isShowing()) continue;
            comp.validate();
        }
        this.invalidComponents.clear();
    }

    public void paintDirtyRegions() {
        HashMap roots = new HashMap();
        Enumeration e = this.dirtyComponents.keys();
        while (e.hasMoreElements()) {
            JRootPane root;
            JComponent comp = (JComponent)e.nextElement();
            if (!comp.isVisible() || !comp.isShowing()) continue;
            Rectangle damaged = this.getDirtyRegion(comp);
            if (damaged.width == 0 || damaged.height == 0 || (root = comp.getRootPane()) == null) continue;
            Rectangle rootDamage = SwingUtilities.convertRectangle(comp, damaged, root);
            if (!roots.containsKey(root)) {
                roots.put(root, rootDamage);
                continue;
            }
            roots.put(root, ((Rectangle)roots.get(root)).union(rootDamage));
        }
        this.dirtyComponents.clear();
        Iterator i = roots.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry ent = (Map.Entry)i.next();
            JRootPane root = (JRootPane)ent.getKey();
            Rectangle rect = (Rectangle)ent.getValue();
            root.paintImmediately(rect);
        }
    }

    public Image getOffscreenBuffer(Component component, int proposedWidth, int proposedHeight) {
        if (this.doubleBuffer == null || (this.doubleBuffer.getWidth(null) < proposedWidth || this.doubleBuffer.getHeight(null) < proposedHeight) && proposedWidth < this.doubleBufferMaximumSize.width && proposedHeight < this.doubleBufferMaximumSize.height) {
            this.doubleBuffer = component.createImage(proposedWidth, proposedHeight);
        }
        return this.doubleBuffer;
    }

    public Dimension getDoubleBufferMaximumSize() {
        return this.doubleBufferMaximumSize;
    }

    public void setDoubleBufferMaximumSize(Dimension size) {
        this.doubleBufferMaximumSize = size;
    }

    public void setDoubleBufferingEnabled(boolean buffer) {
        this.doubleBufferingEnabled = buffer;
    }

    public boolean isDoubleBufferingEnabled() {
        return this.doubleBufferingEnabled;
    }

    public String toString() {
        return "RepaintManager";
    }

    protected class RepaintWorker
    implements Runnable {
        private /* synthetic */ RepaintManager this$0;
        boolean live = false;

        public RepaintWorker(RepaintManager this$0) {
            this.this$0 = this$0;
        }

        public synchronized void setLive(boolean b) {
            this.live = b;
        }

        public synchronized boolean isLive() {
            return this.live;
        }

        public void run() {
            RepaintManager rm = globalManager;
            this.setLive(false);
            rm.validateInvalidComponents();
            rm.paintDirtyRegions();
        }
    }
}

