/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneConstants;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class ScrollPaneLayout
implements LayoutManager,
ScrollPaneConstants,
Serializable {
    static final long serialVersionUID = -4480022884523193743L;
    protected JViewport viewport;
    protected JScrollBar vsb;
    protected JScrollBar hsb;
    protected JViewport rowHead;
    protected JViewport colHead;
    protected Component lowerLeft;
    protected Component lowerRight;
    protected Component upperLeft;
    protected Component upperRight;
    protected int vsbPolicy;
    protected int hsbPolicy;

    public void syncWithScrollPane(JScrollPane scrollPane) {
        this.viewport = scrollPane.getViewport();
        this.rowHead = scrollPane.getRowHeader();
        this.colHead = scrollPane.getColumnHeader();
        this.vsb = scrollPane.getVerticalScrollBar();
        this.hsb = scrollPane.getHorizontalScrollBar();
        this.vsbPolicy = scrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = scrollPane.getHorizontalScrollBarPolicy();
        this.lowerLeft = scrollPane.getCorner("LOWER_LEFT_CORNER");
        this.lowerRight = scrollPane.getCorner("LOWER_RIGHT_CORNER");
        this.upperLeft = scrollPane.getCorner("UPPER_LEFT_CORNER");
        this.upperRight = scrollPane.getCorner("UPPER_RIGHT_CORNER");
    }

    protected Component addSingletonComponent(Component oldComponent, Component newComponent) {
        return null;
    }

    public void addLayoutComponent(String key, Component component) {
        if (key == "VIEWPORT") {
            this.viewport = (JViewport)component;
        } else if (key == "VERTICAL_SCROLLBAR") {
            this.vsb = (JScrollBar)component;
        } else if (key == "HORIZONTAL_SCROLLBAR") {
            this.hsb = (JScrollBar)component;
        } else if (key == "ROW_HEADER") {
            this.rowHead = (JViewport)component;
        } else if (key == "COLUMN_HEADER") {
            this.colHead = (JViewport)component;
        } else if (key == "LOWER_RIGHT_CORNER") {
            this.lowerRight = component;
        } else if (key == "UPPER_RIGHT_CORNER") {
            this.upperRight = component;
        } else if (key == "LOWER_LEFT_CORNER") {
            this.lowerLeft = component;
        } else if (key == "UPPER_LEFT_CORNER") {
            this.upperLeft = component;
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.viewport) {
            this.viewport = null;
        } else if (component == this.vsb) {
            this.vsb = null;
        } else if (component == this.hsb) {
            this.hsb = null;
        } else if (component == this.rowHead) {
            this.rowHead = null;
        } else if (component == this.colHead) {
            this.colHead = null;
        } else if (component == this.lowerRight) {
            this.lowerRight = null;
        } else if (component == this.upperRight) {
            this.upperRight = null;
        } else if (component == this.lowerLeft) {
            this.lowerLeft = null;
        } else if (component == this.upperLeft) {
            this.upperLeft = null;
        }
    }

    public int getVerticalScrollBarPolicy() {
        return this.vsbPolicy;
    }

    public void setVerticalScrollBarPolicy(int policy) {
        this.vsbPolicy = policy;
    }

    public int getHorizontalScrollBarPolicy() {
        return this.hsbPolicy;
    }

    public void setHorizontalScrollBarPolicy(int policy) {
        this.hsbPolicy = policy;
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.hsb;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.vsb;
    }

    public JViewport getRowHeader() {
        return this.rowHead;
    }

    public JViewport getColumnHeader() {
        return this.colHead;
    }

    public Component getCorner(String key) {
        if (key == "LOWER_RIGHT_CORNER") {
            return this.lowerRight;
        }
        if (key == "UPPER_RIGHT_CORNER") {
            return this.upperRight;
        }
        if (key == "LOWER_LEFT_CORNER") {
            return this.lowerLeft;
        }
        if (key == "UPPER_LEFT_CORNER") {
            return this.upperLeft;
        }
        return null;
    }

    private static void maybeSetPreferredSize(JComponent src, Dimension dim) {
        Dimension tmp = null;
        if (src != null) {
            tmp = src.getPreferredSize();
        }
        if (tmp != null) {
            dim.setSize(tmp);
        }
    }

    private static void maybeSetMinimumSize(JComponent src, Dimension dim) {
        Dimension tmp = null;
        if (src != null) {
            tmp = src.getMinimumSize();
        }
        if (tmp != null) {
            dim.setSize(tmp);
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        if (parent != null && parent instanceof JScrollPane) {
            JScrollPane sc = (JScrollPane)parent;
            Object object = sc.getTreeLock();
            synchronized (object) {
                try {
                    Dimension insetsSize = new Dimension(0, 0);
                    Dimension viewportSize = new Dimension(0, 0);
                    Dimension viewportInsetsSize = new Dimension(0, 0);
                    Dimension columnHeaderSize = new Dimension(0, 0);
                    Dimension rowHeaderSize = new Dimension(0, 0);
                    Dimension verticalScrollBarSize = new Dimension(0, 0);
                    Dimension horizontalScrollBarSize = new Dimension(0, 0);
                    Insets insets = sc.getInsets();
                    Border viewportBorder = sc.getViewportBorder();
                    Insets viewportInsets = null;
                    if (viewportBorder != null && (viewportInsets = viewportBorder.getBorderInsets(parent)) != null) {
                        viewportInsetsSize.setSize(viewportInsets.left + viewportInsets.right, viewportInsets.top + viewportInsets.bottom);
                    }
                    if (insets != null) {
                        insetsSize.setSize(insets.left + insets.right, insets.top + insets.bottom);
                    }
                    if (this.viewport != null) {
                        Component view = null;
                        Scrollable scr = null;
                        Dimension pref = null;
                        view = this.viewport.getView();
                        if (view != null && view instanceof Scrollable) {
                            scr = (Scrollable)((Object)view);
                        }
                        if (scr != null) {
                            pref = scr.getPreferredScrollableViewportSize();
                        }
                        if (pref == null) {
                            pref = this.viewport.getPreferredSize();
                        }
                        if (pref != null) {
                            viewportSize.setSize(pref);
                        }
                    }
                    ScrollPaneLayout.maybeSetPreferredSize(this.colHead, columnHeaderSize);
                    ScrollPaneLayout.maybeSetPreferredSize(this.rowHead, rowHeaderSize);
                    ScrollPaneLayout.maybeSetPreferredSize(this.vsb, verticalScrollBarSize);
                    ScrollPaneLayout.maybeSetPreferredSize(this.hsb, horizontalScrollBarSize);
                    Dimension dimension = new Dimension(insetsSize.width + viewportSize.width + viewportInsetsSize.width + rowHeaderSize.width + verticalScrollBarSize.width, insetsSize.height + viewportSize.height + viewportInsetsSize.height + columnHeaderSize.height + horizontalScrollBarSize.height);
                    Object var15_16 = null;
                    return dimension;
                }
                catch (Throwable throwable) {
                    Object var15_17 = null;
                    throw throwable;
                }
            }
        }
        Dimension dimension = new Dimension(0, 0);
        return dimension;
    }

    public Dimension minimumLayoutSize(Container parent) {
        if (parent instanceof JScrollPane) {
            JScrollPane sc = (JScrollPane)parent;
            Object object = sc.getTreeLock();
            synchronized (object) {
                try {
                    Dimension insetsSize = new Dimension(0, 0);
                    Dimension viewportSize = new Dimension(0, 0);
                    Dimension viewportInsetsSize = new Dimension(0, 0);
                    Dimension columnHeaderSize = new Dimension(0, 0);
                    Dimension rowHeaderSize = new Dimension(0, 0);
                    Dimension verticalScrollBarSize = new Dimension(0, 0);
                    Dimension horizontalScrollBarSize = new Dimension(0, 0);
                    Insets insets = sc.getInsets();
                    Border viewportBorder = sc.getViewportBorder();
                    Insets viewportInsets = null;
                    if (viewportBorder != null && (viewportInsets = viewportBorder.getBorderInsets(parent)) != null) {
                        viewportInsetsSize.setSize(viewportInsets.left + viewportInsets.right, viewportInsets.top + viewportInsets.bottom);
                    }
                    if (insets != null) {
                        insetsSize.setSize(insets.left + insets.right, insets.top + insets.bottom);
                    }
                    ScrollPaneLayout.maybeSetMinimumSize(this.viewport, viewportSize);
                    ScrollPaneLayout.maybeSetMinimumSize(this.colHead, columnHeaderSize);
                    ScrollPaneLayout.maybeSetMinimumSize(this.rowHead, rowHeaderSize);
                    if (this.vsbPolicy != 21) {
                        ScrollPaneLayout.maybeSetMinimumSize(this.vsb, verticalScrollBarSize);
                    }
                    if (this.hsbPolicy != 31) {
                        ScrollPaneLayout.maybeSetMinimumSize(this.hsb, horizontalScrollBarSize);
                    }
                    Dimension dimension = new Dimension(insetsSize.width + viewportSize.width + viewportInsetsSize.width + rowHeaderSize.width + verticalScrollBarSize.width, insetsSize.height + viewportSize.height + viewportInsetsSize.height + columnHeaderSize.height + horizontalScrollBarSize.height);
                    Object var15_16 = null;
                    return dimension;
                }
                catch (Throwable throwable) {
                    Object var15_17 = null;
                    throw throwable;
                }
            }
        }
        Dimension dimension = new Dimension(0, 0);
        return dimension;
    }

    public void layoutContainer(Container parent) {
        if (parent instanceof JScrollPane) {
            JScrollPane sc = (JScrollPane)parent;
            Object object = sc.getTreeLock();
            synchronized (object) {
                block18: {
                    try {
                        boolean showHsb;
                        JViewport viewport = sc.getViewport();
                        Dimension viewSize = viewport.getViewSize();
                        Point viewPos = viewport.getViewPosition();
                        int x1 = 0;
                        int x2 = 0;
                        int x3 = 0;
                        int x4 = 0;
                        int y1 = 0;
                        int y2 = 0;
                        int y3 = 0;
                        int y4 = 0;
                        Rectangle scrollPaneBounds = SwingUtilities.calculateInnerArea(sc, null);
                        x1 = scrollPaneBounds.x;
                        y1 = scrollPaneBounds.y;
                        x4 = scrollPaneBounds.x + scrollPaneBounds.width;
                        y4 = scrollPaneBounds.y + scrollPaneBounds.height;
                        y2 = this.colHead != null ? y1 + this.colHead.getPreferredSize().height : y1;
                        x2 = this.rowHead != null ? x1 + this.rowHead.getPreferredSize().width : x1;
                        int vsbPolicy = sc.getVerticalScrollBarPolicy();
                        int hsbPolicy = sc.getHorizontalScrollBarPolicy();
                        x3 = x4 - this.vsb.getPreferredSize().width;
                        y3 = y4 - this.hsb.getPreferredSize().height;
                        boolean showVsb = this.vsb != null && (vsbPolicy == 22 || vsbPolicy == 20 && viewSize.height > y3 - y2);
                        boolean bl = showHsb = this.hsb != null && (hsbPolicy == 32 || hsbPolicy == 30 && viewSize.width > x3 - x2);
                        if (!showVsb) {
                            x3 = x4;
                        }
                        if (!showHsb) {
                            y3 = y4;
                        }
                        if (viewport != null) {
                            viewport.setBounds(new Rectangle(x2, y2, x3 - x2, y3 - y2));
                        }
                        if (this.colHead != null) {
                            this.colHead.setBounds(new Rectangle(x2, y1, x3 - x2, y2 - y1));
                        }
                        if (this.rowHead != null) {
                            this.rowHead.setBounds(new Rectangle(x1, y2, x2 - x1, y3 - y2));
                        }
                        if (showVsb) {
                            this.vsb.setVisible(true);
                            this.vsb.setBounds(new Rectangle(x3, y2, x4 - x3, y3 - y2));
                        } else if (this.vsb != null) {
                            this.vsb.setVisible(false);
                        }
                        if (showHsb) {
                            this.hsb.setVisible(true);
                            this.hsb.setBounds(new Rectangle(x2, y3, x3 - x2, y4 - y3));
                        } else if (this.hsb != null) {
                            this.hsb.setVisible(false);
                        }
                        if (this.upperLeft != null) {
                            this.upperLeft.setBounds(new Rectangle(x1, y1, x2 - x1, y2 - y1));
                        }
                        if (this.upperRight != null) {
                            this.upperRight.setBounds(new Rectangle(x3, y1, x4 - x3, y2 - y1));
                        }
                        if (this.lowerLeft != null) {
                            this.lowerLeft.setBounds(new Rectangle(x1, y3, x2 - x1, y4 - y3));
                        }
                        if (this.lowerRight == null) break block18;
                        this.lowerRight.setBounds(new Rectangle(x3, y3, x4 - x3, y4 - y3));
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        throw throwable;
                    }
                }
                Object var4_4 = null;
            }
        }
    }

    public Rectangle getViewportBorderBounds(JScrollPane scrollPane) {
        return null;
    }

    public static class UIResource
    extends ScrollPaneLayout
    implements javax.swing.plaf.UIResource {
    }
}

