/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import javax.swing.AbstractSpinnerModel;

public class SpinnerNumberModel
extends AbstractSpinnerModel {
    private Number value;
    private Comparable minimum;
    private Comparable maximum;
    private Number stepSize;

    public SpinnerNumberModel() {
        this(new Integer(0), null, null, new Integer(1));
    }

    public SpinnerNumberModel(double value, double minimum, double maximum, double stepSize) {
        this(new Double(value), new Double(minimum), new Double(maximum), new Double(stepSize));
    }

    public SpinnerNumberModel(int value, int minimum, int maximum, int stepSize) {
        this(new Integer(value), new Integer(minimum), new Integer(maximum), new Integer(stepSize));
    }

    public SpinnerNumberModel(Number value, Comparable minimum, Comparable maximum, Number stepSize) {
        if (stepSize == null) {
            throw new IllegalArgumentException("stepSize may not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value may not be null");
        }
        if (minimum != null) {
            if (minimum.compareTo(value) > 0) {
                throw new IllegalArgumentException("minimum is not <= value");
            }
        } else {
            minimum = new Comparable(this){
                private /* synthetic */ SpinnerNumberModel this$0;
                {
                    this.this$0 = this$0;
                }

                public int compareTo(Object obj) {
                    return -1;
                }
            };
        }
        if (maximum != null) {
            if (maximum.compareTo(value) < 0) {
                throw new IllegalArgumentException("maximum is not >= value");
            }
        } else {
            maximum = new Comparable(this){
                private /* synthetic */ SpinnerNumberModel this$0;
                {
                    this.this$0 = this$0;
                }

                public int compareTo(Object obj) {
                    return 1;
                }
            };
        }
        this.value = value;
        this.stepSize = stepSize;
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public void setValue(Object value) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("value must be a Number");
        }
        this.value = (Number)value;
        this.fireStateChanged();
    }

    public Object getValue() {
        return this.value;
    }

    public Object getNextValue() {
        Number num = this.value instanceof Double ? (Number)new Double(this.value.doubleValue() + this.stepSize.doubleValue()) : (Number)(this.value instanceof Float ? (Number)new Double(this.value.floatValue() + this.stepSize.floatValue()) : (Number)(this.value instanceof Long ? (Number)new Long(this.value.longValue() + this.stepSize.longValue()) : (Number)(this.value instanceof Integer ? (Number)new Integer(this.value.intValue() + this.stepSize.intValue()) : (Number)(this.value instanceof Short ? (Number)new Short(this.value.shortValue() + this.stepSize.shortValue()) : (Number)new Byte(this.value.byteValue() + this.stepSize.byteValue())))));
        if (this.maximum.compareTo(num) >= 0) {
            return num;
        }
        return null;
    }

    public Object getPreviousValue() {
        Number num = this.value instanceof Double ? (Number)new Double(this.value.doubleValue() - this.stepSize.doubleValue()) : (Number)(this.value instanceof Float ? (Number)new Double(this.value.floatValue() - this.stepSize.floatValue()) : (Number)(this.value instanceof Long ? (Number)new Long(this.value.longValue() - this.stepSize.longValue()) : (Number)(this.value instanceof Integer ? (Number)new Integer(this.value.intValue() - this.stepSize.intValue()) : (Number)(this.value instanceof Short ? (Number)new Short(this.value.shortValue() - this.stepSize.shortValue()) : (Number)new Byte(this.value.byteValue() - this.stepSize.byteValue())))));
        if (this.minimum.compareTo(num) <= 0) {
            return num;
        }
        return null;
    }

    public Number getNumber() {
        return this.value;
    }
}

