/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

public abstract class Spring {
    public static final int UNSET = Integer.MIN_VALUE;

    protected Spring() {
    }

    public static Spring constant(int val) {
        return new SimpleSpring(val, val, val);
    }

    public static Spring constant(int min, int pref, int max) {
        return new SimpleSpring(min, pref, max);
    }

    public abstract int getMaximumValue();

    public abstract int getMinimumValue();

    public abstract int getPreferredValue();

    public abstract int getValue();

    public static Spring max(Spring s1, Spring s2) {
        return new MaxSpring(s1, s2);
    }

    public static Spring minus(Spring s) {
        return new MinusSpring(s);
    }

    public abstract void setValue(int var1);

    public static Spring sum(Spring s1, Spring s2) {
        return new AddSpring(s1, s2);
    }

    private static final class MaxSpring
    extends Spring {
        private final Spring s1;
        private final Spring s2;
        private int value;

        protected MaxSpring(Spring s1, Spring s2) {
            this.s1 = s1;
            this.s2 = s2;
            this.value = Integer.MIN_VALUE;
        }

        public int getMaximumValue() {
            int max1 = this.s1.getMaximumValue();
            int max2 = this.s2.getMaximumValue();
            return Math.max(max1, max2);
        }

        public int getMinimumValue() {
            int min1 = this.s1.getMinimumValue();
            int min2 = this.s2.getMinimumValue();
            return Math.max(min1, min2);
        }

        public int getPreferredValue() {
            int pref1 = this.s1.getPreferredValue();
            int pref2 = this.s2.getPreferredValue();
            return Math.max(pref1, pref2);
        }

        public int getValue() {
            if (this.value == Integer.MIN_VALUE) {
                int val1 = this.s1.getValue();
                int val2 = this.s2.getValue();
                this.value = Math.max(val1, val2);
            }
            return this.value;
        }

        public void setValue(int val) {
            this.value = val > this.getMaximumValue() ? this.getMaximumValue() : (val < this.getMinimumValue() ? this.getMinimumValue() : val);
        }
    }

    private static final class MinusSpring
    extends Spring {
        private final Spring s;
        private int value;

        protected MinusSpring(Spring s) {
            this.s = s;
            this.value = Integer.MIN_VALUE;
        }

        public int getMaximumValue() {
            return -this.s.getMinimumValue();
        }

        public int getMinimumValue() {
            return -this.s.getMaximumValue();
        }

        public int getPreferredValue() {
            return -this.s.getPreferredValue();
        }

        public int getValue() {
            if (this.value == Integer.MIN_VALUE) {
                this.value = -this.s.getValue();
            }
            return this.value;
        }

        public void setValue(int val) {
            this.value = val > this.getMaximumValue() ? this.getMaximumValue() : (val < this.getMinimumValue() ? this.getMinimumValue() : val);
        }
    }

    private static final class AddSpring
    extends Spring {
        private final Spring s1;
        private final Spring s2;
        private int value;

        protected AddSpring(Spring s1, Spring s2) {
            this.s1 = s1;
            this.s2 = s2;
            this.value = Integer.MIN_VALUE;
        }

        public int getMaximumValue() {
            int max1 = this.s1.getMaximumValue();
            int max2 = this.s2.getMaximumValue();
            return max1 + max2;
        }

        public int getMinimumValue() {
            int min1 = this.s1.getMinimumValue();
            int min2 = this.s2.getMinimumValue();
            return min1 + min2;
        }

        public int getPreferredValue() {
            int pref1 = this.s1.getPreferredValue();
            int pref2 = this.s2.getPreferredValue();
            return pref1 + pref2;
        }

        public int getValue() {
            if (this.value == Integer.MIN_VALUE) {
                int val1 = this.s1.getValue();
                int val2 = this.s2.getValue();
                this.value = val1 + val2;
            }
            return this.value;
        }

        public void setValue(int val) {
            this.value = val > this.getMaximumValue() ? this.getMaximumValue() : (val < this.getMinimumValue() ? this.getMinimumValue() : val);
        }
    }

    private static final class SimpleSpring
    extends Spring {
        private final int min;
        private final int pref;
        private final int max;
        private int value;

        public SimpleSpring(int newMin, int newPref, int newMax) {
            this.min = newMin;
            this.pref = newPref;
            this.max = newMax;
            this.value = Integer.MIN_VALUE;
        }

        public int getMaximumValue() {
            return this.max;
        }

        public int getMinimumValue() {
            return this.min;
        }

        public int getPreferredValue() {
            return this.pref;
        }

        public int getValue() {
            if (this.value == Integer.MIN_VALUE) {
                this.value = this.pref;
            }
            return this.value;
        }

        public void setValue(int val) {
            this.value = val > this.max ? this.max : (val < this.min ? this.min : val);
        }
    }
}

