/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.InputMapUIResource;

public class SwingUtilities
implements SwingConstants {
    private static OwnerFrame ownerFrame;

    public static Rectangle calculateInsetArea(Rectangle base, Insets insets, Rectangle ret) {
        if (ret == null) {
            ret = new Rectangle();
        }
        ret.setBounds(base.x + insets.left, base.y + insets.top, base.width - (insets.left + insets.right), base.height - (insets.top + insets.bottom));
        return ret;
    }

    public static Rectangle calculateInnerArea(JComponent c, Rectangle r) {
        Rectangle b = SwingUtilities.getLocalBounds(c);
        return SwingUtilities.calculateInsetArea(b, c.getInsets(), r);
    }

    public static Rectangle getLocalBounds(Component aComponent) {
        Rectangle bounds = aComponent.getBounds();
        return new Rectangle(0, 0, bounds.width, bounds.height);
    }

    public static FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static JRootPane getRootPane(Component comp) {
        if (comp instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)comp)).getRootPane();
        }
        return (JRootPane)SwingUtilities.getAncestorOfClass(SwingUtilities.class$("javax.swing.JRootPane"), comp);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public static Container getAncestorNamed(String name, Component comp) {
        while (comp != null && comp.getName() != name) {
            comp = comp.getParent();
        }
        return (Container)comp;
    }

    public static Container getAncestorOfClass(Class c, Component comp) {
        while (comp != null && !c.isInstance(comp)) {
            comp = comp.getParent();
        }
        return (Container)comp;
    }

    public static Window windowForComponent(Component comp) {
        return (Window)SwingUtilities.getAncestorOfClass(SwingUtilities.class$("java.awt.Window"), comp);
    }

    public static Component getRoot(Component comp) {
        Applet app = null;
        Window win = null;
        while (comp != null) {
            if (win == null && comp instanceof Window) {
                win = (Window)comp;
            } else if (comp instanceof Applet) {
                app = (Applet)comp;
            }
            comp = comp.getParent();
        }
        if (win != null) {
            return win;
        }
        return app;
    }

    public static boolean isDescendingFrom(Component a, Component b) {
        while (a != null && b != null) {
            if (a == b) {
                return true;
            }
            a = a.getParent();
        }
        return false;
    }

    public static Component getDeepestComponentAt(Component parent, int x, int y) {
        if (parent == null || !parent.contains(x, y)) {
            return null;
        }
        if (!(parent instanceof Container)) {
            return parent;
        }
        Container c = (Container)parent;
        return c.findComponentAt(x, y);
    }

    public static void convertPointToScreen(Point p, Component c) {
        Point c0 = c.getLocationOnScreen();
        p.translate(c0.x, c0.y);
    }

    public static void convertPointFromScreen(Point p, Component c) {
        Point c0 = c.getLocationOnScreen();
        p.translate(-c0.x, -c0.y);
    }

    public static Point convertPoint(Component source, int x, int y, Component destination) {
        Point pt = new Point(x, y);
        if (source == null && destination == null) {
            return pt;
        }
        if (source == null) {
            source = SwingUtilities.getRoot(destination);
        }
        if (destination == null) {
            destination = SwingUtilities.getRoot(source);
        }
        SwingUtilities.convertPointToScreen(pt, source);
        SwingUtilities.convertPointFromScreen(pt, destination);
        return pt;
    }

    public static Point convertPoint(Component source, Point aPoint, Component destination) {
        return SwingUtilities.convertPoint(source, aPoint.x, aPoint.y, destination);
    }

    public static Rectangle convertRectangle(Component source, Rectangle rect, Component destination) {
        Point pt = SwingUtilities.convertPoint(source, rect.x, rect.y, destination);
        return new Rectangle(pt.x, pt.y, rect.width, rect.height);
    }

    public static MouseEvent convertMouseEvent(Component source, MouseEvent sourceEvent, Component destination) {
        Point newpt = SwingUtilities.convertPoint(source, sourceEvent.getX(), sourceEvent.getY(), destination);
        return new MouseEvent(destination, sourceEvent.getID(), sourceEvent.getWhen(), sourceEvent.getModifiersEx(), newpt.x, newpt.y, sourceEvent.getClickCount(), sourceEvent.isPopupTrigger(), sourceEvent.getButton());
    }

    public static void updateComponentTreeUI(Component comp) {
        if (comp == null) {
            return;
        }
        if (comp instanceof Container) {
            Component[] children = ((Container)comp).getComponents();
            for (int i = 0; i < children.length; ++i) {
                SwingUtilities.updateComponentTreeUI(children[i]);
            }
        }
        if (comp instanceof JComponent) {
            ((JComponent)comp).updateUI();
        }
    }

    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        if (horizontalTextPosition == 10) {
            horizontalTextPosition = c.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? 4 : 2;
        } else if (horizontalTextPosition == 11) {
            horizontalTextPosition = c.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? 2 : 4;
        }
        if (horizontalAlignment == 10) {
            horizontalAlignment = c.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? 4 : 2;
        } else if (horizontalAlignment == 11) {
            horizontalAlignment = c.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT ? 2 : 4;
        }
        return SwingUtilities.layoutCompoundLabel(fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
    }

    public static String layoutCompoundLabel(FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int centerLine;
        if (icon == null) {
            textIconGap = 0;
            iconR.width = 0;
            iconR.height = 0;
        } else {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        }
        if (text == null) {
            textIconGap = 0;
            textR.width = 0;
            textR.height = 0;
        } else {
            textR.width = fm.stringWidth(text);
            textR.height = fm.getHeight();
        }
        switch (horizontalTextPosition) {
            case 2: {
                textR.x = 0;
                iconR.x = textR.width + textIconGap;
                break;
            }
            case 4: {
                iconR.x = 0;
                textR.x = iconR.width + textIconGap;
                break;
            }
            case 0: {
                centerLine = Math.max(textR.width, iconR.width) / 2;
                textR.x = centerLine - textR.width / 2;
                iconR.x = centerLine - iconR.width / 2;
            }
        }
        switch (verticalTextPosition) {
            case 1: {
                textR.y = 0;
                iconR.y = horizontalTextPosition == 0 ? textR.height + textIconGap : 0;
                break;
            }
            case 3: {
                iconR.y = 0;
                textR.y = horizontalTextPosition == 0 ? iconR.height + textIconGap : iconR.height - textR.height;
                break;
            }
            case 0: {
                centerLine = Math.max(textR.height, iconR.height) / 2;
                textR.y = centerLine - textR.height / 2;
                iconR.y = centerLine - iconR.height / 2;
            }
        }
        Rectangle u = textR.union(iconR);
        int horizontalAdjustment = viewR.x;
        int verticalAdjustment = viewR.y;
        switch (verticalAlignment) {
            case 1: {
                break;
            }
            case 3: {
                verticalAdjustment += viewR.height - u.height;
                break;
            }
            case 0: {
                verticalAdjustment += viewR.height / 2 - u.height / 2;
            }
        }
        switch (horizontalAlignment) {
            case 2: {
                break;
            }
            case 4: {
                horizontalAdjustment += viewR.width - u.width;
                break;
            }
            case 0: {
                horizontalAdjustment += viewR.width / 2 - u.width / 2;
            }
        }
        iconR.x += horizontalAdjustment;
        iconR.y += verticalAdjustment;
        textR.x += horizontalAdjustment;
        textR.y += verticalAdjustment;
        return text;
    }

    public static void invokeLater(Runnable doRun) {
        EventQueue.invokeLater(doRun);
    }

    public static void invokeAndWait(Runnable doRun) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(doRun);
    }

    public static boolean isEventDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public static void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h) {
        Container parent = c.getParent();
        if (parent != null) {
            parent.remove(c);
        }
        if (p != null) {
            p.add(c);
        }
        Shape savedClip = g.getClip();
        g.setClip(x, y, w, h);
        g.translate(x, y);
        c.paint(g);
        g.translate(-x, -y);
        g.setClip(savedClip);
    }

    public static void paintComponent(Graphics g, Component c, Container p, Rectangle r) {
        SwingUtilities.paintComponent(g, c, p, r.x, r.y, r.width, r.height);
    }

    static Frame getOwnerFrame() {
        if (ownerFrame == null) {
            ownerFrame = new OwnerFrame();
        }
        return ownerFrame;
    }

    public static boolean isLeftMouseButton(MouseEvent event) {
        return (event.getModifiersEx() >> 10 & 1) != 0;
    }

    public static boolean isMiddleMouseButton(MouseEvent event) {
        return (event.getModifiersEx() >> 11 & 1) != 0;
    }

    public static boolean isRightMouseButton(MouseEvent event) {
        return (event.getModifiersEx() >> 12 & 1) != 0;
    }

    public static boolean notifyAction(Action action, KeyStroke ks, KeyEvent event, Object sender, int modifiers) {
        if (action != null && action.isEnabled()) {
            String name = (String)action.getValue("ActionCommandKey");
            if (name == null && event.getKeyChar() != '\uffff') {
                name = new String(new char[]{event.getKeyChar()});
            }
            action.actionPerformed(new ActionEvent(sender, 1001, name, modifiers));
            return true;
        }
        return false;
    }

    public static void replaceUIActionMap(JComponent component, ActionMap uiActionMap) {
        ActionMap child = component.getActionMap();
        if (child == null) {
            component.setActionMap(uiActionMap);
        } else {
            while (child.getParent() != null && !(child.getParent() instanceof ActionMapUIResource)) {
                child = child.getParent();
            }
            if (child != null) {
                child.setParent(uiActionMap);
            }
        }
    }

    public static void replaceUIInputMap(JComponent component, int condition, InputMap uiInputMap) {
        InputMap child = component.getInputMap(condition);
        if (child == null) {
            component.setInputMap(condition, uiInputMap);
        } else {
            while (child.getParent() != null && !(child.getParent() instanceof InputMapUIResource)) {
                child = child.getParent();
            }
            if (child != null) {
                child.setParent(uiInputMap);
            }
        }
    }

    private static class OwnerFrame
    extends Frame {
        public void setVisible(boolean b) {
        }

        public boolean isShowing() {
            return true;
        }

        OwnerFrame() {
        }
    }
}

