/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    Timer enterTimer;
    Timer exitTimer;
    Timer insideTimer;
    private transient boolean enabled;
    protected boolean lightWeightPopupEnabled;
    protected boolean heavyWeightPopupEnabled;
    private static ToolTipManager shared;
    private static Component currentComponent;
    private static JToolTip currentTip;
    private static Point currentPoint;
    private static Container containerPanel;
    private static JWindow tooltipWindow;

    private /* synthetic */ void finit$() {
        this.enabled = true;
        this.lightWeightPopupEnabled = true;
        this.heavyWeightPopupEnabled = false;
    }

    ToolTipManager() {
        this.finit$();
        this.enterTimer = new Timer(750, new insideTimerAction(this));
        this.enterTimer.setRepeats(false);
        this.insideTimer = new Timer(4000, new stillInsideTimerAction(this));
        this.insideTimer.setRepeats(false);
        this.exitTimer = new Timer(500, new outsideTimerAction(this));
        this.exitTimer.setRepeats(false);
    }

    public static ToolTipManager sharedInstance() {
        if (shared == null) {
            shared = new ToolTipManager();
        }
        return shared;
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.enterTimer.stop();
            this.exitTimer.stop();
            this.insideTimer.stop();
        }
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setLightWeightPopupEnabled(boolean enabled) {
        this.lightWeightPopupEnabled = enabled;
        this.heavyWeightPopupEnabled = enabled ^ true;
    }

    public int getInitialDelay() {
        return this.enterTimer.getDelay();
    }

    public void setInitialDelay(int delay) {
        this.enterTimer.setDelay(delay);
    }

    public int getDismissDelay() {
        return this.insideTimer.getDelay();
    }

    public void setDismissDelay(int delay) {
        this.insideTimer.setDelay(delay);
    }

    public int getReshowDelay() {
        return this.exitTimer.getDelay();
    }

    public void setReshowDelay(int delay) {
        this.exitTimer.setDelay(delay);
    }

    public void registerComponent(JComponent component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    public void unregisterComponent(JComponent component) {
        component.removeMouseMotionListener(this);
        component.removeMouseListener(this);
    }

    public void mouseEntered(MouseEvent event) {
        if (currentComponent != null && this.getContentPaneDeepestComponent(event) == currentComponent) {
            return;
        }
        currentPoint = event.getPoint();
        currentComponent = (Component)event.getSource();
        if (this.exitTimer.isRunning()) {
            this.exitTimer.stop();
            this.showTip();
            this.insideTimer.start();
            return;
        }
        if (!this.enterTimer.isRunning()) {
            this.enterTimer.start();
        }
    }

    public void mouseExited(MouseEvent event) {
        if (this.getContentPaneDeepestComponent(event) == currentComponent) {
            return;
        }
        currentPoint = event.getPoint();
        currentComponent = null;
        this.hideTip();
        if (!this.enterTimer.isRunning() && this.insideTimer.isRunning()) {
            this.exitTimer.start();
        }
        if (this.enterTimer.isRunning()) {
            this.enterTimer.stop();
        }
        if (this.insideTimer.isRunning()) {
            this.insideTimer.stop();
        }
    }

    public void mousePressed(MouseEvent event) {
        currentPoint = event.getPoint();
        if (this.enterTimer.isRunning()) {
            this.enterTimer.restart();
        } else if (this.insideTimer.isRunning()) {
            this.insideTimer.stop();
            this.hideTip();
        }
        currentComponent.invalidate();
        currentComponent.validate();
        currentComponent.repaint();
    }

    public void mouseDragged(MouseEvent event) {
        currentPoint = event.getPoint();
        if (this.enterTimer.isRunning()) {
            this.enterTimer.restart();
        }
    }

    public void mouseMoved(MouseEvent event) {
        currentPoint = event.getPoint();
        if (currentTip != null) {
            currentTip.setTipText(((JComponent)currentComponent).getToolTipText(event));
        }
        if (this.enterTimer.isRunning()) {
            this.enterTimer.restart();
        }
    }

    private void showTip() {
        if (!this.enabled) {
            return;
        }
        if (currentTip == null || currentTip.getComponent() != currentComponent && currentComponent instanceof JComponent) {
            currentTip = ((JComponent)currentComponent).createToolTip();
        }
        Point p = currentPoint;
        Dimension dims = currentTip.getPreferredSize();
        if (this.canToolTipFit(currentTip)) {
            JLayeredPane pane = ((JRootPane)SwingUtilities.getAncestorOfClass(ToolTipManager.class$("javax.swing.JRootPane"), currentComponent)).getLayeredPane();
            if (pane == null) {
                return;
            }
            if (containerPanel != null) {
                this.hideTip();
            }
            if (this.isLightWeightPopupEnabled()) {
                containerPanel = new Panel();
                JRootPane root = new JRootPane();
                root.getContentPane().add(currentTip);
                containerPanel.add(root);
            } else {
                containerPanel = new JPanel();
                containerPanel.add(currentTip);
            }
            LayoutManager lm = containerPanel.getLayout();
            if (lm instanceof FlowLayout) {
                FlowLayout fm = (FlowLayout)lm;
                fm.setVgap(0);
                fm.setHgap(0);
            }
            p = this.getGoodPoint(p, pane, currentTip, dims);
            pane.add(containerPanel);
            containerPanel.setBounds(p.x, p.y, dims.width, dims.height);
            currentTip.setBounds(0, 0, dims.width, dims.height);
            pane.revalidate();
            pane.repaint();
        } else {
            SwingUtilities.convertPointToScreen(p, currentComponent);
            tooltipWindow = new JWindow();
            tooltipWindow.getContentPane().add(currentTip);
            tooltipWindow.setFocusable(false);
            tooltipWindow.pack();
            tooltipWindow.setBounds(p.x, p.y, dims.width, dims.height);
            tooltipWindow.show();
        }
        currentTip.setVisible(true);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    private void hideTip() {
        if (currentTip == null || !currentTip.isVisible() || !this.enabled) {
            return;
        }
        currentTip.setVisible(false);
        if (containerPanel != null) {
            Container parent = containerPanel.getParent();
            if (parent == null) {
                return;
            }
            parent.remove(containerPanel);
            parent.invalidate();
            parent.validate();
            parent.repaint();
            parent = currentTip.getParent();
            if (parent == null) {
                return;
            }
            parent.remove(currentTip);
            containerPanel = null;
        }
        if (tooltipWindow != null) {
            tooltipWindow.hide();
            tooltipWindow.dispose();
            tooltipWindow = null;
        }
    }

    private Point getGoodPoint(Point p, JLayeredPane c, JToolTip tip, Dimension dims) {
        if (dims == null) {
            dims = tip.getPreferredSize();
        }
        Rectangle bounds = currentComponent.getBounds();
        if (p.x + dims.width > bounds.width) {
            p.x = bounds.width - dims.width;
        }
        if (p.y + dims.height > bounds.height) {
            p.y = bounds.height - dims.height;
        }
        p = SwingUtilities.convertPoint(currentComponent, p, c);
        return p;
    }

    private Component getContentPaneDeepestComponent(MouseEvent e) {
        Component source = (Component)e.getSource();
        Container parent = SwingUtilities.getAncestorOfClass(ToolTipManager.class$("javax.swing.JRootPane"), currentComponent);
        if (parent == null) {
            return null;
        }
        parent = ((JRootPane)parent).getContentPane();
        Point p = e.getPoint();
        p = SwingUtilities.convertPoint(source, p, parent);
        Component target = SwingUtilities.getDeepestComponentAt(parent, p.x, p.y);
        return target;
    }

    private boolean canToolTipFit(JToolTip tip) {
        JRootPane root = (JRootPane)SwingUtilities.getAncestorOfClass(ToolTipManager.class$("javax.swing.JRootPane"), currentComponent);
        if (root == null) {
            return false;
        }
        Dimension pref = tip.getPreferredSize();
        Dimension rootSize = root.getSize();
        return rootSize.width > pref.width && rootSize.height > pref.height;
    }

    protected class insideTimerAction
    implements ActionListener {
        private /* synthetic */ ToolTipManager this$0;

        protected insideTimerAction(ToolTipManager this$0) {
            this.this$0 = this$0;
        }

        public void actionPerformed(ActionEvent event) {
            this.this$0.showTip();
            if (this.this$0.insideTimer != null) {
                this.this$0.insideTimer.start();
            }
        }
    }

    protected class outsideTimerAction
    implements ActionListener {
        private /* synthetic */ ToolTipManager this$0;

        protected outsideTimerAction(ToolTipManager this$0) {
            this.this$0 = this$0;
        }

        public void actionPerformed(ActionEvent event) {
        }
    }

    protected class stillInsideTimerAction
    implements ActionListener {
        private /* synthetic */ ToolTipManager this$0;

        protected stillInsideTimerAction(ToolTipManager this$0) {
            this.this$0 = this$0;
        }

        public void actionPerformed(ActionEvent event) {
            this.this$0.hideTip();
        }
    }
}

