/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JViewport;

public class ViewportLayout
implements LayoutManager,
Serializable {
    static final long serialVersionUID = -788225906076097229L;

    public void addLayoutComponent(String name, Component c) {
    }

    public void removeLayoutComponent(Component c) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        JViewport vp = (JViewport)parent;
        Component view = vp.getView();
        return view.getPreferredSize();
    }

    public Dimension minimumLayoutSize(Container parent) {
        JViewport vp = (JViewport)parent;
        Component view = vp.getView();
        return view.getMinimumSize();
    }

    public void layoutContainer(Container parent) {
        int overextension;
        JViewport port = (JViewport)parent;
        Component view = port.getView();
        Rectangle portBounds = port.getViewRect();
        Dimension viewPref = view.getPreferredSize();
        Dimension viewMinimum = view.getMinimumSize();
        Point portLowerRight = new Point(portBounds.x + portBounds.width, portBounds.y + portBounds.height);
        if (portBounds.height >= viewMinimum.height) {
            portBounds.y = 0;
            viewPref.height = portBounds.height;
        } else {
            viewPref.height = viewMinimum.height;
            overextension = portLowerRight.y - viewPref.height;
            if (overextension > 0) {
                portBounds.y -= overextension;
            }
        }
        if (portBounds.width >= viewMinimum.width) {
            portBounds.x = 0;
            viewPref.width = portBounds.width;
        } else {
            viewPref.width = viewMinimum.width;
            overextension = portLowerRight.x - viewPref.width;
            if (overextension > 0) {
                portBounds.x -= overextension;
            }
        }
        port.setViewPosition(portBounds.getLocation());
        port.setViewSize(viewPref);
    }
}

