/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DefaultHSBChooserPanel
extends AbstractColorChooserPanel {
    private transient Image gradientImage;
    private transient JPanel gradientPanel;
    private transient Image trackImage;
    private transient JPanel trackPanel;
    private transient JSlider slider;
    private transient JRadioButton hRadio;
    private transient JRadioButton sRadio;
    private transient JRadioButton bRadio;
    private transient JSpinner hSpinner;
    private transient JSpinner sSpinner;
    private transient JSpinner bSpinner;
    private static final int imgWidth = 200;
    private static final int imgHeight = 200;
    private static final int trackWidth = 30;
    private static final JLabel R = new JLabel("R");
    private static final JLabel G = new JLabel("G");
    private static final JLabel B = new JLabel("B");
    private transient JLabel rFull;
    private transient JLabel gFull;
    private transient JLabel bFull;
    private transient Point gradientPoint;
    private transient boolean internalChange;
    private transient boolean spinnerTrigger;
    private transient int locked;
    static final int HLOCKED = 0;
    static final int SLOCKED = 1;
    static final int BLOCKED = 2;
    private transient boolean handlingMouse;

    private /* synthetic */ void finit$() {
        this.gradientPoint = new Point();
        this.internalChange = false;
        this.spinnerTrigger = false;
        this.locked = -1;
    }

    static /* synthetic */ JSlider access$16(DefaultHSBChooserPanel inst$, JSlider write_parm_value$) {
        inst$.slider = write_parm_value$;
        return inst$.slider;
    }

    static /* synthetic */ JRadioButton access$14(DefaultHSBChooserPanel inst$, JRadioButton write_parm_value$) {
        inst$.sRadio = write_parm_value$;
        return inst$.sRadio;
    }

    static /* synthetic */ JRadioButton access$12(DefaultHSBChooserPanel inst$, JRadioButton write_parm_value$) {
        inst$.hRadio = write_parm_value$;
        return inst$.hRadio;
    }

    static /* synthetic */ boolean access$8(DefaultHSBChooserPanel inst$) {
        return inst$.spinnerTrigger;
    }

    static /* synthetic */ JSpinner access$7(DefaultHSBChooserPanel inst$, JSpinner write_parm_value$) {
        inst$.bSpinner = write_parm_value$;
        return inst$.bSpinner;
    }

    static /* synthetic */ JSpinner access$6(DefaultHSBChooserPanel inst$, JSpinner write_parm_value$) {
        inst$.sSpinner = write_parm_value$;
        return inst$.sSpinner;
    }

    static /* synthetic */ JSpinner access$5(DefaultHSBChooserPanel inst$, JSpinner write_parm_value$) {
        inst$.hSpinner = write_parm_value$;
        return inst$.hSpinner;
    }

    static /* synthetic */ Image access$2(DefaultHSBChooserPanel inst$, Image write_parm_value$) {
        inst$.gradientImage = write_parm_value$;
        return inst$.gradientImage;
    }

    static /* synthetic */ Image access$1(DefaultHSBChooserPanel inst$, Image write_parm_value$) {
        inst$.trackImage = write_parm_value$;
        return inst$.trackImage;
    }

    DefaultHSBChooserPanel() {
        this.finit$();
    }

    public String getDisplayName() {
        return "HSB";
    }

    public void updateChooser() {
        Color c = this.getColorSelectionModel().getSelectedColor();
        float[] hsbVals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        this.internalChange = true;
        if (!this.spinnerTrigger) {
            this.hSpinner.setValue(new Integer((int)(hsbVals[0] * 360.0f)));
            this.sSpinner.setValue(new Integer((int)(hsbVals[1] * 100.0f)));
            this.bSpinner.setValue(new Integer((int)(hsbVals[2] * 100.0f)));
        }
        switch (this.locked) {
            case 0: {
                if (this.slider != null) {
                    this.slider.setValue(((Number)this.hSpinner.getValue()).intValue());
                }
                if (this.handlingMouse) break;
                this.gradientPoint.x = (int)((1.0f - hsbVals[1]) * 200.0f);
                this.gradientPoint.y = (int)((1.0f - hsbVals[2]) * 200.0f);
                break;
            }
            case 1: {
                if (this.slider != null) {
                    this.slider.setValue(((Number)this.sSpinner.getValue()).intValue());
                }
                if (this.handlingMouse) break;
                this.gradientPoint.x = (int)(hsbVals[0] * 200.0f);
                this.gradientPoint.y = (int)((1.0f - hsbVals[2]) * 200.0f);
                break;
            }
            case 2: {
                if (this.slider != null) {
                    this.slider.setValue(((Number)this.bSpinner.getValue()).intValue());
                }
                if (this.handlingMouse) break;
                this.gradientPoint.x = (int)(hsbVals[0] * 200.0f);
                this.gradientPoint.y = (int)((1.0f - hsbVals[1]) * 200.0f);
            }
        }
        this.internalChange = false;
        this.updateImage();
        this.updateTrack();
        this.updateTextFields();
    }

    protected void buildChooser() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildRightPanel(), "East");
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        this.gradientPanel = new JPanel(this){
            private /* synthetic */ DefaultHSBChooserPanel this$0;
            {
                this.this$0 = this$0;
            }

            public Dimension getPreferredSize() {
                return new Dimension(200, 200);
            }

            public void paint(Graphics g) {
                if (this.this$0.gradientImage != null) {
                    g.drawImage(this.this$0.gradientImage, 0, 0, this);
                }
                Color saved = g.getColor();
                g.setColor(Color.WHITE);
                g.drawOval(((DefaultHSBChooserPanel)this.this$0).gradientPoint.x - 3, ((DefaultHSBChooserPanel)this.this$0).gradientPoint.y - 3, 6, 6);
                g.setColor(saved);
            }
        };
        MainGradientMouseListener ml = new MainGradientMouseListener(this);
        this.gradientPanel.addMouseListener(ml);
        this.gradientPanel.addMouseMotionListener(ml);
        this.trackPanel = new JPanel(this){
            private /* synthetic */ DefaultHSBChooserPanel this$0;
            {
                this.this$0 = this$0;
            }

            public Dimension getPreferredSize() {
                return new Dimension(30, 200);
            }

            public void paint(Graphics g) {
                if (this.this$0.trackImage != null) {
                    g.drawImage(this.this$0.trackImage, 0, 0, this);
                }
            }
        };
        this.slider = new JSlider();
        this.slider.setPaintTrack(false);
        this.slider.setPaintTicks(false);
        this.slider.setOrientation(1);
        this.updateSlider();
        container.add((Component)this.gradientPanel, "West");
        container.add((Component)this.slider, "Center");
        container.add((Component)this.trackPanel, "East");
        this.add((Component)container, "West");
        this.slider.addChangeListener(new SliderChangeListener(this));
        this.repaint();
    }

    public void uninstallChooserPanel(JColorChooser chooser) {
        this.trackImage = null;
        this.gradientImage = null;
        this.gradientPanel = null;
        this.slider = null;
        this.hSpinner = null;
        this.sSpinner = null;
        this.bSpinner = null;
        this.hRadio = null;
        this.sRadio = null;
        this.bRadio = null;
        this.removeAll();
        super.uninstallChooserPanel(chooser);
    }

    private Container buildRightPanel() {
        JPanel container = new JPanel();
        container.setLayout(new GridLayout(6, 2));
        this.hRadio = new JRadioButton("H");
        this.sRadio = new JRadioButton("S");
        this.bRadio = new JRadioButton("B");
        ButtonGroup group = new ButtonGroup();
        group.add(this.hRadio);
        group.add(this.sRadio);
        group.add(this.bRadio);
        this.hSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 359, 1));
        this.sSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));
        this.bSpinner = new JSpinner(new SpinnerNumberModel(100, 0, 100, 1));
        this.hSpinner.setEnabled(false);
        this.sSpinner.setEnabled(false);
        this.bSpinner.setEnabled(false);
        RadioStateListener cl = new RadioStateListener(this);
        ImageScrollListener scroll = new ImageScrollListener(this);
        this.hRadio.addChangeListener(cl);
        this.sRadio.addChangeListener(cl);
        this.bRadio.addChangeListener(cl);
        this.hSpinner.addChangeListener(scroll);
        this.sSpinner.addChangeListener(scroll);
        this.bSpinner.addChangeListener(scroll);
        this.hRadio.setSelected(true);
        container.add(this.hRadio);
        container.add(this.hSpinner);
        container.add(this.sRadio);
        container.add(this.sSpinner);
        container.add(this.bRadio);
        container.add(this.bSpinner);
        this.rFull = new JLabel("red full");
        this.gFull = new JLabel("green full");
        this.bFull = new JLabel("blue full");
        container.add(R);
        container.add(this.rFull);
        container.add(G);
        container.add(this.gFull);
        container.add(B);
        container.add(this.bFull);
        return container;
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    private void updateHLockImage() {
        int index = 0;
        int[] pix = new int[40000];
        float hValue = (float)((Number)this.hSpinner.getValue()).intValue() / 360.0f;
        for (int j = 0; j < 200; ++j) {
            for (int i = 0; i < 200; ++i) {
                pix[index++] = Color.HSBtoRGB(hValue, (200.0f - (float)i * 1.0f) / 200.0f, (200.0f - (float)j * 1.0f) / 200.0f) | 0xFF000000;
            }
        }
        this.gradientImage = this.createImage(new MemoryImageSource(200, 200, pix, 0, 200));
    }

    private void updateBLockImage() {
        int[] pix = new int[40000];
        float bValue = (float)((Number)this.bSpinner.getValue()).intValue() / 100.0f;
        int index = 0;
        for (int j = 0; j < 200; ++j) {
            for (int i = 0; i < 200; ++i) {
                pix[index++] = Color.HSBtoRGB((float)i * 1.0f / 200.0f, (200.0f - (float)j * 1.0f) / 200.0f, bValue) | 0xFF000000;
            }
        }
        this.gradientImage = this.createImage(new MemoryImageSource(200, 200, pix, 0, 200));
    }

    private void updateSLockImage() {
        int[] pix = new int[40000];
        float sValue = (float)((Number)this.sSpinner.getValue()).intValue() / 100.0f;
        int index = 0;
        for (int j = 0; j < 200; ++j) {
            for (int i = 0; i < 200; ++i) {
                pix[index++] = Color.HSBtoRGB((float)i * 1.0f / 200.0f, sValue, (200.0f - (float)j * 1.0f) / 200.0f) | 0xFF000000;
            }
        }
        this.gradientImage = this.createImage(new MemoryImageSource(200, 200, pix, 0, 200));
    }

    private void updateImage() {
        switch (this.locked) {
            case 0: {
                this.updateHLockImage();
                break;
            }
            case 1: {
                this.updateSLockImage();
                break;
            }
            case 2: {
                this.updateBLockImage();
            }
        }
    }

    private void updateTextFields() {
        int c = this.getColorSelectionModel().getSelectedColor().getRGB();
        this.rFull.setText("" + (c >> 16 & 0xFF));
        this.gFull.setText("" + (c >> 8 & 0xFF));
        this.bFull.setText("" + (c & 0xFF));
        this.repaint();
    }

    private void updateSlider() {
        if (this.slider == null) {
            return;
        }
        this.slider.setMinimum(0);
        if (this.locked == 0) {
            this.slider.setMaximum(359);
            this.slider.setValue(((Number)this.hSpinner.getValue()).intValue());
            this.slider.setInverted(true);
        } else {
            this.slider.setMaximum(100);
            this.slider.setInverted(false);
            if (this.sRadio.isSelected()) {
                this.slider.setValue(((Number)this.sSpinner.getValue()).intValue());
            } else {
                this.slider.setValue(((Number)this.bSpinner.getValue()).intValue());
            }
        }
        this.repaint();
    }

    private void updateTrack() {
        switch (this.locked) {
            case 0: {
                this.updateHTrack();
                break;
            }
            case 1: {
                this.updateSTrack();
                break;
            }
            case 2: {
                this.updateBTrack();
            }
        }
    }

    private void updateHTrack() {
        int trackIndex = 0;
        int[] trackPix = new int[6000];
        for (int j = 0; j < 200; ++j) {
            for (int i = 0; i < 30; ++i) {
                trackPix[trackIndex++] = Color.HSBtoRGB((float)j * 1.0f / 200.0f, 1.0f, 1.0f) | 0xFF000000;
            }
        }
        this.trackImage = this.createImage(new MemoryImageSource(30, 200, trackPix, 0, 30));
    }

    private void updateSTrack() {
        int[] trackPix = new int[6000];
        float hValue = (float)((Number)this.hSpinner.getValue()).intValue() / 360.0f;
        float bValue = (float)((Number)this.bSpinner.getValue()).intValue() / 100.0f;
        int trackIndex = 0;
        for (int j = 0; j < 200; ++j) {
            for (int i = 0; i < 30; ++i) {
                trackPix[trackIndex++] = Color.HSBtoRGB(hValue, (200.0f - (float)j * 1.0f) / 200.0f, bValue) | 0xFF000000;
            }
        }
        this.trackImage = this.createImage(new MemoryImageSource(30, 200, trackPix, 0, 30));
    }

    private void updateBTrack() {
        int[] trackPix = new int[6000];
        float hValue = (float)((Number)this.hSpinner.getValue()).intValue() / 360.0f;
        float sValue = (float)((Number)this.sSpinner.getValue()).intValue() / 100.0f;
        int trackIndex = 0;
        for (int j = 0; j < 200; ++j) {
            for (int i = 0; i < 30; ++i) {
                trackPix[trackIndex++] = Color.HSBtoRGB(hValue, sValue, (200.0f - (float)j * 1.0f) / 200.0f) | 0xFF000000;
            }
        }
        this.trackImage = this.createImage(new MemoryImageSource(30, 200, trackPix, 0, 30));
    }

    class ImageScrollListener
    implements ChangeListener {
        private /* synthetic */ DefaultHSBChooserPanel this$0;

        public void stateChanged(ChangeEvent e) {
            if (this.this$0.internalChange) {
                return;
            }
            float h = (float)((Number)this.this$0.hSpinner.getValue()).intValue() / 360.0f;
            float s = (float)((Number)this.this$0.sSpinner.getValue()).intValue() / 100.0f;
            float b = (float)((Number)this.this$0.bSpinner.getValue()).intValue() / 100.0f;
            this.this$0.spinnerTrigger = true;
            this.this$0.getColorSelectionModel().setSelectedColor(new Color(Color.HSBtoRGB(h, s, b)));
            this.this$0.spinnerTrigger = false;
            if (!this.this$0.handlingMouse) {
                this.this$0.updateImage();
                this.this$0.updateTrack();
            }
            this.this$0.repaint();
        }

        ImageScrollListener(DefaultHSBChooserPanel this$0) {
            this.this$0 = this$0;
        }
    }

    class RadioStateListener
    implements ChangeListener {
        private /* synthetic */ DefaultHSBChooserPanel this$0;

        public void stateChanged(ChangeEvent e) {
            JSpinner change;
            if (e.getSource() == this.this$0.hRadio) {
                this.this$0.locked = 0;
                change = this.this$0.hSpinner;
            } else if (e.getSource() == this.this$0.sRadio) {
                this.this$0.locked = 1;
                change = this.this$0.sSpinner;
            } else {
                this.this$0.locked = 2;
                change = this.this$0.bSpinner;
            }
            change.setEnabled(((AbstractButton)e.getSource()).isSelected());
            this.this$0.updateSlider();
            this.this$0.updateTrack();
            this.this$0.updateImage();
            this.this$0.repaint();
        }

        RadioStateListener(DefaultHSBChooserPanel this$0) {
            this.this$0 = this$0;
        }
    }

    class SliderChangeListener
    implements ChangeListener {
        private /* synthetic */ DefaultHSBChooserPanel this$0;

        public void stateChanged(ChangeEvent e) {
            if (this.this$0.internalChange) {
                return;
            }
            Integer value = new Integer(this.this$0.slider.getValue());
            switch (this.this$0.locked) {
                case 0: {
                    this.this$0.hSpinner.setValue(value);
                    break;
                }
                case 1: {
                    this.this$0.sSpinner.setValue(value);
                    break;
                }
                case 2: {
                    this.this$0.bSpinner.setValue(value);
                }
            }
        }

        SliderChangeListener(DefaultHSBChooserPanel this$0) {
            this.this$0 = this$0;
        }
    }

    class MainGradientMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private /* synthetic */ DefaultHSBChooserPanel this$0;

        public void mousePressed(MouseEvent e) {
            this.this$0.gradientPoint = e.getPoint();
            this.update(e.getPoint());
        }

        public void mouseDragged(MouseEvent e) {
            Point p = e.getPoint();
            if (p.x < 0 || p.y < 0 || p.y > 200 || p.x > 200) {
                return;
            }
            this.this$0.gradientPoint = p;
            this.update(p);
        }

        public void mouseMoved(MouseEvent e) {
        }

        private void update(Point p) {
            this.this$0.handlingMouse = true;
            if (this.this$0.hSpinner.isEnabled()) {
                this.updateH(p);
            } else if (this.this$0.sSpinner.isEnabled()) {
                this.updateS(p);
            } else {
                this.updateB(p);
            }
            this.this$0.handlingMouse = false;
        }

        private void updateH(Point p) {
            float s = (200.0f - (float)p.x * 1.0f) / 200.0f;
            float b = (200.0f - (float)p.y * 1.0f) / 200.0f;
            this.this$0.internalChange = true;
            this.this$0.sSpinner.setValue(new Integer((int)(s * 100.0f)));
            this.this$0.internalChange = false;
            this.this$0.bSpinner.setValue(new Integer((int)(b * 100.0f)));
            this.this$0.revalidate();
        }

        private void updateS(Point p) {
            float h = (float)p.x * 1.0f / 200.0f;
            float b = (200.0f - (float)p.y * 1.0f) / 200.0f;
            this.this$0.internalChange = true;
            this.this$0.hSpinner.setValue(new Integer((int)(h * 365.0f)));
            this.this$0.internalChange = false;
            this.this$0.bSpinner.setValue(new Integer((int)(b * 100.0f)));
            this.this$0.revalidate();
        }

        private void updateB(Point p) {
            float h = (float)p.x * 1.0f / 200.0f;
            float s = (200.0f - (float)p.y * 1.0f) / 200.0f;
            this.this$0.internalChange = true;
            this.this$0.hSpinner.setValue(new Integer((int)(h * 365.0f)));
            this.this$0.internalChange = false;
            this.this$0.sSpinner.setValue(new Integer((int)(s * 100.0f)));
            this.this$0.revalidate();
        }

        MainGradientMouseListener(DefaultHSBChooserPanel this$0) {
            this.this$0 = this$0;
        }
    }
}

