/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultRGBChooserPanel
extends AbstractColorChooserPanel {
    private transient boolean internalChange;
    private transient ChangeListener colorChanger;
    private transient ChangeListener spinnerHandler;
    private transient JSlider R;
    private transient JSlider G;
    private transient JSlider B;
    private transient JLabel RLabel;
    private transient JLabel GLabel;
    private transient JLabel BLabel;
    private transient JSpinner RSpinner;
    private transient JSpinner GSpinner;
    private transient JSpinner BSpinner;

    private /* synthetic */ void finit$() {
        this.internalChange = false;
    }

    static /* synthetic */ JSlider access$7(DefaultRGBChooserPanel inst$, JSlider write_parm_value$) {
        inst$.B = write_parm_value$;
        return inst$.B;
    }

    static /* synthetic */ JSlider access$6(DefaultRGBChooserPanel inst$, JSlider write_parm_value$) {
        inst$.G = write_parm_value$;
        return inst$.G;
    }

    static /* synthetic */ JSlider access$5(DefaultRGBChooserPanel inst$, JSlider write_parm_value$) {
        inst$.R = write_parm_value$;
        return inst$.R;
    }

    static /* synthetic */ JSpinner access$4(DefaultRGBChooserPanel inst$, JSpinner write_parm_value$) {
        inst$.BSpinner = write_parm_value$;
        return inst$.BSpinner;
    }

    static /* synthetic */ JSpinner access$3(DefaultRGBChooserPanel inst$, JSpinner write_parm_value$) {
        inst$.GSpinner = write_parm_value$;
        return inst$.GSpinner;
    }

    static /* synthetic */ JSpinner access$2(DefaultRGBChooserPanel inst$, JSpinner write_parm_value$) {
        inst$.RSpinner = write_parm_value$;
        return inst$.RSpinner;
    }

    static /* synthetic */ boolean access$1(DefaultRGBChooserPanel inst$, boolean write_parm_value$) {
        inst$.internalChange = write_parm_value$;
        return inst$.internalChange;
    }

    public DefaultRGBChooserPanel() {
        this.finit$();
    }

    public String getDisplayName() {
        return "RGB";
    }

    public void updateChooser() {
        Color c = this.getColorFromModel();
        int rgb = c.getRGB();
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        this.internalChange = true;
        if (this.R != null) {
            this.R.setValue(red);
        }
        if (this.RSpinner != null) {
            this.RSpinner.setValue(new Integer(red));
        }
        if (this.G != null) {
            this.G.setValue(green);
        }
        if (this.GSpinner != null) {
            this.GSpinner.setValue(new Integer(green));
        }
        if (this.B != null) {
            this.B.setValue(blue);
        }
        if (this.BSpinner != null) {
            this.BSpinner.setValue(new Integer(blue));
        }
        this.internalChange = false;
        this.revalidate();
        this.repaint();
    }

    protected void buildChooser() {
        this.setLayout(new GridBagLayout());
        this.RLabel = new JLabel("Red");
        this.RLabel.setDisplayedMnemonic('d');
        this.GLabel = new JLabel("Green");
        this.GLabel.setDisplayedMnemonic('n');
        this.BLabel = new JLabel("Blue");
        this.BLabel.setDisplayedMnemonic('B');
        this.R = new JSlider(0, 0, 255, 255);
        this.G = new JSlider(0, 0, 255, 255);
        this.B = new JSlider(0, 0, 255, 255);
        this.R.setPaintTicks(true);
        this.R.setSnapToTicks(false);
        this.G.setPaintTicks(true);
        this.G.setSnapToTicks(false);
        this.B.setPaintTicks(true);
        this.B.setSnapToTicks(false);
        this.R.setLabelTable(this.R.createStandardLabels(85));
        this.R.setPaintLabels(true);
        this.G.setLabelTable(this.G.createStandardLabels(85));
        this.G.setPaintLabels(true);
        this.B.setLabelTable(this.B.createStandardLabels(85));
        this.B.setPaintLabels(true);
        this.R.setMajorTickSpacing(85);
        this.G.setMajorTickSpacing(85);
        this.B.setMajorTickSpacing(85);
        this.R.setMinorTickSpacing(17);
        this.G.setMinorTickSpacing(17);
        this.B.setMinorTickSpacing(17);
        this.RSpinner = new JSpinner(new SpinnerNumberModel(this.R.getValue(), this.R.getMinimum(), this.R.getMaximum(), 1));
        this.GSpinner = new JSpinner(new SpinnerNumberModel(this.G.getValue(), this.G.getMinimum(), this.G.getMaximum(), 1));
        this.BSpinner = new JSpinner(new SpinnerNumberModel(this.B.getValue(), this.B.getMinimum(), this.B.getMaximum(), 1));
        this.RLabel.setLabelFor(this.R);
        this.GLabel.setLabelFor(this.G);
        this.BLabel.setLabelFor(this.B);
        GridBagConstraints bag = new GridBagConstraints();
        bag.fill = 3;
        bag.gridx = 0;
        bag.gridy = 0;
        this.add((Component)this.RLabel, bag);
        bag.gridx = 1;
        this.add((Component)this.R, bag);
        bag.gridx = 2;
        this.add((Component)this.RSpinner, bag);
        bag.gridx = 0;
        bag.gridy = 1;
        this.add((Component)this.GLabel, bag);
        bag.gridx = 1;
        this.add((Component)this.G, bag);
        bag.gridx = 2;
        this.add((Component)this.GSpinner, bag);
        bag.gridx = 0;
        bag.gridy = 2;
        this.add((Component)this.BLabel, bag);
        bag.gridx = 1;
        this.add((Component)this.B, bag);
        bag.gridx = 2;
        this.add((Component)this.BSpinner, bag);
        this.installListeners();
    }

    public void uninstallChooserPanel(JColorChooser chooser) {
        this.uninstallListeners();
        this.removeAll();
        this.R = null;
        this.G = null;
        this.B = null;
        this.RSpinner = null;
        this.GSpinner = null;
        this.BSpinner = null;
        super.uninstallChooserPanel(chooser);
    }

    private void uninstallListeners() {
        this.R.removeChangeListener(this.colorChanger);
        this.G.removeChangeListener(this.colorChanger);
        this.B.removeChangeListener(this.colorChanger);
        this.colorChanger = null;
        this.RSpinner.removeChangeListener(this.spinnerHandler);
        this.GSpinner.removeChangeListener(this.spinnerHandler);
        this.BSpinner.removeChangeListener(this.spinnerHandler);
        this.spinnerHandler = null;
    }

    private void installListeners() {
        this.colorChanger = new SliderHandler(this);
        this.R.addChangeListener(this.colorChanger);
        this.G.addChangeListener(this.colorChanger);
        this.B.addChangeListener(this.colorChanger);
        this.spinnerHandler = new SpinnerHandler(this);
        this.RSpinner.addChangeListener(this.spinnerHandler);
        this.GSpinner.addChangeListener(this.spinnerHandler);
        this.BSpinner.addChangeListener(this.spinnerHandler);
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    class SpinnerHandler
    implements ChangeListener {
        private /* synthetic */ DefaultRGBChooserPanel this$0;

        public void stateChanged(ChangeEvent e) {
            if (this.this$0.internalChange) {
                return;
            }
            int red = ((Number)this.this$0.RSpinner.getValue()).intValue();
            int green = ((Number)this.this$0.GSpinner.getValue()).intValue();
            int blue = ((Number)this.this$0.BSpinner.getValue()).intValue();
            int color = red << 16 | green << 8 | blue;
            this.this$0.getColorSelectionModel().setSelectedColor(new Color(color));
        }

        SpinnerHandler(DefaultRGBChooserPanel this$0) {
            this.this$0 = this$0;
        }
    }

    class SliderHandler
    implements ChangeListener {
        private /* synthetic */ DefaultRGBChooserPanel this$0;

        public void stateChanged(ChangeEvent e) {
            if (this.this$0.internalChange) {
                return;
            }
            int color = this.this$0.R.getValue() << 16 | this.this$0.G.getValue() << 8 | this.this$0.B.getValue();
            this.this$0.getColorSelectionModel().setSelectedColor(new Color(color));
        }

        SliderHandler(DefaultRGBChooserPanel this$0) {
            this.this$0 = this$0;
        }
    }
}

