/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.border.Border;

public class BasicArrowButton
extends JButton
implements SwingConstants {
    protected int direction;
    private transient Color shadow;
    private transient Color darkShadow;
    private transient Color highlight;
    private transient Border tmpBorder;

    private /* synthetic */ void finit$() {
        this.shadow = Color.gray;
        this.darkShadow = Color.BLACK;
        this.highlight = Color.BLACK;
        this.tmpBorder = new Border(this){
            private /* synthetic */ BasicArrowButton this$0;
            {
                this.this$0 = this$0;
            }

            public Insets getBorderInsets(Component c) {
                return new Insets(0, 0, 0, 0);
            }

            public boolean isBorderOpaque() {
                return false;
            }

            public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
                Rectangle bounds = this.this$0.getBounds();
                Color saved = g.getColor();
                g.setColor(this.this$0.highlight);
                g.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height);
                g.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y);
                g.setColor(this.this$0.shadow);
                g.drawLine(bounds.x + 1, bounds.y + bounds.height - 1, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
                g.drawLine(bounds.x + bounds.width - 1, bounds.y + 1, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
                g.setColor(this.this$0.darkShadow);
                g.drawLine(bounds.x, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y + bounds.height);
                g.drawLine(bounds.x + bounds.width, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height);
                g.setColor(saved);
            }
        };
    }

    static /* synthetic */ Color access$3(BasicArrowButton inst$, Color write_parm_value$) {
        inst$.darkShadow = write_parm_value$;
        return inst$.darkShadow;
    }

    static /* synthetic */ Color access$2(BasicArrowButton inst$, Color write_parm_value$) {
        inst$.shadow = write_parm_value$;
        return inst$.shadow;
    }

    static /* synthetic */ Color access$1(BasicArrowButton inst$, Color write_parm_value$) {
        inst$.highlight = write_parm_value$;
        return inst$.highlight;
    }

    public BasicArrowButton(int direction) {
        this.finit$();
        this.setDirection(direction);
        this.setBorder(this.tmpBorder);
    }

    public BasicArrowButton(int direction, Color background, Color shadow, Color darkShadow, Color highlight) {
        this(direction);
        this.setBackground(background);
        this.shadow = shadow;
        this.darkShadow = darkShadow;
        this.highlight = highlight;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int dir) {
        Polygon arrow = this.getArrow(dir, 10);
        if (this.getIcon() == null) {
            this.setIcon(new arrowIcon(this, arrow));
        } else {
            ((arrowIcon)this.getIcon()).setArrow(arrow);
        }
        this.direction = dir;
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight());
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paintTriangle(Graphics g, int x, int y, int size, int direction, boolean isEnabled) {
        Polygon arrow = this.getArrow(direction, size);
        arrowIcon arrowI = new arrowIcon(this, arrow);
        arrowI.setSize(size);
        Color arrowColor = this.isEnabled() ? this.darkShadow : this.shadow;
        arrowI.paintIconImpl(g, x, y, arrowColor);
    }

    private Polygon getArrow(int direction, int size) {
        Polygon arrow;
        double dsize = size;
        int one = (int)(dsize * 1.0 / 10.0);
        int two = (int)(dsize * 2.0 / 10.0);
        int five = (int)(dsize * 5.0 / 10.0);
        int eight = (int)(dsize * 8.0 / 10.0);
        switch (direction) {
            case 1: {
                arrow = new Polygon(new int[]{eight, five, one}, new int[]{eight, one, eight}, 3);
                break;
            }
            case 5: {
                arrow = new Polygon(new int[]{eight, five, two}, new int[]{two, eight, two}, 3);
                break;
            }
            case 3: 
            case 4: {
                arrow = new Polygon(new int[]{two, eight, two}, new int[]{two, five, eight}, 3);
                break;
            }
            case 2: 
            case 7: {
                arrow = new Polygon(new int[]{eight, two, eight}, new int[]{two, five, eight}, 3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid direction given.");
            }
        }
        return arrow;
    }

    private class arrowIcon
    implements Icon {
        private /* synthetic */ BasicArrowButton this$0;
        private Polygon arrow;
        private int size;

        private /* synthetic */ void finit$() {
            this.size = 10;
        }

        public arrowIcon(BasicArrowButton this$0, Polygon arrow) {
            this.this$0 = this$0;
            this.finit$();
            this.arrow = arrow;
        }

        public int getIconHeight() {
            return this.size;
        }

        public int getIconWidth() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void setArrow(Polygon arrow) {
            this.arrow = arrow;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color arrowColor = c.isEnabled() ? this.this$0.darkShadow : this.this$0.shadow;
            this.paintIconImpl(g, x, y, arrowColor);
        }

        public void paintIconImpl(Graphics g, int x, int y, Color arrowColor) {
            g.translate(x, y);
            Color saved = g.getColor();
            g.setColor(arrowColor);
            g.fillPolygon(this.arrow);
            g.setColor(saved);
            g.translate(-x, -y);
        }
    }
}

