/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorChooserComponentFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;

public class BasicColorChooserUI
extends ColorChooserUI {
    protected AbstractColorChooserPanel[] defaultChoosers;
    protected ChangeListener previewListener;
    protected PropertyChangeListener propertyChangeListener;
    private JColorChooser chooser;
    private JTabbedPane pane;
    private Container prevContainer;

    static /* synthetic */ JColorChooser access$2(BasicColorChooserUI inst$, JColorChooser write_parm_value$) {
        inst$.chooser = write_parm_value$;
        return inst$.chooser;
    }

    static /* synthetic */ JTabbedPane access$1(BasicColorChooserUI inst$, JTabbedPane write_parm_value$) {
        inst$.pane = write_parm_value$;
        return inst$.pane;
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicColorChooserUI();
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        return ColorChooserComponentFactory.getDefaultChooserPanels();
    }

    public void installUI(JComponent c) {
        if (c instanceof JColorChooser) {
            this.chooser = (JColorChooser)c;
            this.chooser.setLayout(new BorderLayout());
            this.defaultChoosers = this.createDefaultChoosers();
            this.chooser.setChooserPanels(this.defaultChoosers);
            this.pane = new JTabbedPane();
            this.pane.addChangeListener(new ChangeListener(this){
                private /* synthetic */ BasicColorChooserUI this$0;
                {
                    this.this$0 = this$0;
                }

                public void stateChanged(ChangeEvent e) {
                    this.this$0.pane.repaint();
                }
            });
            this.makeTabs(this.defaultChoosers);
            this.chooser.add((Component)this.pane, "North");
            this.installPreviewPanel();
            this.installDefaults();
            this.installListeners();
        }
    }

    private void makeTabs(AbstractColorChooserPanel[] panels) {
        this.pane.removeAll();
        for (int i = 0; i < panels.length; ++i) {
            this.pane.addTab(panels[i].getDisplayName(), panels[i].getSmallDisplayIcon(), panels[i]);
        }
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.pane = null;
        this.chooser = null;
    }

    protected void installPreviewPanel() {
        this.updatePreviewPanel(ColorChooserComponentFactory.getPreviewPanel());
    }

    private void updatePreviewPanel(JComponent preview) {
        if (this.prevContainer == null) {
            this.prevContainer = new JPanel();
            this.prevContainer.setLayout(new BorderLayout());
            this.chooser.add((Component)this.prevContainer, "Center");
        }
        this.prevContainer.removeAll();
        this.prevContainer.add((Component)preview, "Center");
    }

    protected void installDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.chooser.setFont(defaults.getFont("ColorChooser.font"));
        this.chooser.setForeground(defaults.getColor("ColorChooser.foreground"));
        this.chooser.setBackground(defaults.getColor("ColorChooser.background"));
    }

    protected void uninstallDefaults() {
        this.chooser.setBackground(null);
        this.chooser.setForeground(null);
        this.chooser.setFont(null);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.previewListener = new PreviewListener(this);
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
        this.pane.addChangeListener(new TabPaneListener(this));
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler(this);
    }

    protected void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
        this.previewListener = null;
        this.propertyChangeListener = null;
    }

    private class TabPaneListener
    implements ChangeListener {
        private /* synthetic */ BasicColorChooserUI this$0;

        public void stateChanged(ChangeEvent e) {
            AbstractColorChooserPanel comp = (AbstractColorChooserPanel)this.this$0.pane.getSelectedComponent();
            comp.updateChooser();
        }

        TabPaneListener(BasicColorChooserUI this$0) {
            this.this$0 = this$0;
        }
    }

    private class PreviewListener
    implements ChangeListener {
        private /* synthetic */ BasicColorChooserUI this$0;

        public void stateChanged(ChangeEvent e) {
            AbstractColorChooserPanel panel;
            if (this.this$0.pane != null && (panel = (AbstractColorChooserPanel)this.this$0.pane.getSelectedComponent()) != null) {
                panel.updateChooser();
            }
            this.this$0.chooser.repaint();
        }

        PreviewListener(BasicColorChooserUI this$0) {
            this.this$0 = this$0;
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicColorChooserUI this$0;

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == "chooserPanels") {
                this.this$0.makeTabs(this.this$0.chooser.getChooserPanels());
            } else if (e.getPropertyName() == "previewPanel") {
                this.this$0.updatePreviewPanel(this.this$0.chooser.getPreviewPanel());
            } else if (e.getPropertyName() == "selectionModel") {
                ((AbstractColorChooserPanel)this.this$0.pane.getSelectedComponent()).updateChooser();
            }
            this.this$0.chooser.repaint();
        }

        public PropertyHandler(BasicColorChooserUI this$0) {
            this.this$0 = this$0;
        }
    }
}

