/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.ComboPopup;

public class BasicComboBoxUI
extends ComboBoxUI {
    protected JButton arrowButton;
    protected JComboBox comboBox;
    protected Component editor;
    protected FocusListener focusListener;
    protected boolean hasFocus;
    protected ItemListener itemListener;
    protected KeyListener keyListener;
    private MouseListener mouseListener;
    protected JList listBox;
    protected ListDataListener listDataListener;
    protected ComboPopup popup;
    protected KeyListener popupKeyListener;
    protected MouseListener popupMouseListener;
    protected MouseMotionListener popupMouseMotionListener;
    protected PropertyChangeListener propertyChangeListener;
    private Color shadow;
    private Color darkShadow;
    private Color highlight;
    private Color lightHighlight;
    private Dimension largestItemSize;
    private static final Insets borderInsets = new Insets(2, 2, 2, 2);
    private static int arrowButtonWidth = 15;
    protected Dimension cachedMinimumSize;
    protected CellRendererPane currentValuePane;
    protected boolean isMinimumSizeDirty;

    public static ComponentUI createUI(JComponent c) {
        return new BasicComboBoxUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JComboBox) {
            this.comboBox = (JComboBox)c;
            this.comboBox.setOpaque(true);
            this.comboBox.setLayout(this.createLayoutManager());
            this.installDefaults();
            this.installComponents();
            this.installListeners();
            this.installKeyboardActions();
        }
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.comboBox = null;
    }

    protected void installDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.comboBox.setBackground(defaults.getColor("ComboBox.background"));
        this.comboBox.setFont(defaults.getFont("ComboBox.font"));
        this.comboBox.setForeground(defaults.getColor("ComboBox.foreground"));
        this.shadow = defaults.getColor("Button.shadow");
        this.darkShadow = defaults.getColor("Button.darkShadow");
        this.lightHighlight = defaults.getColor("Button.light");
        this.highlight = defaults.getColor("Button.highlight");
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        this.focusListener = this.createFocusListener();
        this.comboBox.addFocusListener(this.focusListener);
        this.itemListener = this.createItemListener();
        this.comboBox.addItemListener(this.itemListener);
        this.keyListener = this.createKeyListener();
        this.comboBox.addKeyListener(this.keyListener);
        this.mouseListener = this.createMouseListener();
        this.comboBox.addMouseListener(this.mouseListener);
        this.listDataListener = this.createListDataListener();
        this.comboBox.getModel().addListDataListener(this.listDataListener);
        this.configureArrowButton();
    }

    protected void uninstallDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.comboBox.setBackground(null);
        this.comboBox.setFont(null);
        this.comboBox.setForeground(null);
        this.shadow = null;
        this.darkShadow = null;
        this.lightHighlight = null;
        this.highlight = null;
    }

    protected void uninstallListeners() {
        this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.comboBox.removeFocusListener(this.focusListener);
        this.focusListener = null;
        this.comboBox.removeItemListener(this.itemListener);
        this.itemListener = null;
        this.comboBox.removeKeyListener(this.keyListener);
        this.keyListener = null;
        this.comboBox.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
        this.comboBox.getModel().removeListDataListener(this.listDataListener);
        this.listDataListener = null;
        this.unconfigureArrowButton();
    }

    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.comboBox);
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler(this);
    }

    private MouseListener createMouseListener() {
        return new MouseHandler(this);
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler(this);
    }

    protected ItemListener createItemListener() {
        return new ItemHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected LayoutManager createLayoutManager() {
        return new ComboBoxLayoutManager(this);
    }

    protected ListCellRenderer createRenderer() {
        return new BasicComboBoxRenderer();
    }

    protected ComboBoxEditor createEditor() {
        return new BasicComboBoxEditor();
    }

    protected void installComponents() {
        this.arrowButton = this.createArrowButton();
        this.comboBox.add(this.arrowButton);
        this.listBox = new JList();
        Color background = this.arrowButton.getBackground();
        this.listBox.setBackground(background);
        this.listBox.setSelectionBackground(background.darker());
        Color foreground = this.arrowButton.getForeground();
        this.listBox.setForeground(foreground);
        this.listBox.setSelectionForeground(foreground);
        this.comboBox.setRenderer(this.createRenderer());
        this.comboBox.setEditor(this.createEditor());
        this.editor = this.comboBox.getEditor().getEditorComponent();
        this.popup = this.createPopup();
        this.comboBox.revalidate();
    }

    protected void uninstallComponents() {
        this.unconfigureArrowButton();
        this.comboBox.remove(this.arrowButton);
        this.arrowButton = null;
        this.listBox = null;
        this.popup = null;
        this.comboBox.setRenderer(null);
        this.comboBox.setEditor(null);
        this.editor = null;
    }

    public void addEditor() {
        this.comboBox.add(this.editor);
    }

    public void removeEditor() {
        this.comboBox.remove(this.editor);
    }

    protected void configureEditor() {
    }

    protected void unconfigureEditor() {
    }

    public void configureArrowButton() {
        this.arrowButton.addMouseListener(this.mouseListener);
    }

    public void unconfigureArrowButton() {
        this.arrowButton.removeMouseListener(this.mouseListener);
    }

    protected JButton createArrowButton() {
        return new BasicArrowButton(5);
    }

    public boolean isPopupVisible(JComboBox c) {
        return this.popup.isVisible();
    }

    public void setPopupVisible(JComboBox c, boolean v) {
        if (v) {
            this.popup.show();
        } else {
            this.popup.hide();
        }
    }

    public boolean isFocusTraversable(JComboBox c) {
        return this.comboBox.isEditable();
    }

    public void paint(Graphics g, JComponent c) {
        if (c instanceof JComboBox) {
            JComboBox cb = (JComboBox)c;
            this.paintBorder(g, this.comboBox.getBounds(), this.hasFocus);
            Rectangle rect = this.rectangleForCurrentValue();
            this.paintCurrentValueBackground(g, rect, this.hasFocus);
            this.paintCurrentValue(g, rect, this.hasFocus);
        }
    }

    private void paintBorder(Graphics g, Rectangle bounds, boolean hasFocus) {
        int x = 0;
        int y = 0;
        int width = bounds.width;
        int height = bounds.height;
        Color oldColor = g.getColor();
        if (!this.arrowButton.getModel().isPressed()) {
            BasicGraphicsUtils.drawEtchedRect(g, x, y, width, height, Color.gray, Color.white, Color.gray, Color.white);
        } else {
            g.setColor(this.darkShadow);
            g.drawRect(x, y, width, height);
            g.setColor(this.shadow);
            g.drawRect(x + 1, y + 1, width - 3, height - 3);
        }
        g.setColor(oldColor);
    }

    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    public int getAccessibleChildrenCount(JComponent c) {
        return 0;
    }

    public Accessible getAccessibleChild(JComponent c, int i) {
        return null;
    }

    protected boolean isNavigationKey(int keyCode) {
        return false;
    }

    protected void selectNextPossibleValue() {
        int index = this.comboBox.getSelectedIndex();
        if (index != this.comboBox.getItemCount() - 1) {
            this.comboBox.setSelectedIndex(index + 1);
        }
    }

    protected void selectPreviousPossibleValue() {
        int index = this.comboBox.getSelectedIndex();
        if (index != 0) {
            this.comboBox.setSelectedIndex(index - 1);
        }
    }

    protected void toggleOpenClose() {
        this.setPopupVisible(this.comboBox, this.isPopupVisible(this.comboBox) ^ true);
    }

    protected Rectangle rectangleForCurrentValue() {
        Rectangle cbBounds = this.comboBox.getBounds();
        Rectangle rectForCurrentValue = new Rectangle(cbBounds.x + BasicComboBoxUI.borderInsets.left, cbBounds.y + BasicComboBoxUI.borderInsets.top, cbBounds.width - arrowButtonWidth - BasicComboBoxUI.borderInsets.left - BasicComboBoxUI.borderInsets.right, cbBounds.height - BasicComboBoxUI.borderInsets.top - BasicComboBoxUI.borderInsets.bottom);
        return rectForCurrentValue;
    }

    protected Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        if (!this.comboBox.isEditable()) {
            Object currentValue = this.comboBox.getSelectedItem();
            boolean isPressed = this.arrowButton.getModel().isPressed();
            if (currentValue != null) {
                Component comp = this.comboBox.getRenderer().getListCellRendererComponent(this.listBox, currentValue, -1, isPressed, isPressed);
                if (!this.comboBox.isEnabled()) {
                    comp.setEnabled(false);
                }
                g.translate(BasicComboBoxUI.borderInsets.left, BasicComboBoxUI.borderInsets.top);
                comp.setBounds(0, 0, bounds.width, bounds.height);
                comp.paint(g);
                g.translate(-BasicComboBoxUI.borderInsets.left, -BasicComboBoxUI.borderInsets.top);
            }
            this.comboBox.revalidate();
        } else {
            this.comboBox.getEditor().setItem(this.comboBox.getSelectedItem());
        }
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
    }

    protected Dimension getDefaultSize() {
        return new Dimension(6, 17);
    }

    protected Dimension getLargestItemSize() {
        ComboBoxModel model = this.comboBox.getModel();
        int numItems = model.getSize();
        if (numItems == 0) {
            this.largestItemSize = this.getDefaultSize();
            return this.largestItemSize;
        }
        Dimension size = new Dimension(0, 0);
        ListCellRenderer renderer = this.comboBox.getRenderer();
        for (int i = 0; i < numItems; ++i) {
            Object item = model.getElementAt(i);
            String s = item.toString();
            Component comp = renderer.getListCellRendererComponent(this.listBox, item, -1, false, false);
            if (!(comp.getPreferredSize().getWidth() > size.getWidth())) continue;
            size = comp.getPreferredSize();
        }
        this.largestItemSize = size;
        return this.largestItemSize;
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    private class MouseHandler
    extends MouseAdapter {
        private /* synthetic */ BasicComboBoxUI this$0;

        public void mousePressed(MouseEvent e) {
            if (this.this$0.comboBox.isEnabled()) {
                if (e.getSource() instanceof JComboBox) {
                    this.this$0.arrowButton.getModel().setPressed(true);
                    this.this$0.arrowButton.getModel().setArmed(true);
                }
                this.this$0.comboBox.repaint();
                if (e.getSource() instanceof BasicArrowButton) {
                    this.this$0.toggleOpenClose();
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.this$0.comboBox.isEnabled()) {
                if (e.getSource() instanceof JComboBox) {
                    this.this$0.arrowButton.getModel().setPressed(false);
                    this.this$0.arrowButton.getModel().setArmed(false);
                }
                this.this$0.comboBox.repaint();
            }
        }

        MouseHandler(BasicComboBoxUI this$0) {
            this.this$0 = this$0;
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicComboBoxUI this$0;

        public PropertyChangeHandler(BasicComboBoxUI this$0) {
            this.this$0 = this$0;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("enabled")) {
                this.this$0.arrowButton.setEnabled(this.this$0.comboBox.isEnabled());
                if (this.this$0.comboBox.isEditable()) {
                    this.this$0.comboBox.getEditor().getEditorComponent().setEnabled(this.this$0.comboBox.isEnabled());
                }
            } else if (e.getPropertyName().equals("editable")) {
                if (this.this$0.comboBox.isEditable()) {
                    this.this$0.configureEditor();
                    this.this$0.addEditor();
                } else {
                    this.this$0.unconfigureEditor();
                    this.this$0.removeEditor();
                }
                this.this$0.comboBox.revalidate();
                this.this$0.comboBox.repaint();
            }
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        private /* synthetic */ BasicComboBoxUI this$0;

        public ListDataHandler(BasicComboBoxUI this$0) {
            this.this$0 = this$0;
        }

        public void contentsChanged(ListDataEvent e) {
        }

        public void intervalAdded(ListDataEvent e) {
            int start = e.getIndex0();
            int end = e.getIndex1();
            ComboBoxModel model = this.this$0.comboBox.getModel();
            ListCellRenderer renderer = this.this$0.comboBox.getRenderer();
            if (this.this$0.largestItemSize == null) {
                this.this$0.largestItemSize = new Dimension(0, 0);
            }
            for (int i = start - 1; i < end; ++i) {
                Object item = model.getElementAt(i);
                Component comp = renderer.getListCellRendererComponent(new JList(), item, -1, false, false);
                if (!(comp.getPreferredSize().getWidth() > this.this$0.largestItemSize.getWidth())) continue;
                this.this$0.largestItemSize = comp.getPreferredSize();
            }
        }

        public void intervalRemoved(ListDataEvent e) {
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        private /* synthetic */ BasicComboBoxUI this$0;

        public KeyHandler(BasicComboBoxUI this$0) {
            this.this$0 = this$0;
        }

        public void keyPressed(KeyEvent e) {
        }
    }

    public class ItemHandler
    implements ItemListener {
        private /* synthetic */ BasicComboBoxUI this$0;

        public ItemHandler(BasicComboBoxUI this$0) {
            this.this$0 = this$0;
        }

        public void itemStateChanged(ItemEvent e) {
            this.this$0.comboBox.repaint();
        }
    }

    public class FocusHandler
    implements FocusListener {
        private /* synthetic */ BasicComboBoxUI this$0;

        public FocusHandler(BasicComboBoxUI this$0) {
            this.this$0 = this$0;
        }

        public void focusGained(FocusEvent e) {
            this.this$0.hasFocus = true;
            this.this$0.comboBox.repaint();
        }

        public void focusLost(FocusEvent e) {
            this.this$0.hasFocus = false;
            this.this$0.comboBox.repaint();
            this.this$0.popup.hide();
        }
    }

    public class ComboBoxLayoutManager
    implements LayoutManager {
        private /* synthetic */ BasicComboBoxUI this$0;

        public ComboBoxLayoutManager(BasicComboBoxUI this$0) {
            this.this$0 = this$0;
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = new Dimension(0, 0);
            if (this.this$0.largestItemSize == null) {
                this.this$0.largestItemSize = this.this$0.getLargestItemSize();
            }
            d.width = (int)((double)d.width + this.this$0.largestItemSize.getWidth());
            d.height = (int)((double)d.height + this.this$0.largestItemSize.getHeight());
            d.width += arrowButtonWidth;
            d.width += BasicComboBoxUI.borderInsets.left + BasicComboBoxUI.borderInsets.right;
            d.height += BasicComboBoxUI.borderInsets.left + BasicComboBoxUI.borderInsets.right;
            Insets insets = parent.getInsets();
            d.width += insets.left + insets.right;
            d.width += insets.left + insets.right;
            return d;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            int editorWidth = this.this$0.comboBox.getBounds().width - arrowButtonWidth - 2;
            if (this.this$0.comboBox.isEditable()) {
                this.this$0.editor.setBounds(BasicComboBoxUI.borderInsets.left, BasicComboBoxUI.borderInsets.top, editorWidth, this.this$0.comboBox.getBounds().height - BasicComboBoxUI.borderInsets.left - BasicComboBoxUI.borderInsets.top);
            }
            this.this$0.arrowButton.setBounds(editorWidth, 2, arrowButtonWidth, this.this$0.comboBox.getBounds().height - 4);
            this.this$0.comboBox.revalidate();
        }
    }
}

