/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.ComboPopup;

public class BasicComboPopup
extends JPopupMenu
implements ComboPopup {
    protected Timer autoscrollTimer;
    protected JComboBox comboBox;
    protected boolean hasEntered;
    protected boolean isAutoScrolling;
    protected ItemListener itemListener;
    protected KeyListener keyListener;
    protected JList list;
    protected ListDataListener listDataListener;
    protected MouseListener listMouseListener;
    protected MouseMotionListener listMouseMotionListener;
    protected ListSelectionListener listSelectionListener;
    protected MouseListener mouseListener;
    protected MouseMotionListener mouseMotionListener;
    protected PropertyChangeListener propertyChangeListener;
    protected static int SCROLL_DOWN = 1;
    protected static int SCROLL_UP = 0;
    protected int scrollDirection;
    protected JScrollPane scroller;
    protected boolean valueIsAdjusting;

    public BasicComboPopup(JComboBox comboBox) {
        this.comboBox = comboBox;
        this.installComboBoxListeners();
        this.list = this.createList();
        ((JLabel)((Object)this.list.getCellRenderer())).setHorizontalAlignment(2);
        this.configureList();
        this.scroller = this.createScroller();
        this.configureScroller();
        super.add(this.scroller);
        this.setLightWeightPopupEnabled(comboBox.isLightWeightPopupEnabled());
    }

    public void show() {
        Rectangle cbBounds = this.comboBox.getBounds();
        int popupHeight = this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()) + 4;
        super.setPopupSize(cbBounds.width, popupHeight);
        super.show(this.comboBox, 0, cbBounds.height);
    }

    public void hide() {
        super.setVisible(false);
    }

    public JList getList() {
        return this.list;
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public MouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    public void uninstallingUI() {
        this.uninstallComboBoxModelListeners(this.comboBox.getModel());
        this.uninstallListeners();
        this.uninstallKeyboardActions();
    }

    protected void uninstallComboBoxModelListeners(ComboBoxModel model) {
        model.removeListDataListener(this.listDataListener);
    }

    protected void uninstallKeyboardActions() {
    }

    protected void firePopupMenuWillBecomeVisible() {
    }

    protected void firePopupMenuWillBecomeInvisible() {
    }

    protected void firePopupMenuCanceled() {
    }

    protected MouseListener createMouseListener() {
        return new InvocationMouseHandler(this);
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new InvocationMouseMotionHandler(this);
    }

    protected KeyListener createKeyListener() {
        return new InvocationKeyHandler(this);
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler(this);
    }

    protected ListDataListener createListDataListener() {
        return null;
    }

    protected MouseListener createListMouseListener() {
        return new ListMouseHandler(this);
    }

    protected MouseMotionListener createListMouseMotionListener() {
        return new ListMouseMotionHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected ItemListener createItemListener() {
        return new ItemHandler(this);
    }

    protected JList createList() {
        JList l = new JList(this.comboBox.getModel());
        l.setSelectionMode(1);
        return l;
    }

    protected void configureList() {
        this.list.setModel(this.comboBox.getModel());
        if (this.comboBox.getItemCount() < this.comboBox.getMaximumRowCount()) {
            this.list.setVisibleRowCount(this.comboBox.getItemCount());
        } else {
            this.list.setVisibleRowCount(this.comboBox.getMaximumRowCount());
        }
        this.installListListeners();
    }

    protected void installListListeners() {
        this.listMouseListener = this.createListMouseListener();
        this.list.addMouseListener(this.listMouseListener);
        this.listMouseMotionListener = this.createListMouseMotionListener();
        this.list.addMouseMotionListener(this.listMouseMotionListener);
        this.listSelectionListener = this.createListSelectionListener();
        this.list.addListSelectionListener(this.listSelectionListener);
    }

    protected JScrollPane createScroller() {
        return new JScrollPane();
    }

    protected void configureScroller() {
        this.scroller.getViewport().setView(this.list);
        this.scroller.setHorizontalScrollBarPolicy(31);
    }

    protected void configurePopup() {
    }

    protected void installComboBoxListeners() {
        this.mouseListener = this.createMouseListener();
        this.comboBox.addMouseListener(this.mouseListener);
        this.mouseMotionListener = this.createMouseMotionListener();
        this.comboBox.addMouseMotionListener(this.mouseMotionListener);
        this.itemListener = this.createItemListener();
        this.comboBox.addItemListener(this.itemListener);
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installComboBoxModelListeners(ComboBoxModel model) {
        this.listDataListener = this.createListDataListener();
        this.comboBox.getModel().addListDataListener(this.listDataListener);
    }

    protected void installKeyboardActions() {
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void startAutoScrolling(int direction) {
    }

    protected void stopAutoScrolling() {
    }

    protected void autoScrollUp() {
    }

    protected void autoScrollDown() {
    }

    protected void delegateFocus(MouseEvent e) {
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    protected MouseEvent convertMouseEvent(MouseEvent e) {
        return null;
    }

    protected int getPopupHeightForRowCount(int maxRowCount) {
        int totalHeight = 0;
        ListCellRenderer rend = this.list.getCellRenderer();
        if (this.comboBox.getItemCount() < maxRowCount) {
            maxRowCount = this.comboBox.getItemCount();
        }
        for (int i = 0; i < maxRowCount; ++i) {
            Component comp = rend.getListCellRendererComponent(this.list, this.list.getModel().getElementAt(i), -1, false, false);
            Dimension dim = comp.getPreferredSize();
            totalHeight += dim.height;
        }
        return totalHeight;
    }

    protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
        return new Rectangle(px, py, pw, ph);
    }

    protected void updateListBoxSelectionForEvent(MouseEvent anEvent, boolean shouldScroll) {
    }

    private void uninstallListeners() {
        this.uninstallListListeners();
        this.uninstallComboBoxListeners();
        this.uninstallComboBoxModelListeners(this.comboBox.getModel());
    }

    private void uninstallListListeners() {
        this.list.removeMouseListener(this.listMouseListener);
        this.listMouseListener = null;
        this.list.removeMouseMotionListener(this.listMouseMotionListener);
        this.listMouseMotionListener = null;
    }

    private void uninstallComboBoxListeners() {
        this.comboBox.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
        this.comboBox.removeMouseMotionListener(this.mouseMotionListener);
        this.mouseMotionListener = null;
        this.comboBox.removeItemListener(this.itemListener);
        this.itemListener = null;
        this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public class InvocationKeyHandler
    extends KeyAdapter {
        private /* synthetic */ BasicComboPopup this$0;

        public InvocationKeyHandler(BasicComboPopup this$0) {
            this.this$0 = this$0;
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    protected class ListSelectionHandler
    implements ListSelectionListener {
        private /* synthetic */ BasicComboPopup this$0;

        protected ListSelectionHandler(BasicComboPopup this$0) {
            this.this$0 = this$0;
        }

        public void valueChanged(ListSelectionEvent e) {
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        private /* synthetic */ BasicComboPopup this$0;

        public ListDataHandler(BasicComboPopup this$0) {
            this.this$0 = this$0;
        }

        public void contentsChanged(ListDataEvent e) {
        }

        public void intervalAdded(ListDataEvent e) {
        }

        public void intervalRemoved(ListDataEvent e) {
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicComboPopup this$0;

        protected PropertyChangeHandler(BasicComboPopup this$0) {
            this.this$0 = this$0;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("renderer")) {
                this.this$0.list.setCellRenderer((ListCellRenderer)e.getNewValue());
                this.this$0.revalidate();
                this.this$0.repaint();
            }
        }
    }

    protected class ListMouseMotionHandler
    extends MouseMotionAdapter {
        private /* synthetic */ BasicComboPopup this$0;

        protected ListMouseMotionHandler(BasicComboPopup this$0) {
            this.this$0 = this$0;
        }

        public void mouseMoved(MouseEvent anEvent) {
        }
    }

    protected class ListMouseHandler
    extends MouseAdapter {
        private /* synthetic */ BasicComboPopup this$0;

        protected ListMouseHandler(BasicComboPopup this$0) {
            this.this$0 = this$0;
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent anEvent) {
            int index = this.this$0.list.locationToIndex(anEvent.getPoint());
            this.this$0.comboBox.setSelectedIndex(index);
            this.this$0.hide();
        }
    }

    protected class ItemHandler
    implements ItemListener {
        private /* synthetic */ BasicComboPopup this$0;

        protected ItemHandler(BasicComboPopup this$0) {
            this.this$0 = this$0;
        }

        public void itemStateChanged(ItemEvent e) {
        }
    }

    protected class InvocationMouseMotionHandler
    extends MouseMotionAdapter {
        private /* synthetic */ BasicComboPopup this$0;

        protected InvocationMouseMotionHandler(BasicComboPopup this$0) {
            this.this$0 = this$0;
        }

        public void mouseDragged(MouseEvent e) {
        }
    }

    protected class InvocationMouseHandler
    extends MouseAdapter {
        private /* synthetic */ BasicComboPopup this$0;

        protected InvocationMouseHandler(BasicComboPopup this$0) {
            this.this$0 = this$0;
        }

        public void mousePressed(MouseEvent e) {
            if (this.this$0.comboBox.isEnabled()) {
                this.this$0.togglePopup();
            }
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

