/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopPaneUI;

public class BasicDesktopPaneUI
extends DesktopPaneUI {
    protected KeyStroke closeKey;
    protected KeyStroke maximizeKey;
    protected KeyStroke minimizeKey;
    protected KeyStroke navigateKey;
    protected KeyStroke navigateKey2;
    protected DesktopManager desktopManager;
    protected JDesktopPane desktop;

    public static ComponentUI createUI(JComponent c) {
        return new BasicDesktopPaneUI();
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    protected void installDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.desktop.setBackground(defaults.getColor("Desktop.background"));
    }

    protected void installDesktopManager() {
        this.desktopManager = new DefaultDesktopManager();
        this.desktop.setDesktopManager(this.desktopManager);
    }

    protected void installKeyboardActions() {
        this.registerKeyboardAction();
    }

    public void installUI(JComponent c) {
        if (c instanceof JDesktopPane) {
            this.desktop = (JDesktopPane)c;
            this.installDefaults();
            this.installDesktopManager();
            this.installKeyboardActions();
        }
    }

    protected void registerKeyboardAction() {
    }

    protected void uninstallDefaults() {
        this.desktop.setBackground(null);
    }

    protected void uninstallDesktopManager() {
        this.desktopManager = null;
        this.desktop.setDesktopManager(null);
    }

    protected void uninstallKeyboardActions() {
        this.unregisterKeyboardActions();
    }

    protected void unregisterKeyboardActions() {
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallDesktopManager();
        this.uninstallDefaults();
        this.desktop = null;
    }

    protected class OpenAction
    extends AbstractAction {
        private /* synthetic */ BasicDesktopPaneUI this$0;

        public void actionPerformed(ActionEvent e) {
            JInternalFrame frame = this.this$0.desktop.getSelectedFrame();
            if (frame != null) {
                try {
                    if (frame.isIcon()) {
                        frame.setIcon(false);
                    } else if (frame.isMaximum()) {
                        frame.setMaximum(false);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }

        OpenAction(BasicDesktopPaneUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class NavigateAction
    extends AbstractAction {
        private /* synthetic */ BasicDesktopPaneUI this$0;

        public void actionPerformed(ActionEvent e) {
            int i;
            JInternalFrame[] frames = this.this$0.desktop.getAllFrames();
            if (frames.length == 0) {
                return;
            }
            JInternalFrame sFrame = frames[0];
            if (this.this$0.desktop.getSelectedFrame() != null) {
                sFrame = this.this$0.desktop.getSelectedFrame();
            }
            for (i = 0; i < frames.length && frames[i] != sFrame; ++i) {
            }
            if (i == frames.length) {
                i = 0;
            }
            this.this$0.desktop.setSelectedFrame(frames[i]);
        }

        public boolean isEnabled() {
            return true;
        }

        NavigateAction(BasicDesktopPaneUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class MinimizeAction
    extends AbstractAction {
        private /* synthetic */ BasicDesktopPaneUI this$0;

        public void actionPerformed(ActionEvent e) {
            if (this.this$0.desktop.getSelectedFrame() != null) {
                try {
                    this.this$0.desktop.getSelectedFrame().setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            if (this.this$0.desktop.getSelectedFrame() != null) {
                return this.this$0.desktop.getSelectedFrame().isIconifiable();
            }
            return false;
        }

        MinimizeAction(BasicDesktopPaneUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        private /* synthetic */ BasicDesktopPaneUI this$0;

        public void actionPerformed(ActionEvent e) {
            if (this.this$0.desktop.getSelectedFrame() != null) {
                try {
                    this.this$0.desktop.getSelectedFrame().setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            if (this.this$0.desktop.getSelectedFrame() != null) {
                return this.this$0.desktop.getSelectedFrame().isMaximizable();
            }
            return false;
        }

        MaximizeAction(BasicDesktopPaneUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class CloseAction
    extends AbstractAction {
        private /* synthetic */ BasicDesktopPaneUI this$0;

        public void actionPerformed(ActionEvent e) {
            if (this.this$0.desktop.getSelectedFrame() != null) {
                try {
                    this.this$0.desktop.getSelectedFrame().setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            if (this.this$0.desktop.getSelectedFrame() != null) {
                return this.this$0.desktop.getSelectedFrame().isClosable();
            }
            return false;
        }

        CloseAction(BasicDesktopPaneUI this$0) {
            this.this$0 = this$0;
        }
    }
}

