/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class BasicIconFactory
implements Serializable {
    static final long serialVersionUID = 5605588811185324383L;

    public static Icon getMenuItemCheckIcon() {
        return new DummyIcon();
    }

    public static Icon getMenuItemArrowIcon() {
        return new DummyIcon();
    }

    public static Icon getMenuArrowIcon() {
        return new Icon(null){
            private /* synthetic */ BasicIconFactory this$0;
            {
                this.this$0 = this$0;
            }

            public int getIconHeight() {
                return 12;
            }

            public int getIconWidth() {
                return 12;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.translate(x, y);
                Color saved = g.getColor();
                g.setColor(Color.BLACK);
                g.fillPolygon(new Polygon(new int[]{3, 9, 3}, new int[]{2, 6, 10}, 3));
                g.setColor(saved);
                g.translate(-x, -y);
            }
        };
    }

    public static Icon getCheckBoxIcon() {
        return new Icon(null){
            private /* synthetic */ BasicIconFactory this$0;
            {
                this.this$0 = this$0;
            }

            public int getIconHeight() {
                return 10;
            }

            public int getIconWidth() {
                return 10;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (c instanceof AbstractButton) {
                    UIDefaults defaults = UIManager.getLookAndFeelDefaults();
                    Color hi = defaults.getColor("CheckBox.highlight");
                    Color low = defaults.getColor("CheckBox.darkShadow");
                    Color sel = defaults.getColor("CheckBox.foreground");
                    Color dim = defaults.getColor("CheckBox.shadow");
                    Polygon check = new Polygon(new int[]{x + 3, x + 3, x + 8}, new int[]{y + 5, y + 9, y + 3}, 3);
                    AbstractButton b = (AbstractButton)c;
                    Color saved = g.getColor();
                    if (b.isEnabled()) {
                        g.setColor(low);
                        g.drawRect(x, y, 10, 10);
                        g.setColor(hi);
                        g.drawRect(x + 1, y + 1, 10, 10);
                        if (b.isSelected()) {
                            g.setColor(sel);
                            if (b.isSelected()) {
                                g.drawLine(x + 3, y + 5, x + 3, y + 8);
                                g.drawLine(x + 4, y + 5, x + 4, y + 8);
                                g.drawLine(x + 3, y + 8, x + 8, y + 3);
                                g.drawLine(x + 4, y + 8, x + 8, y + 3);
                            }
                        }
                    } else {
                        g.setColor(hi);
                        g.drawRect(x, y, 10, 10);
                        if (b.isSelected()) {
                            g.drawLine(x + 3, y + 5, x + 3, y + 9);
                            g.drawLine(x + 3, y + 9, x + 8, y + 3);
                        }
                    }
                    g.setColor(saved);
                }
            }
        };
    }

    public static Icon getRadioButtonIcon() {
        return new Icon(null){
            private /* synthetic */ BasicIconFactory this$0;
            {
                this.this$0 = this$0;
            }

            public int getIconHeight() {
                return 12;
            }

            public int getIconWidth() {
                return 12;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                UIDefaults defaults = UIManager.getLookAndFeelDefaults();
                Color hi = defaults.getColor("RadioButton.highlight");
                Color low = defaults.getColor("RadioButton.darkShadow");
                Color sel = defaults.getColor("RadioButton.foreground");
                Color dim = defaults.getColor("RadioButton.shadow");
                if (c instanceof AbstractButton) {
                    AbstractButton b = (AbstractButton)c;
                    Color saved = g.getColor();
                    if (b.isEnabled()) {
                        g.setColor(low);
                        g.drawOval(x, y, 12, 12);
                        g.setColor(hi);
                        g.drawOval(x + 1, y + 1, 12, 12);
                        if (b.isSelected()) {
                            g.setColor(sel);
                            g.fillOval(x + 4, y + 4, 6, 6);
                        }
                    } else {
                        g.setColor(hi);
                        g.drawOval(x, y, 12, 12);
                        if (b.isSelected()) {
                            g.fillOval(x + 4, y + 4, 6, 6);
                        }
                    }
                    g.setColor(saved);
                }
            }
        };
    }

    public static Icon getCheckBoxMenuItemIcon() {
        return BasicIconFactory.getCheckBoxIcon();
    }

    public static Icon getRadioButtonMenuItemIcon() {
        return BasicIconFactory.getRadioButtonIcon();
    }

    public static Icon createEmptyFrameIcon() {
        return new DummyIcon();
    }

    private static class DummyIcon
    implements Icon {
        public int getIconHeight() {
            return 10;
        }

        public int getIconWidth() {
            return 10;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color save = g.getColor();
            g.setColor(c.getForeground());
            g.drawRect(x, y, 10, 10);
            g.setColor(save);
        }

        DummyIcon() {
        }
    }
}

