/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicDesktopIconUI;

public class BasicInternalFrameTitlePane
extends JComponent {
    protected static String CLOSE_CMD = "Close";
    protected static String ICONIFY_CMD = "Minimize";
    protected static String MAXIMIZE_CMD = "Maximize";
    protected static String MOVE_CMD = "Move";
    protected static String RESTORE_CMD = "Restore";
    protected static String SIZE_CMD = "Size";
    protected Action closeAction;
    protected Action iconifyAction;
    protected Action maximizeAction;
    protected Action moveAction;
    protected Action restoreAction;
    protected Action sizeAction;
    protected JButton closeButton;
    protected JButton iconButton;
    protected JButton maxButton;
    protected Color activeBGColor;
    protected Color activeFGColor;
    protected Color inactiveBGColor;
    protected Color inactiveFGColor;
    private static final int iconSize = 16;
    protected Icon closeIcon;
    protected Icon minIcon;
    protected Icon maxIcon;
    protected Icon iconIcon;
    protected JInternalFrame frame;
    protected JMenuBar menuBar;
    protected JMenu windowMenu;
    protected Color notSelectedTextColor;
    protected Color notSelectedTitleColor;
    protected Color selectedTextColor;
    protected Color selectedTitleColor;
    protected PropertyChangeListener propertyChangeListener;
    private transient JLabel title;

    private /* synthetic */ void finit$() {
        this.closeIcon = new Icon(this){
            private /* synthetic */ BasicInternalFrameTitlePane this$0;
            {
                this.this$0 = this$0;
            }

            public int getIconHeight() {
                return 16;
            }

            public int getIconWidth() {
                return 16;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.translate(x, y);
                Color saved = g.getColor();
                g.setColor(Color.BLACK);
                int four = 4;
                int six = 6;
                int ten = 10;
                int twelve = 12;
                Polygon a = new Polygon(new int[]{four, six, ten, twelve}, new int[]{six, four, twelve, ten}, 4);
                Polygon b = new Polygon(new int[]{four, six, ten, twelve}, new int[]{ten, twelve, four, six}, 4);
                g.fillPolygon(a);
                g.fillPolygon(b);
                g.setColor(saved);
                g.translate(-x, -y);
            }
        };
        this.maxIcon = new Icon(this){
            private /* synthetic */ BasicInternalFrameTitlePane this$0;
            {
                this.this$0 = this$0;
            }

            public int getIconHeight() {
                return 16;
            }

            public int getIconWidth() {
                return 16;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.translate(x, y);
                Color saved = g.getColor();
                g.setColor(Color.BLACK);
                int four = 4;
                int two = four / 2;
                int six = 6;
                int eight = four * 2;
                g.fillRect(four, four, eight, two);
                g.drawRect(four, six, eight, six);
                g.setColor(saved);
                g.translate(-x, -y);
            }
        };
        this.iconIcon = new Icon(this){
            private /* synthetic */ BasicInternalFrameTitlePane this$0;
            {
                this.this$0 = this$0;
            }

            public int getIconHeight() {
                return 16;
            }

            public int getIconWidth() {
                return 16;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.translate(x, y);
                Color saved = g.getColor();
                g.setColor(Color.BLACK);
                g.fillRect(4, 10, 8, 2);
                g.setColor(saved);
                g.translate(-x, -y);
            }
        };
    }

    static /* synthetic */ JLabel access$1(BasicInternalFrameTitlePane inst$, JLabel write_parm_value$) {
        inst$.title = write_parm_value$;
        return inst$.title;
    }

    public BasicInternalFrameTitlePane(JInternalFrame f) {
        this.finit$();
        this.frame = f;
        this.setLayout(this.createLayout());
        this.title = new JLabel();
        this.title.setHorizontalAlignment(2);
        this.title.setHorizontalTextPosition(2);
        this.title.setOpaque(false);
        this.setOpaque(true);
        this.setBackground(Color.LIGHT_GRAY);
        this.installTitlePane();
    }

    protected void installTitlePane() {
        this.installDefaults();
        this.installListeners();
        this.createActions();
        this.assembleSystemMenu();
        this.createButtons();
        this.setButtonIcons();
        this.addSubComponents();
        this.enableActions();
    }

    protected void addSubComponents() {
        this.add(this.menuBar);
        this.add(this.closeButton);
        this.add(this.iconButton);
        this.add(this.maxButton);
    }

    protected void createActions() {
        this.closeAction = new CloseAction(this);
        this.closeAction.putValue("ActionCommandKey", CLOSE_CMD);
        this.iconifyAction = new IconifyAction(this);
        this.iconifyAction.putValue("ActionCommandKey", ICONIFY_CMD);
        this.maximizeAction = new MaximizeAction(this);
        this.maximizeAction.putValue("ActionCommandKey", MAXIMIZE_CMD);
        this.sizeAction = new SizeAction(this);
        this.sizeAction.putValue("ActionCommandKey", SIZE_CMD);
        this.restoreAction = new RestoreAction(this);
        this.restoreAction.putValue("ActionCommandKey", RESTORE_CMD);
        this.moveAction = new MoveAction(this);
        this.moveAction.putValue("ActionCommandKey", MOVE_CMD);
    }

    protected void installListeners() {
        this.propertyChangeListener = new PropertyChangeHandler(this);
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void installDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.setFont(defaults.getFont("InternalFrame.titleFont"));
        this.activeFGColor = defaults.getColor("InternalFrame.activeTitleForeground");
        this.activeBGColor = defaults.getColor("InternalFrame.activeTitleBackground");
        this.inactiveFGColor = defaults.getColor("InternalFrame.inactiveTitleForeground");
        this.inactiveBGColor = defaults.getColor("InternalFrame.inactiveTitleBackground");
    }

    protected void uninstallDefaults() {
        this.setFont(null);
        this.activeFGColor = null;
        this.activeBGColor = null;
        this.inactiveFGColor = null;
        this.inactiveBGColor = null;
    }

    protected void createButtons() {
        this.closeButton = new PaneButton(this, this.closeAction);
        this.closeButton.setOpaque(false);
        this.iconButton = new PaneButton(this, this.iconifyAction);
        this.iconButton.setOpaque(false);
        this.maxButton = new PaneButton(this, this.maximizeAction);
        this.maxButton.setOpaque(false);
    }

    protected void setButtonIcons() {
        this.closeButton.setIcon(this.closeIcon);
        this.iconButton.setIcon(this.iconIcon);
        this.maxButton.setIcon(this.maxIcon);
    }

    protected void assembleSystemMenu() {
        this.menuBar = this.createSystemMenuBar();
        this.windowMenu = this.createSystemMenu();
        this.menuBar.add(this.windowMenu);
        this.addSystemMenuItems(this.windowMenu);
        this.enableActions();
    }

    protected void addSystemMenuItems(JMenu systemMenu) {
        JMenuItem tmp = new JMenuItem(RESTORE_CMD);
        tmp.addActionListener(this.restoreAction);
        tmp.setMnemonic(82);
        systemMenu.add(tmp);
        tmp = new JMenuItem(MOVE_CMD);
        tmp.addActionListener(this.moveAction);
        tmp.setMnemonic(77);
        systemMenu.add(tmp);
        tmp = new JMenuItem(SIZE_CMD);
        tmp.addActionListener(this.sizeAction);
        tmp.setMnemonic(83);
        systemMenu.add(tmp);
        tmp = new JMenuItem(ICONIFY_CMD);
        tmp.addActionListener(this.iconifyAction);
        tmp.setMnemonic(78);
        systemMenu.add(tmp);
        tmp = new JMenuItem(MAXIMIZE_CMD);
        tmp.addActionListener(this.maximizeAction);
        tmp.setMnemonic(88);
        systemMenu.add(tmp);
        systemMenu.addSeparator();
        tmp = new JMenuItem(CLOSE_CMD);
        tmp.addActionListener(this.closeAction);
        tmp.setMnemonic(67);
        systemMenu.add(tmp);
    }

    protected JMenuBar createSystemMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new SystemMenuBar(this);
        }
        this.menuBar.removeAll();
        return this.menuBar;
    }

    protected JMenu createSystemMenu() {
        if (this.windowMenu == null) {
            this.windowMenu = new JMenu();
        }
        this.windowMenu.removeAll();
        return this.windowMenu;
    }

    protected void showSystemMenu() {
        this.menuBar.getMenu(1).getPopupMenu().show();
    }

    public void paintComponent(Graphics g) {
        this.paintTitleBackground(g);
        Font f = g.getFont();
        FontMetrics fm = g.getFontMetrics(f);
        if (this.frame.getTitle() != null && this.title != null) {
            Color saved = g.getColor();
            if (this.frame.isSelected()) {
                g.setColor(this.activeFGColor);
            } else {
                g.setColor(this.inactiveFGColor);
            }
            this.title.setText(this.getTitle(this.frame.getTitle(), fm, this.title.getBounds().width));
            SwingUtilities.paintComponent(g, this.title, null, this.title.getBounds());
            g.setColor(saved);
        }
    }

    protected void paintTitleBackground(Graphics g) {
        Color saved = g.getColor();
        Dimension dims = this.getSize();
        Color bg = this.getBackground();
        bg = this.frame.isSelected() ? this.activeBGColor : this.inactiveBGColor;
        g.setColor(bg);
        g.fillRect(0, 0, dims.width, dims.height);
        g.setColor(saved);
    }

    protected String getTitle(String text, FontMetrics fm, int availableWidth) {
        Rectangle vr = new Rectangle(0, 0, availableWidth, fm.getHeight());
        Rectangle ir = new Rectangle();
        Rectangle tr = new Rectangle();
        String value = SwingUtilities.layoutCompoundLabel(this, fm, text, null, 0, 2, 0, 2, vr, ir, tr, 0);
        return value;
    }

    protected void postClosingEvent(JInternalFrame frame) {
    }

    protected void enableActions() {
        this.closeAction.setEnabled(this.frame.isClosable());
        this.iconifyAction.setEnabled(this.frame.isIconifiable());
        this.maximizeAction.setEnabled(this.frame.isMaximizable());
        this.restoreAction.setEnabled(this.frame.isMaximum());
        this.sizeAction.setEnabled(this.frame.isResizable());
        this.moveAction.setEnabled(false);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout(this);
    }

    private class PaneButton
    extends JButton {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public PaneButton(BasicInternalFrameTitlePane this$0, Action a) {
            this.this$0 = this$0;
            super(a);
            this.setMargin(new Insets(0, 0, 0, 0));
            this$0.setBorder(null);
        }

        public boolean isFocusable() {
            return false;
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public void addLayoutComponent(String name, Component c) {
        }

        public void layoutContainer(Container c) {
            this.this$0.enableActions();
            Insets insets = c.getInsets();
            int width = c.getBounds().width - insets.left - insets.right;
            int height = c.getBounds().height - insets.top - insets.bottom;
            Dimension menupref = this.this$0.menuBar.getPreferredSize();
            this.this$0.menuBar.setBounds(insets.left, insets.top, menupref.width, height);
            int loc = width + insets.left;
            Insets i = this.this$0.closeButton.getInsets();
            Dimension prefs = new Dimension(16 + i.left + i.right, 16 + i.top + i.bottom);
            int top = insets.top + (height - prefs.height) / 2;
            if (this.this$0.closeAction.isEnabled()) {
                this.this$0.closeButton.setVisible(true);
                this.this$0.closeButton.setBounds(loc -= prefs.width, top, prefs.width, prefs.height);
            } else {
                this.this$0.closeButton.setVisible(false);
            }
            if (this.this$0.maximizeAction.isEnabled()) {
                this.this$0.maxButton.setVisible(true);
                this.this$0.maxButton.setBounds(loc -= prefs.width, top, prefs.width, prefs.height);
            } else {
                this.this$0.maxButton.setVisible(false);
            }
            if (this.this$0.iconifyAction.isEnabled()) {
                this.this$0.iconButton.setVisible(true);
                this.this$0.iconButton.setBounds(loc -= prefs.width, top, prefs.width, prefs.height);
            } else {
                this.this$0.iconButton.setVisible(false);
            }
            if (this.this$0.title != null) {
                this.this$0.title.setBounds(insets.left + menupref.width, insets.top, loc - menupref.width - insets.left, height);
            }
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public Dimension preferredLayoutSize(Container c) {
            Insets frameInsets = this.this$0.frame.getInsets();
            int height = 0;
            int width = 0;
            Component[] components = this.this$0.getComponents();
            for (int i = 0; i < components.length; ++i) {
                Dimension d = components[i].getPreferredSize();
                height = Math.max(height, d.height);
                width += d.width;
            }
            Insets insets = this.this$0.getInsets();
            return new Dimension(width, height += insets.top + insets.bottom);
        }

        public void removeLayoutComponent(Component c) {
        }

        TitlePaneLayout(BasicInternalFrameTitlePane this$0) {
            this.this$0 = this$0;
        }
    }

    protected class SystemMenuBar
    extends JMenuBar {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public boolean isFocusTransversable() {
            return true;
        }

        public boolean isOpaque() {
            return true;
        }

        public void paint(Graphics g) {
            Icon frameIcon = this.this$0.frame.getFrameIcon();
            if (frameIcon == null) {
                frameIcon = BasicDesktopIconUI.defaultIcon;
            }
            frameIcon.paintIcon(this, g, 0, 0);
        }

        public void requestFocus() {
            super.requestFocus();
        }

        SystemMenuBar(BasicInternalFrameTitlePane this$0) {
            this.this$0 = this$0;
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public void propertyChange(PropertyChangeEvent evt) {
            this.this$0.enableActions();
        }

        PropertyChangeHandler(BasicInternalFrameTitlePane this$0) {
            this.this$0 = this$0;
        }
    }

    protected class SizeAction
    extends AbstractAction {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public void actionPerformed(ActionEvent e) {
        }

        SizeAction(BasicInternalFrameTitlePane this$0) {
            this.this$0 = this$0;
        }
    }

    protected class RestoreAction
    extends AbstractAction {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public void actionPerformed(ActionEvent e) {
            if (this.this$0.frame.isMaximum()) {
                try {
                    this.this$0.frame.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        RestoreAction(BasicInternalFrameTitlePane this$0) {
            this.this$0 = this$0;
        }
    }

    protected class MoveAction
    extends AbstractAction {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public void actionPerformed(ActionEvent e) {
        }

        MoveAction(BasicInternalFrameTitlePane this$0) {
            this.this$0 = this$0;
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.this$0.frame.isMaximizable() && !this.this$0.frame.isMaximum()) {
                    this.this$0.frame.setMaximum(true);
                } else if (this.this$0.frame.isMaximum()) {
                    this.this$0.frame.setMaximum(false);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        MaximizeAction(BasicInternalFrameTitlePane this$0) {
            this.this$0 = this$0;
        }
    }

    protected class IconifyAction
    extends AbstractAction {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public void actionPerformed(ActionEvent e) {
            if (this.this$0.frame.isIconifiable() && !this.this$0.frame.isIcon()) {
                try {
                    this.this$0.frame.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        IconifyAction(BasicInternalFrameTitlePane this$0) {
            this.this$0 = this$0;
        }
    }

    protected class CloseAction
    extends AbstractAction {
        private /* synthetic */ BasicInternalFrameTitlePane this$0;

        public void actionPerformed(ActionEvent e) {
            if (this.this$0.frame.isClosable()) {
                try {
                    this.this$0.frame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        CloseAction(BasicInternalFrameTitlePane this$0) {
            this.this$0 = this$0;
        }
    }
}

