/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicLabelUI
extends LabelUI
implements PropertyChangeListener {
    protected static BasicLabelUI labelUI;

    public static ComponentUI createUI(JComponent c) {
        if (labelUI == null) {
            labelUI = new BasicLabelUI();
        }
        return labelUI;
    }

    public Dimension getPreferredSize(JComponent c) {
        JLabel lab = (JLabel)c;
        Rectangle vr = new Rectangle();
        Rectangle ir = new Rectangle();
        Rectangle tr = new Rectangle();
        Insets insets = lab.getInsets();
        FontMetrics fm = lab.getToolkit().getFontMetrics(lab.getFont());
        this.layoutCL(lab, fm, lab.getText(), lab.getIcon(), vr, ir, tr);
        Rectangle cr = tr.union(ir);
        return new Dimension(insets.left + cr.width + insets.right, insets.top + cr.height + insets.bottom);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public void paint(Graphics g, JComponent c) {
        JLabel b = (JLabel)c;
        Font saved_font = g.getFont();
        Rectangle tr = new Rectangle();
        Rectangle ir = new Rectangle();
        Rectangle vr = new Rectangle();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        vr = SwingUtilities.calculateInnerArea(c, vr);
        if (vr.width < 0) {
            vr.width = 0;
        }
        if (vr.height < 0) {
            vr.height = 0;
        }
        Icon icon = b.isEnabled() ? b.getIcon() : b.getDisabledIcon();
        String text = this.layoutCL(b, fm, b.getText(), icon, vr, ir, tr);
        if (icon != null) {
            icon.paintIcon(b, g, ir.x, ir.y);
        }
        if (text != null && !text.equals("")) {
            if (b.isEnabled()) {
                this.paintEnabledText(b, g, text, tr.x, tr.y + fm.getAscent());
            } else {
                this.paintDisabledText(b, g, text, tr.x, tr.y + fm.getAscent());
            }
        }
        g.setFont(saved_font);
    }

    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        return SwingUtilities.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap());
    }

    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        Color saved_color = g.getColor();
        g.setColor(l.getBackground().brighter());
        int mnemIndex = l.getDisplayedMnemonicIndex();
        if (mnemIndex != -1) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, s, mnemIndex, textX, textY);
        } else {
            g.drawString(s, textX, textY);
        }
        g.setColor(l.getBackground().darker());
        if (mnemIndex != -1) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, s, mnemIndex, textX + 1, textY + 1);
        } else {
            g.drawString(s, textX + 1, textY + 1);
        }
        g.setColor(saved_color);
    }

    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        Color saved_color = g.getColor();
        g.setColor(l.getForeground());
        int mnemIndex = l.getDisplayedMnemonicIndex();
        if (mnemIndex != -1) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, s, mnemIndex, textX, textY);
        } else {
            g.drawString(s, textX, textY);
        }
        g.setColor(saved_color);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JLabel) {
            JLabel l = (JLabel)c;
            this.installComponents(l);
            this.installDefaults(l);
            this.installListeners(l);
            this.installKeyboardActions(l);
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (c instanceof JLabel) {
            JLabel l = (JLabel)c;
            this.uninstallKeyboardActions(l);
            this.uninstallListeners(l);
            this.uninstallDefaults(l);
            this.uninstallComponents(l);
        }
    }

    protected void installComponents(JLabel c) {
    }

    protected void uninstallComponents(JLabel c) {
    }

    protected void installDefaults(JLabel c) {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        c.setForeground(defaults.getColor("Label.foreground"));
        c.setBackground(defaults.getColor("Label.background"));
        c.setFont(defaults.getFont("Label.font"));
        c.setBorder(defaults.getBorder("Label.border"));
        c.setOpaque(true);
    }

    protected void uninstallDefaults(JLabel c) {
        c.setForeground(null);
        c.setBackground(null);
        c.setFont(null);
        c.setBorder(null);
    }

    protected void installKeyboardActions(JLabel l) {
    }

    protected void uninstallKeyboardActions(JLabel l) {
    }

    protected void installListeners(JLabel c) {
        c.addPropertyChangeListener(this);
    }

    protected void uninstallListeners(JLabel c) {
        c.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        JLabel c = (JLabel)e.getSource();
        c.revalidate();
        c.repaint();
    }
}

