/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;

public class BasicListUI
extends ListUI {
    FocusHandler focusListener = new FocusHandler(this);
    ListDataHandler listDataListener = new ListDataHandler(this);
    ListSelectionHandler listSelectionListener = new ListSelectionHandler(this);
    MouseInputHandler mouseInputListener = new MouseInputHandler(this);
    PropertyChangeHandler propertyChangeListener = new PropertyChangeHandler(this);
    JList list;
    int cellHeight;
    int cellWidth;
    int[] cellHeights;
    int updateLayoutStateNeeded = 1;

    public static ComponentUI createUI(JComponent c) {
        return new BasicListUI();
    }

    int getRowHeight(int row) {
        if (row < 0 || row >= this.cellHeights.length) {
            return -1;
        }
        if (this.cellHeight != -1) {
            return this.cellHeight;
        }
        return this.cellHeights[row];
    }

    public Rectangle getCellBounds(JList l, int index1, int index2) {
        this.maybeUpdateLayoutState();
        if (l != this.list || this.cellWidth == -1) {
            return null;
        }
        int lo = Math.min(index1, index2);
        int hi = Math.max(index1, index2);
        Rectangle lobounds = new Rectangle(0, this.convertRowToY(lo), this.cellWidth, this.getRowHeight(lo));
        Rectangle hibounds = new Rectangle(0, this.convertRowToY(hi), this.cellWidth, this.getRowHeight(hi));
        return lobounds.union(hibounds);
    }

    int convertRowToY(int row) {
        int y = 0;
        for (int i = 0; i < row; ++i) {
            int h = this.getRowHeight(i);
            if (h == -1) {
                return -1;
            }
            y += h;
        }
        return y;
    }

    int convertYToRow(int y0) {
        for (int row = 0; row < this.cellHeights.length; ++row) {
            int h = this.getRowHeight(row);
            if (y0 < h) {
                return row;
            }
            y0 -= h;
        }
        return -1;
    }

    void updateLayoutState() {
        int nrows = this.list.getModel().getSize();
        this.cellHeight = -1;
        this.cellWidth = -1;
        if (this.cellHeights == null || this.cellHeights.length != nrows) {
            this.cellHeights = new int[nrows];
        }
        if (this.list.getFixedCellHeight() == -1 || this.list.getFixedCellWidth() == -1) {
            ListCellRenderer rend = this.list.getCellRenderer();
            for (int i = 0; i < nrows; ++i) {
                Component flyweight = rend.getListCellRendererComponent(this.list, this.list.getModel().getElementAt(i), 0, false, false);
                Dimension dim = flyweight.getPreferredSize();
                this.cellHeights[i] = dim.height;
                this.cellWidth = Math.max(this.cellWidth, dim.width);
            }
        } else {
            this.cellHeight = this.list.getFixedCellHeight();
            this.cellWidth = this.list.getFixedCellWidth();
        }
    }

    void damageLayout() {
        this.updateLayoutStateNeeded = 1;
        this.list.revalidate();
    }

    void maybeUpdateLayoutState() {
        if (this.updateLayoutStateNeeded != 0) {
            this.updateLayoutState();
            this.updateLayoutStateNeeded = 0;
        }
    }

    void installDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.list.setForeground(defaults.getColor("List.foreground"));
        this.list.setBackground(defaults.getColor("List.background"));
        this.list.setSelectionForeground(defaults.getColor("List.selectionForeground"));
        this.list.setSelectionBackground(defaults.getColor("List.selectionBackground"));
        this.list.setOpaque(true);
    }

    void uninstallDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.list.setForeground(null);
        this.list.setBackground(null);
        this.list.setSelectionForeground(null);
        this.list.setSelectionBackground(null);
    }

    void installListeners() {
        this.list.addFocusListener(this.focusListener);
        this.list.getModel().addListDataListener(this.listDataListener);
        this.list.addListSelectionListener(this.listSelectionListener);
        this.list.addMouseListener(this.mouseInputListener);
        this.list.addMouseMotionListener(this.mouseInputListener);
        this.list.addPropertyChangeListener(this.propertyChangeListener);
    }

    void uninstallListeners() {
        this.list.removeFocusListener(this.focusListener);
        this.list.getModel().removeListDataListener(this.listDataListener);
        this.list.removeListSelectionListener(this.listSelectionListener);
        this.list.removeMouseListener(this.mouseInputListener);
        this.list.removeMouseMotionListener(this.mouseInputListener);
        this.list.removePropertyChangeListener(this.propertyChangeListener);
    }

    void installKeyboardActions() {
    }

    void uninstallKeyboardActions() {
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.list = (JList)c;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.maybeUpdateLayoutState();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.list = null;
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getPreferredSize(JComponent c) {
        if (this.list.getModel().getSize() == 0) {
            return new Dimension(0, 0);
        }
        Rectangle bounds = this.getCellBounds(this.list, 0, this.list.getModel().getSize() - 1);
        return bounds.getSize();
    }

    public void paintBackground(Graphics g, JComponent c) {
        Dimension size = this.getPreferredSize(c);
        Color save = g.getColor();
        g.setColor(c.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(save);
    }

    void paintCell(Graphics g, int row, Rectangle bounds, ListCellRenderer rend, ListModel data, ListSelectionModel sel, int lead) {
        boolean is_sel = this.list.isSelectedIndex(row);
        boolean has_focus = false;
        Component comp = rend.getListCellRendererComponent(this.list, data.getElementAt(row), 0, is_sel, has_focus);
        g.translate(bounds.x, bounds.y);
        comp.setBounds(new Rectangle(0, 0, bounds.width, bounds.height));
        comp.paint(g);
        g.translate(-bounds.x, -bounds.y);
    }

    public void paint(Graphics g, JComponent c) {
        int nrows = this.list.getModel().getSize();
        if (nrows == 0) {
            return;
        }
        this.maybeUpdateLayoutState();
        ListCellRenderer render = this.list.getCellRenderer();
        ListModel model = this.list.getModel();
        ListSelectionModel sel = this.list.getSelectionModel();
        int lead = sel.getLeadSelectionIndex();
        Rectangle clip = g.getClipBounds();
        this.paintBackground(g, this.list);
        for (int row = 0; row < nrows; ++row) {
            Rectangle bounds = this.getCellBounds(this.list, row, row);
            if (!bounds.intersects(clip)) continue;
            this.paintCell(g, row, bounds, render, model, sel, lead);
        }
    }

    public int locationToIndex(JList list, Point location) {
        return this.convertYToRow(location.y);
    }

    public Point indexToLocation(JList list, int index) {
        return new Point(0, this.convertRowToY(index));
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicListUI this$0;

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == this.this$0.list) {
                if (e.getOldValue() != null && e.getOldValue() instanceof ListModel) {
                    ((ListModel)e.getOldValue()).removeListDataListener(this.this$0.listDataListener);
                }
                if (e.getNewValue() != null && e.getNewValue() instanceof ListModel) {
                    ((ListModel)e.getNewValue()).addListDataListener(this.this$0.listDataListener);
                }
            }
            this.this$0.damageLayout();
        }

        PropertyChangeHandler(BasicListUI this$0) {
            this.this$0 = this$0;
        }
    }

    class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ BasicListUI this$0;

        public void mouseClicked(MouseEvent event) {
        }

        public void mousePressed(MouseEvent event) {
            int row = this.this$0.convertYToRow(event.getY());
            if (row == -1) {
                return;
            }
            this.this$0.list.setSelectedIndex(row);
        }

        public void mouseReleased(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mouseDragged(MouseEvent event) {
        }

        public void mouseMoved(MouseEvent event) {
        }

        MouseInputHandler(BasicListUI this$0) {
            this.this$0 = this$0;
        }
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        private /* synthetic */ BasicListUI this$0;

        public void valueChanged(ListSelectionEvent e) {
        }

        ListSelectionHandler(BasicListUI this$0) {
            this.this$0 = this$0;
        }
    }

    class ListDataHandler
    implements ListDataListener {
        private /* synthetic */ BasicListUI this$0;

        public void contentsChanged(ListDataEvent e) {
            this.this$0.damageLayout();
        }

        public void intervalAdded(ListDataEvent e) {
            this.this$0.damageLayout();
        }

        public void intervalRemoved(ListDataEvent e) {
            this.this$0.damageLayout();
        }

        ListDataHandler(BasicListUI this$0) {
            this.this$0 = this$0;
        }
    }

    class FocusHandler
    implements FocusListener {
        private /* synthetic */ BasicListUI this$0;

        public void focusGained(FocusEvent e) {
            this.repaintCellFocus();
        }

        public void focusLost(FocusEvent e) {
            this.repaintCellFocus();
        }

        void repaintCellFocus() {
        }

        FocusHandler(BasicListUI this$0) {
            this.this$0 = this$0;
        }
    }
}

