/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;

public class BasicMenuBarUI
extends MenuBarUI {
    protected ChangeListener changeListener = this.createChangeListener();
    protected ContainerListener containerListener = this.createContainerListener();
    protected PropertyChangeListener propertyChangeListener = new PropertyChangeHandler(this);
    protected JMenuBar menuBar;

    protected ChangeListener createChangeListener() {
        return new ChangeHandler(this);
    }

    protected ContainerListener createContainerListener() {
        return new ContainerHandler(this);
    }

    public static ComponentUI createUI(JComponent x) {
        return new BasicMenuBarUI();
    }

    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    protected void installDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.menuBar.setBackground(defaults.getColor("MenuBar.background"));
        this.menuBar.setBorder(defaults.getBorder("MenuBar.border"));
        this.menuBar.setFont(defaults.getFont("MenuBar.font"));
        this.menuBar.setForeground(defaults.getColor("MenuBar.foreground"));
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.menuBar.addContainerListener(this.containerListener);
        this.menuBar.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.menuBar = (JMenuBar)c;
        this.menuBar.setLayout(new BoxLayout(this.menuBar, 0));
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void uninstallDefaults() {
        this.menuBar.setBackground(null);
        this.menuBar.setBorder(null);
        this.menuBar.setFont(null);
        this.menuBar.setForeground(null);
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.menuBar.removeContainerListener(this.containerListener);
        this.menuBar.removePropertyChangeListener(this.propertyChangeListener);
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.menuBar = null;
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicMenuBarUI this$0;

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("borderPainted")) {
                this.this$0.menuBar.repaint();
            }
            if (e.getPropertyName().equals("margin")) {
                this.this$0.menuBar.repaint();
            }
        }

        PropertyChangeHandler(BasicMenuBarUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class ContainerHandler
    implements ContainerListener {
        private /* synthetic */ BasicMenuBarUI this$0;

        public void componentAdded(ContainerEvent e) {
            this.this$0.menuBar.revalidate();
            this.this$0.menuBar.repaint();
        }

        public void componentRemoved(ContainerEvent e) {
            this.this$0.menuBar.revalidate();
            this.this$0.menuBar.repaint();
        }

        ContainerHandler(BasicMenuBarUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class ChangeHandler
    implements ChangeListener {
        private /* synthetic */ BasicMenuBarUI this$0;

        public void stateChanged(ChangeEvent event) {
        }

        ChangeHandler(BasicMenuBarUI this$0) {
            this.this$0 = this$0;
        }
    }
}

