/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicMenuItemUI
extends MenuItemUI {
    protected Font acceleratorFont;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    protected Icon arrowIcon;
    protected Icon checkIcon;
    protected int defaultTextIconGap;
    protected Color disabledForeground;
    protected MenuDragMouseListener menuDragMouseListener;
    protected JMenuItem menuItem;
    protected MenuKeyListener menuKeyListener;
    protected MouseInputListener mouseInputListener;
    protected boolean oldBorderPainted;
    protected Color selectionBackground;
    protected Color selectionForeground;
    private String acceleratorDelimiter;
    private PropertyChangeListener propertyChangeListener;
    private int defaultAcceleratorLabelGap;

    private /* synthetic */ void finit$() {
        this.defaultTextIconGap = 4;
        this.defaultAcceleratorLabelGap = 4;
    }

    public BasicMenuItemUI() {
        this.finit$();
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem);
        this.menuKeyListener = this.createMenuKeyListener(this.menuItem);
        this.propertyChangeListener = new PropertyChangeHandler(this);
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler(this);
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return new MenuKeyHandler(this);
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler(this);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicMenuItemUI();
    }

    protected void doClick(MenuSelectionManager msm) {
        this.menuItem.doClick();
        msm.clearSelectedPath();
    }

    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    public MenuElement[] getPath() {
        ArrayList path = new ArrayList();
        if (this.menuItem instanceof JMenu) {
            path.add(((JMenu)this.menuItem).getPopupMenu());
        }
        Component c = this.menuItem;
        while (c instanceof MenuElement) {
            path.add(0, c);
            if (c instanceof JPopupMenu) {
                c = ((JPopupMenu)c).getInvoker();
                continue;
            }
            c = c.getParent();
        }
        Object[] pathArray = new MenuElement[path.size()];
        path.toArray(pathArray);
        return pathArray;
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon2, int defaultTextIconGap) {
        JMenuItem m = (JMenuItem)c;
        Dimension d = BasicGraphicsUtils.getPreferredButtonSize(m, defaultTextIconGap);
        KeyStroke accelerator = m.getAccelerator();
        if (accelerator != null) {
            Rectangle rect = this.getAcceleratorRect(accelerator, m.getToolkit().getFontMetrics(this.acceleratorFont));
            d.width = d.width + rect.width + this.defaultAcceleratorLabelGap;
            if (d.height < rect.height) {
                d.height = rect.height;
            }
        }
        if (checkIcon != null) {
            d.width = d.width + checkIcon.getIconWidth() + defaultTextIconGap;
            if (checkIcon.getIconHeight() > d.height) {
                d.height = checkIcon.getIconHeight();
            }
        }
        if (arrowIcon2 != null && c instanceof JMenu) {
            d.width = d.width + arrowIcon2.getIconWidth() + defaultTextIconGap;
            if (arrowIcon2.getIconHeight() > d.height) {
                d.height = arrowIcon2.getIconHeight();
            }
        }
        return d;
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getPreferredMenuItemSize(c, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    protected String getPropertyPrefix() {
        return null;
    }

    protected void installComponents(JMenuItem menuItem) {
    }

    protected void installDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.menuItem.setBackground(defaults.getColor("MenuItem.background"));
        this.menuItem.setBorder(defaults.getBorder("MenuItem.border"));
        this.menuItem.setFont(defaults.getFont("MenuItem.font"));
        this.menuItem.setForeground(defaults.getColor("MenuItem.foreground"));
        this.menuItem.setMargin(defaults.getInsets("MenuItem.margin"));
        this.menuItem.setOpaque(true);
        this.acceleratorFont = defaults.getFont("MenuItem.acceleratorFont");
        this.acceleratorForeground = defaults.getColor("MenuItem.acceleratorForeground");
        this.acceleratorSelectionForeground = defaults.getColor("MenuItem.acceleratorSelectionForeground");
        this.selectionBackground = defaults.getColor("MenuItem.selectionBackground");
        this.selectionForeground = defaults.getColor("MenuItem.selectionForeground");
        this.acceleratorDelimiter = defaults.getString("MenuItem.acceleratorDelimiter");
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.menuItem.addMouseListener(this.mouseInputListener);
        this.menuItem.addMouseMotionListener(this.mouseInputListener);
        this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.addMenuKeyListener(this.menuKeyListener);
        this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.menuItem = (JMenuItem)c;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
    }

    public void paint(Graphics g, JComponent c) {
        this.paintMenuItem(g, c, this.checkIcon, this.arrowIcon, c.getBackground(), c.getForeground(), this.defaultTextIconGap);
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        Dimension size = this.getPreferredSize(menuItem);
        Color foreground = g.getColor();
        g.setColor(bgColor);
        g.drawRect(0, 0, size.width, size.height);
        g.setColor(foreground);
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon2, Color background, Color foreground, int defaultTextIconGap) {
        Icon i;
        JMenuItem m = (JMenuItem)c;
        Rectangle tr = new Rectangle();
        Rectangle ir = new Rectangle();
        Rectangle vr = new Rectangle();
        Rectangle br = new Rectangle();
        Rectangle ar = new Rectangle();
        Rectangle cr = new Rectangle();
        int vertAlign = m.getVerticalAlignment();
        int horAlign = m.getHorizontalAlignment();
        int vertTextPos = m.getVerticalTextPosition();
        int horTextPos = m.getHorizontalTextPosition();
        Font f = m.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        SwingUtilities.calculateInnerArea(m, br);
        SwingUtilities.calculateInsetArea(br, m.getInsets(), vr);
        this.paintBackground(g, m, m.getBackground());
        Insets insets = m.getInsets();
        br.x -= insets.left;
        br.y -= insets.top;
        br.width += insets.right + insets.left;
        br.height += insets.top + insets.bottom;
        if (m.getModel().isArmed() && (m.getParent() instanceof MenuElement || m.getModel().isPressed())) {
            if (m.isContentAreaFilled()) {
                g.setColor(this.selectionBackground);
                g.fillRect(br.x, br.y, br.width, br.height);
            }
        } else if (m.isContentAreaFilled()) {
            g.setColor(m.getBackground());
            g.fillRect(br.x, br.y, br.width, br.height);
        }
        if (checkIcon != null) {
            SwingUtilities.layoutCompoundLabel(m, fm, null, checkIcon, vertAlign, horAlign, vertTextPos, horTextPos, vr, cr, tr, defaultTextIconGap);
            checkIcon.paintIcon(m, g, cr.x, cr.y);
            vr.x = cr.x + cr.width + defaultTextIconGap;
        }
        if (arrowIcon2 != null && c instanceof JMenu && !((JMenu)c).isTopLevelMenu()) {
            int width = arrowIcon2.getIconWidth();
            int height = arrowIcon2.getIconHeight();
            arrowIcon2.paintIcon(m, g, vr.width - width + defaultTextIconGap, vr.y + 2);
        }
        if ((i = m.getIcon()) != null) {
            i.paintIcon(c, g, vr.x, vr.y);
            vr.x += i.getIconWidth() + defaultTextIconGap;
        }
        SwingUtilities.layoutCompoundLabel(c, fm, m.getText(), m.getIcon(), vertAlign, horAlign, vertTextPos, horTextPos, vr, ir, tr, defaultTextIconGap);
        this.paintText(g, m, tr, m.getText());
        String acceleratorText = "";
        if (m.getAccelerator() != null) {
            acceleratorText = this.getAcceleratorText(m.getAccelerator());
            fm = g.getFontMetrics(this.acceleratorFont);
            ar.width = fm.stringWidth(acceleratorText);
            ar.x = br.width - ar.width;
            vr.x = br.width - ar.width;
            SwingUtilities.layoutCompoundLabel(m, fm, acceleratorText, null, vertAlign, horAlign, vertTextPos, horTextPos, vr, ir, ar, defaultTextIconGap);
            this.paintAccelerator(g, m, ar, acceleratorText);
        }
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        Font f = menuItem.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        if (text != null && !text.equals("")) {
            if (menuItem.isEnabled()) {
                g.setColor(menuItem.getForeground());
            } else {
                g.setColor(Color.gray);
            }
            int mnemonicIndex = menuItem.getDisplayedMnemonicIndex();
            if (mnemonicIndex != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            } else {
                BasicGraphicsUtils.drawString(g, text, 0, textRect.x, textRect.y + fm.getAscent());
            }
        }
    }

    protected void uninstallComponents(JMenuItem menuItem) {
    }

    protected void uninstallDefaults() {
        this.menuItem.setForeground(null);
        this.menuItem.setBackground(null);
        this.menuItem.setBorder(null);
        this.menuItem.setMargin(null);
        this.menuItem.setBackground(null);
        this.menuItem.setBorder(null);
        this.menuItem.setFont(null);
        this.menuItem.setForeground(null);
        this.menuItem.setMargin(null);
        this.acceleratorFont = null;
        this.acceleratorForeground = null;
        this.acceleratorSelectionForeground = null;
        this.arrowIcon = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.acceleratorDelimiter = null;
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.menuItem.removeMouseListener(this.mouseInputListener);
        this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.menuItem = null;
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    private String getAcceleratorText(KeyStroke accelerator) {
        String modifiersText = "";
        int modifiers = accelerator.getModifiers();
        char keyChar = accelerator.getKeyChar();
        int keyCode = accelerator.getKeyCode();
        if (modifiers != 0) {
            modifiersText = KeyEvent.getKeyModifiersText(modifiers) + this.acceleratorDelimiter;
        }
        if (keyCode == 0) {
            return modifiersText + keyChar;
        }
        return modifiersText + KeyEvent.getKeyText(keyCode);
    }

    private Rectangle getAcceleratorRect(KeyStroke accelerator, FontMetrics fm) {
        int width = fm.stringWidth(this.getAcceleratorText(accelerator));
        int height = fm.getHeight();
        return new Rectangle(0, 0, width, height);
    }

    private void paintAccelerator(Graphics g, JMenuItem menuItem, Rectangle acceleratorRect, String acceleratorText) {
        g.setFont(this.acceleratorFont);
        FontMetrics fm = g.getFontMetrics(this.acceleratorFont);
        if (menuItem.isEnabled()) {
            g.setColor(this.acceleratorForeground);
        } else {
            g.setColor(Color.gray);
        }
        BasicGraphicsUtils.drawString(g, acceleratorText, 0, acceleratorRect.x, acceleratorRect.y + fm.getAscent());
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicMenuItemUI this$0;

        public void propertyChange(PropertyChangeEvent evt) {
            this.this$0.menuItem.revalidate();
            this.this$0.menuItem.repaint();
        }

        PropertyChangeHandler(BasicMenuItemUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class MenuKeyHandler
    implements MenuKeyListener {
        private /* synthetic */ BasicMenuItemUI this$0;

        public void menuKeyPressed(MenuKeyEvent e) {
        }

        public void menuKeyReleased(MenuKeyEvent e) {
        }

        public void menuKeyTyped(MenuKeyEvent e) {
        }

        MenuKeyHandler(BasicMenuItemUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private /* synthetic */ BasicMenuItemUI this$0;

        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.setSelectedPath(e.getPath());
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.setSelectedPath(e.getPath());
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
            MenuElement[] path = e.getPath();
            if (path[path.length - 1] instanceof JMenuItem) {
                ((JMenuItem)path[path.length - 1]).doClick();
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.clearSelectedPath();
        }

        MenuDragMouseHandler(BasicMenuItemUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ BasicMenuItemUI this$0;

        protected MouseInputHandler(BasicMenuItemUI this$0) {
            this.this$0 = this$0;
        }

        public void mouseClicked(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseEntered(MouseEvent e) {
            Component source = (Component)e.getSource();
            if (source.getParent() instanceof MenuElement) {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                manager.setSelectedPath(this.this$0.getPath());
                manager.processMouseEvent(e);
            }
        }

        public void mouseExited(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            Rectangle size = this.this$0.menuItem.getBounds();
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            if (e.getX() > 0 && e.getX() < size.width && e.getY() > 0 && e.getY() < size.height) {
                manager.clearSelectedPath();
                this.this$0.menuItem.doClick();
            } else {
                manager.processMouseEvent(e);
            }
        }
    }
}

