/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class BasicMenuUI
extends BasicMenuItemUI {
    protected ChangeListener changeListener;
    protected MenuListener menuListener;
    protected PropertyChangeListener propertyChangeListener;

    public BasicMenuUI() {
        this.mouseInputListener = this.createMouseInputListener((JMenu)this.menuItem);
        this.menuListener = this.createMenuListener((JMenu)this.menuItem);
        this.propertyChangeListener = this.createPropertyChangeListener((JMenu)this.menuItem);
    }

    protected ChangeListener createChangeListener(JComponent c) {
        return new ChangeHandler(this);
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler(this);
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return new MenuKeyHandler(this);
    }

    protected MenuListener createMenuListener(JComponent c) {
        return new MenuHandler(this);
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return new PropertyChangeHandler(this);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicMenuUI();
    }

    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    protected String getPropertyPrefix() {
        return null;
    }

    protected void installDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.menuItem.setBackground(defaults.getColor("Menu.background"));
        this.menuItem.setBorder(defaults.getBorder("Menu.border"));
        this.menuItem.setFont(defaults.getFont("Menu.font"));
        this.menuItem.setForeground(defaults.getColor("Menu.foreground"));
        this.menuItem.setMargin(defaults.getInsets("Menu.margin"));
        this.acceleratorFont = defaults.getFont("Menu.acceleratorFont");
        this.acceleratorForeground = defaults.getColor("Menu.acceleratorForeground");
        this.acceleratorSelectionForeground = defaults.getColor("Menu.acceleratorSelectionForeground");
        this.selectionBackground = defaults.getColor("Menu.selectionBackground");
        this.selectionForeground = defaults.getColor("Menu.selectionForeground");
        this.arrowIcon = defaults.getIcon("Menu.arrowIcon");
        this.oldBorderPainted = defaults.getBoolean("Menu.borderPainted");
        this.menuItem.setOpaque(true);
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        ((JMenu)this.menuItem).addMouseListener(this.mouseInputListener);
        ((JMenu)this.menuItem).addMouseMotionListener(this.mouseInputListener);
        ((JMenu)this.menuItem).addMenuListener(this.menuListener);
        ((JMenu)this.menuItem).addMenuDragMouseListener(this.menuDragMouseListener);
    }

    protected void setupPostTimer(JMenu menu) {
    }

    protected void uninstallDefaults() {
        this.menuItem.setBackground(null);
        this.menuItem.setBorder(null);
        this.menuItem.setFont(null);
        this.menuItem.setForeground(null);
        this.menuItem.setMargin(null);
        this.acceleratorFont = null;
        this.acceleratorForeground = null;
        this.acceleratorSelectionForeground = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.arrowIcon = null;
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        ((JMenu)this.menuItem).removeMouseListener(this.mouseInputListener);
        ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        ((JMenu)this.menuItem).removePropertyChangeListener(this.propertyChangeListener);
    }

    protected class MenuKeyHandler
    implements MenuKeyListener {
        private /* synthetic */ BasicMenuUI this$0;

        public void menuKeyPressed(MenuKeyEvent e) {
        }

        public void menuKeyReleased(MenuKeyEvent e) {
        }

        public void menuKeyTyped(MenuKeyEvent e) {
        }

        MenuKeyHandler(BasicMenuUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private /* synthetic */ BasicMenuUI this$0;

        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.setSelectedPath(e.getPath());
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.setSelectedPath(e.getPath());
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
        }

        MenuDragMouseHandler(BasicMenuUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class ChangeHandler
    implements ChangeListener {
        private /* synthetic */ BasicMenuUI this$0;

        public void stateChanged(ChangeEvent e) {
        }

        ChangeHandler(BasicMenuUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicMenuUI this$0;

        public void propertyChange(PropertyChangeEvent evt) {
        }

        PropertyChangeHandler(BasicMenuUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class MenuHandler
    implements MenuListener {
        private /* synthetic */ BasicMenuUI this$0;

        public void menuCanceled(MenuEvent e) {
            this.menuDeselected(e);
        }

        public void menuDeselected(MenuEvent e) {
            JMenu menu = (JMenu)this.this$0.menuItem;
            if (menu.isTopLevelMenu()) {
                ((JMenuBar)menu.getParent()).getSelectionModel().clearSelection();
            } else {
                ((JPopupMenu)menu.getParent()).getSelectionModel().clearSelection();
            }
        }

        public void menuSelected(MenuEvent e) {
            JMenu menu = (JMenu)this.this$0.menuItem;
            if (menu.isTopLevelMenu()) {
                ((JMenuBar)menu.getParent()).setSelected(menu);
            } else {
                ((JPopupMenu)menu.getParent()).setSelected(menu);
            }
        }

        MenuHandler(BasicMenuUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ BasicMenuUI this$0;

        public void mouseClicked(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseEntered(MouseEvent e) {
            JMenu menu = (JMenu)this.this$0.menuItem;
            if (!menu.isTopLevelMenu() || menu.isTopLevelMenu() && ((JMenuBar)menu.getParent()).isSelected() && !menu.isArmed()) {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                manager.setSelectedPath(this.this$0.getPath());
                manager.processMouseEvent(e);
            }
        }

        public void mouseExited(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            JMenu menu = (JMenu)this.this$0.menuItem;
            manager.processMouseEvent(e);
            if (menu.isTopLevelMenu()) {
                if (menu.getPopupMenu().isVisible()) {
                    manager.clearSelectedPath();
                } else {
                    boolean x = false;
                    int y = menu.getHeight();
                    manager.setSelectedPath(this.this$0.getPath());
                    JMenuBar mb = (JMenuBar)menu.getParent();
                    mb.getSelectionModel().setSelectedIndex(mb.getComponentIndex(menu));
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        MouseInputHandler(BasicMenuUI this$0) {
            this.this$0 = this$0;
        }
    }
}

