/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Polygon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.OptionPaneUI;

public class BasicOptionPaneUI
extends OptionPaneUI {
    protected boolean hasCustomComponents;
    protected Component initialFocusComponent;
    protected JComponent inputComponent;
    public static int minimumHeight;
    public static int minimumWidth;
    protected Dimension minimumSize;
    protected PropertyChangeListener propertyChangeListener;
    protected JOptionPane optionPane;
    private static int iconSize;
    private transient Color messageForeground;
    private transient Border messageBorder;
    private transient Border buttonBorder;
    private static String OK_STRING;
    private static String YES_STRING;
    private static String NO_STRING;
    private static String CANCEL_STRING;
    private transient Container messageAreaContainer;
    private transient Container buttonContainer;
    private static messageIcon errorIcon;
    private static messageIcon infoIcon;
    private static messageIcon warningIcon;
    private static messageIcon questionIcon;

    private /* synthetic */ void finit$() {
        this.hasCustomComponents = false;
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public BasicOptionPaneUI() {
        this.finit$();
    }

    protected void addButtonComponents(Container container, Object[] buttons, int initialIndex) {
        if (buttons == null) {
            return;
        }
        for (int i = 0; i < buttons.length; ++i) {
            Component toAdd;
            if (buttons[i] == null) continue;
            if (buttons[i] instanceof Component) {
                toAdd = (Component)buttons[i];
            } else {
                toAdd = buttons[i] instanceof Icon ? new JButton((Icon)buttons[i]) : new JButton(buttons[i].toString());
                this.hasCustomComponents = true;
            }
            if (toAdd instanceof JButton) {
                ((JButton)toAdd).addActionListener(this.createButtonActionListener(i));
            }
            if (i == initialIndex) {
                this.initialFocusComponent = toAdd;
            }
            container.add(toAdd);
        }
        this.selectInitialValue(this.optionPane);
    }

    protected void addIcon(Container top) {
        JLabel iconLabel = null;
        Icon icon = this.getIcon();
        if (icon != null) {
            iconLabel = new JLabel(icon);
            top.add((Component)iconLabel, "West");
        }
    }

    private static GridBagConstraints createConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.anchor = 21;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 3, 0);
        return constraints;
    }

    protected void addMessageComponents(Container container, GridBagConstraints cons, Object msg, int maxll, boolean internallyCreated) {
        if (msg == null) {
            return;
        }
        this.hasCustomComponents = internallyCreated;
        if (msg instanceof Object[]) {
            Object[] arr = (Object[])msg;
            for (int i = 0; i < arr.length; ++i) {
                this.addMessageComponents(container, cons, arr[i], maxll, internallyCreated);
            }
            return;
        }
        if (msg instanceof Component) {
            container.add((Component)msg, cons);
            ++cons.gridy;
        } else if (msg instanceof Icon) {
            container.add((Component)new JLabel((Icon)msg), cons);
            ++cons.gridy;
        } else if (msg.toString().length() > maxll) {
            Box tmp = new Box(1);
            this.burstStringInto(tmp, msg.toString(), maxll);
            this.addMessageComponents(container, cons, tmp, maxll, true);
        } else {
            this.addMessageComponents(container, cons, new JLabel(msg.toString()), maxll, true);
        }
    }

    protected void burstStringInto(Container c, String d, int maxll) {
        if (d == null || c == null) {
            return;
        }
        JLabel label = new JLabel(d);
        c.add(label);
    }

    public boolean containsCustomComponents(JOptionPane op) {
        return this.hasCustomComponents;
    }

    protected ActionListener createButtonActionListener(int buttonIndex) {
        return new ButtonActionListener(this, buttonIndex);
    }

    protected Container createButtonArea() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(this.createLayoutManager());
        this.addButtonComponents(buttonPanel, this.getButtons(), this.getInitialValueIndex());
        return buttonPanel;
    }

    protected LayoutManager createLayoutManager() {
        return new ButtonAreaLayout(this, this.getSizeButtonsToSameWidth(), 6);
    }

    protected Container createMessageArea() {
        JPanel messageArea = new JPanel();
        messageArea.setLayout(new BorderLayout());
        this.addIcon(messageArea);
        JPanel rightSide = new JPanel(this){
            private /* synthetic */ BasicOptionPaneUI this$0;
            {
                this.this$0 = this$0;
            }

            public Dimension getPreferredSize() {
                int w = Math.max(this.this$0.optionPane.getSize().width, minimumWidth);
                Insets i = this.this$0.optionPane.getInsets();
                Dimension orig = super.getPreferredSize();
                Dimension value = new Dimension(w - i.left - i.right - iconSize, orig.height);
                return value;
            }
        };
        rightSide.setLayout(new GridBagLayout());
        GridBagConstraints con = BasicOptionPaneUI.createConstraints();
        this.addMessageComponents(rightSide, con, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        if (this.optionPane.getWantsInput()) {
            Object[] selection = this.optionPane.getSelectionValues();
            this.inputComponent = selection == null ? null : new JList(selection);
            if (this.inputComponent != null) {
                this.addMessageComponents(rightSide, con, this.inputComponent, this.getMaxCharactersPerLineCount(), true);
                this.resetSelectedValue();
                this.selectInitialValue(this.optionPane);
            }
        }
        messageArea.add((Component)rightSide, "East");
        return messageArea;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected Container createSeparator() {
        return null;
    }

    public static ComponentUI createUI(JComponent x) {
        return new BasicOptionPaneUI();
    }

    protected Object[] getButtons() {
        if (this.optionPane.getOptions() != null) {
            return this.optionPane.getOptions();
        }
        switch (this.optionPane.getOptionType()) {
            case 0: {
                return new Object[]{YES_STRING, NO_STRING};
            }
            case 1: {
                return new Object[]{YES_STRING, NO_STRING, CANCEL_STRING};
            }
            case -1: 
            case 2: {
                return new Object[]{OK_STRING, CANCEL_STRING};
            }
        }
        return null;
    }

    protected Icon getIcon() {
        if (this.optionPane.getIcon() != null) {
            return this.optionPane.getIcon();
        }
        return this.getIconForType(this.optionPane.getMessageType());
    }

    protected Icon getIconForType(int messageType) {
        messageIcon tmp = null;
        switch (messageType) {
            case 0: {
                tmp = errorIcon;
                break;
            }
            case 1: {
                tmp = infoIcon;
                break;
            }
            case 2: {
                tmp = warningIcon;
                break;
            }
            case 3: {
                tmp = questionIcon;
            }
        }
        return tmp;
    }

    protected int getInitialValueIndex() {
        Object[] buttons = this.getButtons();
        if (buttons == null) {
            return -1;
        }
        Object select = this.optionPane.getInitialValue();
        for (int i = 0; i < buttons.length; ++i) {
            if (select != buttons[i]) continue;
            return i;
        }
        return 0;
    }

    protected int getMaxCharactersPerLineCount() {
        return this.optionPane.getMaxCharactersPerLineCount();
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    protected Object getMessage() {
        return this.optionPane.getMessage();
    }

    public Dimension getMinimumOptionPaneSize() {
        return this.minimumSize;
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension d = this.optionPane.getLayout().preferredLayoutSize(this.optionPane);
        Dimension d2 = this.getMinimumOptionPaneSize();
        int w = Math.max(d.width, d2.width);
        int h = Math.max(d.height, d2.height);
        return new Dimension(w, h);
    }

    protected boolean getSizeButtonsToSameWidth() {
        return true;
    }

    protected void installComponents() {
        Container button;
        Container sep;
        this.hasCustomComponents = false;
        Container msg = this.createMessageArea();
        if (msg != null) {
            ((JComponent)msg).setBorder(this.messageBorder);
            msg.setForeground(this.messageForeground);
            this.messageAreaContainer = msg;
            this.optionPane.add(msg);
        }
        if ((sep = this.createSeparator()) != null) {
            this.optionPane.add(sep);
        }
        if ((button = this.createButtonArea()) != null) {
            ((JComponent)button).setBorder(this.buttonBorder);
            this.buttonContainer = button;
            this.optionPane.add(button);
        }
        this.optionPane.invalidate();
    }

    protected void installDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.optionPane.setFont(defaults.getFont("OptionPane.font"));
        this.optionPane.setBackground(defaults.getColor("OptionPane.background"));
        this.optionPane.setForeground(defaults.getColor("OptionPane.foreground"));
        this.optionPane.setBorder(defaults.getBorder("OptionPane.border"));
        this.messageBorder = defaults.getBorder("OptionPane.messageAreaBorder");
        this.messageForeground = defaults.getColor("OptionPane.messageForeground");
        this.buttonBorder = defaults.getBorder("OptionPane.buttonAreaBorder");
        this.minimumSize = defaults.getDimension("OptionPane.minimumSize");
        minimumWidth = this.minimumSize.width;
        minimumHeight = this.minimumSize.height;
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.optionPane.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void installUI(JComponent c) {
        if (c instanceof JOptionPane) {
            this.optionPane = (JOptionPane)c;
            this.installDefaults();
            this.installComponents();
            this.installListeners();
            this.installKeyboardActions();
        }
    }

    protected void resetInputValue() {
        if (this.optionPane.getWantsInput() && this.inputComponent != null) {
            Object output = null;
            if (this.inputComponent instanceof JTextField) {
                output = ((JTextField)this.inputComponent).getText();
            } else if (this.inputComponent instanceof JComboBox) {
                output = ((JComboBox)this.inputComponent).getSelectedItem();
            } else if (this.inputComponent instanceof JList) {
                output = ((JList)this.inputComponent).getSelectedValue();
            }
            if (output != null) {
                this.optionPane.setInputValue(output);
            }
        }
    }

    public void selectInitialValue(JOptionPane op) {
        if (this.inputComponent != null) {
            this.inputComponent.requestFocus();
            return;
        }
        if (this.initialFocusComponent != null) {
            this.initialFocusComponent.requestFocus();
        }
    }

    private void resetSelectedValue() {
        if (this.inputComponent != null) {
            Object init = this.optionPane.getInitialSelectionValue();
            if (init == null) {
                return;
            }
            if (this.inputComponent instanceof JTextField) {
                ((JTextField)this.inputComponent).setText((String)init);
            } else if (this.inputComponent instanceof JComboBox) {
                ((JComboBox)this.inputComponent).setSelectedItem(init);
            } else if (this.inputComponent instanceof JList) {
                // empty if block
            }
        }
    }

    protected void uninstallComponents() {
        this.optionPane.removeAll();
        this.buttonContainer = null;
        this.messageAreaContainer = null;
    }

    protected void uninstallDefaults() {
        this.optionPane.setFont(null);
        this.optionPane.setForeground(null);
        this.optionPane.setBackground(null);
        this.minimumSize = null;
        this.messageBorder = null;
        this.buttonBorder = null;
        this.messageForeground = null;
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.optionPane.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.optionPane = null;
    }

    static {
        iconSize = 36;
        OK_STRING = "OK";
        YES_STRING = "Yes";
        NO_STRING = "No";
        CANCEL_STRING = "Cancel";
        errorIcon = new messageIcon(null){
            private /* synthetic */ BasicOptionPaneUI this$0;
            {
                this.this$0 = this$0;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                Polygon oct = new Polygon(new int[]{0, 0, 9, 27, 36, 36, 27, 9}, new int[]{9, 27, 36, 36, 27, 9, 0, 0}, 8);
                g.translate(x, y);
                Color saved = g.getColor();
                g.setColor(Color.RED);
                g.fillPolygon(oct);
                g.setColor(Color.BLACK);
                g.drawRect(13, 16, 10, 4);
                g.setColor(saved);
                g.translate(-x, -y);
            }
        };
        infoIcon = new messageIcon(null){
            private /* synthetic */ BasicOptionPaneUI this$0;
            {
                this.this$0 = this$0;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.translate(x, y);
                Color saved = g.getColor();
                g.setColor(Color.RED);
                g.fillOval(0, 0, iconSize, iconSize);
                g.setColor(Color.BLACK);
                g.drawOval(16, 6, 4, 4);
                Polygon bottomI = new Polygon(new int[]{15, 15, 13, 13, 23, 23, 21, 21}, new int[]{12, 28, 28, 30, 30, 28, 28, 12}, 8);
                g.drawPolygon(bottomI);
                g.setColor(saved);
                g.translate(-x, -y);
            }
        };
        warningIcon = new messageIcon(null){
            private /* synthetic */ BasicOptionPaneUI this$0;
            {
                this.this$0 = this$0;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.translate(x, y);
                Color saved = g.getColor();
                g.setColor(Color.YELLOW);
                Polygon triangle = new Polygon(new int[]{0, 18, 36}, new int[]{36, 0, 36}, 3);
                g.fillPolygon(triangle);
                g.setColor(Color.BLACK);
                Polygon excl = new Polygon(new int[]{15, 16, 20, 21}, new int[]{8, 26, 26, 8}, 4);
                g.drawPolygon(excl);
                g.drawOval(16, 30, 4, 4);
                g.setColor(saved);
                g.translate(-x, -y);
            }
        };
        questionIcon = new messageIcon(null){
            private /* synthetic */ BasicOptionPaneUI this$0;
            {
                this.this$0 = this$0;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.translate(x, y);
                Color saved = g.getColor();
                g.setColor(Color.GREEN);
                g.fillRect(0, 0, iconSize, iconSize);
                g.setColor(Color.BLACK);
                g.drawOval(11, 2, 16, 16);
                g.drawOval(14, 5, 10, 10);
                g.setColor(Color.GREEN);
                g.fillRect(0, 10, iconSize, iconSize - 10);
                g.setColor(Color.BLACK);
                g.drawLine(11, 10, 14, 10);
                g.drawLine(24, 10, 17, 22);
                g.drawLine(27, 10, 20, 22);
                g.drawLine(17, 22, 20, 22);
                g.drawOval(17, 25, 3, 3);
                g.setColor(saved);
                g.translate(-x, -y);
            }
        };
    }

    private static class messageIcon
    implements Icon {
        public int getIconWidth() {
            return iconSize;
        }

        public int getIconHeight() {
            return iconSize;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        messageIcon() {
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicOptionPaneUI this$0;

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("icon") || e.getPropertyName().equals("messageType")) {
                this.this$0.addIcon(this.this$0.messageAreaContainer);
            } else if (e.getPropertyName().equals("initialSelectionValue")) {
                this.this$0.resetSelectedValue();
            } else if (e.getPropertyName().equals("initialValue") || e.getPropertyName().equals("options") || e.getPropertyName().equals("optionType")) {
                Container newButtons = this.this$0.createButtonArea();
                this.this$0.optionPane.remove(this.this$0.buttonContainer);
                this.this$0.optionPane.add(newButtons);
                this.this$0.buttonContainer = newButtons;
            } else if (e.getPropertyName().equals("message") || e.getPropertyName().equals("wantsInput") || e.getPropertyName().equals("selectionValues")) {
                this.this$0.optionPane.removeAll();
                this.this$0.messageAreaContainer = this.this$0.createMessageArea();
                this.this$0.optionPane.add(this.this$0.messageAreaContainer);
                this.this$0.optionPane.add(this.this$0.buttonContainer);
            }
            this.this$0.optionPane.invalidate();
            this.this$0.optionPane.repaint();
        }

        public PropertyChangeHandler(BasicOptionPaneUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class ButtonAreaLayout
    implements LayoutManager {
        private /* synthetic */ BasicOptionPaneUI this$0;
        protected boolean centersChildren;
        protected int padding;
        protected boolean syncAllWidths;
        private transient int widthOfWidestButton;
        private transient int tallestButton;

        private /* synthetic */ void finit$() {
            this.centersChildren = true;
        }

        public ButtonAreaLayout(BasicOptionPaneUI this$0, boolean syncAllWidths, int padding) {
            this.this$0 = this$0;
            this.finit$();
            this.syncAllWidths = syncAllWidths;
            this.padding = padding;
        }

        public void addLayoutComponent(String string, Component comp) {
        }

        public boolean getCentersChildren() {
            return this.centersChildren;
        }

        public int getPadding() {
            return this.padding;
        }

        public boolean getSyncAllWidths() {
            return this.syncAllWidths;
        }

        public void layoutContainer(Container container) {
            Component[] buttonList = container.getComponents();
            int x = container.getInsets().left;
            if (this.getCentersChildren()) {
                x += (int)((double)container.getSize().width / 2.0 - (double)this.buttonRowLength(container) / 2.0);
            }
            for (int i = 0; i < buttonList.length; ++i) {
                Dimension dims = buttonList[i].getPreferredSize();
                if (this.this$0.getSizeButtonsToSameWidth()) {
                    buttonList[i].setBounds(x, 0, this.widthOfWidestButton, dims.height);
                    x += this.widthOfWidestButton + this.getPadding();
                    continue;
                }
                buttonList[i].setBounds(x, 0, dims.width, dims.height);
                x += dims.width + this.getPadding();
            }
        }

        private int buttonRowLength(Container c) {
            Component[] buttonList = c.getComponents();
            int buttonLength = 0;
            int widest = 0;
            int tallest = 0;
            for (int i = 0; i < buttonList.length; ++i) {
                Dimension dims = buttonList[i].getPreferredSize();
                buttonLength += dims.width + this.getPadding();
                widest = Math.max(widest, dims.width);
                tallest = Math.max(tallest, dims.height);
            }
            this.widthOfWidestButton = widest;
            this.tallestButton = tallest;
            int width = this.getSyncAllWidths() ? widest * buttonList.length + this.getPadding() * (buttonList.length - 1) : buttonLength;
            Insets insets = c.getInsets();
            return width += insets.left + insets.right;
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public Dimension preferredLayoutSize(Container c) {
            int w = this.buttonRowLength(c);
            return new Dimension(w, this.tallestButton);
        }

        public void removeLayoutComponent(Component c) {
        }

        public void setCentersChildren(boolean newValue) {
            this.centersChildren = newValue;
            this.this$0.optionPane.invalidate();
        }

        public void setPadding(int newPadding) {
            this.padding = newPadding;
            this.this$0.optionPane.invalidate();
        }

        public void setSyncAllWidths(boolean newValue) {
            this.syncAllWidths = newValue;
            this.this$0.optionPane.invalidate();
        }
    }

    protected class ButtonActionListener
    implements ActionListener {
        private /* synthetic */ BasicOptionPaneUI this$0;
        protected int buttonIndex;

        public ButtonActionListener(BasicOptionPaneUI this$0, int buttonIndex) {
            this.this$0 = this$0;
            this.buttonIndex = buttonIndex;
        }

        public void actionPerformed(ActionEvent e) {
            JInternalFrame inf;
            Integer value = new Integer(-1);
            Object[] options = this.this$0.optionPane.getOptions();
            if (options != null) {
                value = new Integer(this.buttonIndex);
            } else {
                String text = ((JButton)e.getSource()).getText();
                if (text.equals(OK_STRING)) {
                    value = new Integer(0);
                }
                if (text.equals(CANCEL_STRING)) {
                    value = new Integer(2);
                }
                if (text.equals(YES_STRING)) {
                    value = new Integer(0);
                }
                if (text.equals(NO_STRING)) {
                    value = new Integer(1);
                }
            }
            this.this$0.optionPane.setValue(value);
            this.this$0.resetInputValue();
            Window owner = SwingUtilities.windowForComponent(this.this$0.optionPane);
            if (owner instanceof JDialog) {
                ((JDialog)owner).dispose();
            }
            if ((inf = (JInternalFrame)SwingUtilities.getAncestorOfClass(BasicOptionPaneUI.class$("javax.swing.JInternalFrame"), this.this$0.optionPane)) != null) {
                try {
                    inf.setClosed(true);
                }
                catch (PropertyVetoException pve) {
                    // empty catch block
                }
            }
        }
    }
}

