/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PopupMenuUI;

public class BasicPopupMenuUI
extends PopupMenuUI {
    protected JPopupMenu popupMenu;
    private static transient MouseInputListener mouseInputListener;
    private transient PopupMenuListener popupMenuListener = new PopupMenuHandler(this);
    private TopWindowListener topWindowListener;

    static /* synthetic */ TopWindowListener access$1(BasicPopupMenuUI inst$, TopWindowListener write_parm_value$) {
        inst$.topWindowListener = write_parm_value$;
        return inst$.topWindowListener;
    }

    public BasicPopupMenuUI() {
        mouseInputListener = new MouseInputHandler(this);
        this.topWindowListener = new TopWindowListener(this);
    }

    public static ComponentUI createUI(JComponent x) {
        return new BasicPopupMenuUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.popupMenu = (JPopupMenu)c;
        this.popupMenu.setLayout(new GridBagLayout());
        this.popupMenu.setBorderPainted(true);
        JPopupMenu.setDefaultLightWeightPopupEnabled(true);
        this.installDefaults();
        this.installListeners();
    }

    public void installDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.popupMenu.setBackground(defaults.getColor("PopupMenu.background"));
        this.popupMenu.setBorder(defaults.getBorder("PopupMenu.border"));
        this.popupMenu.setFont(defaults.getFont("PopupMenu.font"));
        this.popupMenu.setForeground(defaults.getColor("PopupMenu.foreground"));
        this.popupMenu.setOpaque(true);
    }

    protected void installListeners() {
        this.popupMenu.addMouseListener(mouseInputListener);
        this.popupMenu.addMouseMotionListener(mouseInputListener);
        this.popupMenu.addPopupMenuListener(this.popupMenuListener);
    }

    protected void installKeyboardActions() {
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.popupMenu = null;
    }

    protected void uninstallDefaults() {
        this.popupMenu.setBackground(null);
        this.popupMenu.setBorder(null);
        this.popupMenu.setFont(null);
        this.popupMenu.setForeground(null);
    }

    protected void uninstallListeners() {
        this.popupMenu.removeMouseListener(mouseInputListener);
        this.popupMenu.removeMouseMotionListener(mouseInputListener);
        this.popupMenu.removePopupMenuListener(this.popupMenuListener);
    }

    protected void uninstallKeyboardActions() {
    }

    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    public boolean isPopupTrigger(MouseEvent e) {
        return false;
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ BasicPopupMenuUI this$0;

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        MouseInputHandler(BasicPopupMenuUI this$0) {
            this.this$0 = this$0;
        }
    }

    private class TopWindowListener
    implements ComponentListener {
        private /* synthetic */ BasicPopupMenuUI this$0;

        public void componentResized(ComponentEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.clearSelectedPath();
        }

        public void componentMoved(ComponentEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.clearSelectedPath();
        }

        public void componentShown(ComponentEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.clearSelectedPath();
        }

        public void componentHidden(ComponentEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.clearSelectedPath();
        }

        TopWindowListener(BasicPopupMenuUI this$0) {
            this.this$0 = this$0;
        }
    }

    private class PopupMenuHandler
    implements PopupMenuListener {
        private /* synthetic */ BasicPopupMenuUI this$0;

        public void popupMenuCanceled(PopupMenuEvent event) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.clearSelectedPath();
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
            Component invoker = this.this$0.popupMenu.getInvoker();
            Container rootContainer = (Container)SwingUtilities.getRoot(invoker);
            rootContainer.removeComponentListener(this.this$0.topWindowListener);
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
            Component invoker = this.this$0.popupMenu.getInvoker();
            Container rootContainer = (Container)SwingUtilities.getRoot(invoker);
            rootContainer.addComponentListener(this.this$0.topWindowListener);
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            if (manager.getSelectedPath().length == 0) {
                MenuElement[] path = new MenuElement[2];
                path[0] = this.this$0.popupMenu;
                Component[] comps = this.this$0.popupMenu.getComponents();
                if (comps.length != 0 && comps[0] instanceof MenuElement) {
                    path[1] = (MenuElement)((Object)comps[0]);
                    manager.setSelectedPath(path);
                }
            }
        }

        PopupMenuHandler(BasicPopupMenuUI this$0) {
            this.this$0 = this$0;
        }
    }
}

