/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;

public class BasicProgressBarUI
extends ProgressBarUI {
    private transient Timer animationTimer;
    private transient int animationIndex;
    private transient int numFrames;
    private transient Animator animation;
    private transient PropertyChangeHandler propertyListener;
    protected ChangeListener changeListener;
    protected JProgressBar progressBar;
    private transient int cellLength;
    private transient int cellSpacing;
    private transient Color selectionBackground;
    private transient Color selectionForeground;

    public static ComponentUI createUI(JComponent x) {
        return new BasicProgressBarUI();
    }

    protected int getAmountFull(Insets b, int width, int height) {
        double percentDone = this.progressBar.getPercentComplete();
        if (this.progressBar.getOrientation() == 0) {
            return (int)(percentDone * (double)(width - b.left - b.right));
        }
        return (int)(percentDone * (double)(height - b.top - b.bottom));
    }

    protected int getAnimationIndex() {
        return this.animationIndex;
    }

    protected Rectangle getBox(Rectangle r) {
        double boxIndependent;
        double boxDependent;
        Dimension dims;
        if (!this.progressBar.isIndeterminate()) {
            return null;
        }
        int iterations = this.numFrames / 2 + 1;
        if (this.progressBar.getOrientation() == 0) {
            dims = this.getPreferredInnerHorizontal();
            boxDependent = (double)dims.width / (double)iterations;
            boxIndependent = dims.height;
        } else {
            dims = this.getPreferredInnerVertical();
            boxDependent = (double)dims.height / (double)iterations;
            boxIndependent = dims.width;
        }
        Rectangle vr = new Rectangle();
        SwingUtilities.calculateInnerArea(this.progressBar, vr);
        int index = this.getAnimationIndex();
        if (this.animationIndex > (this.numFrames + 1) / 2) {
            index = this.numFrames - this.getAnimationIndex();
        }
        if (this.progressBar.getOrientation() == 0) {
            r.x = vr.x + (int)((double)index * boxDependent);
            r.y = vr.y;
            r.width = (int)boxDependent;
            r.height = (int)boxIndependent;
        } else {
            r.x = vr.x;
            r.y = vr.height - (int)((double)(++index) * boxDependent) + vr.y;
            r.width = (int)boxIndependent;
            r.height = (int)boxDependent;
        }
        return r;
    }

    protected int getCellLength() {
        return this.cellLength;
    }

    protected int getCellSpacing() {
        return this.cellSpacing;
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    protected Dimension getPreferredInnerHorizontal() {
        Rectangle vr = new Rectangle();
        SwingUtilities.calculateInnerArea(this.progressBar, vr);
        return new Dimension(vr.width, vr.height);
    }

    protected Dimension getPreferredInnerVertical() {
        Rectangle vr = new Rectangle();
        SwingUtilities.calculateInnerArea(this.progressBar, vr);
        return new Dimension(vr.width, vr.height);
    }

    public Dimension getPreferredSize(JComponent c) {
        Graphics g = this.progressBar.getGraphics();
        Insets insets = c.getInsets();
        FontMetrics fm = g.getFontMetrics(c.getFont());
        int textW = fm.stringWidth(this.progressBar.getString());
        int textH = fm.getHeight();
        g.dispose();
        if (this.progressBar.getOrientation() == 0) {
            if (textH < 20) {
                textH = 20;
            }
            if (textW < 200) {
                textW = 200;
            }
        } else {
            if (textH < 200) {
                textH = 200;
            }
            if (textW < 20) {
                textW = 20;
            }
        }
        return new Dimension(textW += insets.left + insets.right, textH += insets.top + insets.bottom);
    }

    protected Color getSelectionBackground() {
        return this.selectionBackground;
    }

    protected Color getSelectionForeground() {
        return this.selectionForeground;
    }

    protected Point getStringPlacement(Graphics g, String progressString, int x, int y, int width, int height) {
        Rectangle tr = new Rectangle();
        Rectangle vr = new Rectangle(x, y, width, height);
        Rectangle ir = new Rectangle();
        Font f = g.getFont();
        FontMetrics fm = g.getFontMetrics(f);
        SwingUtilities.layoutCompoundLabel(this.progressBar, fm, progressString, null, 0, 0, 0, 0, vr, ir, tr, 0);
        return new Point(tr.x, tr.y);
    }

    public void incrementAnimationIndex() {
        ++this.animationIndex;
        if (this.animationIndex >= this.numFrames) {
            this.animationIndex = 0;
        }
        this.progressBar.repaint();
    }

    public void paint(Graphics g, JComponent c) {
        if (!this.progressBar.isIndeterminate()) {
            this.paintDeterminate(g, c);
        } else {
            this.paintIndeterminate(g, c);
        }
        if (this.progressBar.isBorderPainted()) {
            this.progressBar.getBorder().paintBorder(this.progressBar, g, 0, 0, this.progressBar.getWidth(), this.progressBar.getHeight());
        }
    }

    protected void paintDeterminate(Graphics g, JComponent c) {
        Color saved = g.getColor();
        int space = this.getCellSpacing();
        int len = this.getCellLength();
        int max = this.progressBar.getMaximum();
        int min = this.progressBar.getMinimum();
        int value = this.progressBar.getValue();
        Rectangle vr = new Rectangle();
        SwingUtilities.calculateInnerArea(c, vr);
        Rectangle or = c.getBounds();
        Insets insets = c.getInsets();
        int amountFull = this.getAmountFull(insets, or.width, or.height);
        g.setColor(c.getBackground());
        g.fill3DRect(vr.x, vr.y, vr.width, vr.height, false);
        if (max != min && len != 0 && value > min) {
            int iterations = value / (space + len);
            if (this.progressBar.getOrientation() == 0) {
                double spaceInUnits = (double)space * (double)vr.width / (double)(max - min);
                double lenInUnits = (double)len * (double)vr.width / (double)(max - min);
                double currX = vr.x;
                g.setColor(c.getForeground());
                g.fill3DRect(vr.x, vr.y, amountFull, vr.height, true);
                g.setColor(c.getBackground());
                if (spaceInUnits != 0.0) {
                    for (int i = 0; i < iterations; ++i) {
                        g.fill3DRect((int)(currX += lenInUnits), vr.y, (int)spaceInUnits, vr.height, true);
                        currX += spaceInUnits;
                    }
                }
            } else {
                double currY = vr.y;
                double spaceInUnits = (double)space * (double)vr.height / (double)(max - min);
                double lenInUnits = (double)len * (double)vr.height / (double)(max - min);
                g.setColor(c.getForeground());
                g.fill3DRect(vr.x, vr.y + vr.height - amountFull, vr.width, amountFull, true);
                g.setColor(c.getBackground());
                if (spaceInUnits != 0.0) {
                    for (int i = 0; i < iterations; ++i) {
                        g.fill3DRect(vr.x, (int)(currY -= lenInUnits + spaceInUnits), vr.width, (int)spaceInUnits, true);
                    }
                }
            }
        }
        if (this.progressBar.isStringPainted() && !this.progressBar.getString().equals("")) {
            this.paintString(g, 0, 0, or.width, or.height, amountFull, insets);
        }
        g.setColor(saved);
    }

    protected void paintIndeterminate(Graphics g, JComponent c) {
        Color saved = g.getColor();
        Insets insets = c.getInsets();
        Rectangle or = c.getBounds();
        Rectangle vr = new Rectangle();
        SwingUtilities.calculateInnerArea(c, vr);
        g.setColor(c.getBackground());
        g.fill3DRect(vr.x, vr.y, vr.width, vr.height, false);
        Rectangle box = new Rectangle();
        this.getBox(box);
        g.setColor(c.getForeground());
        g.fill3DRect(box.x, box.y, box.width, box.height, true);
        if (this.progressBar.isStringPainted() && !this.progressBar.getString().equals("")) {
            this.paintString(g, 0, 0, or.width, or.height, this.getAmountFull(insets, or.width, or.height), insets);
        }
        g.setColor(saved);
    }

    protected void paintString(Graphics g, int x, int y, int width, int height, int amountFull, Insets b) {
        Point placement = this.getStringPlacement(g, this.progressBar.getString(), x + b.left, y + b.top, width - b.left - b.right, height - b.top - b.bottom);
        Color saved = g.getColor();
        g.setColor(Color.WHITE);
        FontMetrics fm = g.getFontMetrics(this.progressBar.getFont());
        g.drawString(this.progressBar.getString(), placement.x, placement.y + fm.getAscent());
        g.setColor(saved);
    }

    protected void setAnimationIndex(int newValue) {
        this.animationIndex = newValue <= this.numFrames ? newValue : 0;
        this.progressBar.repaint();
    }

    protected void setCellLength(int cellLen) {
        this.cellLength = cellLen;
    }

    protected void setCellSpacing(int cellSpace) {
        this.cellSpacing = cellSpace;
    }

    protected void startAnimationTimer() {
        if (this.animationTimer != null) {
            this.animationTimer.start();
        }
    }

    protected void stopAnimationTimer() {
        if (this.animationTimer != null) {
            this.animationTimer.stop();
        }
        this.setAnimationIndex(0);
    }

    protected void installDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.progressBar.setFont(defaults.getFont("ProgressBar.font"));
        this.progressBar.setForeground(defaults.getColor("ProgressBar.foreground"));
        this.progressBar.setBackground(defaults.getColor("ProgressBar.background"));
        this.progressBar.setBorder(defaults.getBorder("ProgressBar.border"));
        this.progressBar.setOpaque(true);
        this.selectionForeground = defaults.getColor("ProgressBar.selectionForeground");
        this.selectionBackground = defaults.getColor("ProgressBar.selectionBackground");
        this.cellLength = defaults.getInt("ProgressBar.cellLength");
        this.cellSpacing = defaults.getInt("ProgressBar.cellSpacing");
        int repaintInterval = defaults.getInt("ProgressBar.repaintInterval");
        int cycleTime = defaults.getInt("ProgressBar.cycleTime");
        if (cycleTime % repaintInterval != 0 && cycleTime / repaintInterval % 2 != 0) {
            int div = cycleTime / repaintInterval + 2;
            div /= 2;
            cycleTime = (div *= 2) * repaintInterval;
        }
        this.setAnimationIndex(0);
        this.numFrames = cycleTime / repaintInterval;
        this.animationTimer.setDelay(repaintInterval);
    }

    protected void uninstallDefaults() {
        this.progressBar.setFont(null);
        this.progressBar.setForeground(null);
        this.progressBar.setBackground(null);
        this.selectionForeground = null;
        this.selectionBackground = null;
    }

    protected void installListeners() {
        this.changeListener = new ChangeHandler(this);
        this.propertyListener = new PropertyChangeHandler(this);
        this.animation = new Animator(this);
        this.progressBar.addChangeListener(this.changeListener);
        this.progressBar.addPropertyChangeListener(this.propertyListener);
        this.animationTimer.addActionListener(this.animation);
    }

    protected void uninstallListeners() {
        this.progressBar.removeChangeListener(this.changeListener);
        this.progressBar.removePropertyChangeListener(this.propertyListener);
        this.animationTimer.removeActionListener(this.animation);
        this.changeListener = null;
        this.propertyListener = null;
        this.animation = null;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JProgressBar) {
            this.progressBar = (JProgressBar)c;
            this.animationTimer = new Timer(200, null);
            this.animationTimer.setRepeats(true);
            this.installDefaults();
            this.installListeners();
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.animationTimer = null;
        this.progressBar = null;
    }

    private class Animator
    implements ActionListener {
        private /* synthetic */ BasicProgressBarUI this$0;

        public void actionPerformed(ActionEvent e) {
            this.this$0.incrementAnimationIndex();
        }

        Animator(BasicProgressBarUI this$0) {
            this.this$0 = this$0;
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicProgressBarUI this$0;

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("indeterminate")) {
                if (((Boolean)e.getNewValue()).booleanValue()) {
                    this.this$0.startAnimationTimer();
                } else {
                    this.this$0.stopAnimationTimer();
                }
            } else {
                this.this$0.progressBar.repaint();
            }
        }

        PropertyChangeHandler(BasicProgressBarUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class ChangeHandler
    implements ChangeListener {
        private /* synthetic */ BasicProgressBarUI this$0;

        public void stateChanged(ChangeEvent e) {
            this.this$0.progressBar.repaint();
        }

        ChangeHandler(BasicProgressBarUI this$0) {
            this.this$0 = this$0;
        }
    }
}

