/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;

public class BasicScrollBarUI
extends ScrollBarUI
implements LayoutManager,
SwingConstants {
    protected ArrowButtonListener buttonListener;
    protected ModelListener modelListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ScrollListener scrollListener;
    protected TrackListener trackListener;
    protected JButton decrButton;
    protected JButton incrButton;
    protected static Dimension maximumThumbSize;
    protected static Dimension minimumThumbSize;
    protected Color thumbColor;
    protected Color thumbDarkShadowColor;
    protected Color thumbHighlightColor;
    protected Color thumbLightShadowColor;
    protected Color trackHighlightColor;
    protected Color trackColor;
    protected Rectangle trackRect;
    protected Rectangle thumbRect;
    protected static int DECREASE_HIGHLIGHT;
    protected static int INCREASE_HIGHLIGHT;
    protected static int NO_HIGHLIGHT;
    private static int POSITIVE_SCROLL;
    private static int NEGATIVE_SCROLL;
    private transient Dimension preferredSize;
    protected int trackHighlight;
    protected boolean isDragging;
    protected Timer scrollTimer;
    protected JScrollBar scrollbar;
    private static Icon upIcon;
    private static Icon downIcon;
    private static Icon leftIcon;
    private static Icon rightIcon;

    public void addLayoutComponent(String name, Component child) {
    }

    protected void configureScrollBarColors() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.trackColor = defaults.getColor("ScrollBar.track");
        this.trackHighlightColor = defaults.getColor("ScrollBar.trackHighlight");
        this.thumbColor = defaults.getColor("ScrollBar.thumb");
        this.thumbHighlightColor = defaults.getColor("ScrollBar.thumbHighlight");
        this.thumbDarkShadowColor = defaults.getColor("ScrollBar.thumbDarkShadow");
        this.thumbLightShadowColor = defaults.getColor("ScrollBar.thumbLightShadow");
    }

    protected ArrowButtonListener createArrowButtonListener() {
        return new ArrowButtonListener(this);
    }

    protected JButton createIncreaseButton(int orientation) {
        if (this.incrButton == null) {
            this.incrButton = new JButton();
            this.incrButton.setMargin(new Insets(0, 0, 0, 0));
            this.incrButton.setHorizontalAlignment(0);
            this.incrButton.setHorizontalTextPosition(0);
            this.incrButton.setVerticalAlignment(0);
            this.incrButton.setVerticalTextPosition(0);
        }
        if (orientation == 0) {
            this.incrButton.setIcon(rightIcon);
        } else {
            this.incrButton.setIcon(downIcon);
        }
        return this.incrButton;
    }

    protected JButton createDecreaseButton(int orientation) {
        if (this.decrButton == null) {
            this.decrButton = new JButton();
            this.decrButton.setMargin(new Insets(0, 0, 0, 0));
            this.decrButton.setHorizontalAlignment(0);
            this.decrButton.setHorizontalTextPosition(0);
            this.decrButton.setVerticalAlignment(0);
            this.decrButton.setVerticalTextPosition(0);
        }
        if (orientation == 0) {
            this.decrButton.setIcon(leftIcon);
        } else {
            this.decrButton.setIcon(upIcon);
        }
        return this.decrButton;
    }

    protected ModelListener createModelListener() {
        return new ModelListener(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected ScrollListener createScrollListener() {
        return new ScrollListener(this);
    }

    protected TrackListener createTrackListener() {
        return new TrackListener(this);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicScrollBarUI();
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    protected Dimension getMaximumThumbSize() {
        return maximumThumbSize;
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    protected Dimension getMinimumThumbSize() {
        return minimumThumbSize;
    }

    private void calculatePreferredSize() {
        int width = 0;
        int height = 0;
        if (this.scrollbar.getOrientation() == 0) {
            width = (int)((double)width + this.incrButton.getPreferredSize().getWidth());
            width = (int)((double)width + this.decrButton.getPreferredSize().getWidth());
            width += this.scrollbar.getMaximum() - this.scrollbar.getMinimum();
            height = Math.max(this.incrButton.getPreferredSize().height, this.decrButton.getPreferredSize().height);
            height = Math.max(this.getMinimumThumbSize().height, height);
            height = Math.max(20, height);
            height = Math.min(this.getMaximumThumbSize().height, height);
        } else {
            height = (int)((double)height + this.incrButton.getPreferredSize().getHeight());
            height = (int)((double)height + this.decrButton.getPreferredSize().getHeight());
            height += this.scrollbar.getMaximum() - this.scrollbar.getMinimum();
            width = Math.max(this.incrButton.getPreferredSize().width, this.decrButton.getPreferredSize().width);
            width = Math.max(this.getMinimumThumbSize().width, width);
            width = Math.max(20, width);
            width = Math.min(this.getMaximumThumbSize().width, width);
        }
        Insets insets = this.scrollbar.getInsets();
        this.preferredSize = new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
    }

    public Dimension getPreferredSize(JComponent c) {
        this.calculatePreferredSize();
        return this.preferredSize;
    }

    protected Rectangle getThumbBounds() {
        int max = this.scrollbar.getMaximum();
        int min = this.scrollbar.getMinimum();
        int value = this.scrollbar.getValue();
        int extent = this.scrollbar.getVisibleAmount();
        if (max == min) {
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.y = this.trackRect.y;
            if (this.scrollbar.getOrientation() == 0) {
                this.thumbRect.width = this.getMinimumThumbSize().width;
                this.thumbRect.height = this.trackRect.height;
            } else {
                this.thumbRect.width = this.trackRect.width;
                this.thumbRect.height = this.getMinimumThumbSize().height;
            }
            return this.thumbRect;
        }
        if (this.scrollbar.getOrientation() == 0) {
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.x += (value - min) * this.trackRect.width / (max - min);
            this.thumbRect.y = this.trackRect.y;
            this.thumbRect.width = extent * this.trackRect.width / (max - min);
            this.thumbRect.height = this.trackRect.height;
        } else {
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.y = this.trackRect.y + value * this.trackRect.height / (max - min);
            this.thumbRect.width = this.trackRect.width;
            this.thumbRect.height = extent * this.trackRect.height / (max - min);
        }
        return this.thumbRect;
    }

    protected Rectangle getTrackBounds() {
        SwingUtilities.calculateInnerArea(this.scrollbar, this.trackRect);
        if (this.scrollbar.getOrientation() == 0) {
            this.trackRect.width = (int)((double)this.trackRect.width - this.incrButton.getPreferredSize().getWidth());
            this.trackRect.width = (int)((double)this.trackRect.width - this.decrButton.getPreferredSize().getWidth());
            this.trackRect.x = (int)((double)this.trackRect.x + this.decrButton.getPreferredSize().getWidth());
        } else {
            this.trackRect.height = (int)((double)this.trackRect.height - this.incrButton.getPreferredSize().getHeight());
            this.trackRect.height = (int)((double)this.trackRect.height - this.decrButton.getPreferredSize().getHeight());
            this.trackRect.y = (int)((double)this.trackRect.y + this.incrButton.getPreferredSize().getHeight());
        }
        return this.trackRect;
    }

    protected void installComponents() {
        this.incrButton = this.createIncreaseButton(this.scrollbar.getOrientation());
        this.scrollbar.add(this.incrButton);
        this.decrButton = this.createDecreaseButton(this.scrollbar.getOrientation());
        this.scrollbar.add(this.decrButton);
    }

    protected void installDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.scrollbar.setForeground(defaults.getColor("ScrollBar.foreground"));
        this.scrollbar.setBackground(defaults.getColor("ScrollBar.background"));
        this.scrollbar.setBorder(defaults.getBorder("ScrollBar.border"));
        this.scrollbar.setOpaque(true);
        maximumThumbSize = defaults.getDimension("ScrollBar.maximumThumbSize");
        minimumThumbSize = defaults.getDimension("ScrollBar.minimumThumbSize");
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.scrollListener = this.createScrollListener();
        this.trackListener = this.createTrackListener();
        this.buttonListener = this.createArrowButtonListener();
        this.modelListener = this.createModelListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.scrollbar.addMouseMotionListener(this.trackListener);
        this.scrollbar.addMouseListener(this.trackListener);
        this.incrButton.addMouseListener(this.buttonListener);
        this.decrButton.addMouseListener(this.buttonListener);
        this.scrollbar.addPropertyChangeListener(this.propertyChangeListener);
        this.scrollbar.getModel().addChangeListener(this.modelListener);
        this.scrollTimer.addActionListener(this.scrollListener);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JScrollBar) {
            this.scrollbar = (JScrollBar)c;
            this.trackRect = new Rectangle();
            this.thumbRect = new Rectangle();
            this.scrollTimer = new Timer(200, null);
            this.scrollTimer.setRepeats(true);
            this.installComponents();
            this.installListeners();
            this.installDefaults();
            this.configureScrollBarColors();
            this.calculatePreferredSize();
            this.layoutContainer(this.scrollbar);
        }
    }

    public void layoutContainer(Container scrollbarContainer) {
        if (scrollbarContainer instanceof JScrollBar) {
            if (this.scrollbar.getOrientation() == 0) {
                this.layoutHScrollbar((JScrollBar)scrollbarContainer);
            } else {
                this.layoutVScrollbar((JScrollBar)scrollbarContainer);
            }
        }
    }

    protected void layoutHScrollbar(JScrollBar sb) {
        Rectangle vr = new Rectangle();
        SwingUtilities.calculateInnerArea(this.scrollbar, vr);
        this.getTrackBounds();
        this.getThumbBounds();
        Dimension incrDims = this.incrButton.getPreferredSize();
        Dimension decrDims = this.decrButton.getPreferredSize();
        this.decrButton.setBounds(vr.x, vr.y, decrDims.width, this.trackRect.height);
        this.incrButton.setBounds(this.trackRect.x + this.trackRect.width, vr.y, incrDims.width, this.trackRect.height);
    }

    protected void layoutVScrollbar(JScrollBar sb) {
        Rectangle vr = new Rectangle();
        SwingUtilities.calculateInnerArea(this.scrollbar, vr);
        this.getTrackBounds();
        this.getThumbBounds();
        Dimension incrDims = this.incrButton.getPreferredSize();
        Dimension decrDims = this.decrButton.getPreferredSize();
        this.decrButton.setBounds(vr.x, vr.y, this.trackRect.width, decrDims.height);
        this.incrButton.setBounds(vr.x, this.trackRect.y + this.trackRect.height, this.trackRect.width, incrDims.height);
    }

    public Dimension minimumLayoutSize(Container scrollbarContainer) {
        return this.preferredLayoutSize(scrollbarContainer);
    }

    public void paint(Graphics g, JComponent c) {
        this.layoutContainer(this.scrollbar);
        this.paintTrack(g, c, this.getTrackBounds());
        this.paintThumb(g, c, this.getThumbBounds());
        if (this.trackHighlight == INCREASE_HIGHLIGHT) {
            this.paintIncreaseHighlight(g);
        } else if (this.trackHighlight == DECREASE_HIGHLIGHT) {
            this.paintDecreaseHighlight(g);
        }
    }

    protected void paintDecreaseHighlight(Graphics g) {
        Color saved = g.getColor();
        g.setColor(this.trackHighlightColor);
        if (this.scrollbar.getOrientation() == 0) {
            g.fillRect(this.trackRect.x, this.trackRect.y, this.thumbRect.x - this.trackRect.x, this.trackRect.height);
        } else {
            g.fillRect(this.trackRect.x, this.trackRect.y, this.trackRect.width, this.thumbRect.y - this.trackRect.y);
        }
        g.setColor(saved);
    }

    protected void paintIncreaseHighlight(Graphics g) {
        Color saved = g.getColor();
        g.setColor(this.trackHighlightColor);
        if (this.scrollbar.getOrientation() == 0) {
            g.fillRect(this.thumbRect.x + this.thumbRect.width, this.trackRect.y, this.trackRect.x + this.trackRect.width - this.thumbRect.x - this.thumbRect.width, this.trackRect.height);
        } else {
            g.fillRect(this.trackRect.x, this.thumbRect.y + this.thumbRect.height, this.trackRect.width, this.trackRect.y + this.trackRect.height - this.thumbRect.y - this.thumbRect.height);
        }
        g.setColor(saved);
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        Color saved = g.getColor();
        g.setColor(this.thumbHighlightColor);
        Point x = new Point(thumbBounds.x + 1, thumbBounds.y + 1);
        Point y = new Point(x);
        y.translate(thumbBounds.width - 2, 0);
        Point z = new Point(x);
        z.translate(0, thumbBounds.height - 2);
        Polygon lines = new Polygon(new int[]{x.x, y.x, z.x}, new int[]{x.y, y.y, z.y}, 3);
        g.drawPolygon(lines);
        g.setColor(this.thumbLightShadowColor);
        x = new Point(thumbBounds.x + thumbBounds.width - 1, thumbBounds.y + thumbBounds.height - 1);
        y = new Point(x);
        y.translate(2 - thumbBounds.width, 0);
        z = new Point(x);
        z.translate(0, 2 - thumbBounds.height);
        lines = new Polygon(new int[]{x.x, y.x, z.x}, new int[]{x.y, y.y, z.y}, 3);
        g.drawPolygon(lines);
        g.setColor(this.thumbDarkShadowColor);
        x = new Point(thumbBounds.x + thumbBounds.width, thumbBounds.y + thumbBounds.height);
        y = new Point(x);
        y.translate(-thumbBounds.width, 0);
        z = new Point(x);
        z.translate(0, -thumbBounds.height);
        lines = new Polygon(new int[]{x.x, y.x, z.x}, new int[]{x.y, y.y, z.y}, 3);
        g.drawPolygon(lines);
        g.setColor(this.thumbColor);
        g.fillRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
        g.setColor(saved);
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        Color saved = g.getColor();
        g.setColor(this.trackColor);
        g.fill3DRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, false);
        g.setColor(saved);
    }

    public Dimension preferredLayoutSize(Container scrollbarContainer) {
        if (scrollbarContainer instanceof JComponent) {
            return this.getPreferredSize((JComponent)scrollbarContainer);
        }
        return null;
    }

    public void removeLayoutComponent(Component child) {
    }

    protected void scrollByBlock(int direction) {
        this.scrollbar.setValue(this.scrollbar.getValue() + this.scrollbar.getBlockIncrement(direction));
    }

    protected void scrollByUnit(int direction) {
        this.scrollbar.setValue(this.scrollbar.getValue() + this.scrollbar.getUnitIncrement(direction));
    }

    protected void setThumbBounds(int x, int y, int width, int height) {
        this.thumbRect.x = x;
        this.thumbRect.y = y;
        this.thumbRect.width = width;
        this.thumbRect.height = height;
    }

    protected void uninstallComponents() {
        this.scrollbar.remove(this.incrButton);
        this.scrollbar.remove(this.decrButton);
        this.incrButton = null;
        this.decrButton = null;
    }

    protected void uninstallDefaults() {
        this.scrollbar.setForeground(null);
        this.scrollbar.setBackground(null);
        this.scrollbar.setBorder(null);
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.scrollTimer.removeActionListener(this.scrollListener);
        this.scrollbar.getModel().removeChangeListener(this.modelListener);
        this.scrollbar.removePropertyChangeListener(this.propertyChangeListener);
        this.decrButton.removeMouseListener(this.buttonListener);
        this.incrButton.removeMouseListener(this.buttonListener);
        this.scrollbar.removeMouseListener(this.trackListener);
        this.scrollbar.removeMouseMotionListener(this.trackListener);
        this.propertyChangeListener = null;
        this.modelListener = null;
        this.buttonListener = null;
        this.trackListener = null;
        this.scrollListener = null;
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallComponents();
        this.scrollTimer = null;
        this.thumbRect = null;
        this.trackRect = null;
        this.trackColor = null;
        this.trackHighlightColor = null;
        this.thumbColor = null;
        this.thumbHighlightColor = null;
        this.thumbDarkShadowColor = null;
        this.thumbLightShadowColor = null;
        this.scrollbar = null;
    }

    private int valueForYPosition(int yPos) {
        int min = this.scrollbar.getMinimum();
        int max = this.scrollbar.getMaximum();
        int len = this.trackRect.height;
        if (len == 0) {
            return (max - min) / 2;
        }
        int value = (yPos - this.trackRect.y) * (max - min) / len + min;
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    private int valueForXPosition(int xPos) {
        int min = this.scrollbar.getMinimum();
        int max = this.scrollbar.getMaximum();
        int len = this.trackRect.width;
        if (len == 0) {
            return (max - min) / 2;
        }
        int value = (xPos - this.trackRect.x) * (max - min) / len + min;
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    static {
        DECREASE_HIGHLIGHT = 1;
        INCREASE_HIGHLIGHT = 2;
        NO_HIGHLIGHT = 0;
        POSITIVE_SCROLL = 1;
        NEGATIVE_SCROLL = -1;
        upIcon = new arrowIcon(new Polygon(new int[]{2, 5, 8}, new int[]{7, 3, 7}, 3));
        downIcon = new arrowIcon(new Polygon(new int[]{2, 5, 8}, new int[]{3, 7, 3}, 3));
        leftIcon = new arrowIcon(new Polygon(new int[]{7, 3, 7}, new int[]{2, 5, 8}, 3));
        rightIcon = new arrowIcon(new Polygon(new int[]{3, 7, 3}, new int[]{2, 5, 8}, 3));
    }

    private static class arrowIcon
    implements Icon {
        private Polygon arrow;

        public arrowIcon(Polygon arrow) {
            this.arrow = arrow;
        }

        public int getIconHeight() {
            return 10;
        }

        public int getIconWidth() {
            return 10;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            Color saved = g.getColor();
            g.setColor(Color.BLACK);
            g.fillPolygon(this.arrow);
            g.setColor(saved);
            g.translate(-x, -y);
        }
    }

    protected class TrackListener
    extends MouseAdapter
    implements MouseMotionListener {
        private /* synthetic */ BasicScrollBarUI this$0;
        protected int currentMouseX;
        protected int currentMouseY;
        protected int offset;

        public void mouseDragged(MouseEvent e) {
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (this.this$0.scrollbar.getValueIsAdjusting()) {
                int value = this.this$0.scrollbar.getOrientation() == 0 ? this.this$0.valueForXPosition(this.currentMouseX) - this.offset : this.this$0.valueForYPosition(this.currentMouseY) - this.offset;
                this.this$0.scrollbar.setValue(value);
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            int value = this.this$0.scrollbar.getOrientation() == 0 ? this.this$0.valueForXPosition(this.currentMouseX) : this.this$0.valueForYPosition(this.currentMouseY);
            if (value == this.this$0.scrollbar.getValue()) {
                return;
            }
            if (!this.this$0.thumbRect.contains(e.getPoint())) {
                this.this$0.scrollTimer.stop();
                this.this$0.scrollListener.setScrollByBlock(true);
                if (value > this.this$0.scrollbar.getValue()) {
                    this.this$0.trackHighlight = INCREASE_HIGHLIGHT;
                    this.this$0.scrollListener.setDirection(POSITIVE_SCROLL);
                } else {
                    this.this$0.trackHighlight = DECREASE_HIGHLIGHT;
                    this.this$0.scrollListener.setDirection(NEGATIVE_SCROLL);
                }
                this.this$0.scrollTimer.start();
            } else {
                this.this$0.scrollbar.setValueIsAdjusting(true);
                this.offset = value - this.this$0.scrollbar.getValue();
            }
            this.this$0.scrollbar.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            this.this$0.trackHighlight = NO_HIGHLIGHT;
            this.this$0.scrollTimer.stop();
            if (this.this$0.scrollbar.getValueIsAdjusting()) {
                this.this$0.scrollbar.setValueIsAdjusting(false);
            }
            this.this$0.scrollbar.repaint();
        }

        public boolean shouldScroll(int direction) {
            int value = this.this$0.scrollbar.getOrientation() == 0 ? this.this$0.valueForXPosition(this.currentMouseX) : this.this$0.valueForYPosition(this.currentMouseY);
            if (direction == POSITIVE_SCROLL) {
                return value > this.this$0.scrollbar.getValue();
            }
            return value < this.this$0.scrollbar.getValue();
        }

        TrackListener(BasicScrollBarUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class ScrollListener
    implements ActionListener {
        private /* synthetic */ BasicScrollBarUI this$0;
        private transient int direction;
        private transient boolean block;

        public ScrollListener(BasicScrollBarUI this$0) {
            this.this$0 = this$0;
            this.direction = POSITIVE_SCROLL;
            this.block = true;
        }

        public ScrollListener(BasicScrollBarUI this$0, int dir, boolean block) {
            this.this$0 = this$0;
            this.direction = dir;
            this.block = block;
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public void setScrollByBlock(boolean block) {
            this.block = block;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.block) {
                if (!this.this$0.trackListener.shouldScroll(this.direction)) {
                    this.this$0.trackHighlight = NO_HIGHLIGHT;
                    this.this$0.scrollbar.repaint();
                    return;
                }
                this.this$0.scrollByBlock(this.direction);
            } else {
                this.this$0.scrollByUnit(this.direction);
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicScrollBarUI this$0;

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("model")) {
                ((BoundedRangeModel)e.getOldValue()).removeChangeListener(this.this$0.modelListener);
                this.this$0.scrollbar.getModel().addChangeListener(this.this$0.modelListener);
                this.this$0.getThumbBounds();
            } else if (e.getPropertyName().equals("orientation")) {
                this.this$0.incrButton.removeMouseListener(this.this$0.buttonListener);
                this.this$0.decrButton.removeMouseListener(this.this$0.buttonListener);
                this.this$0.incrButton = this.this$0.createIncreaseButton(this.this$0.scrollbar.getOrientation());
                this.this$0.decrButton = this.this$0.createDecreaseButton(this.this$0.scrollbar.getOrientation());
                this.this$0.incrButton.addMouseListener(this.this$0.buttonListener);
                this.this$0.decrButton.addMouseListener(this.this$0.buttonListener);
                this.this$0.calculatePreferredSize();
                this.this$0.layoutContainer(this.this$0.scrollbar);
            }
            this.this$0.layoutContainer(this.this$0.scrollbar);
            this.this$0.scrollbar.repaint();
        }

        public PropertyChangeHandler(BasicScrollBarUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class ModelListener
    implements ChangeListener {
        private /* synthetic */ BasicScrollBarUI this$0;

        public void stateChanged(ChangeEvent e) {
            this.this$0.calculatePreferredSize();
            this.this$0.layoutContainer(this.this$0.scrollbar);
            this.this$0.getThumbBounds();
            this.this$0.scrollbar.repaint();
        }

        ModelListener(BasicScrollBarUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class ArrowButtonListener
    extends MouseAdapter {
        private /* synthetic */ BasicScrollBarUI this$0;

        public void mousePressed(MouseEvent e) {
            this.this$0.scrollTimer.stop();
            this.this$0.scrollListener.setScrollByBlock(false);
            if (e.getSource() == this.this$0.incrButton) {
                this.this$0.scrollListener.setDirection(POSITIVE_SCROLL);
            } else {
                this.this$0.scrollListener.setDirection(NEGATIVE_SCROLL);
            }
            this.this$0.scrollTimer.start();
        }

        public void mouseReleased(MouseEvent e) {
            this.this$0.scrollTimer.stop();
        }

        ArrowButtonListener(BasicScrollBarUI this$0) {
            this.this$0 = this$0;
        }
    }
}

