/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.ScrollPaneLayout;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollPaneUI;

public class BasicScrollPaneUI
extends ScrollPaneUI
implements ScrollPaneConstants {
    public static ComponentUI createUI(JComponent c) {
        return new BasicScrollPaneUI();
    }

    protected void installDefaults(JScrollPane p) {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        p.setForeground(defaults.getColor("ScrollPane.foreground"));
        p.setBackground(defaults.getColor("ScrollPane.background"));
        p.setFont(defaults.getFont("ScrollPane.font"));
        p.setBorder(defaults.getBorder("ScrollPane.border"));
        p.setOpaque(true);
    }

    protected void uninstallDefaults(JScrollPane p) {
        p.setForeground(null);
        p.setBackground(null);
        p.setFont(null);
        p.setBorder(null);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.installDefaults((JScrollPane)c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallDefaults((JScrollPane)c);
    }

    public Dimension getMinimumSize(JComponent c) {
        JScrollPane p = (JScrollPane)c;
        ScrollPaneLayout sl = (ScrollPaneLayout)p.getLayout();
        return sl.minimumLayoutSize(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        JScrollPane p = (JScrollPane)c;
        ScrollPaneLayout sl = (ScrollPaneLayout)p.getLayout();
        return sl.preferredLayoutSize(c);
    }

    public void paint(Graphics g, JComponent c) {
    }
}

