/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SeparatorUI;

public class BasicSeparatorUI
extends SeparatorUI {
    protected Color shadow;
    protected Color highlight;

    public static ComponentUI createUI(JComponent c) {
        return new BasicSeparatorUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JSeparator) {
            JSeparator s = (JSeparator)c;
            this.installDefaults(s);
            this.installListeners(s);
        }
    }

    public void uninstallUI(JComponent c) {
        if (c instanceof JSeparator) {
            JSeparator s = (JSeparator)c;
            this.uninstallListeners(s);
            this.uninstallDefaults(s);
        }
    }

    protected void installDefaults(JSeparator s) {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.shadow = defaults.getColor("Separator.shadow");
        this.highlight = defaults.getColor("Separator.highlight");
        s.setOpaque(true);
    }

    protected void uninstallDefaults(JSeparator s) {
        this.shadow = null;
        this.highlight = null;
    }

    protected void installListeners(JSeparator s) {
    }

    protected void uninstallListeners(JSeparator s) {
    }

    public void paint(Graphics g, JComponent c) {
        Rectangle r = new Rectangle();
        SwingUtilities.calculateInnerArea(c, r);
        Color saved = g.getColor();
        int midAB = r.width / 2 + r.x;
        int midAD = r.height / 2 + r.y;
        if (!(c instanceof JSeparator)) {
            return;
        }
        JSeparator s = (JSeparator)c;
        if (s.getOrientation() == 0) {
            g.setColor(this.highlight);
            g.drawLine(r.x, midAD, r.x + r.width, midAD);
            g.setColor(this.shadow);
            g.drawLine(r.x, midAD + 1, r.x + r.width, midAD + 1);
        } else {
            g.setColor(this.highlight);
            g.drawLine(midAB, r.y, midAB, r.y + r.height);
            g.setColor(this.shadow);
            g.drawLine(midAB + 1, r.y, midAB + 1, r.y + r.height);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension dims = new Dimension(0, 0);
        Insets insets = c.getInsets();
        if (c instanceof JSeparator) {
            JSeparator s = (JSeparator)c;
            if (s.getOrientation() == 0) {
                dims.height = 2;
                dims.width = 40;
            } else {
                dims.width = 2;
                dims.height = 40;
            }
        }
        dims.width += insets.left + insets.right;
        dims.height += insets.top + insets.bottom;
        return dims;
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }
}

