/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class BasicSplitPaneDivider
extends Container
implements PropertyChangeListener {
    static final long serialVersionUID = 1463404307042803342L;
    protected static final int ONE_TOUCH_SIZE = 6;
    protected static final int ONE_TOUCH_OFFSET = 2;
    protected DragController dragger;
    protected BasicSplitPaneUI splitPaneUI;
    protected int dividerSize;
    protected Component hiddenDivider;
    protected JSplitPane splitPane;
    protected MouseHandler mouseHandler;
    protected int orientation;
    protected JButton leftButton;
    protected JButton rightButton;
    private Border border;
    private transient int currentDividerLocation;
    private transient Border tmpBorder;

    private /* synthetic */ void finit$() {
        this.mouseHandler = new MouseHandler(this);
        this.currentDividerLocation = 1;
        this.tmpBorder = new Border(this){
            private /* synthetic */ BasicSplitPaneDivider this$0;
            {
                this.this$0 = this$0;
            }

            public Insets getBorderInsets(Component c) {
                return new Insets(2, 2, 2, 2);
            }

            public boolean isBorderOpaque() {
                return false;
            }

            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Color saved = g.getColor();
                g.setColor(Color.BLACK);
                g.drawRect(x + 2, y + 2, width - 4, height - 4);
                g.setColor(saved);
            }
        };
    }

    public BasicSplitPaneDivider(BasicSplitPaneUI ui) {
        this.finit$();
        this.setLayout(new DividerLayout(this));
        this.setBasicSplitPaneUI(ui);
        this.setDividerSize(this.splitPane.getDividerSize());
        this.setBorder(this.tmpBorder);
    }

    public void setBasicSplitPaneUI(BasicSplitPaneUI newUI) {
        if (this.splitPane != null) {
            this.splitPane.removePropertyChangeListener(this);
            this.splitPane.removeMouseListener(this.mouseHandler);
            this.splitPane.removeMouseMotionListener(this.mouseHandler);
            this.removeMouseListener(this.mouseHandler);
            this.removeMouseMotionListener(this.mouseHandler);
            this.splitPane = null;
            this.hiddenDivider = null;
        }
        this.splitPaneUI = newUI;
        if (this.splitPaneUI != null) {
            this.splitPane = newUI.getSplitPane();
        }
        if (this.splitPane != null) {
            this.splitPane.addPropertyChangeListener(this);
            this.splitPane.addMouseListener(this.mouseHandler);
            this.splitPane.addMouseMotionListener(this.mouseHandler);
            this.addMouseListener(this.mouseHandler);
            this.addMouseMotionListener(this.mouseHandler);
            this.hiddenDivider = this.splitPaneUI.getNonContinuousLayoutDivider();
            this.orientation = this.splitPane.getOrientation();
            this.oneTouchExpandableChanged();
        }
    }

    public BasicSplitPaneUI getBasicSplitPaneUI() {
        return this.splitPaneUI;
    }

    public void setDividerSize(int newSize) {
        this.dividerSize = newSize;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setBorder(Border border) {
        if (border != this.border) {
            Border oldValue = this.border;
            this.border = border;
            this.firePropertyChange("border", oldValue, border);
        }
    }

    public Border getBorder() {
        return this.border;
    }

    public Insets getInsets() {
        if (this.border != null) {
            return this.border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("oneTouchExpandable")) {
            this.oneTouchExpandableChanged();
        } else if (e.getPropertyName().equals("orientation")) {
            this.orientation = this.splitPane.getOrientation();
            if (this.splitPane.isOneTouchExpandable()) {
                this.layout();
                this.repaint();
            }
        } else if (e.getPropertyName().equals("dividerSize")) {
            this.dividerSize = this.splitPane.getDividerSize();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.border != null) {
            Dimension dividerSize = this.getSize();
            this.border.paintBorder(this, g, 0, 0, dividerSize.width, dividerSize.height);
        }
    }

    protected void oneTouchExpandableChanged() {
        if (this.splitPane.isOneTouchExpandable()) {
            this.leftButton = this.createLeftOneTouchButton();
            this.rightButton = this.createRightOneTouchButton();
            this.add(this.leftButton);
            this.add(this.rightButton);
            this.leftButton.addMouseListener(this.mouseHandler);
            this.rightButton.addMouseListener(this.mouseHandler);
            this.currentDividerLocation = 1;
        } else if (this.leftButton != null && this.rightButton != null) {
            this.leftButton.removeMouseListener(this.mouseHandler);
            this.rightButton.removeMouseListener(this.mouseHandler);
            this.remove(this.leftButton);
            this.remove(this.rightButton);
            this.leftButton = null;
            this.rightButton = null;
        }
        this.layout();
        this.repaint();
    }

    protected JButton createLeftOneTouchButton() {
        int dir = 7;
        if (this.orientation == 0) {
            dir = 1;
        }
        BasicArrowButton button = new BasicArrowButton(dir);
        button.setBorderPainted(false);
        return button;
    }

    protected JButton createRightOneTouchButton() {
        int dir = 3;
        if (this.orientation == 0) {
            dir = 5;
        }
        BasicArrowButton button = new BasicArrowButton(dir);
        button.setBorderPainted(false);
        return button;
    }

    protected void prepareForDragging() {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.startDragging();
        }
    }

    protected void dragDividerTo(int location) {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.dragDividerTo(location);
        }
    }

    protected void finishDraggingTo(int location) {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.finishDraggingTo(location);
        }
    }

    private void moveDividerTo(int locationIndex) {
        Insets insets = this.splitPane.getInsets();
        switch (locationIndex) {
            case 1: {
                this.splitPane.setDividerLocation(this.splitPane.getLastDividerLocation());
                break;
            }
            case 0: {
                int top = this.orientation == 1 ? insets.left : insets.top;
                this.splitPane.setDividerLocation(top);
                break;
            }
            case 2: {
                int bottom = this.orientation == 1 ? this.splitPane.getBounds().width - insets.right - this.dividerSize : this.splitPane.getBounds().height - insets.bottom - this.dividerSize;
                this.splitPane.setDividerLocation(bottom);
            }
        }
    }

    protected class DividerLayout
    implements LayoutManager {
        private /* synthetic */ BasicSplitPaneDivider this$0;

        protected DividerLayout(BasicSplitPaneDivider this$0) {
            this.this$0 = this$0;
        }

        public void addLayoutComponent(String string, Component c) {
        }

        public void layoutContainer(Container c) {
            if (this.this$0.splitPane.isOneTouchExpandable()) {
                this.changeButtonOrientation();
                this.positionButtons();
            }
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(this.this$0.dividerSize, this.this$0.dividerSize);
        }

        public void removeLayoutComponent(Component c) {
        }

        private void changeButtonOrientation() {
            if (this.this$0.orientation == 1) {
                ((BasicArrowButton)this.this$0.rightButton).setDirection(3);
                ((BasicArrowButton)this.this$0.leftButton).setDirection(7);
            } else {
                ((BasicArrowButton)this.this$0.rightButton).setDirection(5);
                ((BasicArrowButton)this.this$0.leftButton).setDirection(1);
            }
        }

        private void positionButtons() {
            int w = 0;
            int h = 0;
            if (this.this$0.orientation == 1) {
                this.this$0.rightButton.setLocation(2, 2);
                this.this$0.leftButton.setLocation(2, 14);
                w = this.this$0.dividerSize - 4;
                h = 12;
            } else {
                this.this$0.leftButton.setLocation(2, 2);
                this.this$0.rightButton.setLocation(14, 2);
                h = this.this$0.dividerSize - 4;
                w = 12;
            }
            Dimension dims = new Dimension(w, h);
            this.this$0.leftButton.setSize(dims);
            this.this$0.rightButton.setSize(dims);
        }
    }

    protected class VerticalDragController
    extends DragController {
        private /* synthetic */ BasicSplitPaneDivider this$0;

        protected VerticalDragController(BasicSplitPaneDivider this$0, MouseEvent e) {
            this.this$0 = this$0;
            super(this$0, e);
            this.offset = e.getY();
        }

        protected int getNeededLocation(int x, int y) {
            return y;
        }

        protected int positionForMouseEvent(MouseEvent e) {
            return e.getY() + this.this$0.getY() - this.offset;
        }

        int adjust(int x, int y) {
            return this.getNeededLocation(x, y) + this.this$0.getY() - this.offset;
        }
    }

    protected class DragController {
        private /* synthetic */ BasicSplitPaneDivider this$0;
        transient int offset;

        protected DragController(BasicSplitPaneDivider this$0, MouseEvent e) {
            this.this$0 = this$0;
            this.offset = e.getX();
        }

        protected boolean isValid() {
            return true;
        }

        protected int positionForMouseEvent(MouseEvent e) {
            return e.getX() + this.this$0.getX() - this.offset;
        }

        protected int getNeededLocation(int x, int y) {
            return x;
        }

        protected void continueDrag(int newX, int newY) {
            if (this.isValid()) {
                this.this$0.dragDividerTo(this.adjust(newX, newY));
            }
        }

        protected void continueDrag(MouseEvent e) {
            if (this.isValid()) {
                this.this$0.dragDividerTo(this.positionForMouseEvent(e));
            }
        }

        protected void completeDrag(int x, int y) {
            this.this$0.finishDraggingTo(this.adjust(x, y));
        }

        protected void completeDrag(MouseEvent e) {
            this.this$0.finishDraggingTo(this.positionForMouseEvent(e));
        }

        int adjust(int x, int y) {
            return this.getNeededLocation(x, y) + this.this$0.getX() - this.offset;
        }
    }

    protected class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private /* synthetic */ BasicSplitPaneDivider this$0;
        private transient boolean isDragging;

        public void mousePressed(MouseEvent e) {
            if (this.this$0.splitPane.isOneTouchExpandable()) {
                if (e.getSource() == this.this$0.leftButton) {
                    this.this$0.currentDividerLocation = this.this$0.currentDividerLocation + 1;
                    if (this.this$0.currentDividerLocation < 0) {
                        this.this$0.currentDividerLocation = 0;
                    }
                    this.this$0.moveDividerTo(this.this$0.currentDividerLocation);
                    return;
                }
                if (e.getSource() == this.this$0.rightButton) {
                    this.this$0.currentDividerLocation = this.this$0.currentDividerLocation + 1;
                    if (this.this$0.currentDividerLocation > 2) {
                        this.this$0.currentDividerLocation = 2;
                    }
                    this.this$0.moveDividerTo(this.this$0.currentDividerLocation);
                    return;
                }
            }
            this.isDragging = true;
            this.this$0.currentDividerLocation = 1;
            this.this$0.dragger = this.this$0.orientation == 1 ? new DragController(this.this$0, e) : new VerticalDragController(this.this$0, e);
            this.this$0.prepareForDragging();
        }

        public void mouseReleased(MouseEvent e) {
            if (this.isDragging) {
                this.this$0.dragger.completeDrag(e);
            }
            this.isDragging = false;
        }

        public void mouseDragged(MouseEvent e) {
            if (this.this$0.dragger != null) {
                this.this$0.dragger.continueDrag(e);
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        MouseHandler(BasicSplitPaneDivider this$0) {
            this.this$0 = this$0;
        }
    }
}

