/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicPanelUI;
import javax.swing.text.View;

public class BasicTabbedPaneUI
extends TabbedPaneUI
implements SwingConstants {
    private transient ScrollingButton incrButton;
    private transient ScrollingButton decrButton;
    private transient ScrollingViewport viewport;
    private transient ScrollingPanel panel;
    private transient int currentScrollLocation;
    protected Rectangle calcRect;
    protected Rectangle[] rects;
    protected Insets contentBorderInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets tabInsets;
    protected Color darkShadow;
    protected Color focus;
    protected Color highlight;
    protected Color lightHighlight;
    protected Color shadow;
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected int runCount;
    protected int selectedRun;
    protected int tabRunOverlay;
    protected int textIconGap;
    protected int[] tabRuns;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected KeyStroke upKey;
    protected FocusListener focusListener;
    protected MouseListener mouseListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ChangeListener tabChangeListener;
    protected JTabbedPane tabPane;
    private transient LayoutManager layoutManager;
    private transient Rectangle tabAreaRect;
    private transient Rectangle contentRect;

    static /* synthetic */ ScrollingPanel access$9(BasicTabbedPaneUI inst$, ScrollingPanel write_parm_value$) {
        inst$.panel = write_parm_value$;
        return inst$.panel;
    }

    static /* synthetic */ ScrollingViewport access$6(BasicTabbedPaneUI inst$, ScrollingViewport write_parm_value$) {
        inst$.viewport = write_parm_value$;
        return inst$.viewport;
    }

    static /* synthetic */ Rectangle access$3(BasicTabbedPaneUI inst$, Rectangle write_parm_value$) {
        inst$.contentRect = write_parm_value$;
        return inst$.contentRect;
    }

    static /* synthetic */ Rectangle access$2(BasicTabbedPaneUI inst$, Rectangle write_parm_value$) {
        inst$.tabAreaRect = write_parm_value$;
        return inst$.tabAreaRect;
    }

    private ScrollingButton createIncreaseButton() {
        if (this.incrButton == null) {
            this.incrButton = new ScrollingButton(1);
        }
        if (this.tabPane.getTabPlacement() == 1 || this.tabPane.getTabPlacement() == 3) {
            this.incrButton.setDirection(3);
        } else {
            this.incrButton.setDirection(5);
        }
        return this.incrButton;
    }

    private ScrollingButton createDecreaseButton() {
        if (this.decrButton == null) {
            this.decrButton = new ScrollingButton(5);
        }
        if (this.tabPane.getTabPlacement() == 1 || this.tabPane.getTabPlacement() == 3) {
            this.decrButton.setDirection(7);
        } else {
            this.decrButton.setDirection(1);
        }
        return this.decrButton;
    }

    private Point findPointForIndex(int index) {
        int tabPlacement = this.tabPane.getTabPlacement();
        int selectedIndex = this.tabPane.getSelectedIndex();
        Insets insets = this.getSelectedTabPadInsets(tabPlacement);
        int w = 0;
        int h = 0;
        if (tabPlacement == 1 || tabPlacement == 3) {
            if (index > 0) {
                w += this.rects[index - 1].x + this.rects[index - 1].width;
                if (index > selectedIndex) {
                    w -= insets.left + insets.right;
                }
            }
        } else if (index > 0) {
            h += this.rects[index - 1].y + this.rects[index - 1].height;
            if (index > selectedIndex) {
                h -= insets.top + insets.bottom;
            }
        }
        Point p = new Point(w, h);
        return p;
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicTabbedPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JTabbedPane) {
            this.tabPane = (JTabbedPane)c;
            this.installComponents();
            this.installDefaults();
            this.installListeners();
            this.installKeyboardActions();
            this.layoutManager = this.createLayoutManager();
            this.tabPane.setLayout(this.layoutManager);
            this.tabPane.layout();
        }
    }

    public void uninstallUI(JComponent c) {
        this.layoutManager = null;
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.tabPane = null;
    }

    public LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            return new TabbedPaneLayout(this);
        }
        this.incrButton = this.createIncreaseButton();
        this.decrButton = this.createDecreaseButton();
        this.viewport = new ScrollingViewport(this);
        this.panel = new ScrollingPanel(this);
        this.viewport.setView(this.panel);
        this.tabPane.add(this.incrButton);
        this.tabPane.add(this.decrButton);
        this.tabPane.add(this.viewport);
        this.currentScrollLocation = 0;
        this.decrButton.setEnabled(false);
        this.panel.addMouseListener(this.mouseListener);
        this.incrButton.addMouseListener(this.mouseListener);
        this.decrButton.addMouseListener(this.mouseListener);
        this.viewport.setBackground(Color.LIGHT_GRAY);
        return new TabbedPaneScrollLayout(this);
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.tabPane.setFont(defaults.getFont("TabbedPane.font"));
        this.tabPane.setForeground(defaults.getColor("TabbedPane.foreground"));
        this.tabPane.setBackground(defaults.getColor("TabbedPane.background"));
        this.tabPane.setOpaque(true);
        this.highlight = defaults.getColor("TabbedPane.highlight");
        this.lightHighlight = defaults.getColor("TabbedPane.lightHighlight");
        this.shadow = defaults.getColor("TabbedPane.shadow");
        this.darkShadow = defaults.getColor("TabbedPane.darkShadow");
        this.focus = defaults.getColor("TabbedPane.focus");
        this.textIconGap = defaults.getInt("TabbedPane.textIconGap");
        this.tabRunOverlay = defaults.getInt("TabbedPane.tabRunOverlay");
        this.tabInsets = defaults.getInsets("TabbedPane.tabbedPaneTabInsets");
        this.selectedTabPadInsets = defaults.getInsets("TabbedPane.tabbedPaneTabPadInsets");
        this.tabAreaInsets = defaults.getInsets("TabbedPane.tabbedPaneTabAreaInsets");
        this.contentBorderInsets = defaults.getInsets("TabbedPane.tabbedPaneContentBorderInsets");
        this.calcRect = new Rectangle();
        this.tabRuns = new int[10];
        this.tabAreaRect = new Rectangle();
        this.contentRect = new Rectangle();
    }

    protected void uninstallDefaults() {
        this.calcRect = null;
        this.tabAreaRect = null;
        this.contentRect = null;
        this.tabRuns = null;
        this.contentBorderInsets = null;
        this.tabAreaInsets = null;
        this.selectedTabPadInsets = null;
        this.tabInsets = null;
        this.focus = null;
        this.darkShadow = null;
        this.shadow = null;
        this.lightHighlight = null;
        this.highlight = null;
        this.tabPane.setBackground(null);
        this.tabPane.setForeground(null);
        this.tabPane.setFont(null);
    }

    protected void installListeners() {
        this.mouseListener = this.createMouseListener();
        this.tabChangeListener = this.createChangeListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.focusListener = this.createFocusListener();
        this.tabPane.addMouseListener(this.mouseListener);
        this.tabPane.addChangeListener(this.tabChangeListener);
        this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        this.tabPane.addFocusListener(this.focusListener);
    }

    protected void uninstallListeners() {
        this.tabPane.removeFocusListener(this.focusListener);
        this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
        this.tabPane.removeChangeListener(this.tabChangeListener);
        this.tabPane.removeMouseListener(this.mouseListener);
        this.focusListener = null;
        this.propertyChangeListener = null;
        this.tabChangeListener = null;
        this.mouseListener = null;
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler(this);
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.layoutManager.preferredLayoutSize(this.tabPane);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.layoutManager.minimumLayoutSize(this.tabPane);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public void paint(Graphics g, JComponent c) {
        if (this.tabPane.getTabCount() == 0) {
            return;
        }
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            this.paintTabArea(g, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex());
        }
        this.paintContentBorder(g, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex());
    }

    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        Rectangle ir = new Rectangle();
        Rectangle tr = new Rectangle();
        int tabCount = this.tabPane.getTabCount();
        int currRun = 1;
        if (tabCount < 1) {
            return;
        }
        if (this.runCount > 1) {
            currRun = 0;
        }
        for (int i = 0; i < this.runCount; ++i) {
            int first = this.lastTabInRun(tabCount, this.getPreviousTabRun(currRun)) + 1;
            if (first == tabCount) {
                first = 0;
            }
            int last = this.lastTabInRun(tabCount, currRun);
            for (int j = first; j <= last; ++j) {
                if (j == selectedIndex) continue;
                this.paintTab(g, tabPlacement, this.rects, j, ir, tr);
            }
            currRun = this.getNextTabRun(currRun);
        }
        this.paintTab(g, tabPlacement, this.rects, selectedIndex, ir, tr);
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        FontMetrics fm = this.getFontMetrics();
        Icon icon = this.getIconForTab(tabIndex);
        String title = this.tabPane.getTitleAt(tabIndex);
        boolean isSelected = tabIndex == this.tabPane.getSelectedIndex();
        this.calcRect = this.getTabBounds(this.tabPane, tabIndex);
        int x = this.calcRect.x;
        int y = this.calcRect.y;
        int w = this.calcRect.width;
        int h = this.calcRect.height;
        if (this.getRunForTab(this.tabPane.getTabCount(), tabIndex) == 1) {
            Insets insets = this.getTabAreaInsets(tabPlacement);
            switch (tabPlacement) {
                case 1: {
                    h += insets.bottom;
                    break;
                }
                case 2: {
                    w += insets.right;
                    break;
                }
                case 3: {
                    y -= insets.top;
                    h += insets.top;
                    break;
                }
                case 4: {
                    x -= insets.left;
                    w += insets.left;
                }
            }
        }
        this.layoutLabel(tabPlacement, fm, tabIndex, title, icon, this.calcRect, iconRect, textRect, isSelected);
        this.paintTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
        this.paintTabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
        if (icon != null) {
            this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        }
        if (title != null && !title.equals("")) {
            this.paintText(g, tabPlacement, this.tabPane.getFont(), fm, tabIndex, title, textRect, isSelected);
        }
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        SwingUtilities.layoutCompoundLabel(metrics, title, icon, 0, 0, 0, 0, tabRect, iconRect, textRect, this.textIconGap);
        int shiftX = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int shiftY = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += shiftX;
        iconRect.y += shiftY;
        textRect.x += shiftX;
        textRect.y += shiftY;
    }

    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        icon.paintIcon(this.tabPane, g, iconRect.x, iconRect.y);
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Color bg;
        View textView = this.getTextViewForTab(tabIndex);
        if (textView != null) {
            textView.paint(g, textRect);
            return;
        }
        Color fg = this.tabPane.getForegroundAt(tabIndex);
        if (fg == null) {
            fg = this.tabPane.getForeground();
        }
        if ((bg = this.tabPane.getBackgroundAt(tabIndex)) == null) {
            bg = this.tabPane.getBackground();
        }
        Color saved_color = g.getColor();
        Font f = g.getFont();
        g.setFont(font);
        if (this.tabPane.isEnabledAt(tabIndex)) {
            g.setColor(fg);
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (mnemIndex != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.drawString(title, textRect.x, textRect.y + metrics.getAscent());
            }
        } else {
            g.setColor(bg.brighter());
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (mnemIndex != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y);
            } else {
                g.drawString(title, textRect.x, textRect.y);
            }
            g.setColor(bg.darker());
            if (mnemIndex != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x + 1, textRect.y + 1);
            } else {
                g.drawString(title, textRect.x + 1, textRect.y + 1);
            }
        }
        g.setColor(saved_color);
        g.setFont(f);
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        Color saved = g.getColor();
        this.calcRect = iconRect.union(textRect);
        g.setColor(this.focus);
        g.drawRect(this.calcRect.x, this.calcRect.y, this.calcRect.width, this.calcRect.height);
        g.setColor(saved);
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Color saved = g.getColor();
        if (!isSelected || tabPlacement != 1) {
            g.setColor(this.shadow);
            g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
            g.setColor(this.darkShadow);
            g.drawLine(x, y + h, x + w, y + h);
        }
        if (!isSelected || tabPlacement != 2) {
            g.setColor(this.darkShadow);
            g.drawLine(x + w, y, x + w, y + h);
            g.setColor(this.shadow);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
        }
        if (!isSelected || tabPlacement != 4) {
            g.setColor(this.lightHighlight);
            g.drawLine(x, y, x, y + h);
        }
        if (!isSelected || tabPlacement != 3) {
            g.setColor(this.lightHighlight);
            g.drawLine(x, y, x + w, y);
        }
        g.setColor(saved);
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Color saved = g.getColor();
        if (isSelected) {
            g.setColor(Color.LIGHT_GRAY);
        } else {
            Color bg = this.tabPane.getBackgroundAt(tabIndex);
            if (bg == null) {
                bg = this.tabPane.getBackground();
            }
            g.setColor(bg);
        }
        g.fillRect(x, y, w, h);
        g.setColor(saved);
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        Insets insets = this.getContentBorderInsets(tabPlacement);
        int x = this.contentRect.x;
        int y = this.contentRect.y;
        int w = this.contentRect.width;
        int h = this.contentRect.height;
        this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Color saved = g.getColor();
        g.setColor(this.lightHighlight);
        int startgap = this.rects[selectedIndex].x;
        int endgap = this.rects[selectedIndex].x + this.rects[selectedIndex].width;
        int diff = 0;
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            Point p = this.findPointForIndex(this.currentScrollLocation);
            diff = p.x;
        }
        if (tabPlacement == 1) {
            g.drawLine(x, y, startgap - diff, y);
            g.drawLine(endgap - diff, y, x + w, y);
        } else {
            g.drawLine(x, y, x + w, y);
        }
        g.setColor(saved);
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Color saved = g.getColor();
        g.setColor(this.lightHighlight);
        int startgap = this.rects[selectedIndex].y;
        int endgap = this.rects[selectedIndex].y + this.rects[selectedIndex].height;
        int diff = 0;
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            Point p = this.findPointForIndex(this.currentScrollLocation);
            diff = p.y;
        }
        if (tabPlacement == 2) {
            g.drawLine(x, y, x, startgap - diff);
            g.drawLine(x, endgap - diff, x, y + h);
        } else {
            g.drawLine(x, y, x, y + h);
        }
        g.setColor(saved);
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Color saved = g.getColor();
        int startgap = this.rects[selectedIndex].x;
        int endgap = this.rects[selectedIndex].x + this.rects[selectedIndex].width;
        int diff = 0;
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            Point p = this.findPointForIndex(this.currentScrollLocation);
            diff = p.x;
        }
        if (tabPlacement == 3) {
            g.setColor(this.shadow);
            g.drawLine(x + 1, y + h - 1, startgap - diff, y + h - 1);
            g.drawLine(endgap - diff, y + h - 1, x + w - 1, y + h - 1);
            g.setColor(this.darkShadow);
            g.drawLine(x, y + h, startgap - diff, y + h);
            g.drawLine(endgap - diff, y + h, x + w, y + h);
        } else {
            g.setColor(this.shadow);
            g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
            g.setColor(this.darkShadow);
            g.drawLine(x, y + h, x + w, y + h);
        }
        g.setColor(saved);
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Color saved = g.getColor();
        int startgap = this.rects[selectedIndex].y;
        int endgap = this.rects[selectedIndex].y + this.rects[selectedIndex].height;
        int diff = 0;
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            Point p = this.findPointForIndex(this.currentScrollLocation);
            diff = p.y;
        }
        if (tabPlacement == 4) {
            g.setColor(this.shadow);
            g.drawLine(x + w - 1, y + 1, x + w - 1, startgap - diff);
            g.drawLine(x + w - 1, endgap - diff, x + w - 1, y + h - 1);
            g.setColor(this.darkShadow);
            g.drawLine(x + w, y, x + w, startgap - diff);
            g.drawLine(x + w, endgap - diff, x + w, y + h);
        } else {
            g.setColor(this.shadow);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
            g.setColor(this.darkShadow);
            g.drawLine(x + w, y, x + w, y + h);
        }
        g.setColor(saved);
    }

    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        return this.rects[i];
    }

    public int getTabRunCount(JTabbedPane pane) {
        return this.runCount;
    }

    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        Point p = new Point(x, y);
        int tabCount = this.tabPane.getTabCount();
        int currRun = 1;
        for (int i = 0; i < this.runCount; ++i) {
            int first = this.lastTabInRun(tabCount, this.getPreviousTabRun(currRun)) + 1;
            if (first == tabCount) {
                first = 0;
            }
            int last = this.lastTabInRun(tabCount, currRun);
            for (int j = first; j <= last; ++j) {
                if (!this.getTabBounds(pane, j).contains(p)) continue;
                return j;
            }
            currRun = this.getNextTabRun(currRun);
        }
        return -1;
    }

    protected Rectangle getTabBounds(int tabIndex, Rectangle dest) {
        dest.setBounds(this.getTabBounds(this.tabPane, tabIndex));
        return dest;
    }

    protected Component getVisibleComponent() {
        return this.tabPane.getComponentAt(this.tabPane.getSelectedIndex());
    }

    protected void setVisibleComponent(Component component) {
        component.setVisible(true);
        this.tabPane.setSelectedComponent(component);
    }

    protected void assureRectsCreated(int tabCount) {
        if (this.rects == null) {
            this.rects = new Rectangle[tabCount];
        }
        if (tabCount == this.rects.length) {
            return;
        }
        int numToCopy = Math.min(tabCount, this.rects.length);
        Rectangle[] tmp = new Rectangle[tabCount];
        System.arraycopy(this.rects, 0, tmp, 0, numToCopy);
        this.rects = tmp;
    }

    protected void expandTabRunsArray() {
        if (this.tabRuns == null) {
            this.tabRuns = new int[10];
        } else {
            int[] newRuns = new int[this.tabRuns.length + 10];
            System.arraycopy(this.tabRuns, 0, newRuns, 0, this.tabRuns.length);
            this.tabRuns = newRuns;
        }
    }

    protected int getRunForTab(int tabCount, int tabIndex) {
        if (this.runCount == 1 && tabIndex < tabCount && tabIndex >= 0) {
            return 1;
        }
        for (int i = 0; i < this.runCount; ++i) {
            int last;
            int first = this.lastTabInRun(tabCount, this.getPreviousTabRun(i)) + 1;
            if (first == tabCount) {
                first = 0;
            }
            if ((last = this.lastTabInRun(tabCount, i)) < tabIndex || first > tabIndex) continue;
            return i;
        }
        return -1;
    }

    protected int lastTabInRun(int tabCount, int run) {
        if (this.tabRuns[run] == 0) {
            return tabCount - 1;
        }
        return this.tabRuns[run] - 1;
    }

    protected int getTabRunOverlay(int tabPlacement) {
        return this.tabRunOverlay;
    }

    protected int getTabRunIndent(int tabPlacement, int run) {
        return 0;
    }

    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return true;
    }

    protected boolean shouldRotateTabRuns(int tabPlacement) {
        return true;
    }

    protected Icon getIconForTab(int tabIndex) {
        if (this.tabPane.isEnabledAt(tabIndex)) {
            return this.tabPane.getIconAt(tabIndex);
        }
        return this.tabPane.getDisabledIconAt(tabIndex);
    }

    protected View getTextViewForTab(int tabIndex) {
        return null;
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        Icon icon = this.getIconForTab(tabIndex);
        Insets insets = this.getTabInsets(tabPlacement, tabIndex);
        if (icon != null) {
            Rectangle vr = new Rectangle();
            Rectangle ir = new Rectangle();
            Rectangle tr = new Rectangle();
            this.layoutLabel(tabPlacement, this.getFontMetrics(), tabIndex, this.tabPane.getTitleAt(tabIndex), icon, vr, ir, tr, tabIndex == this.tabPane.getSelectedIndex());
            this.calcRect = tr.union(ir);
        } else {
            this.calcRect.height = fontHeight;
        }
        this.calcRect.height += insets.top + insets.bottom;
        return this.calcRect.height;
    }

    protected int calculateMaxTabHeight(int tabPlacement) {
        this.maxTabHeight = 0;
        FontMetrics fm = this.getFontMetrics();
        int fontHeight = fm.getHeight();
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            this.maxTabHeight = Math.max(this.calculateTabHeight(tabPlacement, i, fontHeight), this.maxTabHeight);
        }
        return this.maxTabHeight;
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        Icon icon = this.getIconForTab(tabIndex);
        Insets insets = this.getTabInsets(tabPlacement, tabIndex);
        if (icon != null) {
            Rectangle vr = new Rectangle();
            Rectangle ir = new Rectangle();
            Rectangle tr = new Rectangle();
            this.layoutLabel(tabPlacement, this.getFontMetrics(), tabIndex, this.tabPane.getTitleAt(tabIndex), icon, vr, ir, tr, tabIndex == this.tabPane.getSelectedIndex());
            this.calcRect = tr.union(ir);
        } else {
            this.calcRect.width = metrics.stringWidth(this.tabPane.getTitleAt(tabIndex));
        }
        this.calcRect.width += insets.left + insets.right;
        return this.calcRect.width;
    }

    protected int calculateMaxTabWidth(int tabPlacement) {
        this.maxTabWidth = 0;
        FontMetrics fm = this.getFontMetrics();
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            this.maxTabWidth = Math.max(this.calculateTabWidth(tabPlacement, i, fm), this.maxTabWidth);
        }
        return this.maxTabWidth;
    }

    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        Insets insets = this.getTabAreaInsets(tabPlacement);
        int tabAreaHeight = horizRunCount * maxTabHeight - (horizRunCount - 1) * this.tabRunOverlay;
        return tabAreaHeight += insets.top + insets.bottom;
    }

    protected int calculateTabAreaWidth(int tabPlacement, int vertRunCount, int maxTabWidth) {
        Insets insets = this.getTabAreaInsets(tabPlacement);
        int tabAreaWidth = vertRunCount * maxTabWidth - (vertRunCount - 1) * this.tabRunOverlay;
        return tabAreaWidth += insets.left + insets.right;
    }

    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        Insets target = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.tabInsets, target, tabPlacement);
        return target;
    }

    protected Insets getSelectedTabPadInsets(int tabPlacement) {
        Insets target = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.selectedTabPadInsets, target, tabPlacement);
        return target;
    }

    protected Insets getTabAreaInsets(int tabPlacement) {
        Insets target = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.tabAreaInsets, target, tabPlacement);
        return target;
    }

    protected Insets getContentBorderInsets(int tabPlacement) {
        Insets target = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.contentBorderInsets, target, tabPlacement);
        return target;
    }

    protected FontMetrics getFontMetrics() {
        FontMetrics fm = this.tabPane.getToolkit().getFontMetrics(this.tabPane.getFont());
        return fm;
    }

    protected void navigateSelectedTab(int direction) {
        int offset;
        int tabPlacement = this.tabPane.getTabPlacement();
        if (tabPlacement == 1 || tabPlacement == 3) {
            if (direction == 7) {
                this.selectPreviousTabInRun(this.tabPane.getSelectedIndex());
            } else if (direction == 3) {
                this.selectNextTabInRun(this.tabPane.getSelectedIndex());
            } else {
                offset = this.getTabRunOffset(tabPlacement, this.tabPane.getTabCount(), this.tabPane.getSelectedIndex(), tabPlacement == 4);
                this.selectAdjacentRunTab(tabPlacement, this.tabPane.getSelectedIndex(), offset);
            }
        }
        if (tabPlacement == 2 || tabPlacement == 4) {
            if (direction == 1) {
                this.selectPreviousTabInRun(this.tabPane.getSelectedIndex());
            } else if (direction == 5) {
                this.selectNextTabInRun(this.tabPane.getSelectedIndex());
            } else {
                offset = this.getTabRunOffset(tabPlacement, this.tabPane.getTabCount(), this.tabPane.getSelectedIndex(), tabPlacement == 4);
                this.selectAdjacentRunTab(tabPlacement, this.tabPane.getSelectedIndex(), offset);
            }
        }
    }

    protected void selectNextTabInRun(int current) {
        this.tabPane.setSelectedIndex(this.getNextTabIndexInRun(this.tabPane.getTabCount(), current));
    }

    protected void selectPreviousTabInRun(int current) {
        this.tabPane.setSelectedIndex(this.getPreviousTabIndexInRun(this.tabPane.getTabCount(), current));
    }

    protected void selectNextTab(int current) {
        this.tabPane.setSelectedIndex(this.getNextTabIndex(current));
    }

    protected void selectPreviousTab(int current) {
        this.tabPane.setSelectedIndex(this.getPreviousTabIndex(current));
    }

    protected void selectAdjacentRunTab(int tabPlacement, int tabIndex, int offset) {
        int x = this.rects[tabIndex].x + this.rects[tabIndex].width / 2;
        int y = this.rects[tabIndex].y + this.rects[tabIndex].height / 2;
        switch (tabPlacement) {
            case 1: 
            case 3: {
                y += offset;
                break;
            }
            case 2: 
            case 4: {
                x += offset;
            }
        }
        int index = this.tabForCoordinate(this.tabPane, x, y);
        if (index != -1) {
            this.tabPane.setSelectedIndex(index);
        }
    }

    protected int getTabRunOffset(int tabPlacement, int tabCount, int tabIndex, boolean forward) {
        int currRun = this.getRunForTab(tabCount, tabIndex);
        int nextRun = forward ? this.getNextTabRun(currRun) : this.getPreviousTabRun(currRun);
        int offset = tabPlacement == 1 || tabPlacement == 3 ? this.rects[this.lastTabInRun((int)tabCount, (int)nextRun)].y - this.rects[this.lastTabInRun((int)tabCount, (int)currRun)].y : this.rects[this.lastTabInRun((int)tabCount, (int)nextRun)].x - this.rects[this.lastTabInRun((int)tabCount, (int)currRun)].x;
        return offset;
    }

    protected int getPreviousTabIndex(int base) {
        if (--base < 0) {
            return this.tabPane.getTabCount() - 1;
        }
        return base;
    }

    protected int getNextTabIndex(int base) {
        if (++base == this.tabPane.getTabCount()) {
            return 0;
        }
        return base;
    }

    protected int getNextTabIndexInRun(int tabCount, int base) {
        int run;
        int index = this.getNextTabIndex(base);
        if (index == this.lastTabInRun(tabCount, run = this.getRunForTab(tabCount, base)) + 1) {
            index = this.lastTabInRun(tabCount, this.getPreviousTabRun(run)) + 1;
        }
        return this.getNextTabIndex(base);
    }

    protected int getPreviousTabIndexInRun(int tabCount, int base) {
        int run;
        int index = this.getPreviousTabIndex(base);
        if (index == this.lastTabInRun(tabCount, this.getPreviousTabRun(run = this.getRunForTab(tabCount, base)))) {
            index = this.lastTabInRun(tabCount, run);
        }
        return this.getPreviousTabIndex(base);
    }

    protected int getPreviousTabRun(int baseRun) {
        int prevRun;
        if (this.getTabRunCount(this.tabPane) == 1) {
            return 1;
        }
        if ((prevRun = --baseRun) < 0) {
            prevRun = this.getTabRunCount(this.tabPane) - 1;
        }
        return prevRun;
    }

    protected int getNextTabRun(int baseRun) {
        int nextRun;
        if (this.getTabRunCount(this.tabPane) == 1) {
            return 1;
        }
        if ((nextRun = ++baseRun) == this.getTabRunCount(this.tabPane)) {
            nextRun = 0;
        }
        return nextRun;
    }

    protected static void rotateInsets(Insets topInsets, Insets targetInsets, int targetPlacement) {
        switch (targetPlacement) {
            case 1: {
                targetInsets.top = topInsets.top;
                targetInsets.left = topInsets.left;
                targetInsets.right = topInsets.right;
                targetInsets.bottom = topInsets.bottom;
                break;
            }
            case 2: {
                targetInsets.left = topInsets.top;
                targetInsets.top = topInsets.left;
                targetInsets.right = topInsets.bottom;
                targetInsets.bottom = topInsets.right;
                break;
            }
            case 3: {
                targetInsets.top = topInsets.bottom;
                targetInsets.bottom = topInsets.top;
                targetInsets.left = topInsets.left;
                targetInsets.right = topInsets.right;
                break;
            }
            case 4: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.bottom;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.top;
            }
        }
    }

    private static class ScrollingButton
    extends BasicArrowButton
    implements UIResource {
        public ScrollingButton(int dir) {
            super(dir);
        }
    }

    private class ScrollingViewport
    extends JViewport
    implements UIResource {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        ScrollingViewport(BasicTabbedPaneUI this$0) {
            this.this$0 = this$0;
        }
    }

    private class ScrollingPanel
    extends JPanel {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        static /* synthetic */ BasicTabbedPaneUI access$1(ScrollingPanel inst$, BasicTabbedPaneUI write_parm_value$) {
            inst$.this$0 = write_parm_value$;
            return inst$.this$0;
        }

        static BasicTabbedPaneUI access$0(ScrollingPanel inst$) {
            return inst$.this$0;
        }

        public void updateUI() {
            this.setUI(new ScrollingPanelUI(this));
        }

        ScrollingPanel(BasicTabbedPaneUI this$0) {
            this.this$0 = this$0;
        }

        private class ScrollingPanelUI
        extends BasicPanelUI {
            private /* synthetic */ ScrollingPanel this$1;

            public void paint(Graphics g, JComponent c) {
                this.this$1.this$0.paintTabArea(g, ScrollingPanel.access$0((ScrollingPanel)this.this$1).tabPane.getTabPlacement(), ScrollingPanel.access$0((ScrollingPanel)this.this$1).tabPane.getSelectedIndex());
            }

            ScrollingPanelUI(ScrollingPanel this$1) {
                this.this$1 = this$1;
            }
        }
    }

    protected class TabSelectionHandler
    implements ChangeListener {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public void stateChanged(ChangeEvent e) {
            this.this$0.selectedRun = this.this$0.getRunForTab(this.this$0.tabPane.getTabCount(), this.this$0.tabPane.getSelectedIndex());
            this.this$0.tabPane.revalidate();
            this.this$0.tabPane.repaint();
        }

        TabSelectionHandler(BasicTabbedPaneUI this$0) {
            this.this$0 = this$0;
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public Dimension preferredLayoutSize(Container parent) {
            return super.calculateSize(true);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return super.calculateSize(true);
        }

        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            if (this.this$0.tabPane.getTabCount() == 0) {
                return this.this$0.calculateTabAreaHeight(tabPlacement, 0, 0);
            }
            int runs = 1;
            int maxTabHeight = this.this$0.calculateMaxTabHeight(tabPlacement);
            int tabAreaHeight = this.this$0.calculateTabAreaHeight(tabPlacement, runs, maxTabHeight);
            return tabAreaHeight;
        }

        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            if (this.this$0.tabPane.getTabCount() == 0) {
                return this.this$0.calculateTabAreaHeight(tabPlacement, 0, 0);
            }
            int runs = 1;
            int maxTabWidth = this.this$0.calculateMaxTabWidth(tabPlacement);
            int tabAreaWidth = this.this$0.calculateTabAreaWidth(tabPlacement, runs, maxTabWidth);
            return tabAreaWidth;
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            if (tabCount == 0) {
                return;
            }
            this.this$0.assureRectsCreated(tabCount);
            FontMetrics fm = this.this$0.getFontMetrics();
            SwingUtilities.calculateInnerArea(this.this$0.tabPane, this.this$0.calcRect);
            Insets tabAreaInsets = this.this$0.getTabAreaInsets(tabPlacement);
            Insets insets = this.this$0.tabPane.getInsets();
            int max = 0;
            int runs = 1;
            int start = 0;
            int top = 0;
            if (tabPlacement == 1 || tabPlacement == 3) {
                int maxHeight = this.this$0.calculateMaxTabHeight(tabPlacement);
                this.this$0.calcRect.width -= tabAreaInsets.left + tabAreaInsets.right;
                max = this.this$0.calcRect.width + tabAreaInsets.left + insets.left;
                start = tabAreaInsets.left + insets.left;
                int width = 0;
                int runWidth = start;
                top = insets.top + tabAreaInsets.top;
                for (int i = 0; i < tabCount; ++i) {
                    width = this.this$0.calculateTabWidth(tabPlacement, i, fm);
                    this.this$0.rects[i] = new Rectangle(runWidth, top, width, maxHeight);
                    runWidth += width;
                }
                ((BasicTabbedPaneUI)this.this$0).tabAreaRect.width = this.this$0.tabPane.getWidth() - insets.left - insets.right;
                ((BasicTabbedPaneUI)this.this$0).tabAreaRect.height = runs * this.this$0.maxTabHeight - (runs - 1) * this.this$0.tabRunOverlay + tabAreaInsets.top + tabAreaInsets.bottom;
                ((BasicTabbedPaneUI)this.this$0).contentRect.width = ((BasicTabbedPaneUI)this.this$0).tabAreaRect.width;
                ((BasicTabbedPaneUI)this.this$0).contentRect.height = this.this$0.tabPane.getHeight() - insets.top - insets.bottom - ((BasicTabbedPaneUI)this.this$0).tabAreaRect.height;
                ((BasicTabbedPaneUI)this.this$0).contentRect.x = insets.left;
                ((BasicTabbedPaneUI)this.this$0).tabAreaRect.x = insets.left;
                if (tabPlacement == 3) {
                    ((BasicTabbedPaneUI)this.this$0).contentRect.y = insets.top;
                    ((BasicTabbedPaneUI)this.this$0).tabAreaRect.y = ((BasicTabbedPaneUI)this.this$0).contentRect.y + ((BasicTabbedPaneUI)this.this$0).contentRect.height;
                } else {
                    ((BasicTabbedPaneUI)this.this$0).tabAreaRect.y = insets.top;
                    ((BasicTabbedPaneUI)this.this$0).contentRect.y = ((BasicTabbedPaneUI)this.this$0).tabAreaRect.y + ((BasicTabbedPaneUI)this.this$0).tabAreaRect.height;
                }
            } else {
                int maxWidth = this.this$0.calculateMaxTabWidth(tabPlacement);
                this.this$0.calcRect.height -= tabAreaInsets.top + tabAreaInsets.bottom;
                max = this.this$0.calcRect.height + tabAreaInsets.top;
                int height = 0;
                int runHeight = start = tabAreaInsets.top + insets.top;
                int fontHeight = fm.getHeight();
                top = insets.left + tabAreaInsets.left;
                for (int i = 0; i < tabCount; ++i) {
                    height = this.this$0.calculateTabHeight(tabPlacement, i, fontHeight);
                    this.this$0.rects[i] = new Rectangle(top, runHeight, maxWidth, height);
                    runHeight += height;
                }
                ((BasicTabbedPaneUI)this.this$0).tabAreaRect.width = runs * this.this$0.maxTabWidth - (runs - 1) * this.this$0.tabRunOverlay + tabAreaInsets.left + tabAreaInsets.right;
                ((BasicTabbedPaneUI)this.this$0).tabAreaRect.height = this.this$0.tabPane.getHeight() - insets.top - insets.bottom;
                ((BasicTabbedPaneUI)this.this$0).tabAreaRect.y = insets.top;
                ((BasicTabbedPaneUI)this.this$0).contentRect.width = this.this$0.tabPane.getWidth() - insets.left - insets.right - ((BasicTabbedPaneUI)this.this$0).tabAreaRect.width;
                ((BasicTabbedPaneUI)this.this$0).contentRect.height = ((BasicTabbedPaneUI)this.this$0).tabAreaRect.height;
                ((BasicTabbedPaneUI)this.this$0).contentRect.y = insets.top;
                if (tabPlacement == 2) {
                    ((BasicTabbedPaneUI)this.this$0).tabAreaRect.x = insets.left;
                    ((BasicTabbedPaneUI)this.this$0).contentRect.x = ((BasicTabbedPaneUI)this.this$0).tabAreaRect.x + ((BasicTabbedPaneUI)this.this$0).tabAreaRect.width;
                } else {
                    ((BasicTabbedPaneUI)this.this$0).contentRect.x = insets.left;
                    ((BasicTabbedPaneUI)this.this$0).tabAreaRect.x = ((BasicTabbedPaneUI)this.this$0).contentRect.x + ((BasicTabbedPaneUI)this.this$0).contentRect.width;
                }
            }
            this.this$0.runCount = runs;
            this.padSelectedTab(tabPlacement, this.this$0.tabPane.getSelectedIndex());
        }

        public void layoutContainer(Container pane) {
            Dimension decrDims;
            Dimension incrDims;
            super.layoutContainer(pane);
            int tabCount = this.this$0.tabPane.getTabCount();
            if (tabCount == 0) {
                return;
            }
            int tabPlacement = this.this$0.tabPane.getTabPlacement();
            this.this$0.incrButton.hide();
            this.this$0.decrButton.hide();
            if ((tabPlacement == 1 || tabPlacement == 3) && ((BasicTabbedPaneUI)this.this$0).tabAreaRect.x + ((BasicTabbedPaneUI)this.this$0).tabAreaRect.width < this.this$0.rects[tabCount - 1].x + this.this$0.rects[tabCount - 1].width) {
                incrDims = this.this$0.incrButton.getPreferredSize();
                decrDims = this.this$0.decrButton.getPreferredSize();
                this.this$0.decrButton.setBounds(((BasicTabbedPaneUI)this.this$0).tabAreaRect.x + ((BasicTabbedPaneUI)this.this$0).tabAreaRect.width - incrDims.width - decrDims.width, ((BasicTabbedPaneUI)this.this$0).tabAreaRect.y, decrDims.width, ((BasicTabbedPaneUI)this.this$0).tabAreaRect.height);
                this.this$0.incrButton.setBounds(((BasicTabbedPaneUI)this.this$0).tabAreaRect.x + ((BasicTabbedPaneUI)this.this$0).tabAreaRect.width - incrDims.width, ((BasicTabbedPaneUI)this.this$0).tabAreaRect.y, decrDims.width, ((BasicTabbedPaneUI)this.this$0).tabAreaRect.height);
                Rectangle rectangle = this.this$0.tabAreaRect;
                rectangle.width -= decrDims.width + incrDims.width;
                this.this$0.incrButton.show();
                this.this$0.decrButton.show();
            }
            if ((tabPlacement == 2 || tabPlacement == 4) && ((BasicTabbedPaneUI)this.this$0).tabAreaRect.y + ((BasicTabbedPaneUI)this.this$0).tabAreaRect.height < this.this$0.rects[tabCount - 1].y + this.this$0.rects[tabCount - 1].height) {
                incrDims = this.this$0.incrButton.getPreferredSize();
                decrDims = this.this$0.decrButton.getPreferredSize();
                this.this$0.decrButton.setBounds(((BasicTabbedPaneUI)this.this$0).tabAreaRect.x, ((BasicTabbedPaneUI)this.this$0).tabAreaRect.y + ((BasicTabbedPaneUI)this.this$0).tabAreaRect.height - incrDims.height - decrDims.height, ((BasicTabbedPaneUI)this.this$0).tabAreaRect.width, decrDims.height);
                this.this$0.incrButton.setBounds(((BasicTabbedPaneUI)this.this$0).tabAreaRect.x, ((BasicTabbedPaneUI)this.this$0).tabAreaRect.y + ((BasicTabbedPaneUI)this.this$0).tabAreaRect.height - incrDims.height, ((BasicTabbedPaneUI)this.this$0).tabAreaRect.width, incrDims.height);
                Rectangle rectangle = this.this$0.tabAreaRect;
                rectangle.height -= decrDims.height + incrDims.height;
                this.this$0.incrButton.show();
                this.this$0.decrButton.show();
            }
            this.this$0.viewport.setBounds(((BasicTabbedPaneUI)this.this$0).tabAreaRect.x, ((BasicTabbedPaneUI)this.this$0).tabAreaRect.y, ((BasicTabbedPaneUI)this.this$0).tabAreaRect.width, ((BasicTabbedPaneUI)this.this$0).tabAreaRect.height);
            int tabC = this.this$0.tabPane.getTabCount() - 1;
            if (tabCount > 0) {
                int w = Math.max(this.this$0.rects[tabC].width + this.this$0.rects[tabC].x, ((BasicTabbedPaneUI)this.this$0).tabAreaRect.width);
                int h = Math.max(this.this$0.rects[tabC].height, ((BasicTabbedPaneUI)this.this$0).tabAreaRect.height);
                Point p = this.this$0.findPointForIndex(this.this$0.currentScrollLocation);
                this.this$0.panel.setSize(w + p.x, h + p.y);
            }
            this.this$0.viewport.setViewPosition(this.this$0.findPointForIndex(this.this$0.currentScrollLocation));
        }

        TabbedPaneScrollLayout(BasicTabbedPaneUI this$0) {
            this.this$0 = this$0;
            super(this$0);
        }
    }

    protected class TabbedPaneLayout
    implements LayoutManager {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public void addLayoutComponent(String name, Component comp) {
        }

        public void calculateLayoutInfo() {
            this.calculateTabRects(this.this$0.tabPane.getTabPlacement(), this.this$0.tabPane.getTabCount());
            if (this.this$0.tabPane.getSelectedIndex() != -1) {
                Component visible = this.this$0.getVisibleComponent();
                Insets insets = this.this$0.getContentBorderInsets(this.this$0.tabPane.getTabPlacement());
                if (visible != null) {
                    visible.setBounds(((BasicTabbedPaneUI)this.this$0).contentRect.x + insets.left, ((BasicTabbedPaneUI)this.this$0).contentRect.y + insets.top, ((BasicTabbedPaneUI)this.this$0).contentRect.width - insets.left - insets.right, ((BasicTabbedPaneUI)this.this$0).contentRect.height - insets.top - insets.bottom);
                }
            }
        }

        protected Dimension calculateSize(boolean minimum) {
            int tabPlacement = this.this$0.tabPane.getTabPlacement();
            int width = 0;
            int height = 0;
            int componentHeight = 0;
            int componentWidth = 0;
            for (int i = 0; i < this.this$0.tabPane.getTabCount(); ++i) {
                Component c = this.this$0.tabPane.getComponentAt(i);
                if (c == null) continue;
                this.this$0.calcRect = c.getBounds();
                Dimension dims = c.getPreferredSize();
                if (dims == null) continue;
                componentHeight = Math.max(componentHeight, dims.height);
                componentWidth = Math.max(componentWidth, dims.width);
            }
            Insets insets = this.this$0.tabPane.getInsets();
            if (tabPlacement == 1 || tabPlacement == 3) {
                width = this.this$0.calculateMaxTabWidth(tabPlacement) * this.this$0.tabPane.getTabCount();
                this.this$0.calcRect = this.this$0.tabPane.getParent().getBounds();
                width = Math.max(width, componentWidth);
                int tabAreaHeight = this.preferredTabAreaHeight(tabPlacement, width);
                height = tabAreaHeight + componentHeight;
            } else {
                height = this.this$0.calculateMaxTabHeight(tabPlacement) * this.this$0.tabPane.getTabCount();
                this.this$0.calcRect = this.this$0.tabPane.getParent().getBounds();
                height = Math.max(height, componentHeight);
                int tabAreaWidth = this.preferredTabAreaWidth(tabPlacement, height);
                width = tabAreaWidth + componentWidth;
            }
            return new Dimension(width, height);
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            if (tabCount == 0) {
                return;
            }
            this.this$0.assureRectsCreated(tabCount);
            FontMetrics fm = this.this$0.getFontMetrics();
            SwingUtilities.calculateInnerArea(this.this$0.tabPane, this.this$0.calcRect);
            Insets tabAreaInsets = this.this$0.getTabAreaInsets(tabPlacement);
            Insets insets = this.this$0.tabPane.getInsets();
            int max = 0;
            int runs = 0;
            int start = this.this$0.getTabRunIndent(tabPlacement, 1);
            if (tabPlacement == 1 || tabPlacement == 3) {
                int maxHeight = this.this$0.calculateMaxTabHeight(tabPlacement);
                this.this$0.calcRect.width -= tabAreaInsets.left + tabAreaInsets.right;
                max = this.this$0.calcRect.width + tabAreaInsets.left + insets.left;
                int width = 0;
                int runWidth = start += tabAreaInsets.left + insets.left;
                for (int i = 0; i < tabCount; ++i) {
                    width = this.this$0.calculateTabWidth(tabPlacement, i, fm);
                    if (runWidth + width > max) {
                        runWidth = tabAreaInsets.left + insets.left + this.this$0.getTabRunIndent(tabPlacement, ++runs);
                        this.this$0.rects[i] = new Rectangle(runWidth, insets.top + tabAreaInsets.top, width, maxHeight);
                        runWidth += width;
                        if (runs > this.this$0.tabRuns.length - 1) {
                            this.this$0.expandTabRunsArray();
                        }
                        this.this$0.tabRuns[runs] = i;
                        continue;
                    }
                    this.this$0.rects[i] = new Rectangle(runWidth, insets.top + tabAreaInsets.top, width, maxHeight);
                    runWidth += width;
                }
                ((BasicTabbedPaneUI)this.this$0).tabAreaRect.width = this.this$0.tabPane.getWidth() - insets.left - insets.right;
                ((BasicTabbedPaneUI)this.this$0).tabAreaRect.height = ++runs * this.this$0.maxTabHeight - (runs - 1) * this.this$0.tabRunOverlay + tabAreaInsets.top + tabAreaInsets.bottom;
                ((BasicTabbedPaneUI)this.this$0).contentRect.width = ((BasicTabbedPaneUI)this.this$0).tabAreaRect.width;
                ((BasicTabbedPaneUI)this.this$0).contentRect.height = this.this$0.tabPane.getHeight() - insets.top - insets.bottom - ((BasicTabbedPaneUI)this.this$0).tabAreaRect.height;
                ((BasicTabbedPaneUI)this.this$0).contentRect.x = insets.left;
                ((BasicTabbedPaneUI)this.this$0).tabAreaRect.x = insets.left;
                if (tabPlacement == 3) {
                    ((BasicTabbedPaneUI)this.this$0).contentRect.y = insets.top;
                    ((BasicTabbedPaneUI)this.this$0).tabAreaRect.y = ((BasicTabbedPaneUI)this.this$0).contentRect.y + ((BasicTabbedPaneUI)this.this$0).contentRect.height;
                } else {
                    ((BasicTabbedPaneUI)this.this$0).tabAreaRect.y = insets.top;
                    ((BasicTabbedPaneUI)this.this$0).contentRect.y = ((BasicTabbedPaneUI)this.this$0).tabAreaRect.y + ((BasicTabbedPaneUI)this.this$0).tabAreaRect.height;
                }
            } else {
                int maxWidth = this.this$0.calculateMaxTabWidth(tabPlacement);
                this.this$0.calcRect.height -= tabAreaInsets.top + tabAreaInsets.bottom;
                max = this.this$0.calcRect.height + tabAreaInsets.top + insets.top;
                int height = 0;
                int runHeight = start += tabAreaInsets.top + insets.top;
                int fontHeight = fm.getHeight();
                for (int i = 0; i < tabCount; ++i) {
                    height = this.this$0.calculateTabHeight(tabPlacement, i, fontHeight);
                    if (runHeight + height > max) {
                        runHeight = tabAreaInsets.top + insets.top + this.this$0.getTabRunIndent(tabPlacement, ++runs);
                        this.this$0.rects[i] = new Rectangle(insets.left + tabAreaInsets.left, runHeight, maxWidth, height);
                        runHeight += height;
                        if (runs > this.this$0.tabRuns.length - 1) {
                            this.this$0.expandTabRunsArray();
                        }
                        this.this$0.tabRuns[runs] = i;
                        continue;
                    }
                    this.this$0.rects[i] = new Rectangle(insets.left + tabAreaInsets.left, runHeight, maxWidth, height);
                    runHeight += height;
                }
                ((BasicTabbedPaneUI)this.this$0).tabAreaRect.width = ++runs * this.this$0.maxTabWidth - (runs - 1) * this.this$0.tabRunOverlay + tabAreaInsets.left + tabAreaInsets.right;
                ((BasicTabbedPaneUI)this.this$0).tabAreaRect.height = this.this$0.tabPane.getHeight() - insets.top - insets.bottom;
                ((BasicTabbedPaneUI)this.this$0).tabAreaRect.y = insets.top;
                ((BasicTabbedPaneUI)this.this$0).contentRect.width = this.this$0.tabPane.getWidth() - insets.left - insets.right - ((BasicTabbedPaneUI)this.this$0).tabAreaRect.width;
                ((BasicTabbedPaneUI)this.this$0).contentRect.height = ((BasicTabbedPaneUI)this.this$0).tabAreaRect.height;
                ((BasicTabbedPaneUI)this.this$0).contentRect.y = insets.top;
                if (tabPlacement == 2) {
                    ((BasicTabbedPaneUI)this.this$0).tabAreaRect.x = insets.left;
                    ((BasicTabbedPaneUI)this.this$0).contentRect.x = ((BasicTabbedPaneUI)this.this$0).tabAreaRect.x + ((BasicTabbedPaneUI)this.this$0).tabAreaRect.width;
                } else {
                    ((BasicTabbedPaneUI)this.this$0).contentRect.x = insets.left;
                    ((BasicTabbedPaneUI)this.this$0).tabAreaRect.x = ((BasicTabbedPaneUI)this.this$0).contentRect.x + ((BasicTabbedPaneUI)this.this$0).contentRect.width;
                }
            }
            this.this$0.runCount = runs;
            this.this$0.tabRuns[0] = 0;
            this.normalizeTabRuns(tabPlacement, tabCount, start, max);
            this.this$0.selectedRun = this.this$0.getRunForTab(tabCount, this.this$0.tabPane.getSelectedIndex());
            if (this.this$0.shouldRotateTabRuns(tabPlacement)) {
                this.rotateTabRuns(tabPlacement, this.this$0.selectedRun);
            }
            for (int i = 0; i < this.this$0.runCount; ++i) {
                int j;
                int adjustment;
                int j2;
                int first = this.this$0.lastTabInRun(tabCount, this.this$0.getPreviousTabRun(i)) + 1;
                if (first == tabCount) {
                    first = 0;
                }
                int last = this.this$0.lastTabInRun(tabCount, i);
                if (this.this$0.shouldPadTabRun(tabPlacement, i)) {
                    this.padTabRun(tabPlacement, first, last, max);
                }
                if (tabPlacement == 1 && i > 0) {
                    for (j2 = first; j2 <= last; ++j2) {
                        this.this$0.rects[j2].y += (this.this$0.runCount - i) * this.this$0.maxTabHeight + (this.this$0.runCount - i) * this.this$0.tabRunOverlay;
                    }
                }
                if (tabPlacement == 3) {
                    int height = this.this$0.tabPane.getBounds().height - insets.bottom - tabAreaInsets.bottom;
                    adjustment = i == 0 ? height - this.this$0.maxTabHeight : height - (this.this$0.runCount - i + 1) * this.this$0.maxTabHeight - (this.this$0.runCount - i) * this.this$0.tabRunOverlay;
                    for (j = first; j <= last; ++j) {
                        this.this$0.rects[j].y = adjustment;
                    }
                }
                if (tabPlacement == 2 && i > 0) {
                    for (j2 = first; j2 <= last; ++j2) {
                        this.this$0.rects[j2].x += (this.this$0.runCount - i) * this.this$0.maxTabWidth - (this.this$0.runCount - i) * this.this$0.tabRunOverlay;
                    }
                }
                if (tabPlacement != 4) continue;
                int width = this.this$0.tabPane.getBounds().width - insets.right - tabAreaInsets.right;
                adjustment = i == 0 ? width - this.this$0.maxTabWidth : width - (this.this$0.runCount - i + 1) * this.this$0.maxTabWidth + (this.this$0.runCount - i) * this.this$0.tabRunOverlay;
                for (j = first; j <= last; ++j) {
                    this.this$0.rects[j].x = adjustment;
                }
            }
            this.padSelectedTab(tabPlacement, this.this$0.tabPane.getSelectedIndex());
        }

        public void layoutContainer(Container parent) {
            this.calculateLayoutInfo();
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.calculateSize(false);
        }

        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            Insets tabAreaInsets = this.this$0.getTabAreaInsets(tabPlacement);
            if (tabPlacement == 1 || tabPlacement == 3) {
                for (int i = 1; i < this.this$0.runCount; ++i) {
                    Rectangle currRun = this.this$0.rects[this.this$0.lastTabInRun(tabCount, i)];
                    Rectangle nextRun = this.this$0.rects[this.this$0.lastTabInRun(tabCount, this.this$0.getNextTabRun(i))];
                    int spaceInCurr = currRun.x + currRun.width;
                    int spaceInNext = nextRun.x + nextRun.width;
                    int diffNow = spaceInCurr - spaceInNext;
                    int diffLater = spaceInCurr - currRun.width - (spaceInNext + currRun.width);
                    while (Math.abs(diffLater) < Math.abs(diffNow) && spaceInNext + currRun.width < max) {
                        int n = i;
                        this.this$0.tabRuns[n] = this.this$0.tabRuns[n] - 1;
                        currRun = this.this$0.rects[this.this$0.lastTabInRun(tabCount, i)];
                        diffNow = (spaceInCurr -= currRun.width) - (spaceInNext += currRun.width);
                        diffLater = spaceInCurr - currRun.width - (spaceInNext + currRun.width);
                    }
                    int first = this.this$0.lastTabInRun(tabCount, i) + 1;
                    int last = this.this$0.lastTabInRun(tabCount, this.this$0.getNextTabRun(i));
                    int currX = tabAreaInsets.left;
                    for (int j = first; j <= last; ++j) {
                        this.this$0.rects[j].x = currX;
                        currX += this.this$0.rects[j].width;
                    }
                }
            } else {
                for (int i = 1; i < this.this$0.runCount; ++i) {
                    Rectangle currRun = this.this$0.rects[this.this$0.lastTabInRun(tabCount, i)];
                    Rectangle nextRun = this.this$0.rects[this.this$0.lastTabInRun(tabCount, this.this$0.getNextTabRun(i))];
                    int spaceInCurr = currRun.y + currRun.height;
                    int spaceInNext = nextRun.y + nextRun.height;
                    int diffNow = spaceInCurr - spaceInNext;
                    int diffLater = spaceInCurr - currRun.height - (spaceInNext + currRun.height);
                    while (Math.abs(diffLater) < Math.abs(diffNow) && spaceInNext + currRun.height < max) {
                        int n = i;
                        this.this$0.tabRuns[n] = this.this$0.tabRuns[n] - 1;
                        currRun = this.this$0.rects[this.this$0.lastTabInRun(tabCount, i)];
                        diffNow = (spaceInCurr -= currRun.height) - (spaceInNext += currRun.height);
                        diffLater = spaceInCurr - currRun.height - (spaceInNext + currRun.height);
                    }
                    int first = this.this$0.lastTabInRun(tabCount, i) + 1;
                    int last = this.this$0.lastTabInRun(tabCount, this.this$0.getNextTabRun(i));
                    int currY = tabAreaInsets.top;
                    for (int j = first; j <= last; ++j) {
                        this.this$0.rects[j].y = currY;
                        currY += this.this$0.rects[j].height;
                    }
                }
            }
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
            Insets insets = this.this$0.getSelectedTabPadInsets(tabPlacement);
            this.this$0.rects[selectedIndex].x -= insets.left;
            this.this$0.rects[selectedIndex].y -= insets.top;
            this.this$0.rects[selectedIndex].width += insets.left + insets.right;
            this.this$0.rects[selectedIndex].height += insets.top + insets.bottom;
        }

        protected void padTabRun(int tabPlacement, int start, int end, int max) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                int runWidth = this.this$0.rects[end].x + this.this$0.rects[end].width;
                int spaceRemaining = max - runWidth;
                int numTabs = end - start + 1;
                int spaceAllocated = spaceRemaining / numTabs;
                int currX = this.this$0.rects[start].x;
                for (int i = start; i <= end; ++i) {
                    this.this$0.rects[i].x = currX;
                    this.this$0.rects[i].width += spaceAllocated;
                    currX += this.this$0.rects[i].width;
                    if (i != end || this.this$0.rects[i].x + this.this$0.rects[i].width == max) continue;
                    this.this$0.rects[i].width = max - this.this$0.rects[i].x;
                }
            } else {
                int runHeight = this.this$0.rects[end].y + this.this$0.rects[end].height;
                int spaceRemaining = max - runHeight;
                int numTabs = end - start + 1;
                int spaceAllocated = spaceRemaining / numTabs;
                int currY = this.this$0.rects[start].y;
                for (int i = start; i <= end; ++i) {
                    this.this$0.rects[i].y = currY;
                    this.this$0.rects[i].height += spaceAllocated;
                    currY += this.this$0.rects[i].height;
                    if (i != end || this.this$0.rects[i].y + this.this$0.rects[i].height == max) continue;
                    this.this$0.rects[i].height = max - this.this$0.rects[i].y;
                }
            }
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.calculateSize(false);
        }

        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            if (this.this$0.tabPane.getTabCount() == 0) {
                return this.this$0.calculateTabAreaHeight(tabPlacement, 0, 0);
            }
            int runs = 0;
            int runWidth = 0;
            int tabWidth = 0;
            FontMetrics fm = this.this$0.getFontMetrics();
            Insets tabAreaInsets = this.this$0.getTabAreaInsets(tabPlacement);
            Insets insets = this.this$0.tabPane.getInsets();
            width -= tabAreaInsets.left + tabAreaInsets.right + insets.left + insets.right;
            for (int i = 0; i < this.this$0.tabPane.getTabCount(); ++i) {
                tabWidth = this.this$0.calculateTabWidth(tabPlacement, i, fm);
                if (runWidth + tabWidth > width) {
                    runWidth = tabWidth;
                    ++runs;
                    continue;
                }
                runWidth += tabWidth;
            }
            int maxTabHeight = this.this$0.calculateMaxTabHeight(tabPlacement);
            int tabAreaHeight = this.this$0.calculateTabAreaHeight(tabPlacement, ++runs, maxTabHeight);
            return tabAreaHeight;
        }

        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            if (this.this$0.tabPane.getTabCount() == 0) {
                return this.this$0.calculateTabAreaHeight(tabPlacement, 0, 0);
            }
            int runs = 0;
            int runHeight = 0;
            int tabHeight = 0;
            FontMetrics fm = this.this$0.getFontMetrics();
            Insets tabAreaInsets = this.this$0.getTabAreaInsets(tabPlacement);
            Insets insets = this.this$0.tabPane.getInsets();
            height -= tabAreaInsets.top + tabAreaInsets.bottom + insets.top + insets.bottom;
            int fontHeight = fm.getHeight();
            for (int i = 0; i < this.this$0.tabPane.getTabCount(); ++i) {
                tabHeight = this.this$0.calculateTabHeight(tabPlacement, i, fontHeight);
                if (runHeight + tabHeight > height) {
                    runHeight = tabHeight;
                    ++runs;
                    continue;
                }
                runHeight += tabHeight;
            }
            int maxTabWidth = this.this$0.calculateMaxTabWidth(tabPlacement);
            int tabAreaWidth = this.this$0.calculateTabAreaWidth(tabPlacement, ++runs, maxTabWidth);
            return tabAreaWidth;
        }

        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
            if (selectedRun == 1 || selectedRun == -1) {
                return;
            }
            int[] newTabRuns = new int[this.this$0.tabRuns.length];
            int currentRun = selectedRun;
            int i = 1;
            do {
                newTabRuns[i] = this.this$0.tabRuns[currentRun];
                currentRun = this.this$0.getNextTabRun(currentRun);
            } while (++i < this.this$0.runCount);
            if (this.this$0.runCount > 1) {
                newTabRuns[0] = this.this$0.tabRuns[currentRun];
            }
            this.this$0.tabRuns = newTabRuns;
            this.this$0.selectedRun = 1;
        }

        public void removeLayoutComponent(Component comp) {
        }

        TabbedPaneLayout(BasicTabbedPaneUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("tabLayoutPolicy")) {
                this.this$0.layoutManager = this.this$0.createLayoutManager();
                this.this$0.tabPane.setLayout(this.this$0.layoutManager);
            } else if (e.getPropertyName().equals("tabPlacement") && this.this$0.tabPane.getTabLayoutPolicy() == 1) {
                this.this$0.incrButton = this.this$0.createIncreaseButton();
                this.this$0.decrButton = this.this$0.createDecreaseButton();
            }
            this.this$0.tabPane.layout();
            this.this$0.tabPane.repaint();
        }

        PropertyChangeHandler(BasicTabbedPaneUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public void mousePressed(MouseEvent e) {
            int index;
            int x = e.getX();
            int y = e.getY();
            int tabCount = this.this$0.tabPane.getTabCount();
            if (this.this$0.tabPane.getTabLayoutPolicy() == 1) {
                if (e.getSource() == this.this$0.incrButton) {
                    if ((this.this$0.currentScrollLocation = this.this$0.currentScrollLocation + 1) >= tabCount) {
                        this.this$0.currentScrollLocation = tabCount - 1;
                    }
                    if (this.this$0.currentScrollLocation == tabCount - 1) {
                        this.this$0.incrButton.setEnabled(false);
                    } else if (!this.this$0.decrButton.isEnabled()) {
                        this.this$0.decrButton.setEnabled(true);
                    }
                    this.this$0.tabPane.layout();
                    this.this$0.tabPane.repaint();
                    return;
                }
                if (e.getSource() == this.this$0.decrButton) {
                    if ((this.this$0.currentScrollLocation = this.this$0.currentScrollLocation + 1) < 0) {
                        this.this$0.currentScrollLocation = 0;
                    }
                    if (this.this$0.currentScrollLocation == 0) {
                        this.this$0.decrButton.setEnabled(false);
                    } else if (!this.this$0.incrButton.isEnabled()) {
                        this.this$0.incrButton.setEnabled(true);
                    }
                    this.this$0.tabPane.layout();
                    this.this$0.tabPane.repaint();
                    return;
                }
            }
            if ((index = this.this$0.tabForCoordinate(this.this$0.tabPane, x, y)) != -1 && this.this$0.tabPane.isEnabledAt(index)) {
                this.this$0.tabPane.setSelectedIndex(index);
            }
            this.this$0.tabPane.layout();
            this.this$0.tabPane.repaint();
        }

        MouseHandler(BasicTabbedPaneUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class FocusHandler
    extends FocusAdapter {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
        }

        FocusHandler(BasicTabbedPaneUI this$0) {
            this.this$0 = this$0;
        }
    }
}

