/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BasicTableUI
extends TableUI {
    protected FocusListener focusListener;
    protected KeyListener keyListener;
    protected MouseInputListener mouseInputListener;
    protected CellRendererPane rendererPane;
    protected JTable table;

    public static ComponentUI createUI(JComponent comp) {
        return new BasicTableUI();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler(this);
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler(this);
    }

    public Dimension getMaximumSize(JComponent comp) {
        return this.getPreferredSize(comp);
    }

    public Dimension getMinimumSize(JComponent comp) {
        return this.getPreferredSize(comp);
    }

    public Dimension getPreferredSize(JComponent comp) {
        int width = this.table.getColumnModel().getTotalColumnWidth();
        int height = this.table.getRowCount() * this.table.getRowHeight();
        return new Dimension(width, height);
    }

    protected void installDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.table.setFont(defaults.getFont("Table.font"));
        this.table.setGridColor(defaults.getColor("Table.gridColor"));
        this.table.setForeground(defaults.getColor("Table.foreground"));
        this.table.setBackground(defaults.getColor("Table.background"));
        this.table.setSelectionForeground(defaults.getColor("Table.selectionForeground"));
        this.table.setSelectionBackground(defaults.getColor("Table.selectionBackground"));
        this.table.setOpaque(true);
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.table.addFocusListener(this.focusListener);
        this.table.addKeyListener(this.keyListener);
        this.table.addMouseListener(this.mouseInputListener);
    }

    protected void uninstallDefaults() {
        this.table.setFont(null);
        this.table.setGridColor(null);
        this.table.setForeground(null);
        this.table.setBackground(null);
        this.table.setSelectionForeground(null);
        this.table.setSelectionBackground(null);
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(this.mouseInputListener);
    }

    public void installUI(JComponent comp) {
        this.table = (JTable)comp;
        this.focusListener = this.createFocusListener();
        this.keyListener = this.createKeyListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.installDefaults();
        this.installKeyboardActions();
        this.installListeners();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
    }

    public void paint(Graphics gfx, JComponent ignored) {
        boolean paintedLine;
        Color save;
        int ncols = this.table.getColumnCount();
        int nrows = this.table.getRowCount();
        if (nrows == 0 || ncols == 0) {
            return;
        }
        Rectangle clip = gfx.getClipBounds();
        TableColumnModel cols = this.table.getColumnModel();
        int height = this.table.getRowHeight();
        int x0 = 0;
        int y0 = 0;
        int x = x0;
        int y = y0;
        Dimension gap = this.table.getInterCellSpacing();
        int ymax = clip.y + clip.height;
        int xmax = clip.x + clip.width;
        for (int c = 0; c < ncols && x < xmax; ++c) {
            y = y0;
            TableColumn col = cols.getColumn(c);
            int width = col.getWidth();
            int modelCol = col.getModelIndex();
            for (int r = 0; r < nrows && y < ymax; ++r) {
                Rectangle bounds = new Rectangle(x, y, width, height);
                if (bounds.intersects(clip)) {
                    TableCellRenderer rend = this.table.getCellRenderer(r, c);
                    Component comp = this.table.prepareRenderer(rend, r, c);
                    gfx.translate(x, y);
                    comp.setBounds(new Rectangle(0, 0, width, height));
                    comp.paint(gfx);
                    gfx.translate(-x, -y);
                }
                y += height;
                if (gap == null) continue;
                y += gap.height;
            }
            x += width;
            if (gap == null) continue;
            x += gap.width;
        }
        ymax = y;
        xmax = x;
        Color grid = this.table.getGridColor();
        if (grid != null && this.table.getShowVerticalLines()) {
            x = x0;
            save = gfx.getColor();
            gfx.setColor(grid);
            paintedLine = false;
            for (int c = 0; c < ncols && x < xmax; ++c) {
                x += cols.getColumn(c).getWidth();
                if (gap != null) {
                    x += gap.width;
                }
                gfx.drawLine(x, y0, x, ymax);
                paintedLine = true;
            }
            gfx.setColor(save);
        }
        if (grid != null && this.table.getShowHorizontalLines()) {
            y = y0;
            save = gfx.getColor();
            gfx.setColor(grid);
            paintedLine = false;
            for (int r = 0; r < nrows && y < ymax; ++r) {
                y += height;
                if (gap != null) {
                    y += gap.height;
                }
                gfx.drawLine(x0, y, xmax, y);
                paintedLine = true;
            }
            gfx.setColor(save);
        }
    }

    class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ BasicTableUI this$0;
        Point begin;
        Point curr;

        private int getRowForPoint(Point p) {
            int y0 = this.this$0.table.getLocation().y;
            int nrows = this.this$0.table.getRowCount();
            Dimension gap = this.this$0.table.getInterCellSpacing();
            int height = this.this$0.table.getRowHeight() + (gap == null ? 0 : gap.height);
            int y = p.y;
            for (int i = 0; i < nrows; ++i) {
                if (y >= 0 && y < height) {
                    return i;
                }
                y -= height;
            }
            return -1;
        }

        private int getColForPoint(Point p) {
            int x0 = this.this$0.table.getLocation().x;
            int ncols = this.this$0.table.getColumnCount();
            Dimension gap = this.this$0.table.getInterCellSpacing();
            TableColumnModel cols = this.this$0.table.getColumnModel();
            int x = p.x;
            for (int i = 0; i < ncols; ++i) {
                int width = cols.getColumn(i).getWidth() + (gap == null ? 0 : gap.width);
                if (x >= 0 && x < width) {
                    return i;
                }
                x -= width;
            }
            return -1;
        }

        private void updateSelection() {
            if (this.this$0.table.getRowSelectionAllowed()) {
                int lo_row = this.getRowForPoint(this.begin);
                int hi_row = this.getRowForPoint(this.curr);
                ListSelectionModel rowModel = this.this$0.table.getSelectionModel();
                if (lo_row != -1 && hi_row != -1) {
                    rowModel.setSelectionInterval(lo_row, hi_row);
                }
            }
            if (this.this$0.table.getColumnSelectionAllowed()) {
                int lo_col = this.getColForPoint(this.begin);
                int hi_col = this.getColForPoint(this.curr);
                ListSelectionModel colModel = this.this$0.table.getColumnModel().getSelectionModel();
                if (lo_col != -1 && hi_col != -1) {
                    colModel.setSelectionInterval(lo_col, hi_col);
                }
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            this.curr = new Point(e.getX(), e.getY());
            this.updateSelection();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.begin = new Point(e.getX(), e.getY());
            this.curr = new Point(e.getX(), e.getY());
            this.updateSelection();
        }

        public void mouseReleased(MouseEvent e) {
            this.begin = null;
            this.curr = null;
        }

        MouseInputHandler(BasicTableUI this$0) {
            this.this$0 = this$0;
        }
    }

    class KeyHandler
    implements KeyListener {
        private /* synthetic */ BasicTableUI this$0;

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        KeyHandler(BasicTableUI this$0) {
            this.this$0 = this$0;
        }
    }

    class FocusHandler
    implements FocusListener {
        private /* synthetic */ BasicTableUI this$0;

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
        }

        FocusHandler(BasicTableUI this$0) {
            this.this$0 = this$0;
        }
    }
}

