/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.PlainView;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class BasicTextUI
extends TextUI
implements ViewFactory {
    static EditorKit kit = new DefaultEditorKit();
    RootView rootView;
    JTextComponent textComponent;
    UpdateHandler updateHandler;

    private /* synthetic */ void finit$() {
        this.rootView = new RootView(this);
        this.updateHandler = new UpdateHandler(this);
    }

    public BasicTextUI() {
        this.finit$();
    }

    protected Caret createCaret() {
        return new BasicCaret();
    }

    protected Highlighter createHighlighter() {
        return new BasicHighlighter();
    }

    protected final JTextComponent getComponent() {
        return this.textComponent;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(true);
        this.textComponent = (JTextComponent)c;
        Document doc = this.textComponent.getDocument();
        if (doc == null) {
            doc = this.getEditorKit(this.textComponent).createDefaultDocument();
            this.textComponent.setDocument(doc);
        }
        this.textComponent.addPropertyChangeListener(this.updateHandler);
        this.modelChanged();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        Highlighter highlighter;
        Caret caret = this.textComponent.getCaret();
        if (caret == null) {
            caret = this.createCaret();
            this.textComponent.setCaret(caret);
        }
        if ((highlighter = this.textComponent.getHighlighter()) == null) {
            this.textComponent.setHighlighter(this.createHighlighter());
        }
        String prefix = this.getPropertyPrefix();
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.textComponent.setBackground(defaults.getColor(prefix + ".background"));
        this.textComponent.setForeground(defaults.getColor(prefix + ".foreground"));
        this.textComponent.setMargin(defaults.getInsets(prefix + ".margin"));
        this.textComponent.setBorder(defaults.getBorder(prefix + ".border"));
        this.textComponent.setFont(defaults.getFont(prefix + ".font"));
        caret.setBlinkRate(defaults.getInt(prefix + ".caretBlinkRate"));
    }

    protected void installListeners() {
    }

    protected String getKeymapName() {
        return "BasicTextUI";
    }

    protected Keymap createKeymap() {
        String prefix = this.getPropertyPrefix();
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        JTextComponent.KeyBinding[] bindings = (JTextComponent.KeyBinding[])defaults.get(prefix + ".keyBindings");
        Keymap km = JTextComponent.addKeymap(this.getKeymapName(), JTextComponent.getKeymap("default"));
        JTextComponent.loadKeymap(km, bindings, this.textComponent.getActions());
        return km;
    }

    protected void installKeyboardActions() {
        Keymap km = JTextComponent.getKeymap(this.getKeymapName());
        if (km == null) {
            km = this.createKeymap();
        }
        this.textComponent.setKeymap(km);
        SwingUtilities.replaceUIInputMap(this.textComponent, 0, this.getInputMap(0));
        SwingUtilities.replaceUIActionMap(this.textComponent, this.getActionMap());
    }

    InputMap getInputMap(int condition) {
        String prefix = this.getPropertyPrefix();
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        switch (condition) {
            case 2: {
                return (InputMap)defaults.get(prefix + ".windowInputMap");
            }
            case 1: {
                return (InputMap)defaults.get(prefix + ".ancestorInputMap");
            }
        }
        return (InputMap)defaults.get(prefix + ".focusInputMap");
    }

    ActionMap getActionMap() {
        String prefix = this.getPropertyPrefix();
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        ActionMap am = (ActionMap)defaults.get(prefix + ".actionMap");
        if (am == null) {
            am = this.createActionMap();
            defaults.put(prefix + ".actionMap", am);
        }
        return am;
    }

    ActionMap createActionMap() {
        Action[] actions = this.textComponent.getActions();
        ActionMap am = new ActionMap();
        for (int i = 0; i < actions.length; ++i) {
            String name = (String)actions[i].getValue("Name");
            if (name == null) continue;
            am.put(name, actions[i]);
        }
        return am;
    }

    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        this.rootView.setView(null);
        this.textComponent.removePropertyChangeListener(this.updateHandler);
        this.textComponent = null;
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
    }

    protected void uninstallKeyboardActions() {
    }

    protected abstract String getPropertyPrefix();

    public Dimension getPreferredSize(JComponent c) {
        View v = this.getRootView(this.textComponent);
        float w = v.getPreferredSpan(0);
        float h = v.getPreferredSpan(1);
        return new Dimension((int)w, (int)h);
    }

    public final void paint(Graphics g, JComponent c) {
        this.paintSafely(g);
    }

    protected void paintSafely(Graphics g) {
        Caret caret = this.textComponent.getCaret();
        Highlighter highlighter = this.textComponent.getHighlighter();
        if (this.textComponent.isOpaque()) {
            this.paintBackground(g);
        }
        if (highlighter != null && this.textComponent.getSelectionStart() != this.textComponent.getSelectionEnd()) {
            highlighter.paint(g);
        }
        this.rootView.paint(g, this.getVisibleEditorRect());
        if (caret != null) {
            caret.paint(g);
        }
    }

    protected void paintBackground(Graphics g) {
        g.setColor(this.textComponent.getBackground());
        g.fillRect(0, 0, this.textComponent.getWidth(), this.textComponent.getHeight());
    }

    public void damageRange(JTextComponent t, int p0, int p1) {
        this.damageRange(t, p0, p1, null, null);
    }

    public void damageRange(JTextComponent t, int p0, int p1, Position.Bias firstBias, Position.Bias secondBias) {
    }

    public EditorKit getEditorKit(JTextComponent t) {
        return kit;
    }

    public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
        return 0;
    }

    public View getRootView(JTextComponent t) {
        return this.rootView;
    }

    public Rectangle modelToView(JTextComponent t, int pos) throws BadLocationException {
        return this.modelToView(t, pos, Position.Bias.Forward);
    }

    public Rectangle modelToView(JTextComponent t, int pos, Position.Bias bias) throws BadLocationException {
        return this.rootView.modelToView(pos, this.getVisibleEditorRect(), bias).getBounds();
    }

    public int viewToModel(JTextComponent t, Point pt) {
        return this.viewToModel(t, pt, null);
    }

    public int viewToModel(JTextComponent t, Point pt, Position.Bias[] biasReturn) {
        return 0;
    }

    public View create(Element elem) {
        return null;
    }

    public View create(Element elem, int p0, int p1) {
        return null;
    }

    protected Rectangle getVisibleEditorRect() {
        int width = this.textComponent.getWidth();
        int height = this.textComponent.getHeight();
        if (width <= 0 || height <= 0) {
            return null;
        }
        Insets insets = this.textComponent.getInsets();
        return new Rectangle(insets.left, insets.top, width - insets.left + insets.right, height - insets.top + insets.bottom);
    }

    protected final void setView(View view) {
        this.rootView.setView(view);
        view.setParent(this.rootView);
    }

    protected void modelChanged() {
        ViewFactory factory = this.rootView.getViewFactory();
        Element elem = this.textComponent.getDocument().getDefaultRootElement();
        this.setView(factory.create(elem));
    }

    class UpdateHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicTextUI this$0;

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("document")) {
                this.this$0.modelChanged();
            }
        }

        UpdateHandler(BasicTextUI this$0) {
            this.this$0 = this$0;
        }
    }

    private class RootView
    extends View {
        private /* synthetic */ BasicTextUI this$0;
        private View view;

        public RootView(BasicTextUI this$0) {
            this.this$0 = this$0;
            super(null);
        }

        public ViewFactory getViewFactory() {
            return this.this$0;
        }

        public void setView(View v) {
            if (this.view != null) {
                this.view.setParent(null);
            }
            if (v != null) {
                v.setParent(null);
            }
            this.view = v;
        }

        public Container getContainer() {
            return this.this$0.textComponent;
        }

        public float getPreferredSpan(int axis) {
            if (this.view != null) {
                return this.view.getPreferredSpan(axis);
            }
            return 2.1474836E9f;
        }

        public void paint(Graphics g, Shape s) {
            if (this.view != null) {
                this.view.paint(g, s);
            }
        }

        protected Rectangle modelToView(int position, Shape a, Position.Bias bias) throws BadLocationException {
            return ((PlainView)this.view).modelToView(position, a, bias).getBounds();
        }
    }

    public static class BasicHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    public static class BasicCaret
    extends DefaultCaret
    implements UIResource {
    }
}

