/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;

public class BasicToolBarUI
extends ToolBarUI
implements SwingConstants {
    private static JFrame owner = new JFrame();
    private static Border nonRolloverBorder;
    private static Border rolloverBorder;
    protected String constraintBeforeFloating;
    private int lastGoodOrientation;
    protected Color dockingBorderColor;
    protected Color dockingColor;
    protected MouseInputListener dockingListener;
    protected DragWindow dragWindow;
    protected Color floatingBorderColor;
    protected Color floatingColor;
    protected int focusedCompIndex;
    protected PropertyChangeListener propertyListener;
    protected JToolBar toolBar;
    protected ContainerListener toolBarContListener;
    protected FocusListener toolBarFocusListener;
    private transient Window floatFrame;
    private transient Container origParent;
    private transient Hashtable borders;
    private transient WindowListener windowListener;
    private transient Dimension cachedBounds;
    private transient int cachedOrientation;

    static /* synthetic */ int access$5(BasicToolBarUI inst$, int write_parm_value$) {
        inst$.lastGoodOrientation = write_parm_value$;
        return inst$.lastGoodOrientation;
    }

    static /* synthetic */ int access$3(BasicToolBarUI inst$) {
        return inst$.cachedOrientation;
    }

    static /* synthetic */ Dimension access$2(BasicToolBarUI inst$) {
        return inst$.cachedBounds;
    }

    static /* synthetic */ Hashtable access$1(BasicToolBarUI inst$, Hashtable write_parm_value$) {
        inst$.borders = write_parm_value$;
        return inst$.borders;
    }

    protected boolean canDock(Component c, Point p) {
        return this.areaOfClick(c, p) != -1;
    }

    private int areaOfClick(Component c, Point p) {
        Rectangle pBounds = c.getBounds();
        Dimension d = this.toolBar.getSize();
        int limit = Math.min(d.width, d.height);
        if (!pBounds.contains(p)) {
            return -1;
        }
        if (p.y < limit) {
            return 1;
        }
        if (p.y > pBounds.height - limit) {
            return 5;
        }
        if (p.x < limit) {
            return 7;
        }
        if (p.x > pBounds.width - limit) {
            return 3;
        }
        return -1;
    }

    protected MouseInputListener createDockingListener() {
        return new DockingListener(this, this.toolBar);
    }

    protected DragWindow createDragWindow(JToolBar toolbar) {
        return new DragWindow(this);
    }

    protected JFrame createFloatingFrame(JToolBar toolbar) {
        return null;
    }

    protected RootPaneContainer createFloatingWindow(JToolBar toolbar) {
        return new ToolBarDialog(this);
    }

    protected WindowListener createFrameListener() {
        return new FrameListener(this);
    }

    protected Border createNonRolloverBorder() {
        return new BorderUIResource.EtchedBorderUIResource();
    }

    protected PropertyChangeListener createPropertyListener() {
        return new PropertyListener(this);
    }

    protected Border createRolloverBorder() {
        return new BorderUIResource.EtchedBorderUIResource(this){
            private /* synthetic */ BasicToolBarUI this$0;
            {
                this.this$0 = this$0;
            }

            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                if (c instanceof JButton && ((JButton)c).getModel().isRollover()) {
                    super.paintBorder(c, g, x, y, width, height);
                }
            }
        };
    }

    protected ContainerListener createToolBarContListener() {
        return new ToolBarContListener(this);
    }

    protected FocusListener createToolBarFocusListener() {
        return new ToolBarFocusListener(this);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicToolBarUI();
    }

    protected void dragTo(Point position, Point origin) {
        boolean tmp;
        int loc = this.areaOfClick(this.origParent, SwingUtilities.convertPoint(this.toolBar, position, this.origParent));
        if (loc != -1) {
            this.dragWindow.setBorderColor(this.dockingBorderColor);
            this.dragWindow.setBackground(this.dockingColor);
        } else {
            this.dragWindow.setBorderColor(this.floatingBorderColor);
            this.dragWindow.setBackground(this.floatingColor);
        }
        int w = 0;
        int h = 0;
        boolean bl = tmp = loc == 1 || loc == 5 || loc == -1;
        if (this.cachedOrientation == 0 && tmp || this.cachedOrientation == 1 && !tmp) {
            w = this.cachedBounds.width;
            h = this.cachedBounds.height;
        } else {
            w = this.cachedBounds.height;
            h = this.cachedBounds.width;
        }
        Point p = this.dragWindow.getOffset();
        Insets insets = this.toolBar.getInsets();
        this.dragWindow.setBounds(origin.x + position.x - p.x - (insets.left + insets.right) / 2, origin.y + position.y - p.y - (insets.top + insets.bottom) / 2, w, h);
        if (!this.dragWindow.isVisible()) {
            this.dragWindow.show();
        }
    }

    protected void floatAt(Point position, Point origin) {
        String constraint;
        Container newParent;
        Point p = new Point(position);
        int aoc = this.areaOfClick(this.origParent, SwingUtilities.convertPoint(this.toolBar, p, this.origParent));
        Container oldParent = this.toolBar.getParent();
        oldParent.remove(this.toolBar);
        oldParent.doLayout();
        oldParent.repaint();
        if (aoc == -1) {
            newParent = ((RootPaneContainer)((Object)this.floatFrame)).getContentPane();
        } else {
            this.floatFrame.hide();
            newParent = this.origParent;
        }
        switch (aoc) {
            case 3: {
                constraint = "East";
                break;
            }
            case 1: {
                constraint = "North";
                break;
            }
            case 5: {
                constraint = "South";
                break;
            }
            case 7: {
                constraint = "West";
                break;
            }
            default: {
                constraint = "Center";
            }
        }
        int newOrientation = 0;
        if (aoc != -1 && (aoc == 3 || aoc == 7)) {
            newOrientation = 1;
        }
        if (aoc != -1) {
            this.constraintBeforeFloating = constraint;
            this.lastGoodOrientation = newOrientation;
        }
        newParent.add((Component)this.toolBar, constraint);
        this.setFloating(aoc == -1, null);
        this.toolBar.setOrientation(newOrientation);
        Insets insets = this.floatFrame.getInsets();
        Dimension dims = this.toolBar.getPreferredSize();
        p = this.dragWindow.getOffset();
        this.setFloatingLocation(position.x + origin.x - p.x - (insets.left + insets.right) / 2, position.y + origin.y - p.y - (insets.top + insets.bottom) / 2);
        if (aoc == -1) {
            this.floatFrame.pack();
            this.floatFrame.setSize(dims.width + insets.left + insets.right, dims.height + insets.top + insets.bottom);
            this.floatFrame.show();
        }
        newParent.invalidate();
        newParent.validate();
        newParent.repaint();
    }

    public Color getDockingColor() {
        return this.dockingColor;
    }

    public Color getFloatingColor() {
        return this.floatingColor;
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.toolBar.getLayout().preferredLayoutSize(c);
    }

    protected void installComponents() {
        this.floatFrame = (Window)((Object)this.createFloatingWindow(this.toolBar));
        this.dragWindow = this.createDragWindow(this.toolBar);
        this.cachedBounds = this.toolBar.getPreferredSize();
        this.cachedOrientation = this.toolBar.getOrientation();
        nonRolloverBorder = this.createNonRolloverBorder();
        rolloverBorder = this.createRolloverBorder();
        this.borders = new Hashtable();
        this.fillHashtable();
    }

    protected void installDefaults() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.toolBar.setBorder(new ToolBarBorder());
        this.toolBar.setBackground(defaults.getColor("ToolBar.background"));
        this.toolBar.setForeground(defaults.getColor("ToolBar.foreground"));
        this.toolBar.setFont(defaults.getFont("ToolBar.font"));
        this.dockingBorderColor = defaults.getColor("ToolBar.dockingForeground");
        this.dockingColor = defaults.getColor("ToolBar.dockingBackground");
        this.floatingBorderColor = defaults.getColor("ToolBar.floatingForeground");
        this.floatingColor = defaults.getColor("ToolBar.floatingBackground");
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners(JToolBar toolbar) {
        this.dockingListener = this.createDockingListener();
        this.toolBar.addMouseListener(this.dockingListener);
        this.toolBar.addMouseMotionListener(this.dockingListener);
        this.propertyListener = this.createPropertyListener();
        this.toolBar.addPropertyChangeListener(this.propertyListener);
        this.toolBarContListener = this.createToolBarContListener();
        this.toolBar.addContainerListener(this.toolBarContListener);
        this.windowListener = this.createFrameListener();
        this.floatFrame.addWindowListener(this.windowListener);
        this.toolBarFocusListener = this.createToolBarFocusListener();
        this.toolBar.addFocusListener(this.toolBarFocusListener);
    }

    protected void installNonRolloverBorders(JComponent c) {
        Component[] components = this.toolBar.getComponents();
        for (int i = 0; i < components.length; ++i) {
            this.setBorderToNonRollover(components[i]);
        }
    }

    protected void installNormalBorders(JComponent c) {
        Component[] components = this.toolBar.getComponents();
        for (int i = 0; i < components.length; ++i) {
            this.setBorderToNormal(components[i]);
        }
    }

    protected void installRolloverBorders(JComponent c) {
        Component[] components = this.toolBar.getComponents();
        for (int i = 0; i < components.length; ++i) {
            this.setBorderToRollover(components[i]);
        }
    }

    private void fillHashtable() {
        Component[] c = this.toolBar.getComponents();
        for (int i = 0; i < c.length; ++i) {
            JButton b;
            if (!(c[i] instanceof JButton) || (b = (JButton)c[i]).getBorder() == null) continue;
            this.borders.put(b, b.getBorder());
        }
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JToolBar) {
            this.toolBar = (JToolBar)c;
            this.toolBar.setOpaque(true);
            this.installDefaults();
            this.installComponents();
            this.installListeners(this.toolBar);
            this.installKeyboardActions();
        }
    }

    public boolean isFloating() {
        return this.floatFrame.isVisible();
    }

    public boolean isRolloverBorders() {
        return this.toolBar.isRollover();
    }

    protected void navigateFocusedComp(int direction) {
    }

    protected void setBorderToNonRollover(Component c) {
        if (c instanceof JButton) {
            JButton b = (JButton)c;
            b.setRolloverEnabled(false);
            b.setBorder(nonRolloverBorder);
        }
    }

    protected void setBorderToNormal(Component c) {
        if (c instanceof JButton) {
            JButton b = (JButton)c;
            Border border = (Border)this.borders.get(b);
            b.setBorder(border);
        }
    }

    protected void setBorderToRollover(Component c) {
        if (c instanceof JButton) {
            JButton b = (JButton)c;
            b.setRolloverEnabled(true);
            b.setBorder(rolloverBorder);
        }
    }

    public void setDockingColor(Color c) {
        this.dockingColor = c;
    }

    public void setFloating(boolean b, Point p) {
        this.floatFrame.setVisible(b);
    }

    public void setFloatingColor(Color c) {
        this.floatingColor = c;
    }

    public void setFloatingLocation(int x, int y) {
        this.floatFrame.setLocation(x, y);
        this.floatFrame.invalidate();
        this.floatFrame.validate();
        this.floatFrame.repaint();
    }

    public void setOrientation(int orientation) {
        this.toolBar.setOrientation(orientation);
    }

    public void setRolloverBorders(boolean rollover) {
        if (rollover) {
            this.installRolloverBorders(this.toolBar);
        } else {
            this.installNonRolloverBorders(this.toolBar);
        }
    }

    protected void uninstallComponents() {
        this.installNormalBorders(this.toolBar);
        this.borders = null;
        rolloverBorder = null;
        nonRolloverBorder = null;
        this.cachedBounds = null;
        this.floatFrame = null;
        this.dragWindow = null;
    }

    protected void uninstallDefaults() {
        this.toolBar.setBackground(null);
        this.toolBar.setForeground(null);
        this.toolBar.setFont(null);
        this.dockingBorderColor = null;
        this.dockingColor = null;
        this.floatingBorderColor = null;
        this.floatingColor = null;
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.toolBar.removeFocusListener(this.toolBarFocusListener);
        this.toolBarFocusListener = null;
        this.floatFrame.removeWindowListener(this.windowListener);
        this.windowListener = null;
        this.toolBar.removeContainerListener(this.toolBarContListener);
        this.toolBarContListener = null;
        this.toolBar.removeMouseMotionListener(this.dockingListener);
        this.toolBar.removeMouseListener(this.dockingListener);
        this.dockingListener = null;
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.toolBar = null;
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    private static class ToolBarBorder
    implements Border {
        private static int offset = 10;
        private static int regular = 2;

        public Insets getBorderInsets(Component c) {
            if (c instanceof JToolBar) {
                JToolBar tb = (JToolBar)c;
                int orientation = tb.getOrientation();
                if (!tb.isFloatable()) {
                    return new Insets(regular, regular, regular, regular);
                }
                if (orientation == 0) {
                    return new Insets(regular, offset, regular, regular);
                }
                return new Insets(offset, regular, regular, regular);
            }
            return new Insets(0, 0, 0, 0);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        private void paintBumps(Graphics g, int x, int y, int w, int h, int size, Color c) {
            Color saved = g.getColor();
            g.setColor(c);
            int hgap = 2 * size;
            int vgap = 4 * size;
            int count = 0;
            for (int i = x; i < w + x; i += hgap) {
                int j;
                int n = j = count++ % 2 == 0 ? y : y + 2 * size;
                while (j < h + y) {
                    g.fillRect(i, j, size, size);
                    j += vgap;
                }
            }
            g.setColor(saved);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (c instanceof JToolBar) {
                JToolBar tb = (JToolBar)c;
                int orientation = tb.getOrientation();
                if (orientation == 0) {
                    this.paintBumps(g, x, y, offset, height, 1, Color.WHITE);
                    this.paintBumps(g, x + 1, y + 1, offset - 1, height - 1, 1, Color.GRAY);
                } else {
                    this.paintBumps(g, x, y, width, offset, 1, Color.WHITE);
                    this.paintBumps(g, x + 1, y + 1, width - 1, offset - 1, 1, Color.GRAY);
                }
            }
        }

        ToolBarBorder() {
        }
    }

    protected class ToolBarFocusListener
    implements FocusListener {
        private /* synthetic */ BasicToolBarUI this$0;

        protected ToolBarFocusListener(BasicToolBarUI this$0) {
            this.this$0 = this$0;
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class ToolBarDialog
    extends JDialog
    implements UIResource {
        private /* synthetic */ BasicToolBarUI this$0;

        public ToolBarDialog(BasicToolBarUI this$0) {
            this.this$0 = this$0;
            this.setName(this$0.toolBar.getName() != null ? this$0.toolBar.getName() : "");
        }
    }

    protected class ToolBarContListener
    implements ContainerListener {
        private /* synthetic */ BasicToolBarUI this$0;

        public void componentAdded(ContainerEvent e) {
            JButton b;
            if (e.getChild() instanceof JButton && (b = (JButton)e.getChild()).getBorder() != null) {
                this.this$0.borders.put(b, b.getBorder());
            }
            if (this.this$0.isRolloverBorders()) {
                this.this$0.setBorderToRollover(e.getChild());
            } else {
                this.this$0.setBorderToNonRollover(e.getChild());
            }
            this.this$0.cachedBounds = this.this$0.toolBar.getPreferredSize();
            this.this$0.cachedOrientation = this.this$0.toolBar.getOrientation();
        }

        public void componentRemoved(ContainerEvent e) {
            this.this$0.setBorderToNormal(e.getChild());
            this.this$0.cachedBounds = this.this$0.toolBar.getPreferredSize();
            this.this$0.cachedOrientation = this.this$0.toolBar.getOrientation();
        }

        ToolBarContListener(BasicToolBarUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class PropertyListener
    implements PropertyChangeListener {
        private /* synthetic */ BasicToolBarUI this$0;

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("rollover")) {
                this.this$0.setRolloverBorders(this.this$0.toolBar.isRollover());
            }
        }

        PropertyListener(BasicToolBarUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        private /* synthetic */ BasicToolBarUI this$0;

        public void windowClosing(WindowEvent e) {
            Container parent = this.this$0.toolBar.getParent();
            parent.remove(this.this$0.toolBar);
            if (this.this$0.origParent != null) {
                this.this$0.origParent.add((Component)this.this$0.toolBar, this.this$0.constraintBeforeFloating != null ? this.this$0.constraintBeforeFloating : "North");
                this.this$0.toolBar.setOrientation(this.this$0.lastGoodOrientation);
            }
            this.this$0.origParent.invalidate();
            this.this$0.origParent.validate();
            this.this$0.origParent.repaint();
        }

        FrameListener(BasicToolBarUI this$0) {
            this.this$0 = this$0;
        }
    }

    protected class DragWindow
    extends Window {
        private /* synthetic */ BasicToolBarUI this$0;
        private Color borderColor;
        private Point offset;

        private DragWindow(BasicToolBarUI this$0) {
            this.this$0 = this$0;
            super(owner);
        }

        public Color getBorderColor() {
            if (this.borderColor == null) {
                return Color.BLACK;
            }
            return this.borderColor;
        }

        public Insets getInsets() {
            return new Insets(0, 0, 0, 0);
        }

        public Point getOffset() {
            return this.offset;
        }

        public void paint(Graphics g) {
            Color saved = g.getColor();
            Rectangle b = this.getBounds();
            g.setColor(this.getBorderColor());
            g.drawRect(0, 0, b.width - 1, b.height - 1);
            g.setColor(saved);
        }

        public void setBorderColor(Color c) {
            this.borderColor = c;
        }

        public void setOffset(Point p) {
            this.offset = p;
        }

        public void setOrientation(int o) {
        }
    }

    protected class DockingListener
    implements MouseInputListener {
        private /* synthetic */ BasicToolBarUI this$0;
        protected boolean isDragging;
        protected Point origin;
        protected JToolBar toolBar;

        public DockingListener(BasicToolBarUI this$0, JToolBar t) {
            this.this$0 = this$0;
            this.toolBar = t;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            if (this.isDragging) {
                this.this$0.dragTo(e.getPoint(), this.origin);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (!this.toolBar.isFloatable()) {
                return;
            }
            Point ssd = e.getPoint();
            Insets insets = this.toolBar.getInsets();
            if (this.toolBar.getOrientation() == 0 ? e.getX() > insets.left : e.getY() > insets.top) {
                return;
            }
            this.origin = new Point(0, 0);
            SwingUtilities.convertPointToScreen(ssd, this.toolBar);
            if (!(SwingUtilities.getAncestorOfClass(BasicToolBarUI.class$("java.awt.Window"), this.toolBar) instanceof UIResource)) {
                this.this$0.origParent = this.toolBar.getParent();
            }
            SwingUtilities.convertPointToScreen(this.origin, this.toolBar);
            this.isDragging = true;
            if (this.this$0.dragWindow != null) {
                this.this$0.dragWindow.setOffset(new Point(e.getX(), e.getY()));
            }
            this.this$0.dragTo(e.getPoint(), this.origin);
        }

        public void mouseReleased(MouseEvent e) {
            if (!this.isDragging || !this.toolBar.isFloatable()) {
                return;
            }
            this.isDragging = false;
            this.this$0.floatAt(e.getPoint(), this.origin);
            this.this$0.dragWindow.hide();
        }
    }
}

