/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;

public class BasicToolTipUI
extends ToolTipUI {
    private static Border defaultBorder = new Border(null){
        private /* synthetic */ BasicToolTipUI this$0;
        {
            this.this$0 = this$0;
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(4, 4, 4, 4);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color saved = g.getColor();
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, w - 1, h - 1);
            g.setColor(saved);
        }
    };
    private static BasicToolTipUI shared;

    public static ComponentUI createUI(JComponent c) {
        if (shared == null) {
            shared = new BasicToolTipUI();
        }
        return shared;
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        JToolTip tip = (JToolTip)c;
        Rectangle vr = new Rectangle();
        Rectangle ir = new Rectangle();
        Rectangle tr = new Rectangle();
        Insets insets = tip.getInsets();
        FontMetrics fm = tip.getToolkit().getFontMetrics(tip.getFont());
        SwingUtilities.layoutCompoundLabel(tip, fm, tip.getTipText(), null, 0, 0, 0, 0, vr, ir, tr, 0);
        return new Dimension(insets.left + tr.width + insets.right, insets.top + tr.height + insets.bottom);
    }

    protected void installDefaults(JComponent c) {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        c.setBackground(defaults.getColor("ToolTip.background"));
        c.setForeground(defaults.getColor("ToolTip.foreground"));
        c.setFont(defaults.getFont("ToolTip.font"));
        c.setBorder(defaultBorder);
    }

    protected void installListeners(JComponent c) {
    }

    public void installUI(JComponent c) {
        c.setOpaque(true);
        this.installDefaults(c);
        this.installListeners(c);
    }

    public void paint(Graphics g, JComponent c) {
        JToolTip tip = (JToolTip)c;
        String text = tip.getTipText();
        if (text == null) {
            return;
        }
        Rectangle vr = new Rectangle();
        vr = SwingUtilities.calculateInnerArea(tip, vr);
        Rectangle ir = new Rectangle();
        Rectangle tr = new Rectangle();
        FontMetrics fm = tip.getToolkit().getFontMetrics(tip.getFont());
        SwingUtilities.layoutCompoundLabel(tip, fm, tip.getTipText(), null, 0, 0, 0, 0, vr, ir, tr, 0);
        Color saved = g.getColor();
        g.setColor(Color.BLACK);
        g.drawString(text, vr.x, vr.y + fm.getAscent());
        g.setColor(saved);
    }

    protected void uninstallDefaults(JComponent c) {
        c.setForeground(null);
        c.setBackground(null);
        c.setFont(null);
        c.setBorder(null);
    }

    protected void uninstallListeners(JComponent c) {
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults(c);
        this.uninstallListeners(c);
    }
}

