/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.ViewportLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ViewportUI;

public class BasicViewportUI
extends ViewportUI {
    ChangeListener changeListener;
    Image backingStoreImage;
    int backingStoreWidth;
    int backingStoreHeight;

    private /* synthetic */ void finit$() {
        this.backingStoreWidth = -1;
        this.backingStoreHeight = -1;
    }

    void installDefaults(JComponent c) {
        c.setOpaque(true);
    }

    void uninstallDefaults(JComponent c) {
    }

    void installListeners(JComponent c) {
        ((JViewport)c).addChangeListener(this.changeListener);
    }

    void uninstallListeners(JComponent c) {
        ((JViewport)c).removeChangeListener(this.changeListener);
    }

    public BasicViewportUI() {
        this.finit$();
        this.changeListener = new ChangeHandler(this);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicViewportUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setLayout(new ViewportLayout());
        this.installListeners(c);
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    public void paint(Graphics g, JComponent c) {
        JViewport v = (JViewport)c;
        Component view = v.getView();
        if (view == null) {
            return;
        }
        Point pos = v.getViewPosition();
        Rectangle viewBounds = view.getBounds();
        Rectangle portBounds = v.getBounds();
        if (viewBounds.width == 0 || viewBounds.height == 0 || portBounds.width == 0 || portBounds.height == 0) {
            return;
        }
        if (this.backingStoreImage == null || this.backingStoreWidth != viewBounds.width || this.backingStoreHeight != viewBounds.height) {
            this.backingStoreImage = v.createImage(viewBounds.width, viewBounds.height);
            this.backingStoreWidth = viewBounds.width;
            this.backingStoreHeight = viewBounds.height;
        }
        Graphics g2 = this.backingStoreImage.getGraphics();
        if (c.getBackground() != null) {
            Color save = g2.getColor();
            g2.setColor(c.getBackground());
            g2.fillRect(0, 0, this.backingStoreWidth, this.backingStoreHeight);
            g2.setColor(save);
            save = g.getColor();
            g.setColor(c.getBackground());
            g.fillRect(0, 0, portBounds.width, portBounds.height);
            g.setColor(save);
        } else {
            g2.clearRect(0, 0, this.backingStoreWidth, this.backingStoreHeight);
            g.clearRect(0, 0, portBounds.width, portBounds.height);
        }
        g2.setClip(g.getClipBounds());
        g2.translate(-pos.x, -pos.y);
        try {
            view.paint(g2);
        }
        finally {
            Object var9_9 = null;
            g2.translate(pos.x, pos.y);
        }
        g2 = null;
        g.drawImage(this.backingStoreImage, 0, 0, null);
    }

    class ChangeHandler
    implements ChangeListener {
        private /* synthetic */ BasicViewportUI this$0;

        public void stateChanged(ChangeEvent event) {
            JViewport v = (JViewport)event.getSource();
            v.repaint();
        }

        ChangeHandler(BasicViewportUI this$0) {
            this.this$0 = this$0;
        }
    }
}

