/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DefaultTableColumnModel
implements TableColumnModel,
PropertyChangeListener,
ListSelectionListener,
Serializable {
    private static final long serialVersionUID = 6580012493508960512L;
    protected Vector tableColumns;
    protected ListSelectionModel selectionModel;
    protected int columnMargin;
    protected EventListenerList listenerList;
    protected transient ChangeEvent changeEvent;
    protected boolean columnSelectionAllowed;
    protected int totalColumnWidth;

    private /* synthetic */ void finit$() {
        this.listenerList = new EventListenerList();
        this.changeEvent = new ChangeEvent(this);
    }

    public DefaultTableColumnModel() {
        this.finit$();
        this.tableColumns = new Vector();
        this.setSelectionModel(new DefaultListSelectionModel());
        this.columnMargin = 1;
        this.columnSelectionAllowed = false;
    }

    public void addColumn(TableColumn col) {
        this.tableColumns.add(col);
        this.invalidateWidthCache();
    }

    public void removeColumn(TableColumn col) {
        this.tableColumns.remove(col);
        this.invalidateWidthCache();
    }

    public void moveColumn(int i, int j) {
        Object tmp = this.tableColumns.get(i);
        this.tableColumns.set(i, this.tableColumns.get(j));
        this.tableColumns.set(j, tmp);
    }

    public void setColumnMargin(int m) {
        this.columnMargin = m;
    }

    public int getColumnCount() {
        return this.tableColumns.size();
    }

    public Enumeration getColumns() {
        return this.tableColumns.elements();
    }

    public int getColumnIndex(Object obj) {
        return this.tableColumns.indexOf(obj, 0);
    }

    public TableColumn getColumn(int i) {
        return (TableColumn)this.tableColumns.get(i);
    }

    public int getColumnMargin() {
        return this.columnMargin;
    }

    public int getColumnIndexAtX(int x) {
        for (int i = 0; i < this.tableColumns.size(); ++i) {
            int w = ((TableColumn)this.tableColumns.get(i)).getWidth();
            if (x >= 0 && x < w) {
                return i;
            }
            x -= w;
        }
        return -1;
    }

    public int getTotalColumnWidth() {
        if (this.totalColumnWidth == -1) {
            this.recalcWidthCache();
        }
        return this.totalColumnWidth;
    }

    public void setSelectionModel(ListSelectionModel model) {
        if (model == null) {
            throw new IllegalArgumentException();
        }
        this.selectionModel = model;
        this.selectionModel.addListSelectionListener(this);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setColumnSelectionAllowed(boolean a) {
        this.columnSelectionAllowed = a;
    }

    public boolean getColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    public int[] getSelectedColumns() {
        return null;
    }

    public int getSelectedColumnCount() {
        return 0;
    }

    public void addColumnModelListener(TableColumnModelListener listener) {
        this.listenerList.add(DefaultTableColumnModel.class$("javax.swing.event.TableColumnModelListener"), listener);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void removeColumnModelListener(TableColumnModelListener value0) {
    }

    protected void fireColumnAdded(TableColumnModelEvent value0) {
    }

    protected void fireColumnRemoved(TableColumnModelEvent value0) {
    }

    protected void fireColumnMoved(TableColumnModelEvent value0) {
    }

    protected void fireColumnSelectionChanged(ListSelectionEvent evt) {
        EventListener[] listeners = this.getListeners(DefaultTableColumnModel.class$("javax.swing.event.TableColumnModelListener"));
        for (int i = 0; i < listeners.length; ++i) {
            ((TableColumnModelListener)listeners[i]).columnSelectionChanged(evt);
        }
    }

    protected void fireColumnMarginChanged() {
    }

    public EventListener[] getListeners(Class klass) {
        return this.listenerList.getListeners(klass);
    }

    public void propertyChange(PropertyChangeEvent value0) {
    }

    public void valueChanged(ListSelectionEvent value0) {
        this.fireColumnSelectionChanged(value0);
    }

    protected ListSelectionModel createSelectionModel() {
        return null;
    }

    protected void recalcWidthCache() {
        if (this.totalColumnWidth == -1) {
            this.totalColumnWidth = 0;
            for (int i = 0; i < this.tableColumns.size(); ++i) {
                this.totalColumnWidth += ((TableColumn)this.tableColumns.get(i)).getWidth();
            }
        }
    }

    private void invalidateWidthCache() {
        this.totalColumnWidth = -1;
    }
}

