/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class DefaultTableModel
extends AbstractTableModel
implements Serializable {
    static final long serialVersionUID = 6680042567037222321L;
    protected Vector dataVector;
    protected Vector columnIdentifiers;

    public DefaultTableModel() {
        this(0, 0);
    }

    public DefaultTableModel(int numRows, int numColumns) {
        Vector defaultNames = new Vector(numColumns);
        Vector data = new Vector(numRows);
        for (int i = 0; i < numColumns; ++i) {
            defaultNames.add(super.getColumnName(i));
            Vector tmp = new Vector(numColumns);
            tmp.setSize(numColumns);
            data.add(tmp);
        }
        this.setDataVector(defaultNames, data);
    }

    public DefaultTableModel(Vector columnNames, int numRows) {
        Vector data = new Vector();
        int numColumns = 0;
        if (columnNames != null) {
            numColumns = columnNames.size();
        }
        while (numRows-- > 0) {
            Vector rowData = new Vector();
            rowData.setSize(numColumns);
            data.add(rowData);
        }
        this.setDataVector(data, columnNames);
    }

    public DefaultTableModel(Object[] columnNames, int numRows) {
        this(DefaultTableModel.convertToVector(columnNames), numRows);
    }

    public DefaultTableModel(Vector data, Vector columnNames) {
        this.setDataVector(data, columnNames);
    }

    public DefaultTableModel(Object[][] data, Object[] columnNames) {
        this(DefaultTableModel.convertToVector(data), DefaultTableModel.convertToVector(columnNames));
    }

    public Vector getDataVector() {
        return this.dataVector;
    }

    public void setDataVector(Vector data, Vector columnNames) {
        this.dataVector = data;
        this.columnIdentifiers = columnNames;
        for (int r = 0; r < data.size(); ++r) {
            ((Vector)this.dataVector.get(r)).setSize(columnNames.size());
        }
    }

    public void setDataVector(Object[][] data, Object[] columnNames) {
        this.setDataVector(DefaultTableModel.convertToVector(data), DefaultTableModel.convertToVector(columnNames));
    }

    public void newDataAvailable(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void newRowsAdded(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void rowsRemoved(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void setColumnIdentifiers(Vector columnIdentifiers) {
        this.columnIdentifiers = columnIdentifiers;
        this.setColumnCount(columnIdentifiers.size());
    }

    public void setColumnIdentifiers(Object[] columnIdentifiers) {
        this.setColumnIdentifiers(DefaultTableModel.convertToVector(columnIdentifiers));
    }

    public void setNumRows(int numRows) {
        this.setRowCount(numRows);
    }

    public void setRowCount(int rowCount) {
        this.dataVector.setSize(rowCount);
        this.fireTableDataChanged();
    }

    public void setColumnCount(int columnCount) {
        for (int i = 0; i < this.dataVector.size(); ++i) {
            ((Vector)this.dataVector.get(i)).setSize(columnCount);
        }
        this.columnIdentifiers.setSize(columnCount);
        this.fireTableDataChanged();
    }

    public void addColumn(Object columnName) {
        this.addColumn(columnName, (Object[])null);
    }

    public void addColumn(Object columnName, Vector columnData) {
        this.addColumn(columnName, columnData == null ? null : columnData.toArray());
    }

    public void addColumn(Object columnName, Object[] columnData) {
        for (int i = 0; i < this.dataVector.size(); ++i) {
            ((Vector)this.dataVector.get(i)).add(columnData == null ? null : columnData[i]);
        }
        this.columnIdentifiers.add(columnName);
        this.fireTableDataChanged();
    }

    public void addRow(Vector rowData) {
        this.dataVector.add(rowData);
        this.fireTableDataChanged();
    }

    public void addRow(Object[] rowData) {
        this.addRow(DefaultTableModel.convertToVector(rowData));
    }

    public void insertRow(int row, Vector rowData) {
        this.dataVector.add(row, rowData);
        this.fireTableDataChanged();
    }

    public void insertRow(int row, Object[] rowData) {
        this.insertRow(row, DefaultTableModel.convertToVector(rowData));
    }

    public void moveRow(int startIndex, int endIndex, int toIndex) {
        for (int index = 0; index < endIndex - startIndex; ++index) {
            Vector vector = (Vector)this.dataVector.remove(startIndex);
            this.dataVector.add(toIndex, vector);
        }
        this.fireTableDataChanged();
    }

    public void removeRow(int row) {
        this.dataVector.remove(row);
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.dataVector.size();
    }

    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    public String getColumnName(int column) {
        if (this.columnIdentifiers == null || column >= this.getColumnCount()) {
            return super.getColumnName(column);
        }
        return (String)this.columnIdentifiers.get(column);
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Object getValueAt(int row, int column) {
        return ((Vector)this.dataVector.get(row)).get(column);
    }

    public void setValueAt(Object value, int row, int column) {
        ((Vector)this.dataVector.get(row)).set(column, value);
        this.fireTableDataChanged();
    }

    protected static Vector convertToVector(Object[] data) {
        if (data == null) {
            return null;
        }
        Vector vector = new Vector(data.length);
        for (int i = 0; i < data.length; ++i) {
            vector.add(data[i]);
        }
        return vector;
    }

    protected static Vector convertToVector(Object[][] data) {
        if (data == null) {
            return null;
        }
        Vector vector = new Vector(data.length);
        for (int i = 0; i < data.length; ++i) {
            vector.add(DefaultTableModel.convertToVector(data[i]));
        }
        return vector;
    }
}

