/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TableColumn
implements Serializable {
    static final long serialVersionUID = -6113660025878112608L;
    public static final String COLUMN_WIDTH_PROPERTY = "columWidth";
    public static final String HEADER_VALUE_PROPERTY = "headerValue";
    public static final String HEADER_RENDERER_PROPERTY = "headerRenderer";
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    protected int modelIndex;
    protected Object identifier;
    protected int width;
    protected int minWidth;
    private int preferredWidth;
    protected int maxWidth;
    protected TableCellRenderer headerRenderer;
    protected Object headerValue;
    protected TableCellRenderer cellRenderer;
    protected TableCellEditor cellEditor;
    protected boolean isResizable;
    protected transient int resizedPostingDisableCount;
    private SwingPropertyChangeSupport changeSupport;

    private /* synthetic */ void finit$() {
        this.minWidth = 15;
        this.maxWidth = Integer.MAX_VALUE;
        this.isResizable = true;
        this.changeSupport = new SwingPropertyChangeSupport(this);
    }

    public TableColumn() {
        this(0, 75, null, null);
    }

    public TableColumn(int modelIndex) {
        this(modelIndex, 75, null, null);
    }

    public TableColumn(int modelIndex, int width) {
        this(modelIndex, width, null, null);
    }

    public TableColumn(int modelIndex, int width, TableCellRenderer cellRenderer, TableCellEditor cellEditor) {
        this.finit$();
        this.modelIndex = modelIndex;
        this.width = width;
        this.preferredWidth = width;
        this.cellRenderer = cellRenderer;
        this.cellEditor = cellEditor;
        this.headerValue = null;
        this.identifier = null;
    }

    private void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(property, oldValue, newValue);
    }

    private void firePropertyChange(String property, int oldValue, int newValue) {
        this.firePropertyChange(property, new Integer(oldValue), new Integer(newValue));
    }

    private void firePropertyChange(String property, boolean oldValue, boolean newValue) {
        this.firePropertyChange(property, new Boolean(oldValue), new Boolean(newValue));
    }

    public void setModelIndex(int modelIndex) {
        this.modelIndex = modelIndex;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public void setIdentifier(Object identifier) {
        this.identifier = identifier;
    }

    public Object getIdentifier() {
        if (this.identifier == null) {
            return this.getHeaderValue();
        }
        return this.identifier;
    }

    public void setHeaderValue(Object headerValue) {
        Object oldValue = this.headerValue;
        this.headerValue = headerValue;
        this.firePropertyChange(HEADER_VALUE_PROPERTY, oldValue, headerValue);
    }

    public Object getHeaderValue() {
        return this.headerValue;
    }

    public void setHeaderRenderer(TableCellRenderer renderer) {
        if (this.headerRenderer == renderer) {
            return;
        }
        TableCellRenderer oldRenderer = this.headerRenderer;
        this.headerRenderer = renderer;
        this.firePropertyChange(HEADER_RENDERER_PROPERTY, oldRenderer, this.headerRenderer);
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public void setCellRenderer(TableCellRenderer renderer) {
        if (this.cellRenderer == renderer) {
            return;
        }
        TableCellRenderer oldRenderer = this.cellRenderer;
        this.cellRenderer = renderer;
        this.firePropertyChange(CELL_RENDERER_PROPERTY, oldRenderer, this.cellRenderer);
    }

    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellEditor(TableCellEditor cellEditor) {
        this.cellEditor = cellEditor;
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setWidth(int newWidth) {
        int oldWidth = this.width;
        this.width = newWidth < this.minWidth ? this.minWidth : (newWidth > this.maxWidth ? this.maxWidth : newWidth);
        if (this.width == oldWidth) {
            return;
        }
        this.firePropertyChange(COLUMN_WIDTH_PROPERTY, oldWidth, this.width);
    }

    public int getWidth() {
        return this.width;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth < this.minWidth ? this.minWidth : (preferredWidth > this.maxWidth ? this.maxWidth : preferredWidth);
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        this.setWidth(this.getWidth());
        this.setPreferredWidth(this.getPreferredWidth());
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        this.setWidth(this.getWidth());
        this.setPreferredWidth(this.getPreferredWidth());
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setResizable(boolean isResizable) {
        this.isResizable = isResizable;
    }

    public boolean getResizable() {
        return this.isResizable;
    }

    public void sizeWidthToFit() {
    }

    public void disableResizedPosting() {
    }

    public void enableResizedPosting() {
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected TableCellRenderer createDefaultHeaderRenderer() {
        return new DefaultTableCellRenderer();
    }
}

