/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleContext;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public abstract class AbstractDocument
implements Document,
Serializable {
    private static final long serialVersionUID = -116069779446114664L;
    protected static final String BAD_LOCATION = "document location failure";
    public static final String BidiElementName = "bidi level";
    public static final String ContentElementName = "content";
    public static final String ParagraphElementName = "paragraph";
    public static final String SectionElementName = "section";
    public static final String ElementNameAttribute = "$ename";
    Content content;
    AttributeContext context;
    protected EventListenerList listenerList;

    private /* synthetic */ void finit$() {
        this.listenerList = new EventListenerList();
    }

    protected AbstractDocument(Content doc) {
        this(doc, StyleContext.getDefaultStyleContext());
    }

    protected AbstractDocument(Content doc, AttributeContext ctx) {
        this.finit$();
        this.content = doc;
        this.context = ctx;
    }

    public abstract Element getParagraphElement(int var1);

    public abstract Element getDefaultRootElement();

    protected Element createBranchElement(Element parent, AttributeSet attributes) {
        return new BranchElement(this, parent, attributes);
    }

    protected Element createLeafElement(Element parent, AttributeSet attributes, int start, int end) {
        return new LeafElement(this, parent, attributes, start, end);
    }

    public Position createPosition(int offset) throws BadLocationException {
        if (offset < 0 || offset > this.getLength()) {
            throw new BadLocationException(this.getText(0, this.getLength()), offset);
        }
        return new Position(this, offset){
            private /* synthetic */ AbstractDocument this$0;
            private /* synthetic */ int val$offset;
            {
                this.this$0 = this$0;
                this.finit$(parm$offset);
            }

            private /* synthetic */ void finit$(int parm$offset) {
                this.val$offset = parm$offset;
            }

            public int getOffset() {
                return this.val$offset;
            }
        };
    }

    protected void fireChangedUpdate(DocumentEvent event) {
        DocumentListener[] listeners = this.getDocumentListeners();
        for (int index = 0; index < listeners.length; ++index) {
            listeners[index].changedUpdate(event);
        }
    }

    protected void fireInsertUpdate(DocumentEvent event) {
        DocumentListener[] listeners = this.getDocumentListeners();
        for (int index = 0; index < listeners.length; ++index) {
            listeners[index].insertUpdate(event);
        }
    }

    protected void fireRemoveUpdate(DocumentEvent event) {
        DocumentListener[] listeners = this.getDocumentListeners();
        for (int index = 0; index < listeners.length; ++index) {
            listeners[index].removeUpdate(event);
        }
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent event) {
        UndoableEditListener[] listeners = this.getUndoableEditListeners();
        for (int index = 0; index < listeners.length; ++index) {
            listeners[index].undoableEditHappened(event);
        }
    }

    public int getAsynchronousLoadPriority() {
        return 0;
    }

    protected AttributeContext getAttributeContext() {
        return this.context;
    }

    public Element getBidiRootElement() {
        return null;
    }

    protected Content getContent() {
        return this.content;
    }

    protected Thread getCurrentWriter() {
        return null;
    }

    public Dictionary getDocumentProperties() {
        return null;
    }

    public Position getEndPosition() {
        return new Position(this){
            private /* synthetic */ AbstractDocument this$0;
            {
                this.this$0 = this$0;
            }

            public int getOffset() {
                return this.this$0.getLength();
            }
        };
    }

    public int getLength() {
        return this.content.length();
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public Object getProperty(Object key) {
        return null;
    }

    public Element[] getRootElements() {
        Element[] elements = new Element[]{this.getDefaultRootElement()};
        return elements;
    }

    public Position getStartPosition() {
        return new Position(this){
            private /* synthetic */ AbstractDocument this$0;
            {
                this.this$0 = this$0;
            }

            public int getOffset() {
                return 0;
            }
        };
    }

    public String getText(int offset, int length) throws BadLocationException {
        return this.content.getString(offset, length);
    }

    public void getText(int offset, int length, Segment segment) throws BadLocationException {
        this.content.getChars(offset, length, segment);
    }

    public void insertString(int offset, String text, AttributeSet attributes) throws BadLocationException {
        if (text == null || text.length() == 0) {
            return;
        }
        DefaultDocumentEvent event = new DefaultDocumentEvent(this, offset, text.length(), DocumentEvent.EventType.INSERT);
        this.content.insertString(offset, text);
        this.insertUpdate(event, attributes);
        this.fireInsertUpdate(event);
    }

    protected void insertUpdate(DefaultDocumentEvent chng, AttributeSet attr) {
    }

    protected void postRemoveUpdate(DefaultDocumentEvent chng) {
    }

    public void putProperty(Object key, Object value) {
    }

    public void readLock() {
    }

    public void readUnlock() {
    }

    public void remove(int offset, int length) throws BadLocationException {
        DefaultDocumentEvent event = new DefaultDocumentEvent(this, offset, length, DocumentEvent.EventType.REMOVE);
        this.removeUpdate(event);
        this.content.remove(offset, length);
        this.postRemoveUpdate(event);
        this.fireRemoveUpdate(event);
    }

    public void replace(int offset, int length, String text, AttributeSet attributes) throws BadLocationException {
        this.remove(offset, length);
        this.insertString(offset, text, attributes);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.listenerList.add(AbstractDocument.class$("javax.swing.event.DocumentListener"), listener);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.listenerList.remove(AbstractDocument.class$("javax.swing.event.DocumentListener"), listener);
    }

    public DocumentListener[] getDocumentListeners() {
        return (DocumentListener[])this.getListeners(AbstractDocument.class$("javax.swing.event.DocumentListener"));
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.listenerList.add(AbstractDocument.class$("javax.swing.event.UndoableEditListener"), listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.listenerList.remove(AbstractDocument.class$("javax.swing.event.UndoableEditListener"), listener);
    }

    public UndoableEditListener[] getUndoableEditListeners() {
        return (UndoableEditListener[])this.getListeners(AbstractDocument.class$("javax.swing.event.UndoableEditListener"));
    }

    protected void removeUpdate(DefaultDocumentEvent chng) {
    }

    public void render(Runnable r) {
    }

    public void setAsynchronousLoadPriority(int p) {
    }

    public void setDocumentProperties(Dictionary x) {
    }

    protected void writeLock() {
    }

    protected void writeUnlock() {
    }

    public class LeafElement
    extends AbstractElement {
        private /* synthetic */ AbstractDocument this$0;
        private static final long serialVersionUID = 5115368706941283802L;
        private int start;
        private int end;

        public LeafElement(AbstractDocument this$0, Element parent, AttributeSet attributes, int start, int end) {
            this.this$0 = this$0;
            super(this$0, parent, attributes);
            this.start = start;
            this.end = end;
        }

        public Enumeration children() {
            return null;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public Element getElement() {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public int getElementIndex(int offset) {
            return -1;
        }

        public int getEndOffset() {
            return this.end;
        }

        public String getName() {
            return "AbstractDocument.LeafElement";
        }

        public int getStartOffset() {
            return this.start;
        }

        public boolean isLeaf() {
            return true;
        }

        public String toString() {
            return this.getName() + ": " + AbstractDocument.ContentElementName;
        }
    }

    public static class ElementEdit
    extends AbstractUndoableEdit
    implements DocumentEvent.ElementChange {
        private static final long serialVersionUID = -1216620962142928304L;
        private Element elem;
        private int index;
        private Element[] removed;
        private Element[] added;

        public ElementEdit(Element elem, int index, Element[] removed, Element[] added) {
            this.elem = elem;
            this.index = index;
            this.removed = removed;
            this.added = added;
        }

        public Element[] getChildrenAdded() {
            return this.added;
        }

        public Element[] getChildrenRemoved() {
            return this.removed;
        }

        public Element getElement() {
            return this.elem;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public class DefaultDocumentEvent
    extends CompoundEdit
    implements DocumentEvent {
        private /* synthetic */ AbstractDocument this$0;
        private static final long serialVersionUID = -7406103236022413522L;
        private int offset;
        private int length;
        private DocumentEvent.EventType type;

        public DefaultDocumentEvent(AbstractDocument this$0, int offset, int length, DocumentEvent.EventType type) {
            this.this$0 = this$0;
            this.offset = offset;
            this.length = length;
            this.type = type;
        }

        public Document getDocument() {
            return this.this$0;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public DocumentEvent.EventType getType() {
            return this.type;
        }

        public DocumentEvent.ElementChange getChange(Element elem) {
            return null;
        }
    }

    public class BranchElement
    extends AbstractElement {
        private /* synthetic */ AbstractDocument this$0;
        private static final long serialVersionUID = -8595176318868717313L;
        private Vector children;

        private /* synthetic */ void finit$() {
            this.children = new Vector();
        }

        public BranchElement(AbstractDocument this$0, Element parent, AttributeSet attributes) {
            this.this$0 = this$0;
            super(this$0, parent, attributes);
            this.finit$();
        }

        public Enumeration children() {
            return this.children.elements();
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public Element getElement(int index) {
            if (index < 0 || index >= this.children.size()) {
                return null;
            }
            return (Element)this.children.get(index);
        }

        public int getElementCount() {
            return this.children.size();
        }

        public int getElementIndex(int offset) {
            if (this.children.size() == 0) {
                return 0;
            }
            Element element = this.positionToElement(offset);
            if (element == null) {
                return 0;
            }
            return this.children.indexOf(element);
        }

        public int getEndOffset() {
            return ((Element)this.children.lastElement()).getEndOffset();
        }

        public String getName() {
            return "AbstractDocument.BranchElement";
        }

        public int getStartOffset() {
            return ((Element)this.children.firstElement()).getStartOffset();
        }

        public boolean isLeaf() {
            return false;
        }

        public Element positionToElement(int position) {
            for (int index = 0; index < this.children.size(); ++index) {
                Element elem = (Element)this.children.get(index);
                if (elem.getStartOffset() > position || position >= elem.getEndOffset()) continue;
                return elem;
            }
            return null;
        }

        public void replace(int offset, int length, Element[] elems) {
            int index;
            for (index = 0; index < length; ++index) {
                this.children.removeElementAt(offset);
            }
            for (index = 0; index < elems.length; ++index) {
                this.children.add(offset + index, elems[index]);
            }
        }

        public String toString() {
            return this.getName() + ": " + AbstractDocument.ContentElementName;
        }
    }

    public abstract class AbstractElement
    implements Element,
    MutableAttributeSet,
    TreeNode,
    Serializable {
        private /* synthetic */ AbstractDocument this$0;
        private static final long serialVersionUID = 1265312733007397733L;
        int count;
        int offset;
        AttributeSet attributes;
        Element element_parent;
        Vector element_children;
        TreeNode tree_parent;
        Vector tree_children;

        public AbstractElement(AbstractDocument this$0, Element p, AttributeSet s) {
            this.this$0 = this$0;
            this.element_parent = p;
            this.attributes = s;
        }

        public Enumeration children() {
            return Collections.enumeration(this.tree_children);
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public TreeNode getChildAt(int index) {
            return (TreeNode)this.tree_children.get(index);
        }

        public int getChildCount() {
            return this.tree_children.size();
        }

        public int getIndex(TreeNode node) {
            return this.tree_children.indexOf(node);
        }

        public TreeNode getParent() {
            return this.tree_parent;
        }

        public abstract boolean isLeaf();

        public void addAttribute(Object name, Object value) {
            this.attributes = this.this$0.getAttributeContext().addAttribute(this.attributes, name, value);
        }

        public void addAttributes(AttributeSet attrs) {
            this.attributes = this.this$0.getAttributeContext().addAttributes(this.attributes, attrs);
        }

        public void removeAttribute(Object name) {
            this.attributes = this.this$0.getAttributeContext().removeAttribute(this.attributes, name);
        }

        public void removeAttributes(AttributeSet attrs) {
            this.attributes = this.this$0.getAttributeContext().removeAttributes(this.attributes, attrs);
        }

        public void removeAttributes(Enumeration names) {
            this.attributes = this.this$0.getAttributeContext().removeAttributes(this.attributes, names);
        }

        public void setResolveParent(AttributeSet parent) {
            this.attributes = this.this$0.getAttributeContext().addAttribute(this.attributes, AttributeSet.ResolveAttribute, parent);
        }

        public boolean containsAttribute(Object name, Object value) {
            return this.attributes.containsAttribute(name, value);
        }

        public boolean containsAttributes(AttributeSet attrs) {
            return this.attributes.containsAttributes(attrs);
        }

        public AttributeSet copyAttributes() {
            return this.attributes.copyAttributes();
        }

        public Object getAttribute(Object key) {
            return this.attributes.getAttribute(key);
        }

        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        public Enumeration getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        public AttributeSet getResolveParent() {
            return this.attributes.getResolveParent();
        }

        public boolean isDefined(Object attrName) {
            return this.attributes.isDefined(attrName);
        }

        public boolean isEqual(AttributeSet attrs) {
            return this.attributes.isEqual(attrs);
        }

        public AttributeSet getAttributes() {
            return this.attributes;
        }

        public Document getDocument() {
            return this.this$0;
        }

        public Element getElement(int index) {
            return (Element)this.element_children.get(index);
        }

        public String getName() {
            return (String)this.getAttribute(AttributeSet.NameAttribute);
        }

        public Element getParentElement() {
            return this.element_parent;
        }

        public abstract int getEndOffset();

        public abstract int getElementCount();

        public abstract int getElementIndex(int var1);

        public abstract int getStartOffset();
    }

    public interface Content {
        public Position createPosition(int var1) throws BadLocationException;

        public int length();

        public UndoableEdit insertString(int var1, String var2) throws BadLocationException;

        public UndoableEdit remove(int var1, int var2) throws BadLocationException;

        public String getString(int var1, int var2) throws BadLocationException;

        public void getChars(int var1, int var2, Segment var3) throws BadLocationException;
    }

    public interface AttributeContext {
        public AttributeSet addAttribute(AttributeSet var1, Object var2, Object var3);

        public AttributeSet addAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet getEmptySet();

        public void reclaim(AttributeSet var1);

        public AttributeSet removeAttribute(AttributeSet var1, Object var2);

        public AttributeSet removeAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet removeAttributes(AttributeSet var1, Enumeration var2);
    }
}

