/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class DefaultCaret
extends Rectangle
implements Caret,
FocusListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 228155774675466193L;
    protected ChangeEvent changeEvent;
    protected EventListenerList listenerList;
    private JTextComponent textComponent;
    private boolean selectionVisible;
    private int blinkRate;
    private int dot;
    private int mark;
    private Point magicCaretPosition;
    private boolean visible;
    private Object highlightEntry;

    private /* synthetic */ void finit$() {
        this.changeEvent = new ChangeEvent(this);
        this.listenerList = new EventListenerList();
        this.selectionVisible = true;
        this.blinkRate = 0;
        this.dot = 0;
        this.mark = 0;
        this.magicCaretPosition = null;
        this.visible = true;
    }

    public void mouseDragged(MouseEvent event) {
    }

    public void mouseMoved(MouseEvent event) {
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
    }

    protected void moveCaret(MouseEvent event) {
    }

    protected void positionCaret(MouseEvent event) {
    }

    public void deinstall(JTextComponent c) {
        this.textComponent.removeFocusListener(this);
        this.textComponent.removeMouseListener(this);
        this.textComponent.removeMouseMotionListener(this);
        this.textComponent = null;
    }

    public void install(JTextComponent c) {
        this.textComponent = c;
        this.textComponent.addFocusListener(this);
        this.textComponent.addMouseListener(this);
        this.textComponent.addMouseMotionListener(this);
        this.repaint();
    }

    public void setMagicCaretPosition(Point p) {
        this.magicCaretPosition = p;
    }

    public Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    public int getMark() {
        return this.mark;
    }

    private void handleHighlight() {
        Highlighter highlighter = this.textComponent.getHighlighter();
        if (highlighter == null) {
            return;
        }
        int p0 = Math.min(this.dot, this.mark);
        int p1 = Math.max(this.dot, this.mark);
        if (this.selectionVisible && p0 != p1) {
            try {
                if (this.highlightEntry == null) {
                    this.highlightEntry = highlighter.addHighlight(p0, p1, this.getSelectionPainter());
                }
                highlighter.changeHighlight(this.highlightEntry, p0, p1);
            }
            catch (BadLocationException e) {
                throw new InternalError();
            }
        } else if (this.highlightEntry != null) {
            highlighter.removeHighlight(this.highlightEntry);
            this.highlightEntry = null;
        }
    }

    public void setSelectionVisible(boolean v) {
        if (this.selectionVisible == v) {
            return;
        }
        this.selectionVisible = v;
        this.handleHighlight();
        this.repaint();
    }

    public boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    protected final void repaint() {
        if (this.textComponent != null) {
            this.textComponent.repaint();
        }
    }

    public void paint(Graphics g) {
        if (this.textComponent == null) {
            return;
        }
        int dot = this.getDot();
        Rectangle rect = null;
        try {
            rect = this.textComponent.modelToView(dot);
        }
        catch (BadLocationException e) {
            return;
        }
        if (rect == null) {
            return;
        }
        if (this.visible) {
            g.setColor(this.textComponent.getCaretColor());
            g.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height);
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(DefaultCaret.class$("javax.swing.event.ChangeListener"), listener);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(DefaultCaret.class$("javax.swing.event.ChangeListener"), listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.getListeners(DefaultCaret.class$("javax.swing.event.ChangeListener"));
    }

    protected void fireStateChanged() {
        ChangeListener[] listeners = this.getChangeListeners();
        for (int index = 0; index < listeners.length; ++index) {
            listeners[index].stateChanged(this.changeEvent);
        }
    }

    protected final JTextComponent getComponent() {
        return this.textComponent;
    }

    public int getBlinkRate() {
        return this.blinkRate;
    }

    public void setBlinkRate(int rate) {
        this.blinkRate = rate;
    }

    public int getDot() {
        return this.dot;
    }

    public void moveDot(int dot) {
        this.dot = dot;
        this.handleHighlight();
        this.repaint();
    }

    public void setDot(int dot) {
        this.dot = dot;
        this.mark = dot;
        this.handleHighlight();
        this.repaint();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean v) {
        this.visible = v;
        this.repaint();
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return DefaultHighlighter.DefaultPainter;
    }

    public DefaultCaret() {
        this.finit$();
    }
}

