/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.TextAction;
import javax.swing.text.ViewFactory;

public class DefaultEditorKit
extends EditorKit {
    private static final long serialVersionUID = 9017245433028523428L;
    public static final String backwardAction = "caret-backward";
    public static final String beepAction = "beep";
    public static final String beginAction = "caret-begin";
    public static final String beginLineAction = "caret-begin-line";
    public static final String beginParagraphAction = "caret-begin-paragraph";
    public static final String beginWordAction = "caret-begin-word";
    public static final String copyAction = "copy-to-clipboard";
    public static final String cutAction = "cut-to-clipboard";
    public static final String defaultKeyTypedAction = "default-typed";
    public static final String deleteNextCharAction = "delete-next";
    public static final String deletePrevCharAction = "delete-previous";
    public static final String downAction = "caret-down";
    public static final String endAction = "caret-end";
    public static final String endLineAction = "caret-end-line";
    public static final String EndOfLineStringProperty = "__EndOfLine__";
    public static final String endParagraphAction = "caret-end-paragraph";
    public static final String endWordAction = "caret-end-word";
    public static final String forwardAction = "caret-forward";
    public static final String insertBreakAction = "insert-break";
    public static final String insertContentAction = "insert-content";
    public static final String insertTabAction = "insert-tab";
    public static final String nextWordAction = "caret-next-word";
    public static final String pageDownAction = "page-down";
    public static final String pageUpAction = "page-up";
    public static final String pasteAction = "paste-from-clipboard";
    public static final String previousWordAction = "caret-previous-word";
    public static final String readOnlyAction = "set-read-only";
    public static final String selectAllAction = "select-all";
    public static final String selectionBackwardAction = "selection-backward";
    public static final String selectionBeginAction = "selection-begin";
    public static final String selectionBeginLineAction = "selection-begin-line";
    public static final String selectionBeginParagraphAction = "selection-begin-paragraph";
    public static final String selectionBeginWordAction = "selection-begin-word";
    public static final String selectionDownAction = "selection-down";
    public static final String selectionEndAction = "selection-end";
    public static final String selectionEndLineAction = "selection-end-line";
    public static final String selectionEndParagraphAction = "selection-end-paragraph";
    public static final String selectionEndWordAction = "selection-end-word";
    public static final String selectionForwardAction = "selection-forward";
    public static final String selectionNextWordAction = "selection-next-word";
    public static final String selectionPreviousWordAction = "selection-previous-word";
    public static final String selectionUpAction = "selection-up";
    public static final String selectLineAction = "select-line";
    public static final String selectParagraphAction = "select-paragraph";
    public static final String selectWordAction = "select-word";
    public static final String upAction = "caret-up";
    public static final String writableAction = "set-writable";
    private static Action[] defaultActions;

    public void deinstall(JEditorPane c) {
    }

    public void install(JEditorPane c) {
    }

    public Caret createCaret() {
        return new DefaultCaret();
    }

    public Document createDefaultDocument() {
        return new PlainDocument();
    }

    public Action[] getActions() {
        return defaultActions;
    }

    public String getContentType() {
        return "text/plain";
    }

    public ViewFactory getViewFactory() {
        return null;
    }

    public void read(InputStream in, Document doc, int pos) throws BadLocationException, IOException {
    }

    public void read(Reader in, Document doc, int pos) throws BadLocationException, IOException {
    }

    public void write(OutputStream out, Document doc, int pos, int len) throws BadLocationException, IOException {
    }

    public void write(Writer out, Document doc, int pos, int len) throws BadLocationException, IOException {
    }

    static {
        backwardAction = backwardAction;
        beepAction = beepAction;
        beginAction = beginAction;
        beginLineAction = beginLineAction;
        beginParagraphAction = beginParagraphAction;
        beginWordAction = beginWordAction;
        copyAction = copyAction;
        cutAction = cutAction;
        defaultKeyTypedAction = defaultKeyTypedAction;
        deleteNextCharAction = deleteNextCharAction;
        deletePrevCharAction = deletePrevCharAction;
        downAction = downAction;
        endAction = endAction;
        endLineAction = endLineAction;
        EndOfLineStringProperty = EndOfLineStringProperty;
        endParagraphAction = endParagraphAction;
        endWordAction = endWordAction;
        forwardAction = forwardAction;
        insertBreakAction = insertBreakAction;
        insertContentAction = insertContentAction;
        insertTabAction = insertTabAction;
        nextWordAction = nextWordAction;
        pageDownAction = pageDownAction;
        pageUpAction = pageUpAction;
        pasteAction = pasteAction;
        previousWordAction = previousWordAction;
        readOnlyAction = readOnlyAction;
        selectAllAction = selectAllAction;
        selectionBackwardAction = selectionBackwardAction;
        selectionBeginAction = selectionBeginAction;
        selectionBeginLineAction = selectionBeginLineAction;
        selectionBeginParagraphAction = selectionBeginParagraphAction;
        selectionBeginWordAction = selectionBeginWordAction;
        selectionDownAction = selectionDownAction;
        selectionEndAction = selectionEndAction;
        selectionEndLineAction = selectionEndLineAction;
        selectionEndParagraphAction = selectionEndParagraphAction;
        selectionEndWordAction = selectionEndWordAction;
        selectionForwardAction = selectionForwardAction;
        selectionNextWordAction = selectionNextWordAction;
        selectionPreviousWordAction = selectionPreviousWordAction;
        selectionUpAction = selectionUpAction;
        selectLineAction = selectLineAction;
        selectParagraphAction = selectParagraphAction;
        selectWordAction = selectWordAction;
        upAction = upAction;
        writableAction = writableAction;
        defaultActions = new Action[]{new BeepAction(), new CopyAction(), new CutAction(), new DefaultKeyTypedAction(), new InsertBreakAction(), new InsertContentAction(), new InsertTabAction(), new PasteAction(), new TextAction(null, deleteNextCharAction){
            private /* synthetic */ DefaultEditorKit this$0;
            {
                this.this$0 = this$0;
                super(parm0);
            }

            public void actionPerformed(ActionEvent event) {
                JTextComponent t = this.getTextComponent(event);
                if (t != null) {
                    try {
                        int pos = t.getCaret().getDot();
                        if (pos < t.getDocument().getEndPosition().getOffset()) {
                            t.getDocument().remove(t.getCaret().getDot(), 1);
                            t.repaint();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }, new TextAction(null, deletePrevCharAction){
            private /* synthetic */ DefaultEditorKit this$0;
            {
                this.this$0 = this$0;
                super(parm0);
            }

            public void actionPerformed(ActionEvent event) {
                JTextComponent t = this.getTextComponent(event);
                if (t != null) {
                    try {
                        int pos = t.getCaret().getDot();
                        if (pos > t.getDocument().getStartPosition().getOffset()) {
                            t.getDocument().remove(pos - 1, 1);
                            t.getCaret().setDot(pos - 1);
                            t.repaint();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }, new TextAction(null, backwardAction){
            private /* synthetic */ DefaultEditorKit this$0;
            {
                this.this$0 = this$0;
                super(parm0);
            }

            public void actionPerformed(ActionEvent event) {
                JTextComponent t = this.getTextComponent(event);
                if (t != null) {
                    t.getCaret().setDot(Math.max(t.getCaret().getDot() - 1, t.getDocument().getStartPosition().getOffset()));
                }
            }
        }, new TextAction(null, forwardAction){
            private /* synthetic */ DefaultEditorKit this$0;
            {
                this.this$0 = this$0;
                super(parm0);
            }

            public void actionPerformed(ActionEvent event) {
                JTextComponent t = this.getTextComponent(event);
                if (t != null) {
                    t.getCaret().setDot(Math.min(t.getCaret().getDot() + 1, t.getDocument().getEndPosition().getOffset()));
                }
            }
        }, new TextAction(null, selectionBackwardAction){
            private /* synthetic */ DefaultEditorKit this$0;
            {
                this.this$0 = this$0;
                super(parm0);
            }

            public void actionPerformed(ActionEvent event) {
                JTextComponent t = this.getTextComponent(event);
                if (t != null) {
                    t.getCaret().moveDot(Math.max(t.getCaret().getDot() - 1, t.getDocument().getStartPosition().getOffset()));
                }
            }
        }, new TextAction(null, selectionForwardAction){
            private /* synthetic */ DefaultEditorKit this$0;
            {
                this.this$0 = this$0;
                super(parm0);
            }

            public void actionPerformed(ActionEvent event) {
                JTextComponent t = this.getTextComponent(event);
                if (t != null) {
                    t.getCaret().moveDot(Math.min(t.getCaret().getDot() + 1, t.getDocument().getEndPosition().getOffset()));
                }
            }
        }};
    }

    public static class PasteAction
    extends TextAction {
        public PasteAction() {
            super(DefaultEditorKit.pasteAction);
        }

        public void actionPerformed(ActionEvent event) {
        }
    }

    public static class InsertTabAction
    extends TextAction {
        public InsertTabAction() {
            super(DefaultEditorKit.insertTabAction);
        }

        public void actionPerformed(ActionEvent event) {
        }
    }

    public static class InsertContentAction
    extends TextAction {
        public InsertContentAction() {
            super(DefaultEditorKit.insertContentAction);
        }

        public void actionPerformed(ActionEvent event) {
        }
    }

    public static class InsertBreakAction
    extends TextAction {
        public InsertBreakAction() {
            super(DefaultEditorKit.insertBreakAction);
        }

        public void actionPerformed(ActionEvent event) {
        }
    }

    public static class DefaultKeyTypedAction
    extends TextAction {
        public DefaultKeyTypedAction() {
            super(DefaultEditorKit.defaultKeyTypedAction);
        }

        public void actionPerformed(ActionEvent event) {
            JTextComponent t = this.getTextComponent(event);
            if (t != null) {
                try {
                    t.getDocument().insertString(t.getCaret().getDot(), event.getActionCommand(), null);
                    t.getCaret().setDot(Math.min(t.getCaret().getDot() + 1, t.getDocument().getEndPosition().getOffset()));
                    t.repaint();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    public static class CutAction
    extends TextAction {
        public CutAction() {
            super(DefaultEditorKit.cutAction);
        }

        public void actionPerformed(ActionEvent event) {
        }
    }

    public static class CopyAction
    extends TextAction {
        public CopyAction() {
            super(DefaultEditorKit.copyAction);
        }

        public void actionPerformed(ActionEvent event) {
        }
    }

    public static class BeepAction
    extends TextAction {
        public BeepAction() {
            super(DefaultEditorKit.beepAction);
        }

        public void actionPerformed(ActionEvent event) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

